#if 1
#include "mbtk_type.h"
#include "mbtk_log.h"
#include "lynq_qser_thermal.h"
#include "mbtk_info_api.h"

/****************************DEFINE***************************************/
#define QSER_RESULT_FAIL    -1
#define QSER_RESULT_SUCCESS 0
/****************************DEFINE***************************************/

/****************************VARIABLE***************************************/
extern mbtk_info_handle_t* qser_info_handle;
extern int qser_info_handle_num;
/****************************VARIABLE***************************************/


/******************************FUNC*****************************************/
static int qser_thermal_client_init(void)
{
    if(qser_info_handle == NULL)
    {
        qser_info_handle = mbtk_info_handle_get();
        if(qser_info_handle)
        {
            qser_info_handle_num++;
        } 
        else
        {
            LOGE("[qser_thermal] mbtk_info_handle_get() fail.");
            return QSER_RESULT_FAIL;
        }
    }
    else
    {
        qser_info_handle_num++;
    }

    LOGE("[qser_thermal] mbtk_info_handle_get() success.");
    return QSER_RESULT_SUCCESS;
}

static int qser_thermal_client_deinit(void)
{
    if(qser_info_handle)
    {
        LOGE("[qser_thermal] qser_info_handle_num = %d", qser_info_handle_num);
        if(qser_info_handle_num == 1)
        { // 最后一个引用，可释放。
            int ret = mbtk_info_handle_free(&qser_info_handle);
            if(ret)
            {
                LOGE("[qser_thermal] mbtk_info_handle_free() fail.");
                return QSER_RESULT_FAIL;
            }
            else
            {
                qser_info_handle_num = 0;
                qser_info_handle = NULL;
            }
        } 
        else
        {
            qser_info_handle_num--;
        }
    }
    else
    {
        LOGE("[qser_thermal] handle not inited.");
        return QSER_RESULT_FAIL;
    }

    return QSER_RESULT_SUCCESS;
}

/******************************FUNC*****************************************/

/****************************API***************************************/
int get_thermal_zone(int *numbers, int size)
{
    if(numbers == NULL || size < 6)
    {
        LOGE("[qser_thermal]: numbers is NULL!");
        return QSER_RESULT_FAIL;
    }
    
    int ret = 0;
    int thermal = -1;
    int thermal_num = 0;
    mbtk_thermal_info_t temp;
    memset(&temp, 0, sizeof(mbtk_thermal_info_t));

    ret = qser_thermal_client_init();
    if(ret != QSER_RESULT_SUCCESS)
    {
        LOGE("[qser_thermal]qser_led_client_init fail.");
        return QSER_RESULT_FAIL;
    }
    
    ret = mbtk_temp_get(qser_info_handle, 0, &temp);
    thermal = temp.ther;
    if(ret != QSER_RESULT_SUCCESS)
    {
        LOGE("[qser_thermal]mbtk_temp_get fail.");
        qser_thermal_client_deinit();
        return QSER_RESULT_FAIL;
    }

    qser_thermal_client_deinit();
    numbers[thermal_num++] = thermal;
    for(; thermal_num < size; thermal_num++)
    {
        numbers[thermal_num] = 0;
    }

    return 6;
}
/****************************API***************************************/

#endif
