#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>

#define LOG_TAG "mbtk_http"
#include "mbtk_type.h"
#include "mbtk_http.h"
#include "mbtk_log.h"
#include "mbtk_info_api.h"
#include "ql/ql_cell_locator.h"


static int http_handle;
static int http_session;

static char Server[128]={0};
static char Token[128] = {0};
static char Loction[128]={0};
static int PORT = 0;
static int locator_timeout = 60;  // 60s for default.

static int mbtk_lbs_http_parse_location(char* buf, int len, char* rspBuf)
{
    if(buf != NULL && len != 0)
    {
        char* pos0 = NULL;
        char* pos1 = NULL;
        char fac[64] = {'\0'};
        pos0 = strstr(buf, "<info>");
        if(pos0 != NULL)
        {
            pos1 = strstr(pos0 + 1, "</info>");
            if(pos1 != NULL)
            {
                strncpy(fac, pos0 + 6, pos1 - pos0 - 6);
            }
            if(strcmp(fac, "OK") == 0)
            {
                char* l_pos0 = NULL;
                char* l_pos1 = NULL;
                char* type_pos0 = NULL;
                char* type_pos1 = NULL;
                char fac_type[64] = {'\0'};
                type_pos0 = strstr(buf, "<type>");
                if(type_pos0 != NULL)
                {
                    type_pos1 = strstr(type_pos0 + 1, "</type>");
                    if(type_pos1 != NULL)
                    {
                        strncpy(fac_type, type_pos0 + 6, type_pos1 - type_pos0 - 6);
                        if(strcmp(fac_type, "0") == 0)
                        {
                            return -1;
                        }
                    }
                }
                l_pos0 = strstr(buf, "<location>");
                if(l_pos0 != NULL)
                {
                   l_pos1 = strstr(l_pos0 + 1, "</location>");
                    if(l_pos1 != NULL)
                    {
                        strncpy(rspBuf, l_pos0 + 10, l_pos1 - l_pos0 - 10);
                    }
                    return 0;
                }
            }
            else //key error http chunk
            {
                printf("info is %s", fac);
            }
        }
    }
    return -1;
}



static void http_data_cb_func1(
    int session_id, mbtk_http_data_type_enum type,
    void *data,int data_len)
{
    if(type == MBTK_HTTP_DATA_HEADER) {
        LOGE("Header(%d):%s\n",data_len,(char*)data);
    } else if(type == MBTK_HTTP_DATA_CONTENT) {
        LOGE("Data(%d):%s\n",data_len,(char*)data);
		mbtk_lbs_http_parse_location((char*)data, data_len, Loction);
    } else {
        LOGI(">>>>>Complete<<<<<\n");
    }
}


int ql_cell_locator_init()
{
    http_handle = mbtk_http_handle_get(TRUE, http_data_cb_func1);
    if(http_handle < 0)
    {
        LOGE("mbtk_http_handle_get() fail.");
        return -1;
    }

	http_session = mbtk_http_session_create(http_handle,HTTP_OPTION_GET,HTTP_VERSION_1_1);
    if(http_session < 0)
    {
        LOGE("mbtk_http_session_create() fail.");
        return -1;
    }

	return 0;
}


int ql_cell_locator_release()
{
    if(mbtk_http_handle_free(http_handle))
    {
        LOGE("mbtk_http_handle_free() fail.");
        return -1;
    }

	return 0;
}

/*-----------------------------------------------------------------------------------------------*/
/**
  @brief set locator query server and port, server length must be less than 255 bytes.
  @param[in] server the query server ip address
  @param[in] port the query server port
  @return if success return 0, else return -1
  */
/*-----------------------------------------------------------------------------------------------*/
int ql_cell_locator_set_server(const char *server, unsigned short port)
{
	if(server == NULL)
	{
		return -1;
	}

	memset(Server, 0, sizeof(Server));
	memcpy(Server, server, strlen(server));
	PORT = port;

	return 0;
}

/*-----------------------------------------------------------------------------------------------*/
/**
  @brief set locator query timeout, the value must between 1-300 [seconds]
  @param[in] timeout value of query timeout
  @return if success return 0, else return -1
  */
/*-----------------------------------------------------------------------------------------------*/
int ql_cell_locator_set_timeout(unsigned short timeout)
{
    locator_timeout = timeout;
	return 0;
}


/*-----------------------------------------------------------------------------------------------*/
/**
  @brief set locator query token, token length must be 16 bytes. the token Used to verify that
         the client accessing the service is valid.
  @param[in] token string of token which want to be setted.
  @param[in] length of token string.
  @return if success return 0, else return -1
  */
/*-----------------------------------------------------------------------------------------------*/
int ql_cell_locator_set_token(const char *token, int len)
{
	if(token == NULL && (strlen(token) != len) && len > 128)
	{
		return -1;
	}

	memset(Token, 0, sizeof(token));
	memcpy(Token, token, strlen(token));

	return 0;
}

/*-----------------------------------------------------------------------------------------------*/
/**
  @brief perform cell locator query
  @param[out] resp include query result or set the error_msg and error_code
  @return if success return 0, else return -1
  */
/*-----------------------------------------------------------------------------------------------*/
int ql_cell_locator_perform(ql_cell_resp *resp)
{

    int ret = 0;
    int ret1 = 0;

    char url[1024] = {0};
    char imei[50] ={0};
    char cellinfo[512] = {0};
    char *p = cellinfo;
    	int i =0;
    int mcc,mnc,tac,ci,rsrp;

    mbtk_info_handle_t* info_handle = mbtk_info_handle_get();
    if(!info_handle)
    {
        return -1;
    }

    mbtk_imei_get(info_handle, imei);

    list_node_t* cell_list = NULL;
    int type, err;
    int CellId;
    err = mbtk_cell_get(info_handle, &type, &cell_list);
    if(err || cell_list == NULL) {
        printf("Error : %d\n", err);
    }
    else
    {
        list_first(cell_list);
        mbtk_cell_info_t* cell = (mbtk_cell_info_t*) list_next(cell_list);
        if(cell)
        { // Current server cell.
            switch(type)
            {
                case 0:
                    LOGE("GSM : mcc=%d, mnc=%d, lac=%d, ci=%d, arfcn=%d, bsic=%d\n",cell->value5, cell->value6,cell->value1, cell->value2, cell->value3, cell->value4);
                    mcc = cell->value5;
                    mnc = cell->value6;
                    tac = cell->value1;
                    ci = cell->value2;
                    rsrp = 30;
                    break;
                case 1:
                    LOGE("UMTS : lac=%d, ci=%d, arfcn=%d\n", cell->value1, cell->value2, cell->value3);
                    break;
                case 2:
                    LOGE("LTE : tac=%d, PCI=%d, dlEuarfcn=%d, ulEuarfcn=%d, band=%d, mcc=%d, mnc=%d ,cid=%d, rsrp=%d\n",
                    cell->value1, cell->value2, cell->value3, cell->value4, cell->value5,cell->value6, cell->value7, cell->value8,cell->value9);
//// LTE server cell: tac, PCI, dlEuarfcn, ulEuarfcn, band, mcc, mnc ,cid, rsrp
                    mcc = cell->value6;
                    mnc = cell->value7;
                    tac = cell->value1;
                    ci = cell->value10;
                    rsrp = cell->value9;

                    //	LOGE(cellinfo,"&bts=%X,%X,%d,%d,%d&nearbts=",mcc,mnc,tac,ci,rsrp-140);
                    //	LOGE("cellinfo:%s\n", cellinfo);

                    break;
                default:
                    break;
            }
        }

        sprintf(cellinfo,"&bts=%X,%X,%d,%d,%d&nearbts=",mcc,mnc,tac,ci,rsrp-140);
        while ((cell = (mbtk_cell_info_t*) list_next(cell_list)))
        {
            switch(type)
            {
                case 0:
                    LOGE("CELL : %d, %d, %d, %d, %d", cell->value1, cell->value2, cell->value3, cell->value4, cell->value5);
                    if(i < 3)
                    {
                        sprintf(p+strlen(p),"%X,%X,%d,%d,%d|",cell->value5,cell->value6,cell->value1,cell->value2,29-140);
                        i++;
                    }
                    break;
                case 1:
                    LOGE("CELL : lac=%d, ci=%d, arfcn=%d\n", cell->value1, cell->value2, cell->value3);
                    break;
                case 2:
                    CellId = cell->value5;
                //    if(CellId > 0 && cell->value5 != -1)
                    if(CellId > 0 )
                    {
                        if(i < 3)
                        {
                            sprintf(p+strlen(p),"%X,%X,%d,%d,%d|",mcc,mnc,tac,cell->value5,cell->value3-140);
                            i++;
                        }
                    }
                    LOGE("CELL : phyCellId=%d, euArfcn=%d, rsrp=%d, rsrq=%d, cellId:%d\n", cell->value1, cell->value2, cell->value3, cell->value4, cell->value5);
                    break;
                default:
                    break;
           }
        }
    }
    list_free(cell_list);

    sprintf(url,"http://%s:%d/position?accesstype=0&imei=%s&cdma=0%s&output=xml&key=%s",\
            Server, PORT, imei,cellinfo, Token);


    memset(Loction, 0, sizeof(Loction));


    if(mbtk_http_session_url_set(http_handle, http_session, url)) {
        LOGE("mbtk_http_session_url_set() fail.\n");
        return -1;
    }

    const mbtk_http_session_t* session = mbtk_http_session_get(http_handle, http_session);
    LOGI("HTTP:%d,%s,%d,%s\n",session->option,session->host,session->port,session->uri);


    mbtk_http_session_head_add(http_handle, http_session, "Connection", "KeepAlive");


    if(mbtk_http_session_start(http_handle, http_session)) {
        LOGE("mbtk_http_session_start() fail.\n");
        return -1;
    }

    if(strlen(Loction))
    {
        char Lon[20] ={0};
        char Lat[20] = {0};
        char *lon = Loction;
        char *lat = strstr(Loction, ",");
        if(lat != NULL )
        {
            memcpy(Lon, Loction, lat- lon);

            lat++;
            memcpy(Lat, lat, strlen(lat));

            sscanf((char*)Lon,"%lf",&resp->lon);
            sscanf((char*)Lat,"%lf",&resp->lat);
        }

    }

//    printf("lon:%f, lat:%f\n", resp->lon, resp->lat);
//	printf("\nloction:%s\n", Loction);

	return 0;
}





