//**********************
#include "ql/ql_dev.h"
#include "mbtk_type.h"
#include "mbtk_info_api.h"

//**********************

mbtk_info_handle_t* ql_info_handle = NULL;
int ql_info_handle_num = 0;
static bool inited = FALSE;

//**********************
QL_DEV_ERROR_CODE ql_dev_init()
{
    if(!inited && ql_info_handle == NULL)
    {
        ql_info_handle = mbtk_info_handle_get();
        if(ql_info_handle)
        {
            ql_info_handle_num++;
            inited = TRUE;
            return QL_DEV_SUCCESS;
        } else {
            LOGE("mbtk_info_handle_get() fail.");
            return QL_DEV_GENERIC_FAILURE;
        }
    } else {
        if(!inited) {
            ql_info_handle_num++;
            inited = TRUE;
        }
        return QL_DEV_SUCCESS;
    }
}

QL_DEV_ERROR_CODE ql_dev_release()
{
    if(ql_info_handle)
    {
        LOGD("ql_info_handle_num = %d", ql_info_handle_num);
        if(ql_info_handle_num == 1) { // 最后一个引用，可释放。
            int ret = mbtk_info_handle_free(&ql_info_handle);
            if(ret) {
                LOGE("mbtk_info_handle_free() fail.");
                return QL_DEV_GENERIC_FAILURE;
            }
            else
            {
                ql_info_handle_num = 0;
                ql_info_handle = NULL;
                return QL_DEV_SUCCESS;
            }
        } else {
            ql_info_handle_num--;
            return QL_DEV_SUCCESS;
        }
    }
    else
    {
        LOGE("DEV handle not inited.");
        return QL_DEV_GENERIC_FAILURE;
    }
}

QL_DEV_ERROR_CODE ql_dev_get_imei(char* imei)
{
    if(ql_info_handle == NULL || imei == NULL)
    {
        LOGE("ARG error.");
        return QL_DEV_GENERIC_FAILURE;
    }

    if(mbtk_imei_get(ql_info_handle, imei)) {
        return QL_DEV_GENERIC_FAILURE;
    } else {
        return QL_DEV_SUCCESS;
    }
}

QL_DEV_ERROR_CODE ql_dev_get_firmware_version(char* version)
{
    if(ql_info_handle == NULL || version == NULL)
    {
        LOGE("ARG error.");
        return QL_DEV_GENERIC_FAILURE;
    }

    if(mbtk_version_get(ql_info_handle, version)) {
        return QL_DEV_GENERIC_FAILURE;
    } else {
        return QL_DEV_SUCCESS;
    }
}

QL_DEV_ERROR_CODE ql_dev_get_model(char* model)
{
    if(ql_info_handle == NULL || model == NULL)
    {
        LOGE("ARG error.");
        return QL_DEV_GENERIC_FAILURE;
    }

    if(mbtk_model_get(ql_info_handle, model)) {
        return QL_DEV_GENERIC_FAILURE;
    } else {
        return QL_DEV_SUCCESS;
    }
}

QL_DEV_ERROR_CODE ql_dev_get_sn(char* sn)
{
    if(ql_info_handle == NULL || sn == NULL)
    {
        LOGE("ARG error.");
        return QL_DEV_GENERIC_FAILURE;
    }

    if(mbtk_sn_get(ql_info_handle, sn)) {
        return QL_DEV_GENERIC_FAILURE;
    } else {
        return QL_DEV_SUCCESS;
    }
}

QL_DEV_ERROR_CODE ql_dev_set_modem_fun(QL_DEV_MODEM_FUNCTION function, int rst)
{
    if(ql_info_handle == NULL)
    {
        LOGE("ARG error.");
        return QL_DEV_GENERIC_FAILURE;
    }
    mbtk_modem_info_t modem;
    modem.rst = rst;
    switch (function)
    {
        case QL_DEV_MODEM_MIN_FUN:
            modem.fun = MBTK_DEV_MODEM_MIN_FUN;
            break;
        case QL_DEV_MODEM_FULL_FUN:
            modem.fun = MBTK_DEV_MODEM_FULL_FUN;
            break;
        case QL_DEV_MODEM_DISABLE_RECEIVE_RF_CIRCUITS:
            modem.fun = MBTK_DEV_MODEM_DISABLE_RECEIVE_RF_CIRCUITS;
            break;
        case QL_DEV_MODEM_DISABLE_TRANSMIT_AND_RECEIVE_RF_CIRCUITS:
            modem.fun = MBTK_DEV_MODEM_DISABLE_TRANSMIT_AND_RECEIVE_RF_CIRCUITS;
            break;
        case QL_DEV_MODEM_DISABLE_SIM:
            modem.fun = MBTK_DEV_MODEM_DISABLE_SIM;
            break;
        case QL_DEV_MODEM_TURN_OFF_FULL_SECONDARY_RECEIVE:
            modem.fun = MBTK_DEV_MODEM_TURN_OFF_FULL_SECONDARY_RECEIVE;
            break;
        default:
            break;
    }
    if(mbtk_set_modem_fun(ql_info_handle, &modem)) {
        return QL_DEV_GENERIC_FAILURE;
    } else {
        return QL_DEV_SUCCESS;
    }
}

QL_DEV_ERROR_CODE ql_dev_get_modem_fun(int *function)
{
    if(ql_info_handle == NULL || function == NULL)
    {
        LOGE("ARG error.");
        return QL_DEV_GENERIC_FAILURE;
    }

    if(mbtk_get_modem_fun(ql_info_handle, function)) {
        return QL_DEV_GENERIC_FAILURE;
    } else {
        return QL_DEV_SUCCESS;
    }
}

//**********************
