#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <errno.h>
#include <fcntl.h>
#include "mbtk_fota.h"


int ql_fota_init(fota_callback cb)
{
    return mbtk_fota_init(cb);
}

/*******************************************************************************
* @brief write firmware package, the firmware package is written in segments.
         and The result of the write is output by calling the callback function.
         the firmware package size must less than 32MB
  @param
           fname: firmware package file
    segment_size: the length of once write, recommending 3*1024*1024 bytes
  @return
        if success return 0, else return -1
 *******************************************************************************/
int ql_fota_fw_write(char* fname, int segment_size)
{
    return mbtk_fota_fw_write(fname, segment_size);
}


/*******************************************************************************
* @brief download firmware by url, and write firmware package, the firmware
         package is written in segments. The result of the write is output by
         calling the callback function. the firmware package size must less than
         32MB
  @param
                 url: [IN] the address of download firmware package file, the url
                           support http or https protocol.
        segment_size: [IN] the length of once write, recommending 3*1024*1024 bytes
        conn_timeout: [IN] timeout to connect to the server, if set 0 that means
                           switch to the default build-in connection timeout(300s)
    download_timeout: [IN] timeout for download the firmware file. if set 0 that means
                           it never time out
  @return
        if success return 0, else return -1
 *******************************************************************************/
int ql_fota_fw_write_by_url(char* url, int segment_size,
                            int conn_timeout, int download_timeout)
{
    return mbtk_fota_fw_write_by_url(url, segment_size,conn_timeout, download_timeout);
}
/*******************************************************************************
* @brief reboot system and clear env
  @param
   is_reboot: if set 1, after fota success, reboot system
  @return
        if success return 0, else return -1
 *******************************************************************************/
int ql_fota_done(int is_reboot)
{
    return mbtk_fota_done1(is_reboot);
}
