#include "ql/ql_sim.h"
#include "mbtk_type.h"
#include "mbtk_info_api.h"

extern mbtk_info_handle_t* ql_info_handle;
extern int ql_info_handle_num;
static bool inited = FALSE;

QL_SIM_CardStatusIndMsgHandlerFunc_t handlerPtr_cb = NULL;

typedef struct
{
    uint8 *operator_l;
    uint8 *operator_s;
    uint32 mcc_mnc;
} operator_mcc_mnc_t;

static operator_mcc_mnc_t operator_mcc_mnc[] =
{
    {"China Mobile","CMCC",46000},
    {"China Unicom","CU",46001},
    {"China Mobile","CMCC",46002},
    {"China Telecom","CT",46003},
    {"China Mobile","CMCC",46004},
    {"China Telecom","CT",46005},
    {"China Unicom","CU",46006},
    {"China Mobile","CMCC",46007},
    {"China Mobile","CMCC",46008},
    {"China Unicom","CU",46009},
    {"China Telecom","CT",46011}
};

void ql_sim_state_change_cb(const void* data, int data_len)
{
    if(handlerPtr_cb != NULL)
    {
        //QL_SIM_NFY_MSG_ID msg_id, void *pv_data, int pv_data_len, void *contextPtr
        //handlerPtr_cb(net_data[2]);
    }
    mbtk_sim_card_info *info = NULL;
    info = (mbtk_sim_card_info*)data;

    QL_SIM_CARD_STATUS_INFO sim_card_info = {0};
    sim_card_info.card_state = info->sim;
    sim_card_info.card_type = info->sim_card_type;
    /*
        sim_client_handle_type  h_sim,
        E_QL_SIM_NFY_MSG_ID_T   e_msg_id,
        void                    *pv_data,
        void                    *contextPtr
    */
    handlerPtr_cb(QL_SIM_CARD_STATUS_UPDATE_EVENT, &sim_card_info, sizeof(QL_SIM_CARD_STATUS_INFO), NULL);
}

QL_SIM_ERROR_CODE ql_sim_init()
{
    if(!inited && ql_info_handle == NULL)
    {
        ql_info_handle = mbtk_info_handle_get();
        if(ql_info_handle)
        {
            ql_info_handle_num++;
            inited = TRUE;
            return QL_SIM_SUCCESS;
        } else {
            LOGE("mbtk_info_handle_get() fail.");
            return QL_SIM_GENERIC_FAILURE;
        }
    } else {
        if(!inited) {
            ql_info_handle_num++;
            inited = TRUE;
        }
        return QL_SIM_SUCCESS;
    }
}


QL_SIM_ERROR_CODE ql_sim_release()
{
    if(ql_info_handle)
    {
        LOGD("ql_info_handle_num = %d", ql_info_handle_num);
        if(ql_info_handle_num == 1) { // 最后一个引用，可释放。
            int ret = mbtk_info_handle_free(&ql_info_handle);
            if(ret) {
                LOGE("mbtk_info_handle_free() fail.");
                return QL_SIM_GENERIC_FAILURE;
            }
            else
            {
                ql_info_handle_num = 0;
                ql_info_handle = NULL;
                return QL_SIM_SUCCESS;
            }
        } else {
            ql_info_handle_num--;
            return QL_SIM_SUCCESS;
        }
    }
    else
    {
        LOGE("Sim handle not inited.");
        return QL_SIM_GENERIC_FAILURE;
    }
}


QL_SIM_ERROR_CODE ql_sim_get_imsi(uint8_t *imsi, size_t imsiLen)
{
    if(ql_info_handle == NULL || imsi == NULL || imsiLen <= 0)
    {
        LOGE("ARG error.");
        return QL_SIM_GENERIC_FAILURE;
    }
    memset(imsi,0,imsiLen);
    int err = mbtk_imsi_get(ql_info_handle, imsi);
    if(err) {
        return QL_SIM_GENERIC_FAILURE;
    } else {
        return QL_SIM_SUCCESS;
    }
}

QL_SIM_ERROR_CODE ql_sim_get_iccid(uint8_t *iccid, size_t iccidLen)
{
    if(ql_info_handle == NULL || iccid == NULL || iccidLen <= 0)
    {
        LOGE("ARG error.");
        return QL_SIM_GENERIC_FAILURE;
    }
    memset(iccid, 0, iccidLen);
    int err = mbtk_iccid_get(ql_info_handle, iccid);
    if(err) {
        return QL_SIM_GENERIC_FAILURE;
    } else {
        return QL_SIM_SUCCESS;
    }
}

QL_SIM_ERROR_CODE ql_sim_get_phonenumber(uint8_t *phone_num, size_t phoneLen)
{
    if(ql_info_handle == NULL || phone_num == NULL || phoneLen <= 0)
    {
        LOGE("ARG error.");
        return QL_SIM_GENERIC_FAILURE;
    }
    memset(phone_num, 0, phoneLen);
    int err = mbtk_phone_number_get(ql_info_handle, phone_num);
    if(err) {
        return QL_SIM_GENERIC_FAILURE;
    } else {
        return QL_SIM_SUCCESS;
    }
}

QL_SIM_ERROR_CODE ql_sim_get_operator_plmn_list(QL_SIM_PREFERRED_OPERATOR_LIST *pt_info)
{
    if(ql_info_handle == NULL || pt_info == NULL)
    {
        LOGE("ARG error.");
        return QL_SIM_GENERIC_FAILURE;
    }

    mbtk_plmn_info plmn;
    int err = mbtk_get_plmn_list(ql_info_handle, &plmn);
    if(err) {
        LOGE("mbtk_get_plmn_list file : %d",err);
        return QL_SIM_GENERIC_FAILURE;
    } else {
        memset(pt_info, 0x0, sizeof(QL_SIM_PREFERRED_OPERATOR_LIST));
        pt_info->preferred_operator_list_num = plmn.count;
        int list_count;
        for(list_count = 0; list_count < plmn.count; list_count++)
        {
            if(plmn.mbtk_plmn_name[list_count].format == 2)    //number
            {
                uint32 plmn_name = (uint32)atoi(plmn.mbtk_plmn_name[list_count].plmn_name);
                sprintf(pt_info->preferred_operator_list[list_count].mcc,"%d",plmn_name/100);
                sprintf(pt_info->preferred_operator_list[list_count].mnc,"%02d",plmn_name%100);
            }
            else if(plmn.mbtk_plmn_name[list_count].format == 0)
            {
                int i = 0;
                while(i < ARRAY_SIZE(operator_mcc_mnc))
                {
                    if(!strcmp(operator_mcc_mnc[i].operator_l,plmn.mbtk_plmn_name))
                        break;
                    i++;
                }

                if(i == ARRAY_SIZE(operator_mcc_mnc))   // No found mcc&mnc
                {
                    memcpy(pt_info->preferred_operator_list[list_count].mcc,0,3);
                    memcpy(pt_info->preferred_operator_list[list_count].mnc,0,3);
                }
                else
                {
                    sprintf(pt_info->preferred_operator_list[list_count].mcc, "%d", (operator_mcc_mnc[i].mcc_mnc)/100);
                    sprintf(pt_info->preferred_operator_list[list_count].mnc, "%d", (operator_mcc_mnc[i].mcc_mnc)%100);
                }
            }
            else
            {
                int i = 0;
                while(i < ARRAY_SIZE(operator_mcc_mnc))
                {
                    if(!strcmp(operator_mcc_mnc[i].operator_s,plmn.mbtk_plmn_name))
                        break;
                    i++;
                }

                if(i == ARRAY_SIZE(operator_mcc_mnc))   // No found mcc&mnc
                {
                    memcpy(pt_info->preferred_operator_list[list_count].mcc,0,3);
                    memcpy(pt_info->preferred_operator_list[list_count].mnc,0,3);
                }
                else
                {
                    sprintf(pt_info->preferred_operator_list[list_count].mcc, "%d", (operator_mcc_mnc[i].mcc_mnc)/100);
                    sprintf(pt_info->preferred_operator_list[list_count].mnc, "%d", (operator_mcc_mnc[i].mcc_mnc)%100);
                }
            }
        }
        int i;
        for (i=0;i<pt_info->preferred_operator_list_num;i++)
        {
            LOGD("pt_info->preferred_operator_list[%d].mcc=%s",i, pt_info->preferred_operator_list[i].mcc);
            LOGD("pt_info->preferred_operator_list[%d].mnc=%s",i, pt_info->preferred_operator_list[i].mnc);
        }
        return QL_SIM_SUCCESS;
    }
}

QL_SIM_ERROR_CODE ql_sim_verify_pin(QL_SIM_VERIFY_PIN_INFO *pt_info)
{
    if(ql_info_handle == NULL || pt_info == NULL)
    {
        LOGE("ARG error.");
        return QL_SIM_GENERIC_FAILURE;
    }

    int err = mbtk_verify_pin(ql_info_handle, pt_info->pin_value);
    if(err) {
        LOGE("mbtk_verify_pin fail : %d",err);
        return QL_SIM_GENERIC_FAILURE;
    } else {
        return QL_SIM_SUCCESS;
    }
}

QL_SIM_ERROR_CODE ql_sim_change_pin(QL_SIM_CHANGE_PIN_INFO *pt_info)
{
    if(ql_info_handle == NULL || pt_info == NULL)
    {
        LOGE("ARG error.");
        return QL_SIM_GENERIC_FAILURE;
    }
    mbtk_change_pin_info pin_info = {0};
    memcpy(pin_info.old_pin_value, pt_info->old_pin_value, strlen(pt_info->old_pin_value));
    memcpy(pin_info.new_pin_value, pt_info->new_pin_value, strlen(pt_info->new_pin_value));
    int err = mbtk_change_pin(ql_info_handle, &pin_info);
    if(err) {
        LOGE("mbtk_change_pin fail : %d",err);
        return QL_SIM_GENERIC_FAILURE;
    } else {
        return QL_SIM_SUCCESS;
    }
}

QL_SIM_ERROR_CODE ql_sim_unblock_pin(QL_SIM_UNBLOCK_PIN_INFO *pt_info)
{
    if(ql_info_handle == NULL || pt_info == NULL)
    {
        LOGE("ARG error.");
        return QL_SIM_GENERIC_FAILURE;
    }
    mbtk_unlock_pin_info puk_pin_info = {0};
    memcpy(puk_pin_info.pin_value, pt_info->new_pin_value, strlen(pt_info->new_pin_value));
    memcpy(puk_pin_info.puk_value, pt_info->puk_value, strlen(pt_info->puk_value));
    int err = mbtk_unlock_pin(ql_info_handle, &puk_pin_info);
    if(err) {
        LOGE("mbtk_unlock_pin fail : %d",err);
        return QL_SIM_GENERIC_FAILURE;
    } else {
        return QL_SIM_SUCCESS;
    }
}

QL_SIM_ERROR_CODE ql_sim_enable_pin(QL_SIM_VERIFY_PIN_INFO *pt_info)
{
    if(ql_info_handle == NULL || pt_info == NULL)
    {
        LOGE("ARG error.");
        return QL_SIM_GENERIC_FAILURE;
    }
    mbtk_enable_pin_info pin_info = {0};
    memcpy(pin_info.pin_value, pt_info->pin_value, strlen(pt_info->pin_value));
    pin_info.enable = 1;
    int err = mbtk_enable_pin(ql_info_handle, &pin_info);
    if(err) {
        LOGE("mbtk_enable_pin fail : %d",err);
        return QL_SIM_GENERIC_FAILURE;
    } else {
        return QL_SIM_SUCCESS;
    }
}

QL_SIM_ERROR_CODE ql_sim_disable_pin(QL_SIM_VERIFY_PIN_INFO *pt_info)
{
    if(ql_info_handle == NULL || pt_info == NULL)
    {
        LOGE("ARG error.");
        return QL_SIM_GENERIC_FAILURE;
    }
    mbtk_enable_pin_info pin_info = {0};
    memcpy(pin_info.pin_value, pt_info->pin_value, strlen(pt_info->pin_value));
    pin_info.enable = 0;
    int err = mbtk_enable_pin(ql_info_handle, &pin_info);
    if(err) {
        LOGE("ql_sim_disable_pin fail : %d",err);
        return QL_SIM_GENERIC_FAILURE;
    } else {
        return QL_SIM_SUCCESS;
    }
}

QL_SIM_ERROR_CODE ql_sim_get_card_status(QL_SIM_CARD_STATUS_INFO *pt_info)
{
    if(ql_info_handle == NULL || pt_info == NULL)
    {
        LOGE("sim not init.");
        return QL_SIM_GENERIC_FAILURE;
    }

    mbtk_sim_state_enum sim;
    mbtk_sim_card_type_enum sim_card_type;
    mbtk_pin_puk_last_times ql_last_times = {0};
    int err = mbtk_sim_state_get(ql_info_handle, &sim);
    LOGD("mbtk_sim_state_get - %d");
    if(err) {
        return QL_SIM_GENERIC_FAILURE;
    } else {
        memset(pt_info, 0x0, sizeof(QL_SIM_CARD_STATUS_INFO));
        pt_info->card_state = sim;
        switch (sim)
        {
            case 0:                     //ABSENT
                pt_info->card_state = QL_SIM_STAT_NOT_INSERTED;
                break;
            case 1:                     //NOT READY
                pt_info->card_state = QL_SIM_STAT_UNKNOWN;
                break;
            case 2:                     //READY
                pt_info->card_state = QL_SIM_STAT_READY;
                break;
            case 3:                     //SIM PIN
                pt_info->card_state = QL_SIM_STAT_SIM_PIN;
                break;
            case 4:                     //SIM PUK
                pt_info->card_state = QL_SIM_STAT_SIM_PUK;
                break;
            case 5:                     //NETWORK
                pt_info->card_state = QL_SIM_STAT_UNKNOWN;
                break;
            default:
                pt_info->card_state = QL_SIM_STAT_UNKNOWN;
                break;
        }
    }
    err = mbtk_sim_card_type_get(ql_info_handle, &sim_card_type);
    LOGD("mbtk_sim_card_type_get - %d", err);
    if(err) {
        return QL_SIM_GENERIC_FAILURE;
    } else {
        if(sim_card_type == 0 || sim_card_type == 2)
            pt_info->card_type = QL_SIM_CARD_TYPE_ICC;
        else if(sim_card_type == 1 || sim_card_type == 3)
            pt_info->card_type = QL_SIM_CARD_TYPE_UICC;
        else
            pt_info->card_type = QL_SIM_CARD_TYPE_UNKNOWN;
    }
    err = mbtk_pin_last_num_get(ql_info_handle, &ql_last_times);
    LOGD("mbtk_pin_last_num_get - %d", err);
    if(err) {
        return QL_SIM_GENERIC_FAILURE;
    } else {
        pt_info->card_pin_info.pin1_num_retries = ql_last_times.p1_retry;
        pt_info->card_pin_info.pin2_num_retries = ql_last_times.p2_retry;
        pt_info->card_pin_info.puk1_num_retries = ql_last_times.puk1_retry;
        pt_info->card_pin_info.puk2_num_retries = ql_last_times.puk2_retry;
    }
    return QL_SIM_SUCCESS;
}

QL_SIM_ERROR_CODE ql_sim_add_event_handler(QL_SIM_CardStatusIndMsgHandlerFunc_t handlerPtr, void* contextPtr)
{
    if(ql_info_handle == NULL || handlerPtr == NULL)
    {
        return QL_SIM_GENERIC_FAILURE;
    }
    handlerPtr_cb = handlerPtr;
    mbtk_sim_state_change_cb_reg(ql_info_handle, ql_sim_state_change_cb);
    return QL_SIM_SUCCESS;
}

