//#include "lynq/lynq_sms_api.h"
#include "mbtk_info_api.h"
#include "mbtk_pdu_sms.h"
#include "ql/ql_sms.h"


#include <stdio.h>
#include <stdlib.h>


#define TELEPHONE_NUM_MAX 16
#define MSM_NUMBER_MAX 1024+1
#define RES_NUM_MIN 128

#define DSC_to_msg(DSC) (DSC == 0 ? "Bit7" : (DSC == 1 ? "Bit8" : "UCS2"))

static mbtk_info_handle_t* info_handle = NULL;
static char center_address[15] = {0};


// 编码后短信

#if 0
struct PDUS {
    unsigned int count;
    char **PDU;
};
#endif

void lynq_sms_state_change_cb(const void* data, int data_len)
{
	LOGV("sms_state_change_cb()----------start\n");
	uint8 *ptr = (uint8*)data;
		printf("3sms_state_change_cb() : %s\n", ptr);

	struct SMS_Struct s = PDUDecoding(ptr);
	printf("服务中心地址: %s\n", s.SCA);
	printf("发送方地址: %s\n", s.OA);
	printf("服务中心时间戳: %s\n", s.SCTS);
	printf("消息内容: %s\n", s.UD);
	printf("数据编码方案： %s\n", DSC_to_msg(s.DCS));
}


QL_SMS_ERROR_CODE ql_sms_init()
{
    if(info_handle == NULL)
    {
        info_handle = mbtk_info_handle_get();
        if(info_handle)
        {
			printf("creat info_handle is success\n");
        }
		else{
			printf("creat info_handle is fail\n");
			return QL_SMS_GENERIC_FAILURE;
		}
    }

    return QL_SMS_SUCCESS;
}


QL_SMS_ERROR_CODE ql_sms_release()
{
    int ret = QL_SMS_SUCCESS;
    if(info_handle)
    {
        ret = mbtk_info_handle_free(&info_handle);
    }
    else
    {
        ret = QL_SMS_GENERIC_FAILURE;
    }

    return ret;
}


/*
*AT+CMGS="10086", CMGS TEST 				  // Send a SMS
> CMGS TEST
+CMGS: 17
OK
*/
/*
int charset: send sms mode
	 0:pdu, 1:text

*/
//当state 设置为 0（pdu）模式时，telephony_num应该设置为pud 数据大小的长度；msg：为pud 数据

QL_SMS_ERROR_CODE ql_sms_send_pdu_msg(uint8_t *phone_num,uint8_t *data,int sms_type)
{
    if(info_handle == NULL || phone_num == NULL || data == NULL)
    {
        return -1;
    }

    char cmgs[MSM_NUMBER_MAX] = {0};
    char resp[RES_NUM_MIN] = {0};
    char pdu_data[512] = {0};
    char phone_lenth[10] = {0};
    char *p = pdu_data;
    int mode = 0;
    int err = 0;
    int i = 0;
    
    if(strlen(data) > 512 || strlen(data) == 0 || strlen(phone_num) == 0)
    {
        printf("strlen(telephony_num):%d\n", strlen(phone_num));
        printf("strlen(msg):%d\n", strlen(data));
        return -1;
    }

    memset(center_address, 0, sizeof(center_address));
    memcpy(center_address, "+8613800280500", strlen("+8613800280500"));

    printf("phone_num:%s\n", phone_num);
    printf("center_address:%s\n", center_address);
    printf("data:%s\n", data);


    mode = 0;   // PDU

    char* pdu = NULL;
        char* smsc = SCAEncoding(center_address);
    struct PDUS *pdus = PDUEncoding(center_address,phone_num, data, NULL);

    for (i = 0; i < pdus->count; i++) {
         printf("第 %d 条:\n", i + 1);
         printf("%s\n", pdus->PDU[i]);
        pdu = pdus->PDU[i];
    }

    sprintf(p, "%s",smsc);
    printf("pdu_data:%s\n", pdu_data);
    sprintf(p+strlen(p), "%s", pdu);
    printf("pdu_data:%s\n",pdu_data);


    err = mbtk_sms_cmgf_set(info_handle, mode);
    if(err) {
       printf("cmgf set error : %d\n", err);
    } else {
       printf("cmgf set success\n");
    }

    sprintf(cmgs,"%d,%s",strlen(pdu_data), pdu_data);
    printf("cmgs:%s\n", cmgs);

    memset(resp, 0, sizeof(resp));

    err = mbtk_sms_cmgs_set(info_handle, cmgs, resp);
    if(err) {
        printf("Error : %d\n", err);
        return -1;
    } else {
        printf("cmgs set success . resp:%s\n", resp);
    }

    return 0;

}
QL_SMS_ERROR_CODE ql_sms_send_text_msg(uint8_t *phone_num,uint8_t *data,int sms_type)
{
    if(info_handle == NULL || phone_num == NULL || data == NULL)
    {
        return -1;
    }

    char cmgs[MSM_NUMBER_MAX] = {0};
    char resp[RES_NUM_MIN] = {0};
    int mode = 0;
    int err = 0;
    if(strlen(data) > 512 || strlen(data) == 0 || strlen(phone_num) == 0)
    {
        printf("strlen(telephony_num):%d\n", strlen(phone_num));
        printf("strlen(msg):%d\n", strlen(data));
        return -1;
    }

    mode = 1;   // text

    err = mbtk_sms_cmgf_set(info_handle, mode);
    if(err) {
       printf("cmgf set error : %d\n", err);
    } else {
       printf("cmgf set success\n");
    }

    sprintf(cmgs,"%s,%s",phone_num, data);
    printf("cmgs:%s\n", cmgs);

/*  char *ptr = strstr(cmd, "cmgs,");      //CMGS="10086",hf
    if(ptr != NULL)
    {
        ptr = strstr(cmd, ",");
        ptr++;
        memset(cmgs, 0, sizeof(cmgs));
        memcpy(cmgs, ptr, strlen(ptr));
        printf("1cmgs:%s, strlen(cmgs):%d\n", cmgs, strlen(cmgs));
    }
*/

    memset(resp, 0, sizeof(resp));

    err = mbtk_sms_cmgs_set(info_handle, cmgs, resp);
    if(err) {
        printf("Error : %d\n", err);
        return -1;
    } else {
        printf("cmgs set success . resp:%s\n", resp);
    }

    return 0;

}


QL_SMS_ERROR_CODE ql_sms_add_event_handler(QL_SMS_StatusIndMsgHandlerFunc_t handlerPtr, void* contextPtr)
{
    if(info_handle == NULL)
    {
        return QL_SMS_GENERIC_FAILURE;
    }

	int ret = mbtk_sms_cnmi_set(info_handle);
	if(ret)
	{
		printf("set cnmi fail\n");
		return QL_SMS_GENERIC_FAILURE;
	}

	mbtk_sms_state_change_cb_reg(info_handle, lynq_sms_state_change_cb);
	return QL_SMS_SUCCESS;
}


/*
	AT+CMGD=<index>[,<delflag>]

	Deletes message based on index
	node:
		index is -1, delete all message
		delflag set 4
*/

QL_SMS_ERROR_CODE ql_sms_delete_msg(size_t index)
{
    char cmgd[128] = {0};
    int err = 0;

    if(index == -1)		//delete all
    {
    	memcpy(cmgd, ",4", strlen(",4"));
    }
    else
    {
    	sprintf(cmgd,"%d",index);
    }

    printf("cmgd:%s\n", cmgd);

    err = mbtk_sms_cmgd_set(info_handle, cmgd);
    if(err) {
    	printf("lynq_delete_sms Error : %d\n", err);
    	return -1;
    } else {
    	printf("lynq_delete_sms set success\n");
    }

    return 0;

}


QL_SMS_ERROR_CODE ql_search_sms_text_message(int index, recvmessage* payload)
{
    if(info_handle == NULL)
    {
        return -1;
    }

    char cmgs[MSM_NUMBER_MAX] = {0};
    int mode = 1;   // text
    int err = 0;
    char *data = "ALL";

    err = mbtk_sms_cmgf_set(info_handle, mode);
    if(err) {
       printf("cmgf set error : %d\n", err);
    } else {
       printf("cmgf set success\n");
    }


    char cmgl[128] = {0};
    char resp[1024+1] ={0};
    sprintf(cmgl,"%d,%s", index, data);
/*
    char *ptr = strstr(cmd, "cmgl,");  //  AT+CMGL[=<stat>]
    if(ptr != NULL)
    {
        ptr = strstr(cmd, ",");
        ptr++;
        memset(cmgl, 0, sizeof(cmgl));
        memcpy(cmgl, ptr, strlen(ptr));
        printf("0cmgl:%s\n", cmgl);
    }
*/
    memset(resp, 0, sizeof(resp));
    err = mbtk_sms_cmgl_set(info_handle, cmgl, resp);
    if(err) {
        printf("lynq_list_sms Error : %d\n", err);
        return -1;
    } else {
        printf("cmgl set success, reg:%s\n",resp);
    }

    return 0;

}
QL_SMS_ERROR_CODE ql_search_sms_pdu_message(int index, recvmessage* payload)
{
    if(info_handle == NULL)
    {
        return -1;
    }

    char cmgs[MSM_NUMBER_MAX] = {0};
    int mode = 0;   // pud
    int err = 0;
    char *data = "ALL";


    err = mbtk_sms_cmgf_set(info_handle, mode);
    if(err) {
       printf("cmgf set error : %d\n", err);
    } else {
       printf("cmgf set success\n");
    }


    char cmgl[128] = {0};
    char resp[1024+1] ={0};
    sprintf(cmgl,"%d,%s", index, data);
/*
    char *ptr = strstr(cmd, "cmgl,");  //  AT+CMGL[=<stat>]
    if(ptr != NULL)
    {
        ptr = strstr(cmd, ",");
        ptr++;
        memset(cmgl, 0, sizeof(cmgl));
        memcpy(cmgl, ptr, strlen(ptr));
        printf("0cmgl:%s\n", cmgl);
    }
*/
    memset(resp, 0, sizeof(resp));
    err = mbtk_sms_cmgl_set(info_handle, cmgl, resp);
    if(err) {
        printf("lynq_list_sms Error : %d\n", err);
        return -1;
    } else {
        printf("cmgl set success, reg:%s\n",resp);
    }

    return 0;

}


/*
function: lynq_list_sms
stat:0:pud, 1:text
index: 0, list index;
	  > 0,

*/
QL_SMS_ERROR_CODE ql_sms_list_sms(int stat, int index, char *data)
{
    if(info_handle == NULL)
    {
        return -1;
    }

	char cmgs[MSM_NUMBER_MAX] = {0};
	int mode = 0;
	int err = 0;

	if(stat)	// text
	{
		mode = 1;
	}

	err = mbtk_sms_cmgf_set(info_handle, mode);
	if(err) {
	   printf("cmgf set error : %d\n", err);
	} else {
	   printf("cmgf set success\n");
	}


	char cmgl[128] = {0};
	char resp[1024+1] ={0};
	sprintf(cmgl,"%d,%s", index, data);
/*
	char *ptr = strstr(cmd, "cmgl,");  //  AT+CMGL[=<stat>]
	if(ptr != NULL)
	{
		ptr = strstr(cmd, ",");
		ptr++;
		memset(cmgl, 0, sizeof(cmgl));
		memcpy(cmgl, ptr, strlen(ptr));
		printf("0cmgl:%s\n", cmgl);
	}
*/
	memset(resp, 0, sizeof(resp));
	err = mbtk_sms_cmgl_set(info_handle, cmgl, resp);
	if(err) {
		printf("lynq_list_sms Error : %d\n", err);
		return -1;
	} else {
	    printf("cmgl set success, reg:%s\n",resp);
	}

	return 0;
}



int ql_sms_query_sms_storage_status(void)
{
	char mem[128] = {0};
	int err = mbtk_sms_cpms_get(info_handle, mem);
    if(err) {
        printf("cpms query is fail Error : %d\n", err);
		return -1;
    } else {
        printf("cpms query is success : %s\n", mem);
    }

	return 0;
}

QL_SMS_ERROR_CODE ql_sms_get_sms_center_address(uint8_t *sms_center_addree)
{
	char csca[128] = {0};
	if(info_handle == NULL || sms_center_addree == NULL)
    {
		return QL_SMS_GENERIC_FAILURE;
	}

	int err = mbtk_sms_csca_get(info_handle, sms_center_addree);
	if(err) {
		printf("lynq_get_smsc_address Error : %d\n", err);
		return QL_GET_RESPONSE_ERROR;
	} else {
		printf("lynq_get_smsc_address success\n");
	}

	return 0;
}


QL_SMS_ERROR_CODE ql_sms_set_sms_center_address(unsigned char *destNum)
{
    printf("1destNum:%s\n", destNum);
    memset(center_address, 0, sizeof(center_address));
        memcpy(center_address, destNum, strlen(destNum));
	if(info_handle == NULL || destNum == NULL)
	{
		return -1;
	}

	int err = mbtk_sms_csca_set(info_handle, destNum);
	if(err) {
		printf("Error : %d\n", err);
		return err;
	} else {
    //    memset(center_address, 0, sizeof(center_address));
    //    memcpy(center_address, destNum, strlen(destNum));
        printf("destNum:%s\n", destNum);
		printf("lynq_set_smsc_address success\n");
	}
	return 0;

}





