#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include <linux/types.h>
#include <linux/spi/spidev.h>

#include <stdint.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <getopt.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <linux/types.h>
#include <linux/spi/spidev.h>
#include <errno.h>

#include "ql/ql_spi.h"
#include "mbtk_log.h"

#if 0
static const char *device = "/dev/spidev1.0\0";
static uint8_t mode = 3; /* SPI通信使用全双工，设置CPOL＝0，CPHA＝0。 */
static uint8_t bits = 8; /* ８ｂiｔｓ读写，MSB first。*/
static uint32_t speed = 100 * 1000;/* 设置0.5M传输速度 */
static uint16_t delay = 500;

int SPI_Transfer(const uint8_t *TxBuf, uint8_t *RxBuf, int len)
{
    int ret;
    int fd = g_SPI_Fd;


    struct spi_ioc_transfer tr ;
    memset(&tr,0x00,sizeof(tr));
    tr.tx_buf = (unsigned long) TxBuf,
    tr.rx_buf = (unsigned long) RxBuf,
    tr.len =len,
    tr.delay_usecs = delay;
    tr.speed_hz=speed;
    tr.bits_per_word=bits;
    ret = ioctl(fd, SPI_IOC_MESSAGE(1), &tr);
    if (ret < 1)
    {
        printf("can't send spi message");
    }
   else
   {
        //printf("Send spi message OK %d\n",RxBuf[0]);
   }
   return 1;
}

/**
* 功 能：关闭SPI模块
*/
int SPI_Close(void)
{
    int fd = g_SPI_Fd;


    if (fd == 0) /* SPI是否已经打开*/
    return 0;
    close(fd);
    g_SPI_Fd = 0;


    return 0;
}

int SPI_Write(uint8_t *TxBuf, int len)
{
    int ret;
    int fd = g_SPI_Fd;

    printf("fd : %d\n",fd);
    ret = write(fd, TxBuf, len);
    if (ret < 0)
    printf("SPI Write errorn");

    return ret;
}

int SPI_Open(void)
{
    int fd;
    int ret = 0;

	printf("open spi dev:%s \r\n", device);
    fd = open(device, O_RDWR);
    if (fd < 0)
	{
        	printf("can't open device \n");
		return -1;
	}
    else
        printf("SPI - Open Succeed. Start Init SPI...n\n");

    /*
    * spi mode
    */
    ret = ioctl(fd, SPI_IOC_WR_MODE, &mode);
    if (ret == -1)
    printf("can't set spi mode\n");


    ret = ioctl(fd, SPI_IOC_RD_MODE, &mode);
    if (ret == -1)
    printf("can't get spi mode\n");


    /*
    * bits per word
    */
    ret = ioctl(fd, SPI_IOC_WR_BITS_PER_WORD, &bits);
    if (ret == -1)
      printf("can't set bits per word\n");


    ret = ioctl(fd, SPI_IOC_RD_BITS_PER_WORD, &bits);
    if (ret == -1)
      printf("can't get bits per word\n");


    /*
    * max speed hz
    */
    ret = ioctl(fd, SPI_IOC_WR_MAX_SPEED_HZ, &speed);
    if (ret == -1)
    printf("can't set max speed hz\n");


    ret = ioctl(fd, SPI_IOC_RD_MAX_SPEED_HZ, &speed);
    if (ret == -1)
        printf("can't get max speed hz\n");

    g_SPI_Fd=fd;
    return ret;
}
#endif

/**
 * Function:  Ql_SPI_Init
 * Description: spi init
 * Parameters:  dev_name---device name
 *              mode---spi mode
 *              bits---spi per word
 *              speed---spi transfer clock
 * Return: spi fd
 **/
int Ql_SPI_Init(const char *dev_name, SPI_MODE mode, unsigned char bits, SPI_SPEED speed)
{
    int fd;
    int ret = 0;

	LOGD("open spi dev:%s.", dev_name);
    fd = open(dev_name, O_RDWR);
    if (fd < 0)
	{
        LOGE("can't open device, errno - %d", errno);
        return -1;
	}
    else
        LOGD("SPI - Open Succeed. Start Init SPI...");

    /*
    * spi mode
    */
    ret = ioctl(fd, SPI_IOC_WR_MODE, &mode);
    if (ret == -1) {
        LOGE("can't set spi mode");
        goto error;
    }

#if 0
    ret = ioctl(fd, SPI_IOC_RD_MODE, &mode);
    if (ret == -1) {
        LOGE("can't get spi mode");
        goto error;
    }
#endif

    /*
    * bits per word
    */
    ret = ioctl(fd, SPI_IOC_WR_BITS_PER_WORD, &bits);
    if (ret == -1) {
        LOGE("can't set bits per word");
        goto error;
    }

#if 0
    ret = ioctl(fd, SPI_IOC_RD_BITS_PER_WORD, &bits);
    if (ret == -1) {
        LOGE("can't get bits per word");
        goto error;
    }
#endif

    /*
    * max speed hz
    */
    ret = ioctl(fd, SPI_IOC_WR_MAX_SPEED_HZ, &speed);
    if (ret == -1) {
        LOGE("can't set max speed hz");
        goto error;
    }

#if 0
    ret = ioctl(fd, SPI_IOC_RD_MAX_SPEED_HZ, &speed);
    if (ret == -1) {
        LOGE("can't get max speed hz");
        goto error;
    }
#endif

    return fd;
error:
    if(fd > 0)
    {
        close(fd);
    }
    return -1;
}

/**
 * Function: Ql_SPI_DeInit
 * Description: spi deinit
 * Parameters: fd---spi fd
 * Return:
 */
int Ql_SPI_DeInit(int fd)
{
    if (fd <= 0)
        return -1;

    close(fd);
    return 0;
}

/**
 * Function: Ql_SPI_Write_Read
 * Description: spi write read function
 * Parameters: fd---spi fd
 *              w_buf---write buffer
 *              r_buf---read buffer
 *              len---spi transfer length
 * Return: 0---transfer success
 *          other---failed
 **/
int Ql_SPI_Write_Read(int fd, unsigned char *w_buf, unsigned char *r_buf, unsigned int len)
{
    int ret;
    struct spi_ioc_transfer tr ;
    memset(&tr,0x00,sizeof(tr));
    tr.tx_buf = (unsigned long) w_buf,
    tr.rx_buf = (unsigned long) r_buf,
    tr.len =len,
    tr.delay_usecs = 500;
    //tr.speed_hz=speed;
    //tr.bits_per_word=bits;
    ret = ioctl(fd, SPI_IOC_MESSAGE(1), &tr);
    if (ret < 1)
    {
        LOGE("can't send spi message");
        return -1;
    }
    else
    {
        return 0;
    }
}


#if 0
int main(int argc, char *argv[])
{

	char send_data[64] = {0};
	char read_data[64] = {0};
	char crc = 0;
	int i = 0;
	int j = 0;

    system("echo PB6 > /sys/kernel/debug/sunxi_pinctrl/sunxi_pin");
    system("echo PB6 1 > /sys/kernel/debug/sunxi_pinctrl/function");
    system("echo PB6 0 > /sys/kernel/debug/sunxi_pinctrl/data");

	/* spi 初始化程序 */
	SPI_Open();

	send_data[0] = 0x55;
	send_data[1] = 0x00;
	send_data[2] = 0x84;
	send_data[3] = 0x00;
	send_data[4] = 0x08;
	send_data[5] = 0x00;
	send_data[6] = 0x00;

	crc = send_data[1];
	for (i = 2; i < 7; i++)
	{
		crc ^= send_data[i];
	}
	crc = ~crc;

	send_data[7] = crc;

	printf("send data:");
	for (i = 0; i < 8; i++)
	{
		printf("%#x, ", send_data[i]);
	}
	printf("\n");

	/* spi 发送数据 */
	SPI_Transfer(send_data,read_data,8);

	printf("read data:");
	for (j = 0; j < 20; j++)
	{
		printf("%#x, ", read_data[j]);
	}

	usleep(10000);


	memset(read_data, 0, sizeof(read_data));
	memset(send_data, 0, sizeof(send_data));

	/* spi 读取数据 */
	SPI_Transfer(send_data,read_data,16);

	printf("read data:");
	for (j = 0; j < 20; j++)
	{
		printf("%#x, ", read_data[j]);
	}

	return 0;
}
#endif
