#if 1
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <pthread.h>
#include <string.h>
#include <fcntl.h>
#include <signal.h>

#include "mbtk_led.h"
#include "mbtk_log.h"

/****************************DEFINE***************************************/
#define MBTK_RESULT_FAIL   -1
#define MBTK_RESULT_SUCCESS 0

#define MBTK_NET_LED 99
#define MBTK_STATUS_LED 8
/****************************DEFINE***************************************/

/****************************VARIABLE***************************************/
static mbtk_net_led_type mbtk_net_led_state = MBTK_NET_LED_SEARCH_NETWORK;
static mbtk_net_led_type mbtk_net_led_prev_state = MBTK_NET_LED_SEARCH_NETWORK;
static mbtk_status_led_type mbtk_status_led_state = MBTK_STATUS_LED_CLOSE;

static int MBTK_NET_LED_LOCK_SET = 0;
/****************************VARIABLE***************************************/

/******************************FUNC*****************************************/
int mbtk_read_ccinet(void)
{
    FILE *fp;
    int ret = 0;
    char buffer[1024];
    char type[10]={0};

    fp = popen("ifconfig", "r");
    if (fp == NULL) {
        printf("popen fail\n");
        return -1;
    }

    fread(buffer,1, sizeof(buffer) -1, fp);
    //LOGE("[led]buffer:%s\n", buffer);
    pclose(fp); //

    char *p1 = strstr(buffer, "ccinet");
    if(p1 == NULL)
    {
    	//LOGE("[led]read ccinet is null\n");
    	return -1;
    }

    return 0;
}

int mbtk_net_led_get(void)
{

    if (MBTK_NET_LED_LOCK_SET == 1)
    {
        mbtk_net_led_state = MBTK_NET_LED_CALL_CONNECT;//call 优先级最高
        return mbtk_net_led_state;
    }

    if(mbtk_net_led_state == MBTK_NET_LED_OPEN)
    {
        mbtk_net_led_state = mbtk_net_led_prev_state;
    }

    int ret = -1;
    if(mbtk_net_led_state == MBTK_NET_LED_NET_CONNECT)
    {
        ret = mbtk_read_ccinet();
        if(ret == 0)
        {
            mbtk_net_led_state = MBTK_NET_LED_DATA_CONNECT;
        }
    }
    return mbtk_net_led_state;
}

void mbtk_net_led_set(mbtk_net_led_type status)
{
    if(mbtk_net_led_state == MBTK_NET_LED_CLOSE)
    {
        if(status == MBTK_NET_LED_CLOSE || status == MBTK_NET_LED_OPEN)
        {
            //
        }
        else
        {
            mbtk_net_led_prev_state = status;
        }
    }
    else
    {
        if(status == MBTK_NET_LED_CLOSE)
        {
            mbtk_net_led_prev_state = mbtk_net_led_state;
        }
    }

    if (status == MBTK_NET_LED_CALL_CONNECT)
    {
        MBTK_NET_LED_LOCK_SET = 1;
    }

    if (status == MBTK_NET_LED_CALL_DISCONNECT)
    {
        MBTK_NET_LED_LOCK_SET = 0;
        status = MBTK_NET_LED_NET_CONNECT;
    }

    mbtk_net_led_state = status;
}

static int mbtk_led_gpio_init(int gpio)
{
    char buffer[50]= {0};
    char pin_index_buffer[5]= {0};
    int fd =-1;
    int result = -1;

    memset(buffer,0,50);
    sprintf(buffer,"/sys/class/gpio/gpio%d/direction", gpio);
    if(access(buffer , F_OK) != 0)
    {
        fd = open("/sys/class/gpio/export",O_WRONLY);
        if(fd < -1)
        {
            LOGE("[led]Open export fail.", gpio);
            return MBTK_RESULT_FAIL;
        }

        memset(pin_index_buffer,0,5);
        sprintf(pin_index_buffer,"%d", gpio);
        result = write(fd,pin_index_buffer,strlen(pin_index_buffer));
        close(fd);
        if(result < 0)
        {
            LOGE("[led]Gpio[%d] export fail.", gpio);
            return MBTK_RESULT_FAIL;
        }
        fd = -1;
    }

    fd = open(buffer, O_WRONLY);
    if(fd < -1)
    {
        LOGE("[led]Open gpio[%d] direct fail.", gpio);
        return MBTK_RESULT_FAIL;
    }

    result = write(fd, "out",strlen("out"));
    close(fd);
    if(result < 0)
    {
        LOGE("[led]Set gpio[%d] direct fail.", gpio);
        return MBTK_RESULT_FAIL;
    }
    return MBTK_RESULT_SUCCESS;
}

static int mbtk_led_gpio_level_set(int gpio, int value)
{
    char buffer[50]= {0};
    int fd =-1;
    int result =-1;

    memset(buffer,0,50);
    sprintf(buffer,"/sys/class/gpio/gpio%d/value", gpio);
    fd = open(buffer,O_WRONLY);
    if(fd < -1)
    {
        LOGE("[led]Open gpio[%d] value fail.", gpio);
        return MBTK_RESULT_FAIL;
    }
    if(value == 0)
    {
        result = write(fd,"0",1);
    }
    else
    {
        result = write(fd,"1",1);
    }
    close(fd);

    if(result != 1)
    {
        LOGE("[led]Set gpio[%d] value fail.", gpio);
        return MBTK_RESULT_FAIL;
    }

    return MBTK_RESULT_SUCCESS;
}

static void net_led_close(void)
{
    mbtk_led_gpio_level_set(MBTK_NET_LED, 0);
}

static void net_led_open(void)
{
    mbtk_led_gpio_level_set(MBTK_NET_LED, 1);
}

static void net_led_flicker_200ms(void)
{
    mbtk_led_gpio_level_set(MBTK_NET_LED, 1);
    usleep(200000);
    mbtk_led_gpio_level_set(MBTK_NET_LED, 0);
    usleep(200000);
}

static void net_led_flicker_800ms(void)
{
    mbtk_led_gpio_level_set(MBTK_NET_LED, 1);
    usleep(800000);
    mbtk_led_gpio_level_set(MBTK_NET_LED, 0);
    usleep(800000);
}

static void* net_led_thread_run(void* arg)
{
    mbtk_net_led_type status = MBTK_NET_LED_CLOSE;
    while(1)
    {
        status = mbtk_net_led_get();
        //LOGE("[led] get net led status = [%d].", status);

        if (status == MBTK_NET_LED_CALL_CONNECT) //call 优先
        {
            net_led_open();
        }
        else
        {
            switch(status)
            {
                case MBTK_NET_LED_CLOSE:
                case MBTK_NET_LED_POWER:
                {
                    net_led_close();
                    sleep(2);
                    break;
                }
                case MBTK_NET_LED_SEARCH_NETWORK:
                {
                    net_led_open();
                    sleep(2);
                    break;
                }
                case MBTK_NET_LED_DATA_CONNECT:
                {
                    net_led_flicker_200ms();
                    break;
                }
                case MBTK_NET_LED_NET_CONNECT:
                {
                    net_led_flicker_800ms();
                    break;
                }
                default:
                {
                    LOGE("[led]Uknown status.");
                    break;
                }
            }
        }
        sleep(1);
    }
    return NULL;
}

int status_led_set(mbtk_status_led_type status)
{
    int ret = MBTK_RESULT_FAIL;
    ret = mbtk_led_gpio_level_set(MBTK_STATUS_LED, status);
    if(ret != MBTK_RESULT_SUCCESS)
    {
        LOGE("[led]set status led fail.");
        return MBTK_RESULT_FAIL;
    }

    mbtk_status_led_state = status;
    return MBTK_RESULT_SUCCESS;
}


int mbtk_led_init(void)
{
    int ret = MBTK_RESULT_FAIL;

    mbtk_led_gpio_init(MBTK_STATUS_LED);
    mbtk_led_gpio_init(MBTK_NET_LED);
    status_led_set(MBTK_STATUS_LED_OPEN);
    mbtk_net_led_set(MBTK_NET_LED_SEARCH_NETWORK);

    pthread_attr_t thread_attr;
    pthread_t net_led_thread_id;
    pthread_t status_led_thread_id;
    pthread_attr_init(&thread_attr);
    if(pthread_attr_setdetachstate(&thread_attr, PTHREAD_CREATE_DETACHED))
    {
        LOGE("[led] pthread_attr_setdetachstate() fail.");
        return MBTK_RESULT_FAIL;
    }

    if(pthread_create(&net_led_thread_id, &thread_attr, net_led_thread_run, NULL))
    {
        LOGE("[led] pthread_create() fail.");
        return MBTK_RESULT_FAIL;
    }

    pthread_attr_destroy(&thread_attr);
    return MBTK_RESULT_SUCCESS;
}
/******************************FUNC*****************************************/

#endif

