#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netdb.h>
#include <fcntl.h>
#include <time.h>
#include <unistd.h>
#include <time.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <dirent.h>
#include "log_config.h"

/* 文件大小和修改时间 */
static int get_file_size_time(const char *filename)
{
	struct stat statbuf;
	/* 判断未打开文件 */
	if(stat(filename,&statbuf)==-1)
	{
		printf("Get stat on %s Error: %s\n", filename, strerror(errno));
		return(-1);
	}
	if(S_ISDIR(statbuf.st_mode)) // 目录
		return(1);
	if(S_ISREG(statbuf.st_mode)) // 文件
		printf("%s size: %ld bytes\tmodified at %s", filename, statbuf.st_size, ctime(&statbuf.st_mtime));
	return(0);
}

int __main(int argc,char **argv)
{
	DIR *dirp;
	struct dirent *direntp;
	int stats;

	if(argc!=2)
	{
		printf("Usage: %s filename\n\a", argv[0]);
		exit(1);
	}

	if(((stats=get_file_size_time(argv[1]))==0)||(stats==-1)) // 文件或出现错误
		exit(1);

	/* 打开目录 */
	if((dirp=opendir(argv[1]))==NULL)
	{
		printf("Open Directory %s Error: %s\n", argv[1], strerror(errno));
		exit(1);
	}

	/* 返回目录中文件大小和修改时间 */
	while((direntp=readdir(dirp))!=NULL)
	{
		/* 给文件或目录名添加路径:argv[1]+"/"+direntp->d_name */
		char dirbuf[512];
		memset(dirbuf,0,sizeof(dirbuf));
		strcpy(dirbuf,argv[1]);
		strcat(dirbuf,"/");
		strcat(dirbuf,direntp->d_name);
		if(get_file_size_time(dirbuf)==-1) break;
	}

	closedir(dirp);
	exit(1);
}
// 从后往前找
char *strstr_tail(const char *dst, const char *src)
{
    if(NULL == dst || NULL == src)
        return NULL;
    const char *pdst = dst;
    const char *psrc = src;
    char *tmp = NULL ;
    while (*pdst)                          //因为要从后向前找，则首先让pdst指向'\0'
    {
       pdst++;
    }

    while (pdst >= dst )                     //当pdst大于dst则表明dst这个字符串还没有找完
    {
        if ((tmp=(char *)strstr(pdst, psrc = src)))  //使用strstr帮助寻找，找到保存到tmp
        return tmp;

        pdst--;
     }

     return NULL ;
}

char* strcpy_malloc(char* src)
{
    if (NULL == src || 0 == strlen(src)) {
        return NULL;
    }
    int len = strlen(src);
    char* temp = malloc(len + 1);
    if (NULL == temp) {
        return NULL;
    }
    memset(temp, 0, len + 1);
    strcpy(temp, src);

    return temp;
}

int get_time (char *out_time)
{
    time_t rawtime;
    struct tm *info;
    char buffer[16] = {0};

    time( &rawtime );
    info = localtime(&rawtime);
    strftime(buffer, sizeof(buffer), "%Y%m%d%H%M%S \n", info);
    if(out_time)
        memcpy(out_time, &buffer[2], 12);

    return(0);
}

int tcp_connect(char* ip, int port)
{
    int sockfd;
    struct hostent* he;
    struct sockaddr_in server;

    he = gethostbyname(ip);

    if (he == NULL) {
        printf("gethostbyname error\n");
        exit(1);
    }

    sockfd = socket(AF_INET, SOCK_STREAM, 0);

    if (sockfd == -1) {
        printf("socket error\n");
        exit(1);
    }

    bzero(&server, sizeof(server));
    server.sin_family = AF_INET;
    server.sin_port = htons(port);
    server.sin_addr = *((struct in_addr*)he->h_addr);

    if (connect(sockfd, (struct sockaddr*)&server, sizeof(server)) == -1) {
        printf("connect error\n");
        exit(1);
    }

    return sockfd;
}
int movefile(char *src, char *dst)
{
    if (strcmp(src, dst) == 0)
    {
        printf("Destination file name and source file name can't be the same!");
        return -1;
    }
    FILE *fsrc = fopen(src, "rb"); //一定要“rb”否则复制的文件有时会不能使用
    FILE *fdst = fopen(dst, "wb"); //一定要“wb”否则复制的文件有时会不能使用
    int buflen = 1024;
    char buf[1024];
    int nread = 0;
    while ((nread = fread(buf, 1, buflen, fsrc)) > 0) //最好把读文件的代码放这里
    {
        fwrite(buf, 1, nread, fdst);
    }

    fclose(fsrc);
    fsrc = NULL;
    fclose(fdst);
    fdst = NULL;
    remove(src);//删除源文件

    return 0;
}
/**
 * @brief      get_rotate_file
 *
 * @details    转移log文件
 *
 * @param      param
 *
 * @return     return type
 */
int get_rotate_file(int fd, char *base_file, struct file_list_t *_file_list)
{
    char old_name[32] = {0};
    char new_name[32] = {0};


    int rotate_file_count_max = 0;

    if(_file_list->total == -1 || _file_list->total == 0 || _file_list->total > ROTATE_FILE_COUNT_MAX)
    {
        rotate_file_count_max = ROTATE_FILE_COUNT_MAX;
    }
    else
    {
        rotate_file_count_max = _file_list->total;
    }


    snprintf(new_name, sizeof(new_name), "%s.%d", base_file, rotate_file_count_max - 1);
    remove(new_name);

    for (int i = rotate_file_count_max - 1; i >= 0; i--)
    {
        if (i == 0)
        {
            snprintf(old_name, sizeof(old_name), "%s", base_file);
        }
        else
        {
            snprintf(old_name, sizeof(old_name), "%s.%d", base_file, i - 1);
        }
        snprintf(new_name, sizeof(new_name), "%s.%d", base_file, i);
        rename(old_name, new_name);
    }

    close(fd);
    int fd_new = open(base_file, O_CREAT | O_WRONLY | O_APPEND, 0600);
    if (fd_new < 0)
    {
        fprintf(stderr, "failed to open %s: %s\n", base_file, strerror(errno));
        exit(-1);
   }
    return fd_new;
}

#if 0
void get_rotate_file_test()
{
    struct file_list_t file_list;
    int i;
    char *test_path = "/tmp/log/m_log.txt";

    memset(&file_list, 0, sizeof(struct file_list_t));
    file_list.total = 3;

    int fd = open(test_path, O_CREAT | O_WRONLY | O_APPEND, 0600);
    if (fd < 0) {
        fprintf(stderr, "failed to open %s: %s\n", test_path, strerror(errno));
        exit(-1);
    }
    write(fd, "test1111", 8);
    for (i = 0; i < 6; ++i) {
        // sleep(1);
        fd = get_rotate_file(fd, test_path, &file_list);
        write(fd, "test2222", 8);
    }
    close(fd);
}
#endif
