#include <stdio.h>
#include <string.h>
#include <limits.h>
#include <sys/stat.h>

#include "aboot-tiny.h"
#include "jacana_firmware.h"
#include "jacana_pvt.h"

#ifdef PATH_MAX
#undef PATH_MAX
#define PATH_MAX    127
#else
#define PATH_MAX    127
#endif

extern char jacana_firmware_file_name[PATH_MAX];
extern char jacana_pvt_file_name[PATH_MAX];
/*---------------------------------------------------------------------------*/
void *
jacana_firmware_raw_open(void)
{
  FILE *file = fopen(jacana_firmware_file_name, "r");
  return (void *)file;
}
/*---------------------------------------------------------------------------*/
size_t
jacana_firmware_raw_get_total_size(void *priv)
{
  int fd = fileno((FILE *)priv);
  struct stat buf;
  fstat(fd, &buf);
  off_t size = buf.st_size;
  return size;
}
/*---------------------------------------------------------------------------*/
int
jacana_firmware_raw_read(void *priv, size_t start, uint8_t *data, size_t size)
{
  FILE *file = (FILE *)priv;
  fseek(file, start, SEEK_SET);
  return fread(data, 1, size, file);
}
/*---------------------------------------------------------------------------*/
void
jacana_firmware_raw_close(void *priv)
{
  fclose((FILE *)priv);
}
/*---------------------------------------------------------------------------*/
void *
jacana_pvt_raw_open(void)
{
  FILE *file = fopen(jacana_pvt_file_name, "r");
  return (void *)file;
}
/*---------------------------------------------------------------------------*/
size_t
jacana_pvt_raw_get_total_size(void *priv)
{
  return jacana_firmware_raw_get_total_size(priv);
}
/*---------------------------------------------------------------------------*/
int
jacana_pvt_raw_read(void *priv, size_t start, uint8_t *data, size_t size)
{
  return jacana_firmware_raw_read(priv, start, data, size);
}
/*---------------------------------------------------------------------------*/
void
jacana_pvt_raw_close(void *priv)
{
  jacana_firmware_raw_close(priv);
}
/*---------------------------------------------------------------------------*/
