#include "sparse_file.h"

/*---------------------------------------------------------------------------*/
int
sparse_file_new(sparse_file_t *sparse_file, size_t offset,
                size_t size, size_t file_size)
{
  sparse_header_t *sparse;
  chunk_header_t *chunk;
  unsigned chunk_num = 0;

  /* fill the sparse file structure */
  sparse = (sparse_header_t *)sparse_file->header;
  sparse->magic = SPARSE_HEADER_MAGIC;
  sparse->major_version = 1;
  sparse->minor_version = 0;
  sparse->file_hdr_sz = sizeof(sparse_header_t);
  sparse->chunk_hdr_sz = sizeof(chunk_header_t);
  sparse->blk_sz = SPARSE_BLOCK_SZ;
  sparse->total_blks = (file_size + SPARSE_BLOCK_SZ - 1) / SPARSE_BLOCK_SZ;
  sparse->image_checksum = 0;
  sparse->total_chunks = 3;

  chunk = (chunk_header_t *)(sparse + 1);
  chunk->chunk_type = CHUNK_TYPE_DONT_CARE;
  chunk->reserved1 = 0;
  chunk->chunk_sz = offset / SPARSE_BLOCK_SZ;
  chunk->total_sz = sizeof(chunk_header_t);
  chunk_num += chunk->chunk_sz;
  chunk++;

  chunk->chunk_type = CHUNK_TYPE_RAW;
  chunk->reserved1 = 0;
  chunk->chunk_sz = (size + SPARSE_BLOCK_SZ - 1) / SPARSE_BLOCK_SZ;
  unsigned fill_size = chunk->chunk_sz * SPARSE_BLOCK_SZ - size;
  chunk->total_sz = size + fill_size + sizeof(chunk_header_t);
  chunk_num += chunk->chunk_sz;

  sparse_file->header_size = SPARSE_FILE_HEADER_SIZE;
  sparse_file->data_size = size;
  sparse_file->fill_size = fill_size;
  sparse_file->footer_size = SPARSE_FILE_FOOTER_SIZE;

  chunk = (chunk_header_t *)(sparse_file->footer);
  chunk->chunk_type = CHUNK_TYPE_DONT_CARE;
  chunk->reserved1 = 0;
  chunk->chunk_sz = sparse->total_blks - chunk_num;
  chunk->total_sz = sizeof(chunk_header_t);

  return 0;
}
/*---------------------------------------------------------------------------*/
