/*
* mbtk_rtp.h
*
* MBTK RTP(VOIP) internal header file.
*
* Author : lb
* Date   : 2024/12/2 14:14:06
*/
#ifndef _MBTK_RTP_INTERNAL_H
#define _MBTK_RTP_INTERNAL_H
#include "mbtk_type.h"
#include "mbtk_audio2.h"
#ifdef MBTK_SOURCE_VERSION_2
#include "mbtk_ril_api.h"
#else
#include "mbtk_info_api.h"
#endif
#include "mbtk_loop_buffer.h"

#define MBTK_IND_START_FLAG     0xFF
#define MBTK_IND_END_FLAG       0xEE

#define RTP_UDP_SER_PORT_DEFAULT 53248
#define RTP_UDP_CLI_PORT_DEFAULT 55555
#define RTP_IPC_SOCK_PATH "/tmp/mbtk_rtp_sock"

#define RTP_SAMPLE_NUMBER 2     // 2 Byte for every sample.
#define RTP_DEFAULT_MTU 1280
#define MAX_IOVECS 16

typedef void (*rtp_socket_read_cb_func)(int fd);

typedef enum {
    RTP_STATE_DISABLE = 0,      // RTP disable,do nothing. Only wait audio mode change.
    RTP_STATE_ENABLE,           // RTP enable,but not on call.
    RTP_STATE_VOIP_PROCESS      // RTP enable and on call.
} rtp_state_enum;

typedef enum {
    RTP_UDP_SER_STATE_IDEL,
    RTP_UDP_SER_STATE_STARTING,
    RTP_UDP_SER_STATE_RUNNING,
    RTP_UDP_SER_STATE_STOPING
} rtp_udp_ser_state_enum;

typedef enum {
    RTP_VOIP_SER_STATE_IDEL,
    RTP_VOIP_SER_STATE_STARTING,
    RTP_VOIP_SER_STATE_RUNNING,
    RTP_VOIP_SER_STATE_STOPING
} rtp_voip_ser_state_enum;

typedef struct {
    rtp_state_enum rtp_state_pre;
    rtp_state_enum rtp_state_cur;
    int volume;
    char remote_ip[20];
    int server_port;    // Must be 53248 (remote port)
    int client_port;     // local port

    char vlan[32];
    mbtk_audio_sample_rate_enum sample_rate;
    int channel;    // Only support : 1
} rtp_config_t;

typedef struct {
    uint32 version;     // 2 (2 bit)
    uint32 padding;     // 0 (1 bit)
    uint32 extension;   // 0 (1 bit)
    uint32 csrc_count;        // 1 (4 bit)

    uint32 marker;      // 0 (1 bit)
    uint32 payload_type; // 0x60 (7 bit)

    uint32 sequence;    // (16 bit)

    uint32 timestamp;   // (32 bit)

    uint32 ssrc;        // 0xFFFF0000 (32 bit)

    uint32 csrc;        // 0xFFFF0000 (32 bit)
} rtp_header_info_t;

typedef struct {
    int fd;
    rtp_socket_read_cb_func read_cb;
} rtp_socket_info_t;

typedef struct {
    uint32 mtu;

    uint32 pack_size;
    struct iovec iov[MAX_IOVECS];
    int iov_idx;

    uint8 remain_buff[RTP_DEFAULT_MTU];
    uint32 remain_buff_len;
} rtp_udp_send_info_t;

typedef struct {
    bool first_packet;
    uint32_t offset;

    mbtk_loop_buff_handle *recv_buff;
} rtp_udp_recv_info_t;

typedef struct {
#ifdef MBTK_SOURCE_VERSION_2
    mbtk_ril_handle* ril_handle;
#else
    mbtk_info_handle_t *ril_handle;
#endif
    int epoll_fd;

    rtp_socket_info_t unix_sock_cli;

    rtp_socket_info_t udp_recv_sock;  // Server
    rtp_socket_info_t udp_send_sock;  // Client

    uint32 frame_size;
    uint32 playback_size;
    uint32 sample_for_ms;

    rtp_udp_send_info_t send;
    rtp_udp_recv_info_t recv;

    pthread_cond_t cond;
    pthread_mutex_t mutex;
} rtp_info_t;

#endif /* _MBTK_RTP_INTERNAL_H */
