/*
*    main.c
*
*    MBTK important service support.
*
*/
/******************************************************************************

                          EDIT HISTORY FOR FILE

  WHEN        WHO       WHAT,WHERE,WHY
--------    --------    -------------------------------------------------------
2024/6/12     LiuBin      Initial version

******************************************************************************/
#include <stdio.h>
#include <stdint.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <fcntl.h>
#include <cutils/properties.h>

#include "mbtk_type.h"
#include "mbtk_log.h"
#include "instance_info.h"
#include "mbtk_str.h"
#include "mbtk_utils.h"
#include "mbtk_led.h"
#include "reboot_reason.h"

#define MBTK_SERVICES_PID_FILE "/var/run/mbtk_servicesd.pid"
#define MBTK_SERVICES_CONF_FILE "/etc/mbtk_servicesd.conf"

extern int instance_info_size;
extern instance_info_t instance_infos[];
int ins_monitor_service_start();

static void config_parse(const char *conf_file)
{
    FILE *fptr = fopen(conf_file, "r");
    if(fptr != NULL) {
        char line[1024] = {0};
        bool respawn_process = FALSE;
        while(fgets(line, sizeof(line), fptr) != NULL && strlen(line) > 0) {
            if(str_startwith(line, "#")) {
                memset(line, 0, sizeof(line));
                continue;
            }

            if(!respawn_process && str_startwith(line, "respawn_start")) {
                respawn_process = TRUE;
                memset(line, 0, sizeof(line));
                continue;
            } else if(respawn_process && str_startwith(line, "respawn_end")) {
                respawn_process = FALSE;
                memset(line, 0, sizeof(line));
                continue;
            }

            char *ptr = line + strlen(line) - 1;
            while(ptr >= line && (*ptr == '\r' || *ptr == '\n' || *ptr == ' ')) {
                *ptr-- = '\0';
            }

            if(ptr < line) { // Empty line
                memset(line, 0, sizeof(line));
                continue;
            }

            if(respawn_process && instance_info_size < INSTANCE_NUM_MAX) {
                ptr = strstr(line, ":");
                if(ptr) {
                    *ptr++ = '\0';
                    memcpy(instance_infos[instance_info_size].ins_name, line, strlen(line));
                    memcpy(instance_infos[instance_info_size].ins_cmd, ptr, strlen(ptr));
                    instance_infos[instance_info_size].ins_pid = -1;
                    instance_info_size++;
                }
            }

            memset(line, 0, sizeof(line));
        }
        fclose(fptr);
    }
}

int main(int argc, char *argv[])
{
    mbtk_log_init("radio", "MBTK_SERVICES");

    MBTK_SOURCE_INFO_PRINT("mbtk_services");

#ifdef MBTK_DUMP_SUPPORT
    mbtk_debug_open(NULL, TRUE);
#endif

    if(app_already_running(MBTK_SERVICES_PID_FILE)) {
        LOGW("daemon already running.");
        exit(1);
    }

    config_parse(MBTK_SERVICES_CONF_FILE);

    // Start services.
    if(ins_monitor_service_start()) {
        LOGW("ins_monitor_service_start() fail.");
    }

    reboot_reason_init();

#ifdef MBTK_LED
    //led services
    char led_enable_str[10] = {0};
    memset(led_enable_str, 0, 10);
    property_get("persist.mbtk.led_enable", led_enable_str, "1");
    if(atoi(led_enable_str) == 1)
    {
        if(mbtk_led_init())
        {
            LOGE("mbtk_led_init() fail.");
        }

        if(mbtk_led_contril_server_init())
        {
            LOGW("LED_contril_service_start() fail.");
        }
    }
#endif

    while(1) {
        sleep(24 * 60 * 60);
    }

    return 0;
}

