/*
* logo_partition.h
*
* Logo partition header.
*
* Author : lb
* Date   : 2025/2/20 14:45:19
*/
#ifndef _LOGO_PARTITION_H
#define _LOGO_PARTITION_H

typedef unsigned int uint32; /* Unsigned 32 bit value */
typedef unsigned short uint16; /* Unsigned 16 bit value */
typedef unsigned char uint8; /* Unsigned 8  bit value */
typedef signed int int32; /* Signed 32 bit value */
typedef signed short int16; /* Signed 16 bit value */
typedef signed char int8; /* Signed 8  bit value */

/* 该变量只在uboot和kernel中加载        分区custom_logo时会使用 */
/* 与 mbtk_source 无关 */
#define LOGO_PARTITION_ADDR     0x0A3A0000    // custom_logo 分区的地址
#define LOGO_PARTITION_NAME     "custom_logo"

#define LOGO_SIZE_MAX           0x00080000    // 512K
#define LOGO_ADDR_START         0x00001000    // 4K (必须为页大小倍数)
#define ANIMATION_ADDR_START    (LOGO_ADDR_START + LOGO_SIZE_MAX)    // log 不超过 512K

typedef struct {
    uint32 addr;
    uint32 pic_width;
    uint32 pic_height;
    uint32 bg_rgb;      // 背景色
} mbtk_logo_header_t;

typedef struct {
    uint32 addr;
    uint32 pic_num;
    uint32 pic_width;
    uint32 pic_height;
    uint32 waitting_time;   // 每帧图片之间的等待时间（ms）
    uint32 frame_show_num;  // 总共显示的帧数
    uint32 bg_rgb;      // 背景色
} mbtk_animation_header_t;

#endif /* _LOGO_PARTITION_H */

