/*
 * Copyright (c) 2018 MediaTek Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#pragma once

#define PERIPHERAL_BASE_PHYS (0x10000000)
//#define PERIPHERAL_BASE_VIRT    (KERNEL_ASPACE_BASE + PERIPHERAL_BASE_PHYS)
#define PERIPHERAL_BASE_VIRT    (plat_wrap_paddr_to_kvaddr(PERIPHERAL_BASE_PHYS))

/* I/O mapping */
#define IO_PHYS             PERIPHERAL_BASE_VIRT

/* IO register definitions */
#define GPIO_BASE           (IO_PHYS + 0x00005000)

#define GPIO_RDSEL0_EN    (GPIO_BASE + 0xA10)
#define GPIO_RDSEL1_EN    (GPIO_BASE + 0xA20)
#define GPIO_RDSEL2_EN    (GPIO_BASE + 0xA30)
#define GPIO_RDSEL3_EN    (GPIO_BASE + 0xA40)
#define GPIO_RDSEL4_EN    (GPIO_BASE + 0xA50)
#define GPIO_RDSEL5_EN    (GPIO_BASE + 0xA60)
#define GPIO_RDSEL6_EN    (GPIO_BASE + 0xA70)
#define GPIO_RDSEL7_EN    (GPIO_BASE + 0xA80)
#define GPIO_RDSEL8_EN    (GPIO_BASE + 0xA90)
#define GPIO_RDSEL9_EN    (GPIO_BASE + 0xAA0)
#define GPIO_RDSELA_EN    (GPIO_BASE + 0xAB0)
#define GPIO_RDSELB_EN    (GPIO_BASE + 0xAC0)
#define GPIO_RDSELC_EN    (GPIO_BASE + 0xAD0)
#define GPIO_RDSELD_EN    (GPIO_BASE + 0xAE0)
#define GPIO_RDSELE_EN    (GPIO_BASE + 0xAF0)
#define GPIO_RDSELF_EN    (GPIO_BASE + 0xB00)
#define GPIO_RDSEL10_EN   (GPIO_BASE + 0xB10)
#define GPIO_RDSEL11_EN   (GPIO_BASE + 0xB20)
#define GPIO_MSDC0_CTRL5  (GPIO_BASE + 0xC70)
#define GPIO_MSDC1_CTRL5  (GPIO_BASE + 0xCB0)
#define GPIO_MSDC2_CTRL5  (GPIO_BASE + 0xD10)
#define GPIO_MSDC3_CTRL5  (GPIO_BASE + 0xD70)
#define GPIO_EXMD_CTRL0   (GPIO_BASE + 0xE40)
#define GPIO_NC_CTRL4     (GPIO_BASE + 0xF60)

/*----------------------------------------------------------------------------*/
#define RSUCCESS    0
#define ERACCESS    1
#define ERINVAL     2
#define ERWRAPPER   3
/*----------------------------------------------------------------------------*/

typedef struct {
    unsigned short val;
    unsigned short _align1;
    unsigned short set;
    unsigned short _align2;
    unsigned short rst;
    unsigned short _align3[3];
} VAL_REGS;
/*----------------------------------------------------------------------------*/
typedef struct {
    VAL_REGS dir[15];    /*0x0000 ~ 0x00E0: 15*16  bytes*/
    u8   rsv00[16];      /*0x00F0 ~ 0x00FF: 1*16  bytes*/
    VAL_REGS pullen[15]; /*0x0100 ~ 0x01E0: 15*16  bytes*/
    u8   rsv01[16];      /*0x01F0 ~ 0x01FF: 1*16 bytes*/
    VAL_REGS pullsel[15];/*0x0200 ~ 0x02E0: 15*16  bytes*/
    u8   rsv02[16];      /*0x02F0 ~ 0x02FF: 1*16 bytes*/
    VAL_REGS dout[15];   /*0x0300 ~ 0x03E0: 15*16 bytes*/
    u8   rsv03[16];      /*0x03F0 ~ 0x03FF: 1*16 bytes*/
    VAL_REGS din[15];    /*0x0400 ~ 0x04E0: 15*16 bytes*/
    u8   rsv04[16];      /*0x04F0 ~ 0x04FF: 1*16 bytes*/
    VAL_REGS mode[48];   /*0x0500 ~ 0x07F0: 48*16  bytes*/
    u8   rsv05[112];     /*0x0800 ~ 0x086F: 7*16 bytes*/
    VAL_REGS backup1[1]; /*0x0870 ~ 0x087F: 1*16  bytes*/
    VAL_REGS backup2[1]; /*0x0880 ~ 0x088F: 1*16  bytes*/
    VAL_REGS ies[4];     /*0x0890 ~ 0x08CF: 4*16  bytes*/
    VAL_REGS smt[4];     /*0x08D0 ~ 0x090F: 4*16  bytes*/
    VAL_REGS tdsel[16];  /*0x0910 ~ 0x0A0F: 16*16  bytes*/
    VAL_REGS rdsel[12];  /*0x0A10 ~ 0x0B2F: 12*16  bytes*/
    u8   rsv010[16];     /*0x0B30 ~ 0x0B3F: 1*16 bytes*/
    VAL_REGS drv_mode[16]; /*0x0B40 ~ 0x0C3F: 16*16  bytes*/
    VAL_REGS msdc0_crtl[4];  /*0x0C40 ~ 0x0C7F: 4*16 bytes*/
    VAL_REGS msdc1_crtl[6];  /*0x0C80 ~ 0x0CDF: 6*16 bytes*/
    VAL_REGS msdc2_crtl[6];  /*0x0CE0 ~ 0x0D3F: 6*16 bytes*/
    VAL_REGS msdc3_crtl[5];  /*0x0D40 ~ 0x0D8F: 6*16 bytes*/
    VAL_REGS msdc0_crtl3[1]; /*0x0D90 ~ 0x0D9F: 1*16 bytes*/
    VAL_REGS msdc0_crtl4[1]; /*0x0DA0 ~ 0x0DAF: 1*16 bytes*/
    VAL_REGS msdc1_crtl3[1]; /*0x0DB0 ~ 0x0DBF: 1*16 bytes*/
    VAL_REGS msdc1_crtl4[1]; /*0x0DC0 ~ 0x0DCF: 1*16 bytes*/
    VAL_REGS msdc2_crtl3[1]; /*0x0DD0 ~ 0x0DDF: 1*16 bytes*/
    VAL_REGS msdc2_crtl4[1]; /*0x0DE0 ~ 0x0DEF: 1*16 bytes*/
    VAL_REGS msdc3_crtl3[1]; /*0x0DF0 ~ 0x0DFF: 1*16 bytes*/
    VAL_REGS msdc3_crtl4[1]; /*0x0E00 ~ 0x0E0F: 1*16 bytes*/
    u8   rsv011[48];    /*0x0E10 ~ 0x0E3F: 3*16 bytes*/
    VAL_REGS exmd_ctrl0[1];  /*0x0E40 ~ 0x0E4F: 1*16 bytes*/
    VAL_REGS kpad_ctrl0[3];  /*0x0E50 ~ 0x0E7F: 3*16 bytes*/
    VAL_REGS hisc_ctrl0[4];  /*0x0E80 ~ 0x0EBF: 4*16 bytes*/
    VAL_REGS gpio_tm[1]; /*0x0EC0 ~ 0x0ECF: 1*16 bytes*/
    VAL_REGS gpio_backup0_crtl[3];   /*0x0ED0 ~ 0x0EFF: 3*16 bytes*/
    VAL_REGS gpio_backup1_crtl[3];   /*0x0FF0 ~ 0x0F2F: 3*16 bytes*/
    VAL_REGS nc_ctrl[4]; /*0x0F30 ~ 0x0F6F: 4*16 bytes*/
    VAL_REGS norm_trap[1];   /*0x0F70 ~ 0x0F7F: 1*16 bytes*/
    u8   rsv012[128];        /*0x0F80 ~ 0x0FFF: 8*16  bytes*/
} GPIO_REGS;

/*-------for gpio num to eint num-----------*/
struct mtk_lk_gpio_to_eint {
    unsigned int gpionum;
    unsigned int eintnum;
};

