/*
 * Copyright (c) 2018 MediaTek Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#include <err.h>
#include <mtk_i2c.h>
#include <stdio.h>
#include <stdlib.h>
#include <unittest.h>
#include <debug.h>
#include <lib/mempool.h>

#define BUS_NUM 2
#define DEV_ADDR 0x50
#define SPEED 1000
#define DATA 0x10

/**
 * lib/unittest defines several macros for unittest,
 * EXPECT_EQ, EXPECT_NEQ, EXPECT_LE, EXPECT_LT, EXPECT_GE, EXPECT_GT,
 * EXPECT_TRUE, EXPECT_FALSE, EXPECT_BYTES_EQ, EXPECT_BYTES_NE, EXPECT_EQ_LL,
 * ASSERT_NOT_NULL.
 * For detail, please refer to lib/unittest/include/unittest.h
 */

static uint8_t *Memory_alloc(uint32_t data_size,bool is_write)
{
    uint8_t *mem_addr;
    if (data_size<1)
        printf("Memory_alloc data_size parameter must greater than 0./r/n");
    mem_addr=(uint8_t *)mempool_alloc(data_size,MEMPOOL_UNCACHE);
    if (!mem_addr)
        printf("Memory_alloc is fail./r/n");
    if (is_write) {
        mem_addr[0]=0x10;
        for (uint32_t i = 1; i < data_size; i++)
            mem_addr[i]=DATA;
    } else {
        for (uint32_t i = 0; i < data_size; i++)
            mem_addr[i]=0;
    }
    return mem_addr;
}

static bool test_i2c_cust_write(void)
{
    BEGIN_TEST;
    uint32_t bus_num=BUS_NUM;
    uint8_t device_addr=DEV_ADDR;
    uint32_t speed_khz=SPEED;
    uint8_t write_length=15;
    uint8_t *write_buffer=Memory_alloc(write_length,true);
    EXPECT_EQ(NO_ERROR, i2c_cust_write(bus_num, device_addr, speed_khz,write_buffer, write_length), "fail to i2c_cust_write");
    END_TEST;
}

static bool test_i2c_cust_read(void)
{
    BEGIN_TEST;
    uint32_t bus_num=BUS_NUM;
    uint8_t device_addr=DEV_ADDR;
    uint32_t speed_khz=SPEED;
    uint8_t read_length=10;
    uint8_t write_length=1;
    uint8_t *read_buffer=Memory_alloc(read_length,false);
    uint8_t *write_buffer=Memory_alloc(write_length,true);
    uint8_t ret=NO_ERROR;
    plat_wrap_delay(2000);
    i2c_cust_write(bus_num, device_addr, speed_khz,write_buffer, write_length);
    i2c_cust_read(bus_num, device_addr, speed_khz,read_buffer, read_length);
    for (uint8_t i=0; i<read_length; i++) {
        if ((*read_buffer++)!=DATA)
            ret++;
    }
    EXPECT_EQ(NO_ERROR,ret,"i2c_cust_read() read back data error");
    END_TEST;
}

static bool test_i2c_cust_write_read(void)
{
    BEGIN_TEST;
    uint32_t bus_num=BUS_NUM;
    uint8_t device_addr=DEV_ADDR;
    uint32_t speed_khz=SPEED;
    uint8_t read_length=10;
    uint8_t write_length=3;
    uint8_t *read_buffer=Memory_alloc(read_length,false);
    uint8_t *write_buffer=Memory_alloc(write_length,true);
    uint8_t ret=NO_ERROR;
    EXPECT_EQ(NO_ERROR, i2c_cust_write_read(bus_num, device_addr, speed_khz,write_buffer, read_buffer,write_length, read_length), "fail to i2c_cust_write_read");
    for (uint8_t i=0; i<read_length; i++) {
        if ((*read_buffer++)!=DATA)
            ret++;
    }
    EXPECT_EQ(NO_ERROR,ret,"i2c_cust_write_read() read back data error");
    END_TEST;
}

BEGIN_TEST_CASE(i2c_test);
RUN_TEST(test_i2c_cust_write);
RUN_TEST(test_i2c_cust_read);
RUN_TEST(test_i2c_cust_write_read);
END_TEST_CASE(i2c_test);
