/*
 * Copyright (c) 2018 MediaTek Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#pragma once

#include <stdint.h>
#include <stddef.h>
#include <stdbool.h>

#define MTK_SPI0_BASE 0x1100a000
#define MTK_SPI2_BASE 0x11015000
#define MTK_SPI3_BASE 0x11016000
#define MTK_SPI4_BASE 0x10012000
#define MTK_SPI5_BASE 0x11018000

#define MTK_SPI_ROUNDUP_DIV(a, b) (((a) + ((b)-1)) / (b))

struct mtk_spi_bus {
    struct mtk_spi_regs *reg_addr;
    int state;
    bool ismap;
};

/* SPI peripheral register map. */
struct mtk_spi_regs {
    unsigned int spi_cfg0_reg;
    unsigned int spi_cfg1_reg;
    unsigned int spi_tx_src_reg;
    unsigned int spi_rx_dst_reg;
    unsigned int spi_tx_data_reg;
    unsigned int spi_rx_data_reg;
    unsigned int spi_cmd_reg;
    unsigned int spi_status0_reg;
    unsigned int spi_status1_reg;
    unsigned int spi_pad_sel_reg;
    unsigned int spi_cfg2_reg;
};

enum {
    SPI_HZ = 109200000,
    MTK_FIFO_DEPTH = 32,
    MTK_PACKET_SIZE = 8*1024,
    MTK_TXRX_TIMEOUT_US = 1000*1000,
    MTK_ARBITRARY_VALUE = 0xdadadada
};

enum {
    MTK_SPI_IDLE = 0,
    MTK_SPI_PAUSE_IDLE = 1
};

enum {
    MTK_SPI_BUSY_STATUS = 1,
    MTK_SPI_PAUSE_FINISH_INT_STATUS = 3
};

/* SPI_CFG0_REG */
enum {
    SPI_ADJUST_CFG0_CS_HOLD_OFFSET = 0,
    SPI_ADJUST_CFG0_CS_SETUP_OFFSET = 16,
};

enum {
    SPI_CFG0_SCK_HIGH_SHIFT = 0,
    SPI_CFG0_SCK_LOW_SHIFT = 8,
    SPI_CFG0_CS_HOLD_SHIFT = 16,
    SPI_CFG0_CS_SETUP_SHIFT = 24,
};

/*SPI_CFG1_REG*/
enum {
    SPI_CFG1_CS_IDLE_SHIFT = 0,
    SPI_CFG1_PACKET_LOOP_SHIFT = 8,
    SPI_CFG1_PACKET_LENGTH_SHIFT = 16,

    SPI_CFG1_CS_IDLE_MASK = 0xff << SPI_CFG1_CS_IDLE_SHIFT,
    SPI_CFG1_PACKET_LOOP_MASK = 0xff << SPI_CFG1_PACKET_LOOP_SHIFT,
    SPI_CFG1_PACKET_LENGTH_MASK = 0x3ff << SPI_CFG1_PACKET_LENGTH_SHIFT,
};

/*SPI_CFG2_REG*/
enum {
    SPI_ADJUST_CFG2_SCK_HIGH_OFFSET = 0,
    SPI_ADJUST_CFG2_SCK_LOW_OFFSET = 16,
};

enum {
    SPI_CMD_ACT_SHIFT = 0,
    SPI_CMD_RESUME_SHIFT = 1,
    SPI_CMD_RST_SHIFT = 2,
    SPI_CMD_PAUSE_EN_SHIFT = 4,
    SPI_CMD_DEASSERT_SHIFT = 5,
    SPI_CMD_CS_POL_SHIFT = 6,
    SPI_CMD_SAMPLE_SEL_SHIFT = 7,
    SPI_CMD_CPHA_SHIFT = 8,
    SPI_CMD_CPOL_SHIFT = 9,
    SPI_CMD_RX_DMA_SHIFT = 10,
    SPI_CMD_TX_DMA_SHIFT = 11,
    SPI_CMD_TXMSBF_SHIFT = 12,
    SPI_CMD_RXMSBF_SHIFT = 13,
    SPI_CMD_RX_ENDIAN_SHIFT = 14,
    SPI_CMD_TX_ENDIAN_SHIFT = 15,
    SPI_CMD_FINISH_IE_SHIFT = 16,
    SPI_CMD_PAUSE_IE_SHIFT = 17,

    SPI_CMD_ACT_EN = 1 << SPI_CMD_ACT_SHIFT,
    SPI_CMD_RESUME_EN = 1 << SPI_CMD_RESUME_SHIFT,
    SPI_CMD_RST_EN = 1 << SPI_CMD_RST_SHIFT,
    SPI_CMD_PAUSE_EN = 1 << SPI_CMD_PAUSE_EN_SHIFT,
    SPI_CMD_DEASSERT_EN = 1 << SPI_CMD_DEASSERT_SHIFT,
    SPI_CMD_CPHA_EN = 1 << SPI_CMD_CPHA_SHIFT,
    SPI_CMD_CPOL_EN = 1 << SPI_CMD_CPOL_SHIFT,
    SPI_CMD_RX_DMA_EN = 1 << SPI_CMD_RX_DMA_SHIFT,
    SPI_CMD_TX_DMA_EN = 1 << SPI_CMD_TX_DMA_SHIFT,
    SPI_CMD_TXMSBF_EN = 1 << SPI_CMD_TXMSBF_SHIFT,
    SPI_CMD_RXMSBF_EN = 1 << SPI_CMD_RXMSBF_SHIFT,
    SPI_CMD_RX_ENDIAN_EN = 1 << SPI_CMD_RX_ENDIAN_SHIFT,
    SPI_CMD_TX_ENDIAN_EN = 1 << SPI_CMD_TX_ENDIAN_SHIFT,
    SPI_CMD_FINISH_IE_EN = 1 << SPI_CMD_FINISH_IE_SHIFT,
    SPI_CMD_PAUSE_IE_EN = 1 << SPI_CMD_PAUSE_IE_SHIFT,
};
