/*
 * Copyright (c) 2018 MediaTek Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

/**
 * @file cust_common.h
 * @brief Header file of uart_cust driver
 *
 * Foo driver is a blah blah driver, which provides blah blah functions.
 * Several interfaces, init, config, set, get, tx and rx are provided to
 * manipulated the underlying hardware.
 */

#pragma once

#define IO_PHYS  0x10000000

#define BIT0    0x0001
#define BIT1    0x0002
#define BIT2    0x0004
#define BIT3    0x0008
#define BIT4    0x0010
#define BIT5    0x0020
#define BIT6    0x0040
#define BIT7    0x0080
#define BIT8    0x0100
#define BIT9    0x0200
#define BIT10   0x0400
#define BIT11   0x0800
#define BIT12   0x1000
#define BIT13   0x2000
#define BIT14   0x4000
#define BIT15   0x8000
#define BIT16   0x00010000
#define BIT17   0x00020000
#define BIT18   0x00040000
#define BIT19   0x00080000
#define BIT20   0x00100000
#define BIT21   0x00200000
#define BIT22   0x00400000
#define BIT23   0x00800000
#define BIT24   0x01000000
#define BIT25   0x02000000
#define BIT26   0x04000000
#define BIT27   0x08000000
#define BIT28   0x10000000
#define BIT29   0x20000000
#define BIT30   0x40000000
#define BIT31   0x80000000

#define DIV_ROUND_CLOSEST(x, div)   (((x) + ((div) / 2)) / (div))
#define DIV_ROUND_UP(n, div)        (((n) + (div) - 1) / (div))

#define WRAP_EDGE_SENSITIVE    0
#define WRAP_LEVEL_SENSITIVE   1
#define WRAP_POLARITY_LOW      0
#define WRAP_POLARITY_HIGH     1

#define TRUE 1
#define FLASE 0

#define INT_ENABLE 1
#define INT_DISABLE 0

struct circ_buf {
    char *buf;
    uint32_t write;
    uint32_t read;
    uint32_t size;
};

#define CIRC_CNT(write,read,size)   \
    ({((write)>=(read))?((write)-(read)):((size)+(write)-(read));})

#define CIRC_SPACE(write,read,size) \
    ({((write)>=(read))?((size)+(read)-(write)-1):((read)-(write)-1);})

#define CIRC_PUSH(circ,data)    \
    ({*((circ)->buf + (circ)->write) = data; \
    ((circ)->write) = (((circ)->write+1) < ((circ)->size)?((circ)->write+1):0);})

#define CIRC_POP(circ,data)     \
    ({*data = *((circ)->buf + (circ)->read); \
    ((circ)->read) = (((circ)->read+1) < ((circ)->size)?((circ)->read+1):0);})

#define CIRC_AVAIL(circ)    (CIRC_CNT((circ)->write, (circ)->read, (circ)->size))
#define CIRC_LEFT(circ)     (CIRC_SPACE((circ)->write, (circ)->read, (circ)->size))
#define CIRC_IS_EMPTY(circ)    ((circ)->write == (circ)->read)
#define CIRC_IS_FULL(circ)     ((CIRC_AVAIL(circ)) == ((circ)->size-1))

#ifndef min
#define min(x, y)   (x < y ? x : y)
#endif
#ifndef max
#define max(x, y)   (x > y ? x : y)
#endif

