/*
 * Copyright (c) 2018 MediaTek Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

/**
 * @file uart_dma_sw.h
 * @brief Header file of uart_cust driver
 *
 * Foo driver is a blah blah driver, which provides blah blah functions.
 * Several interfaces, init, config, set, get, tx and rx are provided to
 * manipulated the underlying hardware.
 */

#pragma once

#include "cust_common.h"
#include "uart_sw.h"

#define DRV_SUPPORT_VFF_CHANNEL     (DRV_SUPPORT_UART_PORTS * 2)
#define HW_SUPPORT_VFF_CHANNEL      (HW_SUPPORT_UART_PORTS * 2)

typedef enum {
    DMA_UNINIT,
    DMA_INIT,
} DMA_INIT_e;

typedef enum {
    DMA_DIR_TX,
    DMA_DIR_RX,
} DMA_DIR;

struct channel_info {
    uint32_t irq;
    uint32_t line;
    uint32_t status;
    uint32_t direction;
    uint32_t mem_length;
    uint64_t mem_base;
    void *base_addr;
    void *port_info;
};

#define DMA_READ32(addr)            readl(addr)
#define DMA_WRITE32(addr, value)    writel(value, addr)
#define DMA_READ8(addr)             readb(addr)
#define DMA_WRITE8(addr, value)     writeb(value, addr)

#define VFF_TX_THRE(n)              ((n)*9/10)  /* tx left size >= tx thrs */
#define VFF_RX_THRE(n)              ((n)*3/4)   /* trigger level of rx vfifo */
#define VFIFO_GET_LEFT(base)        DMA_READ32(VFF_LEFT_SIZE(base))
#define VFIFO_GET_AVAIL(base)       DMA_READ32(VFF_VALID_SIZE(base))
#define VFIFO_IS_FULL(base)         (0 == VFIFO_GET_LEFT(base))

void __uart_dma_start(struct uart_info *uart_port, char *dma_buff,
                       uint32_t dma_len);
void __uart_dma_enable_tx_INT(uint32_t port_line);

