/*
 * Copyright (c) 2018 MediaTek Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

/**
 * @file uart_hw.h
 * @brief Header file of uart_cust driver
 *
 * Foo driver is a blah blah driver, which provides blah blah functions.
 * Several interfaces, init, config, set, get, tx and rx are provided to
 * manipulated the underlying hardware.
 */

#pragma once

#define UART0_BASE                  (IO_PHYS + 0x01002000)
#define UART1_BASE                  (IO_PHYS + 0x01003000)
#define UART2_BASE                  (IO_PHYS + 0x01004000)
#define UART3_BASE                  (IO_PHYS + 0x01005000)
#define UART4_BASE                  (IO_PHYS + 0x01019000)
#define UART5_BASE                  (IO_PHYS + 0x0000f000)

#define UART0_IRQ_ID                123
#define UART1_IRQ_ID                124
#define UART2_IRQ_ID                125
#define UART3_IRQ_ID                126
#define UART4_IRQ_ID                158
#define UART5_IRQ_ID                159

#define UART_RBR(_baseaddr)         (_baseaddr+0x0)      /* Read only */
#define UART_THR(_baseaddr)         (_baseaddr+0x0)      /* Write only */
#define UART_IER(_baseaddr)         (_baseaddr+0x4)      /* Read Write */
#define UART_IIR(_baseaddr)         (_baseaddr+0x8)      /* Read only */
#define UART_FCR(_baseaddr)         (_baseaddr+0x8)      /* Write only */
#define UART_LCR(_baseaddr)         (_baseaddr+0xc)      /* Read Write */
#define UART_MCR(_baseaddr)         (_baseaddr+0x10)     /* Read Write */
#define UART_LSR(_baseaddr)         (_baseaddr+0x14)     /* Read only */
#define UART_MSR(_baseaddr)         (_baseaddr+0x18)     /* Read Write */
#define UART_SCR(_baseaddr)         (_baseaddr+0x1c)     /* Read Write */
#define UART_DLL(_baseaddr)         (_baseaddr+0x0)      /* Only when LCR = 0xbf */
#define UART_DLH(_baseaddr)         (_baseaddr+0x4)      /* Only when LCR = 0xbf */
#define UART_EFR(_baseaddr)         (_baseaddr+0x8)      /* Only when LCR = 0xbf */
#define UART_XON1(_baseaddr)        (_baseaddr+0x10)     /* Only when LCR = 0xbf */
#define UART_XON2(_baseaddr)        (_baseaddr+0x14)     /* Only when LCR = 0xbf */
#define UART_XOFF1(_baseaddr)       (_baseaddr+0x18)     /* Only when LCR = 0xbf */
#define UART_XOFF2(_baseaddr)       (_baseaddr+0x1c)     /* Only when LCR = 0xbf */
#define UART_AUTOBAUD_EN(_baseaddr)     (_baseaddr+0x20)
#define UART_HIGHSPEED(_baseaddr)       (_baseaddr+0x24)
#define UART_SAMPLE_COUNT(_baseaddr)    (_baseaddr+0x28)
#define UART_SAMPLE_POINT(_baseaddr)    (_baseaddr+0x2c)
#define UART_AUTOBAUD_REG(_baseaddr)    (_baseaddr+0x30)
#define UART_RATE_FIX_REG(_baseaddr)    (_baseaddr+0x34)
#define UART_AUTO_BAUDSAMPLE(_baseaddr) (_baseaddr+0x38)
#define UART_GUARD(_baseaddr)           (_baseaddr+0x3c)
#define UART_ESCAPE_DAT(_baseaddr)      (_baseaddr+0x40)
#define UART_ESCAPE_EN(_baseaddr)       (_baseaddr+0x44)
#define UART_SLEEP_EN(_baseaddr)        (_baseaddr+0x48)
#define UART_DMA_EN(_baseaddr)          (_baseaddr+0x4c)
#define UART_RXTRI_AD(_baseaddr)        (_baseaddr+0x50)
#define UART_FRACDIV_L(_baseaddr)       (_baseaddr+0x54)
#define UART_FRACDIV_M(_baseaddr)       (_baseaddr+0x58)
#define UART_FCR_RD(_baseaddr)          (_baseaddr+0x5C)
#define UART_FEATURE_SEL(_baseaddr)     (_baseaddr+0x9C)
#define UART_USB_RX_SEL(_baseaddr)      (_baseaddr+0xB0)
#define UART_SLEEP_REQ(_baseaddr)       (_baseaddr+0xB4)
#define UART_SLEEP_ACK(_baseaddr)       (_baseaddr+0xB8)
#define UART_SPM_SEL(_baseaddr)         (_baseaddr+0xBC)

/* IER */
#define UART_IER_ALLOFF                 0x0000
#define UART_IER_ERBFI                  0x0001 /* Enable receiver data interrupt */
#define UART_IER_ETBEI                  0x0002 /* Enable Transmitter holding register int. */
#define UART_IER_ELSI                   0x0004 /* Enable receiver line status interrupt */
#define UART_IER_EDSSI                  0x0008 /* Enable Modem status interrupt */
#define UART_IER_XOFFI                  0x0020
#define UART_IER_RTSI                   0x0040
#define UART_IER_CTSI                   0x0080
#define IER_HW_ONTY_RX                  (UART_IER_ERBFI)
#define IER_HW_NORMALINTS               (UART_IER_ERBFI | UART_IER_ETBEI)

/* IIR */
#define UART_IIR_INT_INVALID            0x0001
#define UART_IIR_THRE                   0x0002  /* Transmit Holding Register Empty */
#define UART_IIR_RDA                    0x0004  /* Receive Data Available */
#define UART_IIR_RLS                    0x0006  /* Receiver Line Status */
#define UART_IIR_CTI                    0x000C  /* Character Timeout Indicator */
#define UART_IIR_MS                     0x0000  /* Check Modem Status Register */
#define UART_IIR_SWFlowCtrl             0x0010  /* Receive XOFF characters */
#define UART_IIR_HWFlowCtrl             0x0020  /* CTS or RTS Rising Edge */
#define UART_IIR_FIFOS_ENABLED          0x00c0
#define UART_IIR_NO_INTERRUPT_PENDING   0x0001
#define UART_IIR_INT_MASK               0x003f

/* FCR */
#define UART_TX_FIFO_LENGTH             32

/* LCR */
//LCR WLS
#define UART_WLS_8                   0x0003
#define UART_WLS_7                   0x0002
#define UART_WLS_6                   0x0001
#define UART_WLS_5                   0x0000
#define UART_DATA_MASK               0x0003
//LCR Stop bits
#define UART_ONE_STOP_BIT            0x0000
#define UART_TWO_STOP_BIT            0x0004
#define UART_STOP_MASK               0x0004
//LCR Parity
#define UART_NONE_PARITY             0x0000
#define UART_ODD_PARITY              0x0008
#define UART_EVEN_PARITY             0x0018
#define UART_MARK_PARITY             0x0028
#define UART_SPACE_PARITY            0x0038
#define UART_PARITY_MASK             0x0038
//LCR DLAB
#define UART_LCR_DLAB                0x0080

/* MCR */
#define UART_MCR_DTR                 BIT0
#define UART_MCR_RTS                 BIT1
#define UART_MCR_Normal              (UART_MCR_DTR | UART_MCR_RTS)

/* FCR */
#define UART_FCR_FIFOEN              (1 << 0)
#define UART_FCR_CLRR                (1 << 1)
#define UART_FCR_CLRT                (1 << 2)
#define UART_FCR_RX1Byte_Level       0x0000
#define UART_FCR_RX6Byte_Level       0x0040
#define UART_FCR_RX12Byte_Level      0x0080
#define UART_FCR_RX16Byte_Level      0x00c0
#define UART_FCR_TX1Byte_Level       0x0000
#define UART_FCR_TX4Byte_Level       0x0010
#define UART_FCR_TX8Byte_Level       0x0020
#define UART_FCR_TX14Byte_Level      0x0030
#define UART_FCR_FIFOINI             (UART_FCR_FIFOEN | UART_FCR_CLRR | UART_FCR_CLRT)
#define UART_FCR_NORMAL_TRIG         (UART_FCR_TX1Byte_Level | UART_FCR_RX6Byte_Level | UART_FCR_FIFOINI)

/* LSR */
#define UART_LSR_DR                  (1 << 0) /* Receiver data ready */
#define UART_LSR_OE                  (1 << 1) /* Overrun error indicator */
#define UART_LSR_PE                  (1 << 2) /* Parity error indicator */
#define UART_LSR_FE                  (1 << 3) /* Frame error indicator */
#define UART_LSR_BI                  (1 << 4) /* Break interrupt indicator */
#define UART_LSR_THRE                (1 << 5) /* Transmit-hold-register empty */
#define UART_LSR_TEMT                (1 << 6) /* Transmitter empty */
#define UART_LSR_FIFOERR             (1 << 7) /* Fifo error */

/* MSR */
#define UART_MSR_DCD		    0x80 /* Data Carrier Detect */
#define UART_MSR_RI		    0x40 /* Ring Indicator */
#define UART_MSR_DSR		    0x20 /* Data Set Ready */
#define UART_MSR_CTS		    0x10 /* Clear to Send */
#define UART_MSR_DDCD		    0x08 /* Delta DCD */
#define UART_MSR_TERI		    0x04 /* Trailing edge ring indicator */
#define UART_MSR_DDSR		    0x02 /* Delta DSR */
#define UART_MSR_DCTS		    0x01 /* Delta CTS */
#define UART_MSR_ANY_DELTA	    0x0F /* Any of the delta bits! */

/* DMA_EN */
#define UART_RX_DMA_EN              (1 << 0)
#define UART_TX_DMA_EN              (1 << 1)
#define UART_TIMEROUT_AUTOSET       (1 << 2)

