/*
 * Copyright (c) 2018 MediaTek Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#pragma once
#include <mtk_wrapper.h>

/******************************************************************************
* Enumeration for GPIO pin
******************************************************************************/
typedef enum GPIO_PIN {
    GPIO_UNSUPPORTED = -1,
    GPIO0 ,  GPIO1  , GPIO2  , GPIO3  , GPIO4  , GPIO5  , GPIO6  , GPIO7  ,
    GPIO8  , GPIO9  , GPIO10 , GPIO11 , GPIO12 , GPIO13 , GPIO14 , GPIO15 ,
    GPIO16 , GPIO17 , GPIO18 , GPIO19 , GPIO20 , GPIO21 , GPIO22 , GPIO23 ,
    GPIO24 , GPIO25 , GPIO26 , GPIO27 , GPIO28 , GPIO29 , GPIO30 , GPIO31 ,
    GPIO32 , GPIO33 , GPIO34 , GPIO35 , GPIO36 , GPIO37 , GPIO38 , GPIO39 ,
    GPIO40 , GPIO41 , GPIO42 , GPIO43 , GPIO44 , GPIO45 , GPIO46 , GPIO47 ,
    GPIO48 , GPIO49 , GPIO50 , GPIO51 , GPIO52 , GPIO53 , GPIO54 , GPIO55 ,
    GPIO56 , GPIO57 , GPIO58 , GPIO59 , GPIO60 , GPIO61 , GPIO62 , GPIO63 ,
    GPIO64 , GPIO65 , GPIO66 , GPIO67 , GPIO68 , GPIO69 , GPIO70 , GPIO71 ,
    GPIO72 , GPIO73 , GPIO74 , GPIO75 , GPIO76 , GPIO77 , GPIO78 , GPIO79 ,
    GPIO80 , GPIO81 , GPIO82 , GPIO83 , GPIO84 , GPIO85 , GPIO86 , GPIO87 ,
    GPIO88 , GPIO89 , GPIO90 , GPIO91 , GPIO92 , GPIO93 , GPIO94 , GPIO95 ,
    GPIO96 , GPIO97 , GPIO98 , GPIO99 , GPIO100, GPIO101, GPIO102, GPIO103,
    GPIO104, GPIO105, GPIO106, GPIO107, GPIO108, GPIO109, GPIO110, GPIO111,
    GPIO112, GPIO113, GPIO114, GPIO115, GPIO116, GPIO117, GPIO118, GPIO119,
    GPIO120, GPIO121, GPIO122, GPIO123, GPIO124, GPIO125, GPIO126, GPIO127,
    GPIO128, GPIO129, GPIO130, GPIO131, GPIO132, GPIO133, GPIO134, GPIO135,
    GPIO136, GPIO137, GPIO138, GPIO139, GPIO140, GPIO141, GPIO142, GPIO143,
    GPIO144, GPIO145, GPIO146, GPIO147, GPIO148, GPIO149, GPIO150, GPIO151,
    GPIO152, GPIO153, GPIO154, GPIO155, GPIO156, GPIO157, GPIO158, GPIO159,
    GPIO160, GPIO161, GPIO162, GPIO163, GPIO164, GPIO165, GPIO166, GPIO167,
    GPIO168, GPIO169, GPIO170, GPIO171, GPIO172, GPIO173, GPIO174, GPIO175,
    GPIO176, GPIO177, GPIO178, GPIO179, GPIO180, GPIO181, GPIO182, GPIO183,
    GPIO184, GPIO185, GPIO186, GPIO187, GPIO188, GPIO189, GPIO190, GPIO191,
    GPIO192, GPIO193, GPIO194, GPIO195, GPIO196, GPIO197, GPIO198, GPIO199,
    GPIO200, GPIO201, GPIO202, GPIO203, GPIO204, GPIO205, GPIO206, GPIO207,
    GPIO208, GPIO209,
    MT_GPIO_BASE_MAX
} GPIO_PIN;

#define MAX_GPIO_PIN    (MT_GPIO_BASE_MAX)

/******************************************************************************
* Enumeration for GPIO pin
******************************************************************************/
/* GPIO MODE CONTROL VALUE*/
typedef enum {
    GPIO_MODE_UNSUPPORTED = -1,
    GPIO_MODE_GPIO  = 0,
    GPIO_MODE_00    = 0,
    GPIO_MODE_01    = 1,
    GPIO_MODE_02    = 2,
    GPIO_MODE_03    = 3,
    GPIO_MODE_04    = 4,
    GPIO_MODE_05    = 5,
    GPIO_MODE_06    = 6,
    GPIO_MODE_07    = 7,

    GPIO_MODE_MAX,
    GPIO_MODE_DEFAULT = GPIO_MODE_01,
} GPIO_MODE;
/*----------------------------------------------------------------------------*/
/* GPIO DIRECTION */
typedef enum {
    GPIO_DIR_UNSUPPORTED = -1,
    GPIO_DIR_IN     = 0,
    GPIO_DIR_OUT    = 1,

    GPIO_DIR_MAX,
    GPIO_DIR_DEFAULT = GPIO_DIR_IN,
} GPIO_DIR;
/*----------------------------------------------------------------------------*/
/* GPIO PULL ENABLE*/
typedef enum {
    GPIO_PULL_EN_UNSUPPORTED = -1,
    GPIO_PULL_DISABLE = 0,
    GPIO_PULL_ENABLE  = 1,

    GPIO_PULL_EN_MAX,
    GPIO_PULL_EN_DEFAULT = GPIO_PULL_ENABLE,
} GPIO_PULL_EN;
typedef enum {
    MTK_PUPD_SET_R1R0_00 = 0, /*pull disable, high-z*/
    MTK_PUPD_SET_R1R0_01 = 1, /*PU/PD 10K*/
    MTK_PUPD_SET_R1R0_10 = 2, /*PU/PD 50K*/
    MTK_PUPD_SET_R1R0_11 = 3, /*PU/PD 10K//50K*/

    GPIO_SPEC_PULL_EN_MAX,
    GPIO_SPEC_PULL_EN_DEFAULT = MTK_PUPD_SET_R1R0_01,
} GPIO_SPEC_PULL_EN;
/*----------------------------------------------------------------------------*/
/* GPIO PULL-UP/PULL-DOWN*/
typedef enum {
    GPIO_PULL_UNSUPPORTED = -1,
    GPIO_PULL_DOWN  = 0,
    GPIO_PULL_UP    = 1,

    GPIO_PULL_MAX,
    GPIO_PULL_DEFAULT = GPIO_PULL_DOWN
} GPIO_PULL;
/*----------------------------------------------------------------------------*/
/* GPIO OUTPUT */
typedef enum {
    GPIO_OUT_UNSUPPORTED = -1,
    GPIO_OUT_ZERO = 0,
    GPIO_OUT_ONE  = 1,

    GPIO_OUT_MAX,
    GPIO_OUT_DEFAULT = GPIO_OUT_ZERO,
    GPIO_DATA_OUT_DEFAULT = GPIO_OUT_ZERO,  /*compatible with DCT*/
} GPIO_OUT;
/*----------------------------------------------------------------------------*/
/* GPIO INPUT */
typedef enum {
    GPIO_IN_UNSUPPORTED = -1,
    GPIO_IN_ZERO = 0,
    GPIO_IN_ONE  = 1,

    GPIO_IN_MAX,
} GPIO_IN;
/*----------------------------------------------------------------------------*/
/* GPIO DRIVING */
typedef enum {
    MTK_DRIVE_2mA = 2,
    MTK_DRIVE_4mA = 4,
    MTK_DRIVE_6mA = 6,
    MTK_DRIVE_8mA = 8,
    MTK_DRIVE_10mA = 10,
    MTK_DRIVE_12mA = 12,
    MTK_DRIVE_14mA = 14,
    MTK_DRIVE_16mA = 16,
    MTK_DRIVE_20mA = 20,
    MTK_DRIVE_24mA = 24,
    MTK_DRIVE_28mA = 28,
    MTK_DRIVE_32mA = 32,

    GPIO_DRIVE_MAX = MTK_DRIVE_32mA,
} GPIO_DRIVING;
/*----------------------------------------------------------------------------*/
typedef enum {
    GPIO_VIO28 = 0,
    GPIO_VIO18 = 1,
    GPIO_VIO_MAX,
} GPIO_POWER;

/*----------------------------------------------------------------------------*/
typedef struct {
    unsigned int no     : 16;
    unsigned int mode   : 3;
    unsigned int pullsel: 1;
    unsigned int din    : 1;
    unsigned int dout   : 1;
    unsigned int pullen : 1;
    unsigned int dir    : 1;
    unsigned int dinv   : 1;
    unsigned int _align : 7;
} GPIO_CFG;
/*-------for msdc pupd-----------*/
struct msdc_pupd {
    unsigned short reg;
    unsigned char   bit;
};

/* for spec gpio 57-62 driving setting */
#define MTK_DRIVING_SET_F2F1E8E4_0000 200
#define MTK_DRIVING_SET_F2F1E8E4_0001 201
#define MTK_DRIVING_SET_F2F1E8E4_0010 202
#define MTK_DRIVING_SET_F2F1E8E4_0011 203
#define MTK_DRIVING_SET_F2F1E8E4_0100 204
#define MTK_DRIVING_SET_F2F1E8E4_0101 205
#define MTK_DRIVING_SET_F2F1E8E4_0110 206
#define MTK_DRIVING_SET_F2F1E8E4_0111 207
#define MTK_DRIVING_SET_F2F1E8E4_1000 208
#define MTK_DRIVING_SET_F2F1E8E4_1001 209
#define MTK_DRIVING_SET_F2F1E8E4_1010 210
#define MTK_DRIVING_SET_F2F1E8E4_1011 211
#define MTK_DRIVING_SET_F2F1E8E4_1100 212
#define MTK_DRIVING_SET_F2F1E8E4_1101 213
#define MTK_DRIVING_SET_F2F1E8E4_1110 214
#define MTK_DRIVING_SET_F2F1E8E4_1111 215
#define MASK_SPEC_DRIVING MTK_DRIVING_SET_F2F1E8E4_0000

/******************************************************************************
* GPIO Driver interface
******************************************************************************/
/*direction*/
signed int gpio_cust_set_dir(u32 pin, u32 dir);
signed int gpio_cust_get_dir(u32 pin);
/*pull enable*/
signed int gpio_cust_set_pull_enable(u32 pin, u32 enable, u32 r1r0);
signed int gpio_cust_get_pull_enable(u32 pin);
/*pull select*/
signed int gpio_cust_set_pull_select(u32 pin, u32 select);
signed int gpio_cust_get_pull_select(u32 pin);
/*input/output*/
signed int gpio_cust_set_out(u32 pin, u32 output);
signed int gpio_cust_get_out(u32 pin);
signed int gpio_cust_get_in(u32 pin);
/*mode control*/
signed int gpio_cust_set_mode(u32 pin, u32 mode);
signed int gpio_cust_get_mode(u32 pin);
/*driving*/
signed int gpio_cust_set_driving(u32 pin, unsigned char driving);
/*gpio to irq*/
signed int gpio_cust_get_irq(unsigned int gpio);
void gpio_cust_init(void);

