#include <pthread.h>

#include "Meta_mipc.h"
#include "LogDefine.h"


#include "mipc_msg_host.h"
#include "mipc_msg_tlv_const.h"
//#include "mipc_msg_tlv_api.h"

MetaMIPC::MetaMIPC()
{
	m_bReady = false;
}

MetaMIPC::~MetaMIPC(void)
{
	mipc_deinit();
}


static void atcid_mipc_ind_cb(mipc_msg_t *msg_ptr, void *priv_ptr)
{
	MetaMIPC *pData = (MetaMIPC*)priv_ptr;
		
	const char *urc = "+EIND: 128";
	char *urc_ptr = NULL;
	uint16_t urc_len;

	urc_ptr = (char *)mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_AT_IND_T_ATCMD, &urc_len);

	META_LOG("[Meta] read URC: len= %d,  %s", urc_len, urc_ptr);

	if( NULL != strstr(urc_ptr, urc))
	{
		if(pData != NULL)
			pData->SetModemReady(true);
	}		
}


void MetaMIPC::Init()
{
	int ret =mipc_init("meta_tst");
	META_LOG("[Meta] [MIPC] mipc_init result = %d", ret);
	
	mipc_msg_register_ind((mipc_msg_sim_ps_id_enum)MIPC_SYS_SIM_PS_PS0, MIPC_SYS_AT_IND, (void*)atcid_mipc_ind_cb, this);
}

bool MetaMIPC::Send_at_cmd(const char* cmd, char *res)
{
	mipc_msg_t *msg_req_ptr = NULL;
	mipc_msg_t *msg_cnf_ptr = NULL;
	mipc_result_enum result;
	char *atcmd_res_ptr = NULL;
	uint16_t atcmd_res_len = 0;

	msg_req_ptr = mipc_msg_init(MIPC_SYS_AT_REQ, (mipc_msg_sim_ps_id_enum)MIPC_SYS_SIM_PS_PS0);
	if(msg_req_ptr != NULL)
	{

	    mipc_msg_add_tlv(msg_req_ptr, MIPC_SYS_AT_REQ_T_ATCMD, strlen(cmd), cmd);
		
	    msg_cnf_ptr = mipc_msg_sync(msg_req_ptr);
		if(msg_cnf_ptr == NULL )
		{
			META_LOG("[Meta] [MIPC] mipc_msg_sync failed");
			return false;
		}
		META_LOG("[Meta] [MIPC] Send AT command [%s] with len:[%zd]", cmd, strlen(cmd));
		
		mipc_msg_deinit(msg_req_ptr);
	}
	else
	{
		META_LOG("[Meta] [MIPC] mipc_msg_init failed");
		return false;
	}
	
	atcmd_res_ptr = (char *)mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SYS_AT_CNF_T_ATCMD, &atcmd_res_len);
	atcmd_res_ptr[atcmd_res_len] = '\0';
	META_LOG("[Meta] [MIPC] AT response:[%s] with len:[%d]", atcmd_res_ptr, atcmd_res_len);
	strcpy(res, atcmd_res_ptr);
	res[atcmd_res_len] = '\0';

	mipc_msg_deinit(msg_cnf_ptr);
	return true;
	
}

