#include <assert.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdlib.h>

#ifdef IS_SUPPORT_SP
#include <cutils/properties.h>
#include <cutils/sockets.h>
#endif

#include <unistd.h>
#include <syslog.h>

#include "Modem.h"
#include "SerPort.h"
#include "MSocket.h"
#include "UsbRxWatcher.h"
#include "Context.h"
#include "PortInterface.h"
#include "LogDefine.h"

int main(int argc, char** argv)
{
	openlog( "[META]", LOG_PID, LOG_DAEMON );

	META_LOG("[Meta] Enter meta_tst init flow! V1.01.00");

/*
#ifndef	MTK_META_APONLY
	if(META_BOOT != getBootMode())
	{
		META_LOG("[Meta] not meta mode boot!");
		return 0;
	}
#endif
*/

	umask(007);

	UsbRxWatcher hostRx;
    setVirtualRxWatcher(&hostRx);

	SerPort *pPort = NULL;

	META_LOG("[Meta] is meta mode");
	pPort = createSerPort();
	if (pPort != NULL)
	{
		pPort->pumpAsync(&hostRx);
	}
	else
	{
		META_LOG("[Meta] Enter meta_tst init fail");
	}

/*
#ifndef	MTK_META_APONLY
	createAllModemThread();
#endif
*/
    createAllModemThread();

	while (1)
	{
		usleep(100*1000);
		//querySerPortStatus(); //query port type change every 100ms
	}

	// infinite loop above; it'll never get here...
	destroyContext();

	return 0;
}
