/*
 * Copyright (C) 2019 MediaTek Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See http://www.gnu.org/licenses/gpl-2.0.html for more details.
 */

#include <linux/init.h>
#include <linux/module.h>
#include <linux/device.h>
#include <linux/platform_device.h>
#include <linux/of_device.h>
#include <linux/of_irq.h>
#include <linux/miscdevice.h>
#include <linux/delay.h>
#include <linux/gpio.h>
#include <linux/of_gpio.h>
#include <linux/interrupt.h>
#include <linux/proc_fs.h>
#include <linux/debugfs.h>
#include <linux/fs.h>
#include <linux/uaccess.h>
#include <linux/poll.h>

#define PROC_NAME_OF_EINT_GPIO  "eint_gpio_debug"

#define IRQF_TRIGGER_NONE	0x00000000
#define IRQF_TRIGGER_RISING	0x00000001
#define IRQF_TRIGGER_FALLING	0x00000002
#define IRQF_TRIGGER_HIGH	0x00000004
#define IRQF_TRIGGER_LOW	0x00000008

static volatile int ev_press = 0;

int major;

static DECLARE_WAIT_QUEUE_HEAD(button_waitq);

 
static struct fasync_struct *button_fasync;

static struct class *fifthdrv_class;
//static struct class_device	*fifthdrv_class_dev;
//static int gpio_tri;
static int  gpio_num=0;
static int tri_type;
static int trigger;
static int trigger2;
static int trigger_num=0;
static int irq_gpio1,irq_gpio2,irq_gpio3,irq_gpio4,irq_gpio5,irq_gpio6;
static irqreturn_t irq_gpio1_eint(int irq, void *data)
{
	//struct musb *musb = data;
    pr_err("zz irq_gpio1_eint\n");
	disable_irq_nosync(irq);
 //   gpio_tri=1;
	

    if(tri_type==trigger){
	trigger_num=1;
		 pr_err("zz11\n");
		irq_set_irq_type(irq, trigger2);
		tri_type=trigger2;
	}
	else{
	trigger_num=0;
		 pr_err("zz22\n");
		irq_set_irq_type(irq, trigger);
		tri_type=trigger;
	}
	enable_irq(irq);

	ev_press = 1;				   /* ??D??騦? */
	wake_up_interruptible(&button_waitq);	/* ??D?DY?????3 */	 
	kill_fasync(&button_fasync,SIGIO,POLL_IN);//D?o?
	 pr_err("zz44555\n");
	return IRQ_HANDLED;
}
static irqreturn_t irq_gpio2_eint(int irq, void *data)
{
	//struct musb *musb = data;
    pr_err("zz irq_gpio1_eint\n");
	disable_irq_nosync(irq);
 //   gpio_tri=1;
	

    if(tri_type==trigger){
	trigger_num=1;
		 pr_err("zz11\n");
		irq_set_irq_type(irq, trigger2);
		tri_type=trigger2;
	}
	else{
	trigger_num=0;
		 pr_err("zz22\n");
		irq_set_irq_type(irq, trigger);
		tri_type=trigger;
	}
	enable_irq(irq);

	ev_press = 1;				   /* ??D??騦? */
	wake_up_interruptible(&button_waitq);	/* ??D?DY?????3 */	 
	kill_fasync(&button_fasync,SIGIO,POLL_IN);//D?o?
	 pr_err("zz44555\n");
	return IRQ_HANDLED;
}



static irqreturn_t irq_gpio3_eint(int irq, void *data)
{
	//struct musb *musb = data;
    pr_err("zz irq_gpio1_eint\n");
	disable_irq_nosync(irq);
 //   gpio_tri=1;
	
    if(tri_type==trigger){
	trigger_num=1;
		 pr_err("zz11\n");
		irq_set_irq_type(irq, trigger2);
		tri_type=trigger2;
	}
	else{
	trigger_num=0;
		 pr_err("zz22\n");
		irq_set_irq_type(irq, trigger);
		tri_type=trigger;
	}
	enable_irq(irq);

	ev_press = 1;				   /* ??D??騦? */
	wake_up_interruptible(&button_waitq);	/* ??D?DY?????3 */	 
	kill_fasync(&button_fasync,SIGIO,POLL_IN);//D?o?
	 pr_err("zz44555\n");
	return IRQ_HANDLED;
}






static irqreturn_t irq_gpio4_eint(int irq, void *data)
{
	//struct musb *musb = data;
    pr_err("zz irq_gpio1_eint\n");
	disable_irq_nosync(irq);
 //   gpio_tri=1;
	

    if(tri_type==trigger){
	trigger_num=1;
		 pr_err("zz11\n");
		irq_set_irq_type(irq, trigger2);
		tri_type=trigger2;
	}
	else{
	trigger_num=0;
		 pr_err("zz22\n");
		irq_set_irq_type(irq, trigger);
		tri_type=trigger;
	}
	enable_irq(irq);

	ev_press = 1;				   /* ??D??騦? */
	wake_up_interruptible(&button_waitq);	/* ??D?DY?????3 */	 
	kill_fasync(&button_fasync,SIGIO,POLL_IN);//D?o?
	 pr_err("zz44555\n");
	return IRQ_HANDLED;
}

static irqreturn_t irq_gpio5_eint(int irq, void *data)
{
	//struct musb *musb = data;
    pr_err("zz irq_gpio1_eint\n");
	disable_irq_nosync(irq);
 //   gpio_tri=1;
	

    if(tri_type==trigger){
	trigger_num=1;
		 pr_err("zz11\n");
		irq_set_irq_type(irq, trigger2);
		tri_type=trigger2;
	}
	else{
	trigger_num=0;
		 pr_err("zz22\n");
		irq_set_irq_type(irq, trigger);
		tri_type=trigger;
	}
	enable_irq(irq);

	ev_press = 1;				   /* ??D??騦? */
	wake_up_interruptible(&button_waitq);	/* ??D?DY?????3 */	 
	kill_fasync(&button_fasync,SIGIO,POLL_IN);//D?o?
	 pr_err("zz44555\n");
	return IRQ_HANDLED;
}
static irqreturn_t irq_gpio6_eint(int irq, void *data)
{
	//struct musb *musb = data;
    pr_err("zz irq_gpio1_eint\n");
	disable_irq_nosync(irq);
 //   gpio_tri=1;
	

    if(tri_type==trigger){
	trigger_num=1;
		 pr_err("zz11\n");
		irq_set_irq_type(irq, trigger2);
		tri_type=trigger2;
	}
	else{
	trigger_num=0;
		 pr_err("zz22\n");
		irq_set_irq_type(irq, trigger);
		tri_type=trigger;
	}
	enable_irq(irq);

	ev_press = 1;				   /* ??D??騦? */
	wake_up_interruptible(&button_waitq);	/* ??D?DY?????3 */	 
	kill_fasync(&button_fasync,SIGIO,POLL_IN);//D?o?
	 pr_err("zz44555\n");
	return IRQ_HANDLED;
}


//static int sleep_gpio = 0;
static ssize_t eint_gpio_read(struct file *file, char __user *page, size_t count, loff_t *ppos)
{
	char data_buffer[256]={0};	
int len;
int ret;
    
	wait_event_interruptible(button_waitq, ev_press);
	snprintf(data_buffer,sizeof(data_buffer),"%d %d %d",gpio_num,trigger,trigger_num);
		len = strlen(data_buffer);
	pr_info(" [gpio_num]=%d, [trigger]=%d, [trigger_num]=%d\n",gpio_num,trigger,trigger_num);
	ret=copy_to_user(page, data_buffer, len);
	pr_info("Return Value:%s\n\n", data_buffer);
	ev_press = 0;

	return len;
	
	
	
	
	
	
	
}
static ssize_t eint_gpio_write(struct file *filp, const char __user *buff, size_t count, loff_t *data)
{
		int copybufsize = 0;
		int scanf_ret=0;
		
		int  ret;
		unsigned char buf[1024] = {'\0'};
		//gpio_tri=0;
       // trigger_num=0;
		copybufsize = (count<(sizeof(buf)%sizeof(buf[0])-1)) ? count :(sizeof(buf)%sizeof(buf[0])-1);
		  if (copy_from_user(&buf, buff, copybufsize)) 
	    {
	        printk("[n5600_proc] copy from user error\n");
	        return -EFAULT;
	    }  
		scanf_ret = sscanf(buf, "%d %x %x",&gpio_num, &trigger,&trigger2);
		tri_type=trigger;
		 printk("[n5600_proc] copy from gpio_num=%d trigger=%d,trigger2=%d\n",gpio_num,trigger,trigger2);
	if(gpio_num==1){
			ret = gpio_direction_input(irq_gpio1);
			if (ret < 0) {
			pr_err( "fail to set gpio%d as input pin (%d)\n",
			irq_gpio1, ret);
			return ret;
			}
			gpio_set_debounce(irq_gpio1, 20*1000);
			if (ret < 0) {
				pr_err( "fail to set gpio%d debounce (%d)\n",
						   irq_gpio1, ret);
				return ret;
			}

			irq_gpio1 = gpio_to_irq(irq_gpio1);
			if (irq_gpio1 <= 0) {
				pr_err( "gpio%d to irq fail, irq_gpio1(%d)\n",
						   irq_gpio1, ret);
				return ret;
			}  
			ret = request_irq(irq_gpio1, irq_gpio1_eint,
						   trigger, "irq_gpio1_eint", NULL);
	}


    if(gpio_num==2){
				ret = gpio_direction_input(irq_gpio2);
				if (ret < 0) {
				pr_err( "fail to set gpio%d as input pin (%d)\n",irq_gpio2, ret);
				return ret;
				}
				/* 20 ms */
				gpio_set_debounce(irq_gpio2, 20*1000);
				if (ret < 0) {
				pr_err( "fail to set gpio%d debounce (%d)\n", irq_gpio2, ret);
				return ret;
				}
				irq_gpio2 = gpio_to_irq(irq_gpio2);
				if (irq_gpio2 <= 0) {
				pr_err( "gpio%d to irq fail, irq_gpio1(%d)\n",irq_gpio2, ret);
				return ret;
				}   
				ret = request_irq(irq_gpio2, irq_gpio2_eint,
				trigger, "irq_gpio2_eint", NULL);
	   }




	if(gpio_num==3){
			ret = gpio_direction_input(irq_gpio3);
			if (ret < 0) {
			pr_err( "fail to set gpio%d as input pin (%d)\n",
			irq_gpio3, ret);
			return ret;
			}
			gpio_set_debounce(irq_gpio3, 20*1000);
			if (ret < 0) {
			pr_err( "fail to set gpio%d debounce (%d)\n",
			irq_gpio3, ret);
			return ret;
			}

			irq_gpio3 = gpio_to_irq(irq_gpio3);
			if (irq_gpio3) {
			pr_err( "gpio%d to irq fail, irq_gpio1(%d)\n",
			irq_gpio3, ret);
			return ret;
			}	   
			ret = request_irq(irq_gpio3, irq_gpio3_eint,
			trigger, "irq_gpio3_eint", NULL);
	}


	
		if(gpio_num==4){
				ret = gpio_direction_input(irq_gpio4);
				if (ret < 0) {
				pr_err( "fail to set gpio%d as input pin (%d)\n",
				irq_gpio4, ret);
				return ret;
				}
				gpio_set_debounce(irq_gpio4, 20*1000);
				if (ret < 0) {
				pr_err( "fail to set gpio%d debounce (%d)\n",
				irq_gpio4, ret);
				return ret;
				}
				irq_gpio4 = gpio_to_irq(irq_gpio4);
				if (irq_gpio4 <= 0) {
				pr_err( "gpio%d to irq fail, irq_gpio3(%d)\n",
				irq_gpio4, ret);
				return ret;
				}	   
				ret = request_irq(irq_gpio4, irq_gpio4_eint,
				trigger, "irq_gpio4_eint", NULL);
		}


		
	if(gpio_num==5){
			ret = gpio_direction_input(irq_gpio5);
			if (ret < 0) {
			pr_err( "fail to set gpio%d as input pin (%d)\n",
			irq_gpio5, ret);
			return ret;
			}
			gpio_set_debounce(irq_gpio5, 20*1000);
			if (ret < 0) {
			pr_err( "fail to set gpio%d debounce (%d)\n",
			irq_gpio5, ret);
			return ret;
			}
			irq_gpio5 = gpio_to_irq(irq_gpio5);
			if (irq_gpio5 <= 0) {
			pr_err( "gpio%d to irq fail, irq_gpio4(%d)\n",
			irq_gpio5, ret);
			return ret;
			}	   
			ret = request_irq(irq_gpio5, irq_gpio5_eint,
			trigger, "irq_gpio4_eint", NULL);
	}


	
	if(gpio_num==6){
				ret = gpio_direction_input(irq_gpio6);
				if (ret < 0) {
				pr_err( "fail to set gpio%d as input pin (%d)\n",
				irq_gpio6, ret);
				return ret;
				}
				gpio_set_debounce(irq_gpio6, 20*1000);
				if (ret < 0) {
				pr_err( "fail to set gpio%d debounce (%d)\n",
				irq_gpio6, ret);
				return ret;
				}

				irq_gpio6 = gpio_to_irq(irq_gpio6);
				if (irq_gpio6 <= 0) {
				pr_err( "gpio%d to irq fail, irq_gpio5(%d)\n",
				irq_gpio6, ret);
				return ret;
				}	   
				ret = request_irq(irq_gpio6, irq_gpio6_eint,
				trigger, "irq_gpio6_eint", NULL);
		}	

		
		return count;	
}

static unsigned irq_poll(struct file *file, poll_table *wait)
{
        unsigned int mask = 0;
        poll_wait(file, &button_waitq, wait); // 
 
        if (ev_press)
                mask |= POLLIN | POLLRDNORM;
 
        return mask;
		
}
static int irq_fasync (int fd, struct file *filp, int on)
{
        printk("driver: fifth_drv_fasync\n");
        
        return fasync_helper(fd, filp, on, &button_fasync);
}

static int fifth_drv_open(struct inode *inode,struct file *file)
{
	return 0;
}



static const struct file_operations eint_gpio_fops = {
	.owner = THIS_MODULE,
    .open=fifth_drv_open,
	.read = eint_gpio_read,
	.write = eint_gpio_write,
	.fasync = irq_fasync,
    .poll  =  irq_poll,
};
static int eint_gpio_probe(struct platform_device *pdev)
{
	
	 struct device *drv_device;
	  pr_err("zz eint_gpio_probe\n");
	irq_gpio1 = of_get_named_gpio(pdev->dev.of_node, "eint_gpio1", 0);
	if (irq_gpio1 < 0) {
		pr_err( "no wakeup gpio info\n");
		return irq_gpio1;
	}
		irq_gpio2 = of_get_named_gpio(pdev->dev.of_node, "eint_gpio2", 0);
	if (irq_gpio2 < 0) {
		pr_err( "no irq_gpio2 info\n");
		return irq_gpio2;
	}
		irq_gpio3 = of_get_named_gpio(pdev->dev.of_node, "eint_gpio3", 0);
	if (irq_gpio3 < 0) {
		pr_err( "no irq_gpio3 info\n");
		return irq_gpio3;
	}
		irq_gpio4 = of_get_named_gpio(pdev->dev.of_node, "eint_gpio4", 0);
	if (irq_gpio4 < 0) {
		pr_err( "no irq_gpio4 info\n");
		return irq_gpio4;
	}
		irq_gpio5 = of_get_named_gpio(pdev->dev.of_node, "eint_gpio5", 0);
	if (irq_gpio5 < 0) {
		pr_err( "no irq_gpio5 info\n");
		return irq_gpio5;
	}
			irq_gpio6 = of_get_named_gpio(pdev->dev.of_node, "eint_gpio6", 0);
	if (irq_gpio6 < 0) {
		pr_err( "no irq_gpio6 info\n");
		return irq_gpio6;
	}	
	//proc_create(PROC_NAME_OF_EINT_GPIO, 0777, NULL, &eint_gpio_fops);	
	major = register_chrdev(0, "fifth_drv", &eint_gpio_fops);
 
	fifthdrv_class = class_create(THIS_MODULE, "fifth_drv");
 
	//fifthdrv_class_dev = class_device_create(fifthdrv_class, NULL, MKDEV(major, 0), NULL, "buttons1");
	drv_device = device_create(fifthdrv_class, NULL, MKDEV(major, 0), NULL, "buttons1");
	return 0;
}

static const struct of_device_id eint_gpio_of_match[] = {
	{.compatible = "mediatek,eint_gpio"},
	{},
};
static int gpio_suspend(struct platform_device *dev,pm_message_t state)
{	
   return 0;
}
static int gpio_resume(struct platform_device *dev)
{
  return 0; 
}
static struct platform_driver eint_gpio_driver = {
	.probe = eint_gpio_probe,
	.driver = {
		   .name = "eint_gpio",
		   .owner = THIS_MODULE,
		   .of_match_table = eint_gpio_of_match,
		   },
	.suspend	= gpio_suspend,
	.resume		= gpio_resume,
};

static int __init eint_gpio_init(void)
{
	int ret;
   pr_err("zz eint_gpio_init\n");
	ret = platform_driver_register(&eint_gpio_driver);
	if (ret)
		pr_err("meta gpio register driver failed (%d)\n", ret);

	return 0;
}
core_initcall(eint_gpio_init);

static void __exit eint_gpio_exit(void)
{
	platform_driver_unregister(&eint_gpio_driver);
}
module_exit(eint_gpio_exit);

MODULE_DESCRIPTION("meta gpio Device Driver");
MODULE_LICENSE("GPL v2");
