/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (C) 2019 MediaTek Inc.
 */

#ifndef __BMP280_BARO_H__
#define __BMP280_BARO_H__

/* common definition */
#define BMP_GET_BITSLICE(regvar, bitname)\
	((regvar & bitname##__MSK) >> bitname##__POS)

#define BMP_SET_BITSLICE(regvar, bitname, val)\
	((regvar & ~bitname##__MSK) | ((val<<bitname##__POS)&bitname##__MSK))


/*Define of registers*/
/* Chip ID Register  */
#define BMP280_BARO_CHIP_ID_ADDR       0xD0

#define BMP280_BARO_CHIP_ID_VALUE1    (0x56)
#define BMP280_BARO_CHIP_ID_VALUE2    (0x57)
#define BMP280_BARO_CHIP_ID_VALUE3    (0x58)

/* soft reset  */
#define BMP280_BARO_RESET_ADDR         0xE0
#define BMP280_BARO_SOFT_RESET_VALUE   0xB6

/* Calibration data */
#define BMP280_CALIBRATION_DATA_START   0x88
#define BMP280_CALIBRATION_DATA_LENGTH	24

#define SHIFT_RIGHT_4_POSITION		4
#define SHIFT_LEFT_2_POSITION           2
#define SHIFT_LEFT_4_POSITION           4
#define SHIFT_LEFT_5_POSITION           5
#define SHIFT_LEFT_8_POSITION           8
#define SHIFT_LEFT_12_POSITION          12
#define SHIFT_LEFT_16_POSITION          16


/* Ctrl Measure Register */
#define BMP280_CTRLMEAS_REG             0xF4

#define BMP280_CTRLMEAS_REG_MODE__POS   0
#define BMP280_CTRLMEAS_REG_MODE__MSK   0x03
#define BMP280_CTRLMEAS_REG_MODE__LEN   2
#define BMP280_CTRLMEAS_REG_MODE__REG   BMP280_CTRLMEAS_REG

#define BMP280_CTRLMEAS_REG_OSRSP__POS   2
#define BMP280_CTRLMEAS_REG_OSRSP__MSK   0x1C
#define BMP280_CTRLMEAS_REG_OSRSP__LEN   3
#define BMP280_CTRLMEAS_REG_OSRSP__REG   BMP280_CTRLMEAS_REG

#define BMP280_CTRLMEAS_REG_OSRST__POS   5
#define BMP280_CTRLMEAS_REG_OSRST__MSK   0xE0
#define BMP280_CTRLMEAS_REG_OSRST__LEN   3
#define BMP280_CTRLMEAS_REG_OSRST__REG   BMP280_CTRLMEAS_REG

//#define BMP280_OVERSAMPLING_SKIPPED          0x00
//#define BMP280_OVERSAMPLING_1X               0x01
//#define BMP280_OVERSAMPLING_2X               0x02
//#define BMP280_OVERSAMPLING_4X               0x03
//#define BMP280_OVERSAMPLING_8X               0x04
//#define BMP280_OVERSAMPLING_16X              0x05

/* config */
#define BMP280_CONFIG_REG                    0xF5

#define BMP280_CONFIG_REG_FILTER__POS              2
#define BMP280_CONFIG_REG_FILTER__MSK              0x1C
#define BMP280_CONFIG_REG_FILTER__LEN              3
#define BMP280_CONFIG_REG_FILTER__REG              BMP280_CONFIG_REG

#define BMP280_FILTERCOEFF_OFF               0x00
#define BMP280_FILTERCOEFF_2                 0x01
#define BMP280_FILTERCOEFF_4                 0x02
#define BMP280_FILTERCOEFF_8                 0x03
#define BMP280_FILTERCOEFF_16                0x04

/* data */
#define BMP280_PRESSURE_MSB_REG              0xF7  /* Pressure MSB Reg */
#define BMP280_TEMPERATURE_MSB_REG           0xFA  /* Temperature MSB Reg */


#endif
