/*
 * Copyright (C) 2019 MediaTek Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See http://www.gnu.org/licenses/gpl-2.0.html for more details.
 */

#include <linux/init.h>
#include <linux/module.h>
#include <linux/device.h>
#include <linux/platform_device.h>
#include <linux/of_device.h>
#include <linux/of_irq.h>
#include <linux/miscdevice.h>
#include <linux/delay.h>
#include <linux/gpio.h>
#include <linux/of_gpio.h>
#include <linux/interrupt.h>
#include <linux/fs.h>
#include <linux/uaccess.h>
#include <linux/poll.h>

struct device *dev_wake;
static int wakeup_gpio;
static int wakeup_irq;
static int  major;
static DECLARE_WAIT_QUEUE_HEAD(button_waitq);
static struct fasync_struct *button_fasync;
static struct class *fifthdrv_class;
static int  sleep_enable=0,wakeup_enable=0;
static volatile int ev_press = 0;
static irqreturn_t mt_usb_wakeup_eint_isr(int irq, void *data)
{
	//struct musb *musb = data;
    pr_err("zz mt_usb_wakeup_eint_isr\n");
	disable_irq_nosync(irq);

	if (gpio_get_value(wakeup_gpio)) {
		pr_err( "high,LOW active\n");
		
		irq_set_irq_type(irq, IRQF_TRIGGER_LOW);
	//	pm_relax(dev_wake);
	
	} else
		{
		pr_err( "LOW, wakelock\n");
		ev_press = 1;
		irq_set_irq_type(irq, IRQF_TRIGGER_HIGH);
			pm_stay_awake(dev_wake);
		
	}

	enable_irq(irq);
	return IRQ_HANDLED;
}
//static int sleep_gpio = 0;
static unsigned irq_poll(struct file *file, poll_table *wait)
{
        unsigned int mask = 0;
        poll_wait(file, &button_waitq, wait); // 
 
        if (ev_press)
                mask |= POLLIN | POLLRDNORM;
 
        return mask;
		
}
static int irq_fasync (int fd, struct file *filp, int on)
{
        printk("driver: fifth_drv_fasync\n");
        
        return fasync_helper(fd, filp, on, &button_fasync);
}

static int fifth_drv_open(struct inode *inode,struct file *file)
{
	return 0;
}
static ssize_t eint_gpio_read(struct file *file, char __user *page, size_t count, loff_t *ppos)
{
	char data_buffer[256]={0};	
int len;
int ret;
    
	wait_event_interruptible(button_waitq, ev_press);
	snprintf(data_buffer,sizeof(data_buffer),"wakeup");
		len = strlen(data_buffer);
	printk(" [wakeup]\n");
	ret=copy_to_user(page, data_buffer, len);
	printk("Return Value:%s\n\n", data_buffer);
	ev_press = 0;
	return len;	
}
static ssize_t eint_gpio_write(struct file *filp, const char __user *buff, size_t count, loff_t *data)
{
		int copybufsize = 0;
		int scanf_ret=0;	
		//int  ret;
		unsigned char buf[1024] = {'\0'};
		//gpio_tri=0;
       // trigger_num=0;
		copybufsize = (count<(sizeof(buf)%sizeof(buf[0])-1)) ? count :(sizeof(buf)%sizeof(buf[0])-1);
		  if (copy_from_user(&buf, buff, copybufsize)) 
	    {
	        printk("[n5600_proc] copy from user error\n");
	        return -EFAULT;
	    }  
		scanf_ret = sscanf(buf, "wakeup_enable=%d,sleep_enable=%d",&wakeup_enable,&sleep_enable);
	
		 printk("[n5600_proc] copy from wakeup_enable=%d sleep_enable=%d\n",wakeup_enable,sleep_enable);
    if(sleep_enable==1)
	{
	pm_relax(dev_wake);	
	}
	if(wakeup_enable==0){
		
	}	
	//else
	//{
		
	//}
		return count;	
}
static const struct file_operations eint_gpio_fops = {
	.owner = THIS_MODULE,
    .open=fifth_drv_open,
	.read = eint_gpio_read,
	.write = eint_gpio_write,
	.fasync = irq_fasync,
    .poll  =  irq_poll,
};
static int wake_up_probe(struct platform_device *pdev)
{
	int ret;
	 struct device *drv_device;
	 pr_err("zz wake_up_probe\n");
	 dev_wake=&(pdev->dev);
	 major = register_chrdev(0, "fifth_drv2", &eint_gpio_fops);
	 	fifthdrv_class = class_create(THIS_MODULE, "fifth_drv2");
	drv_device = device_create(fifthdrv_class, NULL, MKDEV(major, 0), NULL, "buttons2");
		ret = of_get_named_gpio(pdev->dev.of_node, "wakeup_gpio", 0);
	if (ret < 0) {
		pr_err( "no wakeup gpio info\n");
		return ret;
	}
	wakeup_gpio = ret;
	ret = gpio_direction_input(wakeup_gpio);
	if (ret < 0) {
		pr_err( "fail to set gpio%d as input pin (%d)\n",
				   wakeup_gpio, ret);
		return ret;
	}

	/* 20 ms */
	gpio_set_debounce(wakeup_gpio, 20*1000);
	if (ret < 0) {
		pr_err( "fail to set gpio%d debounce (%d)\n",
				   wakeup_gpio, ret);
		return ret;
	}

	wakeup_irq = gpio_to_irq(wakeup_gpio);
	if (wakeup_irq <= 0) {
		pr_err( "gpio%d to irq fail, wakeup_gpio(%d)\n",
				   wakeup_gpio, ret);
				   
	
		return ret;
	}
   //sleep_gpio = of_get_named_gpio(pdev->dev.of_node, "sleep_num", 0);
   //pr_err( "zzsleep_gpio(%d)\n",sleep_gpio);
  // gpio_direction_output(sleep_gpio,1);
	   
	ret = request_irq(wakeup_irq, mt_usb_wakeup_eint_isr,
				   IRQF_TRIGGER_LOW, "usb20_wakeup_eint", pdev);
	if (ret) {
		pr_err( "request eint(%d) fail (%d)\n",
				  wakeup_irq, ret);
		return ret;
	}

	enable_irq_wake(wakeup_irq);
	return 0;
}

static const struct of_device_id wake_up_of_match[] = {
	{.compatible = "mediatek,wakeup_gpio"},
	{},
};
static int gpio_suspend(struct platform_device *dev,pm_message_t state)
{
	  //struct rtc *rtc = dev_get_drvdata(dev);
       
            if (device_may_wakeup(&dev->dev)&&wakeup_enable)
           enable_irq_wake(wakeup_irq);

            return 0;	
 //  return 0;
}
static int gpio_resume(struct platform_device *dev)
{
	if (device_may_wakeup(&dev->dev))
		disable_irq_wake(wakeup_irq);
  return 0; 
}
static struct platform_driver wake_up_driver = {
	.probe = wake_up_probe,
	.driver = {
		   .name = "wakeup_gpio",
		   .owner = THIS_MODULE,
		   .of_match_table = wake_up_of_match,
		   },
	.suspend	= gpio_suspend,
	.resume		= gpio_resume,
};

static int __init wake_up_init(void)
{
	int ret;
   pr_err("zz wake_up_init\n");
	ret = platform_driver_register(&wake_up_driver);
	if (ret)
		pr_err("meta gpio register driver failed (%d)\n", ret);

	return 0;
}
core_initcall(wake_up_init);

static void __exit wake_up_exit(void)
{
	platform_driver_unregister(&wake_up_driver);
}
module_exit(wake_up_exit);

MODULE_DESCRIPTION("meta gpio Device Driver");
MODULE_LICENSE("GPL v2");
