// SPDX-License-Identifier: GPL-2.0
/*
 * Copyright (c) 2015 MediaTek Inc.
 */

#ifndef CMDQ_EVENT_COMMON
#define CMDQ_EVENT_COMMON

/* Define CMDQ events
 *
 * For hardware event must define in device tree.
 * For SW event assign event ID here directly.
 *
 * Note: event name must sync to cmdq_events table in mdp_event_common.c
 */
enum cmdq_event {
	/* MDP start frame */
	CMDQ_EVENT_MDP_RDMA0_SOF,			/* 0 */
	CMDQ_EVENT_MDP_RDMA1_SOF,			/* 1 */
	CMDQ_EVENT_MDP_RDMA2_SOF,			/* 2 */
	CMDQ_EVENT_MDP_RDMA3_SOF,			/* 3 */
	CMDQ_EVENT_MDP_RSZ0_SOF,			/* 4 */
	CMDQ_EVENT_MDP_RSZ1_SOF,			/* 5 */
	CMDQ_EVENT_MDP_RSZ2_SOF,			/* 6 */
	CMDQ_EVENT_MDP_RSZ3_SOF,			/* 7 */
	CMDQ_EVENT_MDP_TDSHP_SOF,			/* 8 */
	CMDQ_EVENT_MDP_TDSHP1_SOF,			/* 9 */
	CMDQ_EVENT_MDP_TDSHP2_SOF,			/* 10 */
	CMDQ_EVENT_MDP_TDSHP3_SOF,			/* 11 */
	CMDQ_EVENT_MDP_WDMA_SOF,			/* 12 */
	CMDQ_EVENT_MDP_WROT_SOF,			/* 13 */
	CMDQ_EVENT_MDP_WROT0_SOF,			/* 14 */
	CMDQ_EVENT_MDP_WROT1_SOF,			/* 15 */
	CMDQ_EVENT_MDP_WROT2_SOF,			/* 16 */
	CMDQ_EVENT_MDP_WROT3_SOF,			/* 17 */

	/* Display start frame */
	CMDQ_EVENT_DISP_RDMA0_SOF,			/* 18 */

	/* MDP frame done */
	CMDQ_EVENT_MDP_RDMA0_EOF,			/* 19 */
	CMDQ_EVENT_MDP_RDMA1_EOF,			/* 20 */
	CMDQ_EVENT_MDP_RDMA2_EOF,			/* 21 */
	CMDQ_EVENT_MDP_RDMA3_EOF,			/* 22 */
	CMDQ_EVENT_MDP_RSZ0_EOF,			/* 23 */
	CMDQ_EVENT_MDP_RSZ1_EOF,			/* 24 */
	CMDQ_EVENT_MDP_RSZ2_EOF,			/* 25 */
	CMDQ_EVENT_MDP_RSZ3_EOF,			/* 26 */
	CMDQ_EVENT_MDP_TDSHP_EOF,			/* 27 */
	CMDQ_EVENT_MDP_TDSHP1_EOF,			/* 28 */
	CMDQ_EVENT_MDP_TDSHP2_EOF,			/* 29 */
	CMDQ_EVENT_MDP_TDSHP3_EOF,			/* 30 */
	CMDQ_EVENT_MDP_WDMA_EOF,			/* 31 */
	CMDQ_EVENT_MDP_WROT_WRITE_EOF,			/* 32 */
	CMDQ_EVENT_MDP_WROT0_WRITE_EOF,			/* 33 */
	CMDQ_EVENT_MDP_WROT1_WRITE_EOF,			/* 34 */
	CMDQ_EVENT_MDP_WROT2_WRITE_EOF,			/* 35 */
	CMDQ_EVENT_MDP_WROT3_WRITE_EOF,			/* 36 */

	/* Display frame done */
	CMDQ_EVENT_DISP_OVL0_EOF,			/* 37 */
	CMDQ_EVENT_DISP_RDMA0_EOF,			/* 38 */
	CMDQ_EVENT_DISP_WDMA0_EOF,			/* 39 */

	/* ISP frame done */
	CMDQ_EVENT_ISP_PASS2_2_EOF,			/* 40 */
	CMDQ_EVENT_ISP_PASS2_1_EOF,			/* 41 */
	CMDQ_EVENT_ISP_PASS2_0_EOF,			/* 42 */

	/* ISP (IMGSYS) frame done */
	CMDQ_EVENT_DIP_CQ_THREAD0_EOF,			/* 43 */
	CMDQ_EVENT_DIP_CQ_THREAD1_EOF,			/* 44 */
	CMDQ_EVENT_DIP_CQ_THREAD2_EOF,			/* 45 */
	CMDQ_EVENT_DIP_CQ_THREAD3_EOF,			/* 46 */
	CMDQ_EVENT_DIP_CQ_THREAD4_EOF,			/* 47 */
	CMDQ_EVENT_DIP_CQ_THREAD5_EOF,			/* 48 */
	CMDQ_EVENT_DIP_CQ_THREAD6_EOF,			/* 49 */
	CMDQ_EVENT_DIP_CQ_THREAD7_EOF,			/* 50 */
	CMDQ_EVENT_DIP_CQ_THREAD8_EOF,			/* 51 */
	CMDQ_EVENT_DIP_CQ_THREAD9_EOF,			/* 52 */
	CMDQ_EVENT_DIP_CQ_THREAD10_EOF,			/* 53 */
	CMDQ_EVENT_DIP_CQ_THREAD11_EOF,			/* 54 */
	CMDQ_EVENT_DIP_CQ_THREAD12_EOF,			/* 55 */
	CMDQ_EVENT_DIP_CQ_THREAD13_EOF,			/* 56 */
	CMDQ_EVENT_DIP_CQ_THREAD14_EOF,			/* 57 */
	CMDQ_EVENT_DIP_CQ_THREAD15_EOF,			/* 58 */
	CMDQ_EVENT_DIP_CQ_THREAD16_EOF,			/* 59 */
	CMDQ_EVENT_DIP_CQ_THREAD17_EOF,			/* 60 */
	CMDQ_EVENT_DIP_CQ_THREAD18_EOF,			/* 61 */

	/* JPEG frame done */
	CMDQ_EVENT_JPEG_ENC_EOF,			/* 62 */
	CMDQ_EVENT_JPEG_DEC_EOF,			/* 63 */

	/* WPE frame done */
	CMDQ_EVENT_WPE_A_EOF,				/* 64 */
	CMDQ_EVENT_WPE_B_FRAME_DONE,			/* 65 */

	/* Direct-link start frame */
	CMDQ_EVENT_IMG_DL_RELAY_SOF,			/* 66 */
	CMDQ_EVENT_IMG_DL_RELAY1_SOF,			/* 67 */
	CMDQ_EVENT_IMG_DL_RELAY2_SOF,			/* 68 */
	CMDQ_EVENT_IMG_DL_RELAY3_SOF,			/* 69 */

	/* Dual DIP frame done */
	CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_0,		/* 70 */
	CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_1,		/* 71 */
	CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_2,		/* 72 */
	CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_3,		/* 73 */
	CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_4,		/* 74 */
	CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_5,		/* 75 */
	CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_6,		/* 76 */
	CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_7,		/* 77 */
	CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_8,		/* 78 */
	CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_9,		/* 79 */
	CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_10,		/* 80 */
	CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_11,		/* 81 */
	CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_12,		/* 82 */
	CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_13,		/* 83 */
	CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_14,		/* 84 */
	CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_15,		/* 85 */
	CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_16,		/* 86 */
	CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_17,		/* 87 */
	CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_18,		/* 88 */
	CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_19,		/* 89 */
	CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_20,		/* 90 */
	CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_21,		/* 91 */
	CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_22,		/* 92 */
	CMDQ_EVENT_IMG1_EVENT_TX_FRAME_DONE_23,		/* 93 */
	CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_0,		/* 94 */
	CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_1,		/* 95 */
	CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_2,		/* 96 */
	CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_3,		/* 97 */
	CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_4,		/* 98 */
	CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_5,		/* 99 */
	CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_6,		/* 100 */
	CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_7,		/* 101 */
	CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_8,		/* 102 */
	CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_9,		/* 103 */
	CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_10,		/* 104 */
	CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_11,		/* 105 */
	CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_12,		/* 106 */
	CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_13,		/* 107 */
	CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_14,		/* 108 */
	CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_15,		/* 109 */
	CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_16,		/* 110 */
	CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_17,		/* 111 */
	CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_18,		/* 112 */
	CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_19,		/* 113 */
	CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_20,		/* 114 */
	CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_21,		/* 115 */
	CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_22,		/* 116 */
	CMDQ_EVENT_IMG2_EVENT_TX_FRAME_DONE_23,		/* 117 */

	/* Keep this at the end of HW events */
	CMDQ_MAX_HW_EVENT_COUNT = 512,

	/* token 512 to 639 may set secure */

	/* SW Sync Tokens (Pre-defined) */
	/* Pass-2 notifies VENC frame is ready to be encoded */
	CMDQ_SYNC_TOKEN_VENC_INPUT_READY = 645,		/* 645 */
	/* VENC notifies Pass-2 encode done so next frame may start */
	CMDQ_SYNC_TOKEN_VENC_EOF,			/* 646 */

	/* SW Sync Tokens (User-defined) */
	CMDQ_SYNC_TOKEN_USER_0 = 649,			/* 649 */
	CMDQ_SYNC_TOKEN_USER_1,				/* 650 */

	/* isp */
	CMDQ_SYNC_TOKEN_MSS = 665,			/* 665 */
	CMDQ_SYNC_TOKEN_MSF,				/* 666 */

	/* token after 700 sync user space header */

	/* GPR access tokens (for HW register backup)
	 * There are 15 32-bit GPR, 3 GPR form a set
	 * (64-bit for address, 32-bit for value)
	 */
	CMDQ_SYNC_TOKEN_GPR_SET_0 = 700,
	CMDQ_SYNC_TOKEN_GPR_SET_1,			/* 701 */
	CMDQ_SYNC_TOKEN_GPR_SET_2,			/* 702 */
	CMDQ_SYNC_TOKEN_GPR_SET_3,			/* 703 */
	CMDQ_SYNC_TOKEN_GPR_SET_4,			/* 704 */

	/* Resource lock event to control resource in GCE thread */
	CMDQ_SYNC_RESOURCE_WROT0 = 710,
	CMDQ_SYNC_RESOURCE_WROT1 = 711,

	/* event id is 10 bit */
	CMDQ_SYNC_TOKEN_MAX = 0x3FF,
	CMDQ_SYNC_TOKEN_INVALID = -1,
};

#endif
