// SPDX-License-Identifier: GPL-2.0
/*
 * Copyright (c) 2015 MediaTek Inc.
 */

#ifndef __MDP_ENGINE_H__
#define __MDP_ENGINE_H__

enum CMDQ_ENG_ENUM {
	/* ISP */
	CMDQ_ENG_WPEI = 0,
	CMDQ_ENG_WPEO,		/*  1 */
	CMDQ_ENG_WPEI2,		/*  2 */
	CMDQ_ENG_WPEO2,		/*  3 */
	CMDQ_ENG_ISP_IMGI,	/*  4 */
	CMDQ_ENG_ISP_IMGI2,	/*  5 */
	CMDQ_ENG_ISP_IMG2O,	/*  6 */
	CMDQ_ENG_ISP_IMG2O2,	/*  7 */

	/* MDP */
	CMDQ_ENG_MDP_CAMIN,	/*  8 */
	CMDQ_ENG_MDP_CAMIN2,	/*  9 */
	CMDQ_ENG_MDP_CAMIN3,	/* 10 */
	CMDQ_ENG_MDP_CAMIN4,	/* 11 */
	CMDQ_ENG_MDP_RDMA0,	/* 12 */
	CMDQ_ENG_MDP_RDMA1,	/* 13 */
	CMDQ_ENG_MDP_RDMA2,	/* 14 */
	CMDQ_ENG_MDP_RDMA3,	/* 15 */
	CMDQ_ENG_MDP_FG0,	/* 16 */
	CMDQ_ENG_MDP_FG1,	/* 17 */
	CMDQ_ENG_MDP_PQ0_SOUT,	/* 18 */
	CMDQ_ENG_MDP_PQ1_SOUT,	/* 19 */
	CMDQ_ENG_MDP_HDR0,	/* 20 */
	CMDQ_ENG_MDP_HDR1,	/* 21 */
	CMDQ_ENG_MDP_COLOR0,	/* 22 */
	CMDQ_ENG_MDP_COLOR1,	/* 23 */
	CMDQ_ENG_MDP_AAL0,	/* 24 */
	CMDQ_ENG_MDP_AAL1,	/* 25 */
	CMDQ_ENG_MDP_AAL2,	/* 26 */
	CMDQ_ENG_MDP_AAL3,	/* 27 */
	CMDQ_ENG_MDP_RSZ0,	/* 28 */
	CMDQ_ENG_MDP_RSZ1,	/* 29 */
	CMDQ_ENG_MDP_RSZ2,	/* 30 */
	CMDQ_ENG_MDP_RSZ3,	/* 31 */
	CMDQ_ENG_MDP_TDSHP0,	/* 32 */
	CMDQ_ENG_MDP_TDSHP1,	/* 33 */
	CMDQ_ENG_MDP_TDSHP2,	/* 34 */
	CMDQ_ENG_MDP_TDSHP3,	/* 35 */
	CMDQ_ENG_MDP_TCC0,	/* 36 */
	CMDQ_ENG_MDP_TCC1,	/* 37 */
	CMDQ_ENG_MDP_TCC2,	/* 38 */
	CMDQ_ENG_MDP_TCC3,	/* 39 */
	CMDQ_ENG_MDP_WROT0,	/* 40 */
	CMDQ_ENG_MDP_WROT1,	/* 41 */
	CMDQ_ENG_MDP_WROT2,	/* 42 */
	CMDQ_ENG_MDP_WROT3,	/* 43 */

	/* DPE */
	CMDQ_ENG_DPE,		/* 44 */
	CMDQ_ENG_RSC,		/* 45 */
	CMDQ_ENG_GEPF,		/* 46 */
	CMDQ_ENG_EAF,		/* 47 */
	CMDQ_ENG_OWE,		/* 48 */
	CMDQ_ENG_MFB,		/* 49 */
	CMDQ_ENG_FDVT,		/* 50 */

	/* ISP sec */
	CMDQ_ENG_ISP_VIPI,	/* 51 */
	CMDQ_ENG_ISP_LCEI,	/* 52 */
	CMDQ_ENG_ISP_IMG3O,	/* 53 */
	CMDQ_ENG_ISP_SMXIO,	/* 54 */
	CMDQ_ENG_ISP_DMGI_DEPI,	/* 55 */
	CMDQ_ENG_ISP_IMGCI,	/* 56 */
	CMDQ_ENG_ISP_UFBCI,	/* 57 */
	CMDQ_ENG_ISP_UFBCO,	/* 58 */

	CMDQ_ENG_ISP_MSS,	/* 59 */
	CMDQ_ENG_ISP_MSF,	/* 60 */

	CMDQ_ENG_INORDER,	/* 61 */

	/* Dummy Engine */
	CMDQ_ENG_ISP_TIMGO = 63,
	CMDQ_ENG_MDP_WDMA = 63,

	CMDQ_MAX_ENGINE_COUNT	/* ALWAYS keep at the end */
};

#define CMDQ_ENG_WPE_GROUP_BITS	((1LL << CMDQ_ENG_WPEI) |	\
				 (1LL << CMDQ_ENG_WPEO) |	\
				 (1LL << CMDQ_ENG_WPEI2) |	\
				 (1LL << CMDQ_ENG_WPEO2))

#define CMDQ_ENG_ISP_GROUP_BITS	((1LL << CMDQ_ENG_ISP_IMGI) |	\
				 (1LL << CMDQ_ENG_ISP_IMGI2) |	\
				 (1LL << CMDQ_ENG_ISP_IMG2O) |	\
				 (1LL << CMDQ_ENG_ISP_IMG2O2))

#define CMDQ_ENG_MDP_GROUP_BITS	((1LL << CMDQ_ENG_MDP_CAMIN) |	\
				 (1LL << CMDQ_ENG_MDP_CAMIN2) |	\
				 (1LL << CMDQ_ENG_MDP_CAMIN3) |	\
				 (1LL << CMDQ_ENG_MDP_CAMIN4) |	\
				 (1LL << CMDQ_ENG_MDP_RDMA0) |	\
				 (1LL << CMDQ_ENG_MDP_RDMA1) |	\
				 (1LL << CMDQ_ENG_MDP_RDMA2) |	\
				 (1LL << CMDQ_ENG_MDP_RDMA3) |	\
				 (1LL << CMDQ_ENG_MDP_RSZ0) |	\
				 (1LL << CMDQ_ENG_MDP_RSZ1) |	\
				 (1LL << CMDQ_ENG_MDP_RSZ2) |	\
				 (1LL << CMDQ_ENG_MDP_RSZ3) |	\
				 (1LL << CMDQ_ENG_MDP_TDSHP0) |	\
				 (1LL << CMDQ_ENG_MDP_TDSHP1) |	\
				 (1LL << CMDQ_ENG_MDP_TDSHP2) |	\
				 (1LL << CMDQ_ENG_MDP_TDSHP3) |	\
				 (1LL << CMDQ_ENG_MDP_COLOR0) |	\
				 (1LL << CMDQ_ENG_MDP_COLOR1) |	\
				 (1LL << CMDQ_ENG_MDP_WROT0) |	\
				 (1LL << CMDQ_ENG_MDP_WROT1) |	\
				 (1LL << CMDQ_ENG_MDP_WROT2) |	\
				 (1LL << CMDQ_ENG_MDP_WROT3) |	\
				 (1LL << CMDQ_ENG_MDP_AAL0) |	\
				 (1LL << CMDQ_ENG_MDP_AAL1) |	\
				 (1LL << CMDQ_ENG_MDP_AAL2) |	\
				 (1LL << CMDQ_ENG_MDP_AAL3) |	\
				 (1LL << CMDQ_ENG_MDP_TCC0) |	\
				 (1LL << CMDQ_ENG_MDP_TCC1) |	\
				 (1LL << CMDQ_ENG_MDP_TCC2) |	\
				 (1LL << CMDQ_ENG_MDP_TCC3) |	\
				 (1LL << CMDQ_ENG_MDP_FG0) |	\
				 (1LL << CMDQ_ENG_MDP_FG1) |	\
				 (1LL << CMDQ_ENG_MDP_HDR0) |	\
				 (1LL << CMDQ_ENG_MDP_HDR1))

#define CMDQ_ENG_DPE_GROUP_BITS		(1LL << CMDQ_ENG_DPE)
#define CMDQ_ENG_RSC_GROUP_BITS		(1LL << CMDQ_ENG_RSC)
#define CMDQ_ENG_GEPF_GROUP_BITS	(1LL << CMDQ_ENG_GEPF)
#define CMDQ_ENG_EAF_GROUP_BITS		(1LL << CMDQ_ENG_EAF)
#define CMDQ_ENG_OWE_GROUP_BITS		(1LL << CMDQ_ENG_OWE)
#define CMDQ_ENG_MFB_GROUP_BITS		(1LL << CMDQ_ENG_MFB)
#define CMDQ_ENG_FDVT_GROUP_BITS	(1LL << CMDQ_ENG_FDVT)

#define CMDQ_ENG_ISP_GROUP_FLAG(flag)   ((flag) & (CMDQ_ENG_ISP_GROUP_BITS))
#define CMDQ_ENG_MDP_GROUP_FLAG(flag)   ((flag) & (CMDQ_ENG_MDP_GROUP_BITS))
#define CMDQ_ENG_DPE_GROUP_FLAG(flag)	((flag) & (CMDQ_ENG_DPE_GROUP_BITS))
#define CMDQ_ENG_RSC_GROUP_FLAG(flag)	((flag) & (CMDQ_ENG_RSC_GROUP_BITS))
#define CMDQ_ENG_GEPF_GROUP_FLAG(flag)	((flag) & (CMDQ_ENG_GEPF_GROUP_BITS))
#define CMDQ_ENG_WPE_GROUP_FLAG(flag)	((flag) & (CMDQ_ENG_WPE_GROUP_BITS))
#define CMDQ_ENG_EAF_GROUP_FLAG(flag)	((flag) & (CMDQ_ENG_EAF_GROUP_BITS))
#define CMDQ_ENG_OWE_GROUP_FLAG(flag)	((flag) & (CMDQ_ENG_OWE_GROUP_BITS))
#define CMDQ_ENG_MFB_GROUP_FLAG(flag)	((flag) & (CMDQ_ENG_MFB_GROUP_BITS))
#define CMDQ_ENG_FDVT_GROUP_FLAG(flag)	((flag) & (CMDQ_ENG_FDVT_GROUP_BITS))

#define CMDQ_FOREACH_GROUP(ACTION_struct)\
	ACTION_struct(CMDQ_GROUP_ISP, ISP)	\
	ACTION_struct(CMDQ_GROUP_MDP, MDP)	\
	ACTION_struct(CMDQ_GROUP_DPE, DPE)	\
	ACTION_struct(CMDQ_GROUP_RSC, RSC)	\
	ACTION_struct(CMDQ_GROUP_GEPF, GEPF)	\
	ACTION_struct(CMDQ_GROUP_WPE, WPE)	\
	ACTION_struct(CMDQ_GROUP_EAF, EAF)	\
	ACTION_struct(CMDQ_GROUP_OWE, OWE)	\
	ACTION_struct(CMDQ_GROUP_MFB, MFB)	\
	ACTION_struct(CMDQ_GROUP_FDVT, FDVT)

#define MDP_GENERATE_ENUM(_enum, _string) _enum,

enum CMDQ_GROUP_ENUM {
	CMDQ_FOREACH_GROUP(MDP_GENERATE_ENUM)
	CMDQ_MAX_GROUP_COUNT,	/* ALWAYS keep at the end */
};

#endif				/* __MDP_ENGINE_H__ */
