/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (C) 2019 MediaTek Inc.
 */

#ifndef _HF_SENSOR_IO_H_
#define _HF_SENSOR_IO_H_

#include <linux/ioctl.h>
#include <linux/types.h>

enum {
	HF_MANAGER_SENSOR_DISABLE,
	HF_MANAGER_SENSOR_ENABLE,
	HF_MANAGER_SENSOR_FLUSH,
	HF_MANAGER_SENSOR_ENABLE_CALI,
	HF_MANAGER_SENSOR_CONFIG_CALI,
	HF_MANAGER_SENSOR_SELFTEST,
	HF_MANAGER_SENSOR_RAWDATA,
};

enum {
	DATA_ACTION,
	FLUSH_ACTION,
	BIAS_ACTION,
	CALI_ACTION,
	TEMP_ACTION,
	TEST_ACTION,
	RAW_ACTION,
};

struct hf_manager_cmd {
	uint8_t sensor_type;
	uint8_t action;
	int64_t delay;
	int64_t latency;
	int32_t data[12];
} __packed;

struct hf_manager_event {
	int64_t timestamp;
	uint8_t sensor_type;
	uint8_t accurancy;
	uint8_t action;
	uint8_t reserved;
	union {
		int32_t word[6];
		int8_t byte[0];
	};
} __packed;

struct ioctl_packet {
	uint8_t sensor_type;
	bool status;
} __packed;

#define HF_MANAGER_REQUEST_REGISTER_STATUS  _IOWR('a', 1, struct ioctl_packet)
#define HF_MANAGER_REQUEST_BIAS_DATA        _IOW('a', 2, struct ioctl_packet)
#define HF_MANAGER_REQUEST_CALI_DATA        _IOW('a', 3, struct ioctl_packet)
#define HF_MANAGER_REQUEST_TEMP_DATA        _IOW('a', 4, struct ioctl_packet)
#define HF_MANAGER_REQUEST_TEST_DATA        _IOW('a', 5, struct ioctl_packet)

#endif
