/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (C) 2019 MediaTek Inc.
 */

#ifndef __SMI130_ACC_H__
#define __SMI130_ACC_H__

	/*Define of registers*/

	 /* Hard Wired */
#define SMI130_ACC_CHIP_ID_ADDR                     0x00
	/**<Address of Chip ID Register*/

	/* Data Register */
#define SMI130_ACC_RATE_X_LSB_ADDR                  0x02
	/**<	Address of X axis Rate LSB Register	*/
#define SMI130_ACC_RATE_X_MSB_ADDR                  0x03
	/**<	Address of X axis Rate MSB Register	*/
#define SMI130_ACC_RATE_Y_LSB_ADDR                  0x04
	/**<	Address of Y axis Rate LSB Register	*/
#define SMI130_ACC_RATE_Y_MSB_ADDR                  0x05
	/**<	Address of Y axis Rate MSB Register	*/
#define SMI130_ACC_RATE_Z_LSB_ADDR                  0x06
	/**<	Address of Z axis Rate LSB Register	*/
#define SMI130_ACC_RATE_Z_MSB_ADDR                  0x07
	/**<	Address of Z axis Rate MSB Register	*/
#define SMI130_ACC_TEMP_ADDR                        0x08
	/**<   Address of Temperature Data LSB Register */

#define SMI130_ACC_INT_STATUS1_ADDR                 0x0A
	/**<   Address of Interrupt status Register 1*/

	/* Control Register */
#define SMI130_ACC_RANGE_ADDR                       0x0F
	/**<	Address of Range address Register */
#define SMI130_ACC_BW_ADDR                          0x10
	/**<	Address of Bandwidth Register */
#define SMI130_ACC_RATED_HBW_ADDR                   0x13
	/**<	Address of Rate HBW Register */
#define SMI130_ACC_BGW_SOFTRESET_ADDR               0x14
	/**<	Address of BGW Softreset Register  */

#define SMI130_ACC_INT_ENABLE1_ADDR                 0x17
	/**<        Address of Interrupt Enable 1  */

#define SMI130_ACC_INT_MAP_1_ADDR                   0x1A
	/**<	Address of Interrupt MAP 1  */

#define SMI130_ACC_INT_SRC_ADDR                     0x1E
	/**<	Address of Interrupt SRC 1  */

#define SMI130_ACC_INT_OUT_CTRL_ADDR                0x20
	/**<	Address of Interrupt MAP 1  */

#define SMI130_ACC_BGW_SPI3_WDT_ADDR                0x34
	/**<	Address of BGW SPI3,WDT Register  */

#define SMI130_ACC_SELF_TEST_ADDR                   0x32
	/**<	Address of BGW Self test Register  */

#define SMI130_ACC_DATA_INT_EN                      0x10

/* gyro reg */
#define SMI130_GYRO_CHIP_ID_ADDR                     0x00
	/**<Address of Chip ID Register  */

	/* Data Register */
#define SMI130_GYRO_RATE_X_LSB_ADDR                  0x02
	/**<	 Address of X axis Rate LSB Register  */
#define SMI130_GYRO_RATE_X_MSB_ADDR                  0x03
	/**<	 Address of X axis Rate MSB Register  */
#define SMI130_GYRO_RATE_Y_LSB_ADDR                  0x04
	/**<	 Address of Y axis Rate LSB Register  */
#define SMI130_GYRO_RATE_Y_MSB_ADDR                  0x05
	/**<	 Address of Y axis Rate MSB Register  */
#define SMI130_GYRO_RATE_Z_LSB_ADDR                  0x06
	/**<	 Address of Z axis Rate LSB Register  */
#define SMI130_GYRO_RATE_Z_MSB_ADDR                  0x07
	/**<	 Address of Z axis Rate MSB Register  */
#define SMI130_GYRO_TEMP_ADDR                        0x08
	/**<	 Address of Temperature Data LSB Register */

#define SMI130_GYRO_INT_STATUS1_ADDR                 0x0A
	/**<	 Address of Interrupt status Register 1  */

	/* Control Register */
#define SMI130_GYRO_RANGE_ADDR                       0x0F
	/**<	 Address of Range address Register  */
#define SMI130_GYRO_BW_ADDR                          0x10
	/**<	 Address of Bandwidth Register  */
#define SMI130_GYRO_RATED_HBW_ADDR                   0x13
	/**<	 Address of Rate HBW Register  */
#define SMI130_GYRO_BGW_SOFTRESET_ADDR               0x14
	/**<	 Address of BGW Softreset Register  */
#define SMI130_GYRO_INT_ENABLE0_ADDR                 0x15
	/**<    Address of Interrupt Enable 0  */
#define SMI130_GYRO_INT_ENABLE1_ADDR                 0x16
	/**<    Address of Interrupt Enable 1  */

#define SMI130_GYRO_INT_MAP_1_ADDR                   0x18
	/**<	Address of Interrupt MAP 0  */

#define SMI130_GYRO_BGW_SPI3_WDT_ADDR                0x34
	/**<    Address of BGW SPI3,WDT Register  */

#define SMI130_GYRO_SELF_TEST_ADDR                   0x3C
	/**<	Address of BGW Self test Register  */


#define SMI130_GYRO_DATA_INT_EN                      0x80


#endif
