/*
 * Copyright (C) 2016 MediaTek Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See http://www.gnu.org/licenses/gpl-2.0.html for more details.
 */
/*! \file
*    \brief  Declaration of library functions
*
*    Any definitions in this file will be shared among GLUE Layer and internal Driver Stack.
*/

#ifndef _PLATFORM_MT6880_CONSYS_REG_H_
#define _PLATFORM_MT6880_CONSYS_REG_H_

#include "consys_reg_base.h"
/*******************************************************************************
*                         C O M P I L E R   F L A G S
********************************************************************************
*/

/*******************************************************************************
*                                 M A C R O S
********************************************************************************
*/


/*******************************************************************************
*                    E X T E R N A L   R E F E R E N C E S
********************************************************************************
*/

/*******************************************************************************
*                              C O N S T A N T S
********************************************************************************
*/

/*******************************************************************************
*                             D A T A   T Y P E S
********************************************************************************
*/

enum consys_base_addr_index {
	CONN_INFRA_RGU_BASE = 0,	/* 0x1800_0000 */
	CONN_INFRA_CFG_BASE = 1,	/* 0x1800_1000 */
	CONN_HOST_CSR_TOP_BASE = 2,	/* 0x1806_0000 */
	INFRACFG_AO_BASE = 3,		/* 0x1000_1000 */
	TOPRGU_BASE = 4,		/* 0x1000_7000 */
	SPM_BASE = 5,			/* 0x1000_6000 */
	INFRACFG_BASE = 6,		/* 0x1020_e000 */
	CONN_WT_SLP_CTL_REG = 7,	/* 0x1800_5000 */
	CONN_AFE_CTL = 8,		/* 0x1800_3000 */
	GPIO_BASE = 9,			/* 0x1000_5000 */
	CONN_RF_SPI_MST_REG_BASE = 10,	/* 0x1800_4000 */
	CONN_SEMAPHORE_BASE = 11,	/* 0x1807_0000 */
	CONN_TOP_THERM_CTL_BASE = 12,	/* 0x1800_2000 */
	IOCFG_BM_BASE = 13,		/* 0x11d1_0000 */
	CONN_DEBUG_CTRL = 14,		/* 0x1800_F000 */
	CONN_INFRA_CLKGEN_ON_TOP = 15,	/* 0x1800_9000 */
	CONN_INFRA_BUS_CR = 16,		/* 0x1800_E000, offset 0x200~0x334 */
	CONN_INFRA_DEBUG_CTRL_AO = 17,	/* 0x1802_f000, offset 0x0~0x424 */

	CONSYS_BASE_ADDR_MAX
};


struct consys_base_addr {
	struct consys_reg_base_addr reg_base_addr[CONSYS_BASE_ADDR_MAX];
};

extern struct consys_base_addr conn_reg;

#define REG_CONN_INFRA_RGU_ADDR		conn_reg.reg_base_addr[CONN_INFRA_RGU_BASE].vir_addr
#define REG_CONN_INFRA_CFG_ADDR		conn_reg.reg_base_addr[CONN_INFRA_CFG_BASE].vir_addr
#define REG_CONN_HOST_CSR_ADDR		conn_reg.reg_base_addr[CONN_HOST_CSR_TOP_BASE].vir_addr
#define REG_INFRACFG_AO_ADDR		conn_reg.reg_base_addr[INFRACFG_AO_BASE].vir_addr

#define REG_TOP_RGU_ADDR		conn_reg.reg_base_addr[TOPRGU_BASE].vir_addr
#define REG_SPM_BASE_ADDR		conn_reg.reg_base_addr[SPM_BASE].vir_addr
#define REG_INFRACFG_BASE_ADDR		conn_reg.reg_base_addr[INFRACFG_BASE].vir_addr
#define REG_CONN_WT_SPL_CTL_ADDR	conn_reg.reg_base_addr[CONN_WT_SLP_CTL_REG].vir_addr

#define REG_CONN_AFE_CTL_BASE_ADDR	conn_reg.reg_base_addr[CONN_AFE_CTL].vir_addr
#define REG_GPIO_BASE_ADDR		conn_reg.reg_base_addr[GPIO_BASE].vir_addr
#define REG_CONN_RFSPI_ADDR		conn_reg.reg_base_addr[CONN_RF_SPI_MST_REG_BASE].vir_addr
#define REG_CONN_SEMAPHORE_ADDR		conn_reg.reg_base_addr[CONN_SEMAPHORE_BASE].vir_addr

#define REG_CONN_TOP_THERM_CTL_ADDR	conn_reg.reg_base_addr[CONN_TOP_THERM_CTL_BASE].vir_addr
#define REG_IOCFG_BM_ADDR		conn_reg.reg_base_addr[IOCFG_BM_BASE].vir_addr
#define REG_CONN_DEBUG_CTRL_ADDR		conn_reg.reg_base_addr[CONN_DEBUG_CTRL].vir_addr
#define REG_CONN_INFRA_CLKGEN_ON_TOP_ADDR	conn_reg.reg_base_addr[CONN_INFRA_CLKGEN_ON_TOP].vir_addr

#define REG_CONN_INFRA_BUS_CR_ADDR	conn_reg.reg_base_addr[CONN_INFRA_BUS_CR].vir_addr
#define REG_CONN_INFRA_DEBUG_CTRL_AO	conn_reg.reg_base_addr[CONN_INFRA_DEBUG_CTRL_AO].vir_addr

/*******************************************************************************
*                            P U B L I C   D A T A
********************************************************************************
*/

/*******************************************************************************
*                           P R I V A T E   D A T A
********************************************************************************
*/

/*******************************************************************************
*                  F U N C T I O N   D E C L A R A T I O N S
********************************************************************************
*/


/*******************************************************************************
*                              F U N C T I O N S
********************************************************************************
*/

struct consys_base_addr* get_conn_reg_base_addr(void);

#endif				/* _PLATFORM_MT6880_CONSYS_REG_H_ */
