/*
 * Copyright (C) 2016 MediaTek Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See http://www.gnu.org/licenses/gpl-2.0.html for more details.
 */
/*! \file
*    \brief  Declaration of library functions
*
*    Any definitions in this file will be shared among GLUE Layer and internal Driver Stack.
*/

#ifndef _PLATFORM_MT6880_CONSYS_REG_OFFSET_H_
#define _PLATFORM_MT6880_CONSYS_REG_OFFSET_H_

/**********************************************************************/
/* Base: infracfg_ao (0x1000_1000) */
/**********************************************************************/
#define INFRA_TOPAXI_PROTECTEN		0x0220
#define INFRA_TOPAXI_PROTECTEN_STA1	0x0228
#define INFRA_TOPAXI_PROTECTEN_SET	0x02a0
#define INFRA_TOPAXI_PROTECTEN_CLR	0x02a4

/**********************************************************************/
/* Base: GPIO (0x1000_5000) */
/**********************************************************************/
#define GPIO_MODE15_SET		0x03f4
#define GPIO_MODE15_CLR		0x03f8
#define GPIO_MODE16_SET		0x0404
#define GPIO_MODE16_CLR		0x0408

/**********************************************************************/
/* Base: SPM (0x1000_6000) */
/**********************************************************************/
#define SPM_POWERON_CONFIG_EN		0x0000
#define SPM_PCM_REG0_DATA		0x0100
#define SPM_PCM_REG13_DATA		0x0110
#define SPM_SRC_REQ_STA_0		0x0114
#define SPM_PWR_STATUS			0x016c
#define SPM_PWR_STATUS_2ND		0x0170
#define SPM_CONN_PWR_CON		0x0304
#define SPM_RC_CMD_STA_0		0x0E04
#define SPM_RC_M04_REQ_STA_0		0x0E28
#define SPM_RC_M05_REQ_STA_0		0x0E2C
#define SPM_RC_M06_REQ_STA_0		0x0E30
#define SPM_RC_M07_REQ_STA_0		0x0E34

/**********************************************************************/
/* Base: TOP RGU (0x1000_7000) */
/**********************************************************************/
#define TOP_RGU_WDT_SWSYSRST	0x0018

/**********************************************************************/
/* Base: IOCFG_BM (0x11D1_0000) */
/**********************************************************************/
#define IOCFG_BM_DRV_CFG0_SET	0x0004
#define IOCFG_BM_DRV_CFG0_CLR	0x0008
#define IOCFG_BM_PD_CFG0_SET	0x00d4
#define IOCFG_BM_PD_CFG0_CLR	0x00d8
#define IOCFG_BM_PU_CFG0_SET	0x0114
#define IOCFG_BM_PU_CFG0_CLR	0x0118


/**********************************************************************/
/* Base: conn_infra_rgu (0x1800_0000) */
/**********************************************************************/
#define CONN_INFRA_RGU_CONN_INFRA_OFF_TOP_PWR_CTL		0x0000
#define CONN_INFRA_RGU_SYSRAM_HWCTL_PDN_SYSRAM_HWCTL_PDN	0x0050
#define CONN_INFRA_RGU_SYSRAM_HWCTL_SLP_SYSRAM_HWCTL_SLP	0x0054

/**********************************************************************/
/* Base: conn_infra_cfg (0x1800_1000), offset 0x0~0x654 */
/**********************************************************************/
#define CONN_HW_VER_OFFSET			0x0000
#define CONN_CFG_ID_OFFSET			0x0004
#define AP2CONN_EFUSE_DATA			0x0020
#define CONN_INFRA_CFG_ADIE_CTL			0x0030
#define CONN_INFRA_CFG_PWRCTRL0			0x0200
#define CONN_INFRA_CFG_OSC_CTL_0		0x0300
#define CONN_INFRA_CFG_OSC_CTL_1		0x0304
#define CONN_INFRA_CFG_RC_CTL_0			0x0380
#define CONN_INFRA_CFG_RC_CTL_0_GPS		0x0390
#define CONN_INFRA_CFG_RC_CTL_1_GPS		0x0394
#define CONN_INFRA_CFG_RC_CTL_0_TOP		0x03c0
#define CONN_INFRA_CFG_RC_CTL_1_TOP		0x03c4
#define CONN_INFRA_CFG_EMI_CTL_0		0x0400
#define CONN_INFRA_CONN2AP_SLP_STATUS		0x0504
#define CONN_INFRA_AP2CONN_SLP_STATUS		0x0514
#define CONN_INFRA_ON_BUS_SLP_STATUS		0x0524
#define CONN_INFRA_OFF_BUS_SLP_STATUS		0x0534
#define GALS_CONN2GPS_SLP_STATUS		0x0574
#define GALS_GPS2CONN_SLP_STATUS		0x0584

#define CONN_HW_VER	0x02030100
#define CONN_CFG_ID	0x3



/**********************************************************************/
/* Base: conn_top_therm_ctl (0x1800_2000) */
/**********************************************************************/
#define CONN_TOP_THERM_CTL_THERMCR1	0x0004
#define CONN_TOP_THERM_CTL_THERM_AADDR	0x0018
#define CONN_TOP_THERM_CTL_THERM_CAL_EN	0x0024

/**********************************************************************/
/* Base: conn_afe_ctl(0x1800_3000) */
/**********************************************************************/
#define CONN_AFE_CTL_RG_DIG_EN_02	0x0004
#define CONN_AFE_CTL_RG_PLL_STB_TIME	0x00f4

/**********************************************************************/
/* Base: conn_rf_spi_mst_reg(0x1800_4000) */
/**********************************************************************/
#define CONN_RF_SPI_MST_REG_SPI_STA		0x0000
#define CONN_RF_SPI_MST_REG_SPI_CRTL		0x0004
#define CONN_RF_SPI_MST_REG_FM_CTRL		0x000c
#define CONN_RF_SPI_MST_REG_SPI_WF_ADDR		0x0010
#define CONN_RF_SPI_MST_REG_SPI_WF_WDAT		0x0014
#define CONN_RF_SPI_MST_REG_SPI_WF_RDAT		0x0018
#define CONN_RF_SPI_MST_REG_SPI_BT_ADDR		0x0020
#define CONN_RF_SPI_MST_REG_SPI_BT_WDAT		0x0024
#define CONN_RF_SPI_MST_REG_SPI_BT_RDAT		0x0028
#define CONN_RF_SPI_MST_REG_SPI_FM_ADDR		0x0030
#define CONN_RF_SPI_MST_REG_SPI_FM_WDAT		0x0034
#define CONN_RF_SPI_MST_REG_SPI_FM_RDAT		0x0038
#define CONN_RF_SPI_MST_REG_SPI_TOP_ADDR	0x0050
#define CONN_RF_SPI_MST_REG_SPI_TOP_WDAT	0x0054
#define CONN_RF_SPI_MST_REG_SPI_TOP_RDAT	0x0058
#define CONN_RF_SPI_MST_REG_SPI_GPS_GPS_ADDR	0x0210
#define CONN_RF_SPI_MST_REG_SPI_GPS_GPS_WDAT	0x0214
#define CONN_RF_SPI_MST_REG_SPI_GPS_GPS_RDAT	0x0218

/**********************************************************************/
/* Base: conn_wt_slp_ctl_reg(0x1800_5000) */
/**********************************************************************/
#define CONN_WT_SLP_CTL_REG_WB_SLP_CTL		0x0004
#define CONN_WT_SLP_CTL_REG_WB_BG_ADDR1		0x0010
#define CONN_WT_SLP_CTL_REG_WB_BG_ADDR2		0x0014
#define CONN_WT_SLP_CTL_REG_WB_BG_ADDR3		0x0018
#define CONN_WT_SLP_CTL_REG_WB_BG_ADDR4		0x001c
#define CONN_WT_SLP_CTL_REG_WB_BG_ADDR5		0x0020
#define CONN_WT_SLP_CTL_REG_WB_BG_ADDR6		0x0024
#define CONN_WT_SLP_CTL_REG_WB_BG_ADDR7		0x0028
#define CONN_WT_SLP_CTL_REG_WB_BG_ADDR8		0x002c
#define CONN_WT_SLP_CTL_REG_WB_BG_ON1		0x0030
#define CONN_WT_SLP_CTL_REG_WB_BG_ON2		0x0034
#define CONN_WT_SLP_CTL_REG_WB_BG_ON3		0x0038
#define CONN_WT_SLP_CTL_REG_WB_BG_ON4		0x003c
#define CONN_WT_SLP_CTL_REG_WB_BG_ON5		0x0040
#define CONN_WT_SLP_CTL_REG_WB_BG_ON6		0x0044
#define CONN_WT_SLP_CTL_REG_WB_BG_ON7		0x0048
#define CONN_WT_SLP_CTL_REG_WB_BG_ON8		0x004c
#define CONN_WT_SLP_CTL_REG_WB_BG_OFF1		0x0050
#define CONN_WT_SLP_CTL_REG_WB_BG_OFF2		0x0054
#define CONN_WT_SLP_CTL_REG_WB_BG_OFF3		0x0058
#define CONN_WT_SLP_CTL_REG_WB_BG_OFF4		0x005c
#define CONN_WT_SLP_CTL_REG_WB_BG_OFF5		0x0060
#define CONN_WT_SLP_CTL_REG_WB_BG_OFF6		0x0064
#define CONN_WT_SLP_CTL_REG_WB_BG_OFF7		0x0068
#define CONN_WT_SLP_CTL_REG_WB_BG_OFF8		0x006c
#define CONN_WT_SLP_CTL_REG_WF_CK_ADDR		0x0070
#define CONN_WT_SLP_CTL_REG_WF_WAKE_ADDR	0x0074
#define CONN_WT_SLP_CTL_REG_WF_ZPS_ADDR		0x0078
#define CONN_WT_SLP_CTL_REG_BT_CK_ADDR		0x007c
#define CONN_WT_SLP_CTL_REG_BT_WAKE_ADDR	0x0080
#define CONN_WT_SLP_CTL_REG_TOP_CK_ADDR		0x0084
#define CONN_WT_SLP_CTL_REG_GPS_CK_ADDR		0x0088
#define CONN_WT_SLP_CTL_REG_WF_B0_CMD_ADDR	0x008c
#define CONN_WT_SLP_CTL_REG_WF_B1_CMD_ADDR	0x0090
#define CONN_WT_SLP_CTL_REG_GPS_RFBUF_ADDR	0x0094
#define CONN_WT_SLP_CTL_REG_GPS_L5_EN_ADDR	0x0098
#define CONN_WT_SLP_WB_SLP_TOP_CK_0		0x0120

/**********************************************************************/
/* Base: conn_infra_gpt(0x1800_7000) */
/**********************************************************************/
#define CONN_INFRA_GPT_BASE			0x18007000
#define GPT2_AP_ENABLE				0x0038

/**********************************************************************/
/* Base: conn_infra_clkgen_on_top(0x1800_9000) */
/**********************************************************************/
#define CONN_INFRA_CKGEN_BUS_BPLL_DIV_2		0x0004
#define CONN_INFRA_CLKGEN_ON_TOP_CKGEN_BUS	0x0a00

/**********************************************************************/
/* Base: conn_infra_bus_cr (0x1800_E000), offset 0x200~0x334 */
/**********************************************************************/
#define CONN_INFRA_BUS_CR_GALS_AP2CONN_GALS_DBG		0x02a0
#define CONN_INFRA_BUS_CR_GALS_CONN2AP_GALS_DBG		0x02a4
#define CONN_INFRA_BUS_CR_GALS_GPS2CONN_GALS_DBG	0x02B0
#define CONN_INFRA_BUS_CR_GALS_CONN2GPS_GALS_DBG	0x02B4
#define CONN_INFRA_BUS_CR_GALS_CONN2GPS_CTRL_0		0x02CC
#define CONN_INFRA_BUS_OFF_TIMEOUT_CTRL			0x0300
#define CONN_INFRA_BUS_ON_TIMEOUT_CTRL			0x031C

/**********************************************************************/
/* Base: debug_ctrl (0x1800_f000) */
/**********************************************************************/
#define CONN_DEBUG_CTRL_REG_OFFSET	0x0000

/**********************************************************************/
/* Base: conn_infra_debug_ctrl_ao (0x1802_f000) */
/**********************************************************************/
#define CONN_INFRA_DEBUG_CTRL_AO_CONN_INFRA_ON_CTRL0	0x000
#define CONN_INFRA_DEBUG_CTRL_AO_CONN_INFRA_ON_CTRL1	0x004
#define CONN_INFRA_DEBUG_CTRL_AO_CONN_INFRA_ON_CTRL2	0x008
#define CONN_INFRA_DEBUG_CTRL_AO_CONN_INFRA_ON_RESULT0	0x400
#define CONN_INFRA_DEBUG_CTRL_AO_CONN_INFRA_ON_RESULT1	0x404
#define CONN_INFRA_DEBUG_CTRL_AO_CONN_INFRA_ON_RESULT2	0x408
#define CONN_INFRA_DEBUG_CTRL_AO_CONN_INFRA_ON_RESULT3	0x40C
#define CONN_INFRA_DEBUG_CTRL_AO_CONN_INFRA_ON_RESULT4	0x410
#define CONN_INFRA_DEBUG_CTRL_AO_CONN_INFRA_ON_RESULT5	0x414
#define CONN_INFRA_DEBUG_CTRL_AO_CONN_INFRA_ON_RESULT6	0x418
#define CONN_INFRA_DEBUG_CTRL_AO_CONN_INFRA_ON_RESULT7	0x41C
#define CONN_INFRA_DEBUG_CTRL_AO_CONN_INFRA_ON_RESULT8	0x420
#define CONN_INFRA_DEBUG_CTRL_AO_CONN_INFRA_ON_RESULT9	0x424


/**********************************************************************/
/* Base: conn_host_csr_top (0x1806_0000) */
/**********************************************************************/
#define CONN_INFRA_ON_BUS_TIMEOUT_IRQ					0x014c
#define CONN_HOST_CSR_TOP_CONN_INFRA_CFG_DBG_SEL			0x015c
#define CONN_HOST_CSR_TOP_CONN_INFRA_WAKEPU_TOP_CONN_INFRA_WAKEPU_TOP	0x01a0
#define CONN2AP_REMAP_GPS_PERI_BASE_ADDR				0x01dc
#define CONN_HOST_CSR_TOP_DBG_DUMMY_0					0x02c0
#define CONN_HOST_CSR_TOP_DBG_DUMMY_2					0x02c8
#define CONN_HOST_CSR_TOP_DBG_DUMMY_3					0x02cc
#define CONN_HOST_CSR_TOP_DBG_DUMMY_5					0x02d4
#define CONN_HOST_CSR_TOP_CONN_INFRA_BUS_OFF_DBG_1			0x0414
#define CONN_HOST_CSR_TOP_CONN_INFRA_BUS_OFF_DBG_2			0x0418
#define CONN_HOST_CSR_TOP_CONN_INFRA_BUS_OFF_TOP_DBG_1			0x041C
#define CONN_HOST_CSR_TOP_CONN_INFRA_BUS_OFF_TOP_DBG_2			0x0420
#define CONN_HOST_CSR_TOP_CONN_INFRA_BUS_ON_TOP_DBG_APB_1		0x042C
#define CONN_HOST_CSR_TOP_CONN_INFRA_BUS_ON_TOP_DBG_APB_2		0x0430



#define TOP_BUS_MUC_STAT_HCLK_FR_CK_DETECT_BIT (0x1 << 1)
#define TOP_BUS_MUC_STAT_OSC_CLK_DETECT_BIT (0x1 << 2)

/**********************************************************************/
/* Base: conn_semaphore(0x1807_0000) */
/**********************************************************************/
#define CONN_SEMA_OWN_BY_M0_STA_REP		0x0400
#define CONN_SEMA_OWN_BY_M1_STA_REP		0x1400
#define CONN_SEMAPHORE_M2_OWN_STA		0x2000
#define CONN_SEMAPHORE_M2_OWN_REL		0x2200
#define CONN_SEMA_OWN_BY_M2_STA_REP		0x2400
#define CONN_SEMA_OWN_BY_M3_STA_REP		0x3400

/**********************************************************************/
/* A-die CR */
/**********************************************************************/
#define ATOP_CHIP_ID			0x02c
#define ATOP_RG_TOP_THADC_BG		0x034
#define ATOP_RG_TOP_THADC		0x038
#define ATOP_EFUSE_CTRL			0x108
#define ATOP_EFUSE_RDATA0		0x130
#define ATOP_EFUSE_RDATA1		0x134
#define ATOP_EFUSE_RDATA2		0x138
#define ATOP_EFUSE_RDATA3		0x13c
#define ATOP_RG_TOP_XTAL_01		0xA18
#define ATOP_RG_TOP_XTAL_02		0xA1C

#endif				/* _PLATFORM_MT6880_CONSSY_REG_OFFSET_H_ */
