/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (c) 2020 MediaTek Inc.
 */
#ifndef _GPS_DL_HW_DEP_API_H
#define _GPS_DL_HW_DEP_API_H

#include "conn_infra/conn_infra_cfg.h"
#include "conn_infra/conn_host_csr_top.h"
#include "conn_infra/conn_wt_slp_ctl_reg.h"


#define GDL_HW_SUPPORT_LIST "SUPPORT:MT6880"
#define GDL_HW_CONN_INFRA_VER_MT6880 (0x02030100)
#define GDL_HW_BGF_VER        (0x02030100)

#define GDL_HW_CHECK_CONN_INFRA_VER(p_poll_okay, p_poll_ver)             \
	GDL_HW_POLL_ENTRY_VERBOSE(GPS_DL_CONN_INFRA_BUS,                 \
		CONN_INFRA_CFG_CONN_HW_VER_RO_CONN_HW_VERSION,           \
		p_poll_okay, p_poll_ver, POLL_DEFAULT, (                 \
			(*p_poll_ver == GDL_HW_CONN_INFRA_VER_MT6880))   \
	)

#define CONN2GPS_SLP_PROT_RX_ACK_ADDR CONN_INFRA_CFG_GALS_CONN2GPS_SLP_STATUS_ADDR
#define CONN2GPS_SLP_PROT_RX_ACK_MASK (1UL << 22)
#define CONN2GPS_SLP_PROT_RX_ACK_SHFT 22

#define CONN2GPS_SLP_PROT_TX_ACK_ADDR CONN_INFRA_CFG_GALS_CONN2GPS_SLP_STATUS_ADDR
#define CONN2GPS_SLP_PROT_TX_ACK_MASK (1UL << 23)
#define CONN2GPS_SLP_PROT_TX_ACK_SHFT 23

#define GPS2CONN_SLP_PROT_RX_ACK_ADDR CONN_INFRA_CFG_GALS_GPS2CONN_SLP_STATUS_ADDR
#define GPS2CONN_SLP_PROT_RX_ACK_MASK (1UL << 22)
#define GPS2CONN_SLP_PROT_RX_ACK_SHFT 22

#define GPS2CONN_SLP_PROT_TX_ACK_ADDR CONN_INFRA_CFG_GALS_GPS2CONN_SLP_STATUS_ADDR
#define GPS2CONN_SLP_PROT_TX_ACK_MASK (1UL << 23)
#define GPS2CONN_SLP_PROT_TX_ACK_SHFT 23

#define GDL_HW_SET_CONN2GPS_SLP_PROT_RX_VAL(val) \
	GDL_HW_SET_CONN_INFRA_ENTRY( \
		CONN_INFRA_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CFG_CONN2GPS_GALS_RX_SLP_PROT_SW_EN, val)

#define GDL_HW_POLL_CONN2GPS_SLP_PROT_RX_UNTIL_VAL(val, timeout, p_is_okay) \
	GDL_HW_POLL_CONN_INFRA_ENTRY( \
		CONN2GPS_SLP_PROT_RX_ACK, \
		val, timeout, p_is_okay)


#define GDL_HW_SET_CONN2GPS_SLP_PROT_TX_VAL(val) \
	GDL_HW_SET_CONN_INFRA_ENTRY( \
		CONN_INFRA_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_CFG_CONN2GPS_GALS_TX_SLP_PROT_SW_EN, val)

#define GDL_HW_POLL_CONN2GPS_SLP_PROT_TX_UNTIL_VAL(val, timeout, p_is_okay) \
	GDL_HW_POLL_CONN_INFRA_ENTRY( \
		CONN2GPS_SLP_PROT_TX_ACK, \
		val, timeout, p_is_okay)


#define GDL_HW_SET_GPS2CONN_SLP_PROT_RX_VAL(val) \
	GDL_HW_SET_CONN_INFRA_ENTRY( \
		CONN_INFRA_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_CFG_GPS2CONN_GALS_RX_SLP_PROT_SW_EN, val)

#define GDL_HW_POLL_GPS2CONN_SLP_PROT_RX_UNTIL_VAL(val, timeout, p_is_okay) \
	GDL_HW_POLL_CONN_INFRA_ENTRY( \
		GPS2CONN_SLP_PROT_RX_ACK, \
		val, timeout, p_is_okay)


#define GDL_HW_SET_GPS2CONN_SLP_PROT_TX_VAL(val) \
	GDL_HW_SET_CONN_INFRA_ENTRY( \
		CONN_INFRA_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_CFG_GPS2CONN_GALS_TX_SLP_PROT_SW_EN, val)

#define GDL_HW_POLL_GPS2CONN_SLP_PROT_TX_UNTIL_VAL(val, timeout, p_is_okay) \
	GDL_HW_POLL_CONN_INFRA_ENTRY( \
		GPS2CONN_SLP_PROT_TX_ACK, \
		val, timeout, p_is_okay)


/* For MT6880, no need to wait */
#define GDL_HW_MAY_WAIT_CONN_INFRA_SLP_PROT_DISABLE_ACK(p_poll_okay) \
	do { *p_poll_okay = true; } while(0)


/* For MT6880, the dump address list as below */
#define GDL_HW_DUMP_SLP_RPOT_STATUS() do { \
	gps_dl_bus_rd_opt(GPS_DL_CONN_INFRA_BUS, \
		CONN_INFRA_CFG_CONN_INFRA_CONN2GPS_SLP_CTRL_ADDR, \
		BMASK_RW_FORCE_PRINT); \
	gps_dl_bus_rd_opt(GPS_DL_CONN_INFRA_BUS, \
		CONN_INFRA_CFG_GALS_CONN2GPS_SLP_STATUS_ADDR, \
		BMASK_RW_FORCE_PRINT); \
	gps_dl_bus_rd_opt(GPS_DL_CONN_INFRA_BUS, \
		CONN_INFRA_CFG_CONN_INFRA_GPS2CONN_SLP_CTRL_ADDR, \
		BMASK_RW_FORCE_PRINT); \
		gps_dl_bus_rd_opt(GPS_DL_CONN_INFRA_BUS, \
			CONN_INFRA_CFG_GALS_GPS2CONN_SLP_STATUS_ADDR, \
		BMASK_RW_FORCE_PRINT); \
} while (0)

/* For MT6880, the address is 0x18000020 */
#define GDL_HW_SET_CONN_INFRA_BGF_EN(val) do { \
	unsigned int tmp_val; \
	tmp_val = GDL_HW_RD_CONN_INFRA_REG(CONN_INFRA_RGU_BGFYS_ON_TOP_PWR_CTL_ADDR); \
	if (val == 0) \
		tmp_val = (0x42540000 | (tmp_val & 0xFFFF)) & ~0x80; \
	else \
		tmp_val = (0x42540000 | (tmp_val & 0xFFFF)) | 0x80; \
	GDL_HW_WR_CONN_INFRA_REG(CONN_INFRA_RGU_BGFYS_ON_TOP_PWR_CTL_ADDR, tmp_val); \
	GDL_HW_RD_CONN_INFRA_REG(CONN_INFRA_RGU_BGFYS_ON_TOP_PWR_CTL_ADDR); \
} while (0)

#define GDL_HW_SET_GPS_FUNC_EN(val) \
	GDL_HW_SET_CONN_INFRA_ENTRY(CONN_INFRA_CFG_GPS_PWRCTRL0_GPS_FUNCTION_EN, val)

/* For MT6880, GPS has dedicate entry for top clk control */
#define GDL_HW_ADIE_TOP_CLK_EN(val, p_poll_okay) do { \
	GDL_HW_SET_CONN_INFRA_ENTRY( \
		CONN_WT_SLP_CTL_REG_WB_SLP_TOP_CK_5_WB_SLP_TOP_CK_5, val); \
	GDL_HW_POLL_CONN_INFRA_ENTRY( \
		CONN_WT_SLP_CTL_REG_WB_SLP_TOP_CK_5_WB_SLP_TOP_CK_5_BSY, 0, POLL_DEFAULT, p_poll_okay); \
} while (0)


/* For MT6880:
 * 8: HW TICK H/L, BG tick H/L, TX_END/TX_RD, RX_END/RX_WR
 * 3: PC, GALMAN CNT, WRHOST CNT
 */
#define GPS_DSP_REG_POLL_MAX (11)
#define GPS_L1_REG_POLL_LIST { \
	0x5028, 0x5029, 0x0100, 0x0101, 0x4882, 0x4883, 0x4886, 0x4887, \
	0x9FF0, 0x9FF1, 0x9FF2, }

#define GPS_L5_REG_POLL_LIST { \
	0x5014, 0x5015, 0x0100, 0x0101, 0x4882, 0x4883, 0x4886, 0x4887, \
	0x9FF0, 0x9FF1, 0x9FF2, }


/* For MT6880:
 * 9: PC, GALMAN CNT, WRHOST CNT, DBTT CNT, NEXT CNT, BG TICK H/L, HW TICK H/L
 * 11: USRT CTL, STA, TX_END/RD/MAX, RX_MAX/END/WR, TX_CNT, RX_CNT, MISC
 */
#define GPS_DSP_REG_DBG_POLL_MAX (20)
#define GPS_L1_REG_DBG_POLL_LIST  { \
	0x9FF0, 0x9FF1, 0x9FF2, 0x9FF3, 0x9FF4, 0x0100, 0x0101, 0x5028, 0x5029, \
	0x4880, 0x4881, 0x4882, 0x4883, 0x4884, 0x4885, 0x4886, 0x4887, 0x4888, 0x4889, 0x488a, }

#define GPS_L5_REG_DBG_POLL_LIST { \
	0x9FF0, 0x9FF1, 0x9FF2, 0x9FF3, 0x9FF4, 0x0100, 0x0101, 0x5014, 0x5015, \
	0x4880, 0x4881, 0x4882, 0x4883, 0x4884, 0x4885, 0x4886, 0x4887, 0x4888, 0x4889, 0x488a, }


#if 0
#define CONN_RF_SPI_MST_ADDR_SPI_STA_ADDR \
	CONN_RF_SPI_MST_REG_SPI_STA_ADDR

#define CONN_RF_SPI_MST_ADDR_SPI_GPS_GPS_ADDR_ADDR \
	CONN_RF_SPI_MST_REG_SPI_GPS_GPS_ADDR_ADDR

#define CONN_RF_SPI_MST_ADDR_SPI_GPS_GPS_WDAT_ADDR \
	CONN_RF_SPI_MST_REG_SPI_GPS_GPS_WDAT_ADDR

#define CONN_RF_SPI_MST_ADDR_SPI_GPS_GPS_RDAT_ADDR \
	CONN_RF_SPI_MST_REG_SPI_GPS_GPS_RDAT_ADDR

#define CONN_RF_SPI_MST_ADDR_SPI_FM_ADDR_ADDR \
	CONN_RF_SPI_MST_REG_SPI_FM_ADDR_ADDR

#define CONN_RF_SPI_MST_ADDR_SPI_FM_WDAT_ADDR \
	CONN_RF_SPI_MST_REG_SPI_FM_WDAT_ADDR

#define CONN_RF_SPI_MST_ADDR_SPI_FM_RDAT_ADDR \
	CONN_RF_SPI_MST_REG_SPI_FM_RDAT_ADDR
#endif

#define CONN_HOST_CSR_TOP_CONN_INFRA_DEBUG_AO_DEBUGSYS_ADDR \
	CONN_HOST_CSR_TOP_CONN_INFRA_ON_DEBUG_AO_DEBUGSYS_ADDR

#define CONN_HOST_CSR_TOP_CONN_INFRA_DEBUG_CTRL_AO2SYS_OUT_ADDR \
	CONN_HOST_CSR_TOP_CONN_INFRA_ON_DEBUG_CTRL_AO2SYS_OUT_ADDR

#define CONN_HOST_CSR_TOP_CONN_INFRA_DEBUG_AO_DEBUGSYS_ADDR \
	CONN_HOST_CSR_TOP_CONN_INFRA_ON_DEBUG_AO_DEBUGSYS_ADDR

#define CONN_HOST_CSR_TOP_CONN_INFRA_DEBUG_CTRL_AO2SYS_OUT_ADDR \
	CONN_HOST_CSR_TOP_CONN_INFRA_ON_DEBUG_CTRL_AO2SYS_OUT_ADDR

#define CONN_HOST_CSR_TOP_CONN_INFRA_DEBUG_AO_DEBUGSYS_ADDR \
	CONN_HOST_CSR_TOP_CONN_INFRA_ON_DEBUG_AO_DEBUGSYS_ADDR

#define CONN_HOST_CSR_TOP_CONN_INFRA_DEBUG_CTRL_AO2SYS_OUT_ADDR \
	CONN_HOST_CSR_TOP_CONN_INFRA_ON_DEBUG_CTRL_AO2SYS_OUT_ADDR

#define CONN_HOST_CSR_TOP_CONN_INFRA_DEBUG_AO_DEBUGSYS_ADDR \
	CONN_HOST_CSR_TOP_CONN_INFRA_ON_DEBUG_AO_DEBUGSYS_ADDR

#define CONN_HOST_CSR_TOP_CONN_INFRA_DEBUG_CTRL_AO2SYS_OUT_ADDR \
	CONN_HOST_CSR_TOP_CONN_INFRA_ON_DEBUG_CTRL_AO2SYS_OUT_ADDR

#endif /* _GPS_DL_HW_DEP_API_H */

