/******************************************************************************
 *
 * This file is provided under a dual license.  When you use or
 * distribute this software, you may choose to be licensed under
 * version 2 of the GNU General Public License ("GPLv2 License")
 * or BSD License.
 *
 * GPLv2 License
 *
 * Copyright(C) 2017 MediaTek Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See http://www.gnu.org/licenses/gpl-2.0.html for more details.
 *
 * BSD LICENSE
 *
 * Copyright(C) 2017 MediaTek Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *  * Neither the name of the copyright holder nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *****************************************************************************/
#include <linux/seq_file.h>
#include "ra_nat.h"
#include "frame_engine.h"
#include "foe_fdb.h"
#include "hnat_ioctl.h"
#include "util.h"
#include "hnat_config.h"
#include "hnat_define.h"
#include "hnat_dbg_proc.h"
#include "mcast_tbl.h"
#include "hnat_common.h"

struct proc_dir_entry *hnat_proc_reg_dir;
static struct proc_dir_entry *proc_cpu_reason;
static struct proc_dir_entry *proc_hnat_entry;
static struct proc_dir_entry *proc_hnat_setting;
static struct proc_dir_entry *proc_hnat_multicast;
static struct proc_dir_entry *proc_hnat_whitelist;
static struct proc_dir_entry *proc_hnat_type;
static struct proc_dir_entry *proc_hnat_qos;
static struct proc_dir_entry *proc_hnat_mib;
static struct proc_dir_entry *proc_hnat_med;
static struct proc_dir_entry *proc_hnat_mdma;
static struct proc_dir_entry *proc_hnat_disabling_hwnat;

int dbg_cpu_reason;
EXPORT_SYMBOL(dbg_cpu_reason);

struct hwnat_interface hnat_if[MAX_IF_NUM];
EXPORT_SYMBOL(hnat_if);

int disabling_hwnat;
EXPORT_SYMBOL(disabling_hwnat);

bool ppe_mib_counter_en;

int dbg_entry_state = BIND;
typedef int (*CPU_REASON_SET_FUNC) (int par1, int par2, int par3);
typedef int (*ENTRY_SET_FUNC) (int par1, int par2, int par3);
typedef int (*CR_SET_FUNC) (int par1, int par2, int par3);
typedef int (*MULTICAST_SET_FUNC) (int par1, int par2, int par3);
typedef int (*WHITELIST_SET_FUNC) (int par1, char *par2, int par3);
typedef int (*TYPE_SET_FUNC) (int par1, char *par2, int par3);
typedef int (*QOS_SET_FUNC) (int par1, int par2, int par3);
typedef int (*MIB_SET_FUNC) (int par1, int par2, char *par3);

void dbg_dump_entry(uint32_t index, struct foe_entry *entry)
{
	if (IS_IPV4_HNAPT(entry)) {
		NAT_PRINT
		    ("NAPT(%d): %u.%u.%u.%u:%d->%u.%u.%u.%u:%d ->", index,
		     IP_FORMAT3(entry->ipv4_hnapt.sip),
		     IP_FORMAT2(entry->ipv4_hnapt.sip),
		     IP_FORMAT1(entry->ipv4_hnapt.sip),
		     IP_FORMAT0(entry->ipv4_hnapt.sip),
		     entry->ipv4_hnapt.sport,
		     IP_FORMAT3(entry->ipv4_hnapt.dip), IP_FORMAT2(entry->ipv4_hnapt.dip),
		     IP_FORMAT1(entry->ipv4_hnapt.dip), IP_FORMAT0(entry->ipv4_hnapt.dip),
		     entry->ipv4_hnapt.dport);
		NAT_PRINT
		    (" %u.%u.%u.%u:%d->%u.%u.%u.%u:%d\n",
		     IP_FORMAT3(entry->ipv4_hnapt.new_sip),
		     IP_FORMAT2(entry->ipv4_hnapt.new_sip),
		     IP_FORMAT1(entry->ipv4_hnapt.new_sip),
		     IP_FORMAT0(entry->ipv4_hnapt.new_sip), entry->ipv4_hnapt.new_sport,
		     IP_FORMAT3(entry->ipv4_hnapt.new_dip),
		     IP_FORMAT2(entry->ipv4_hnapt.new_dip),
		     IP_FORMAT1(entry->ipv4_hnapt.new_dip),
		     IP_FORMAT0(entry->ipv4_hnapt.new_dip), entry->ipv4_hnapt.new_dport);
	} else if (IS_IPV4_HNAT(entry)) {
		NAT_PRINT("NAT(%d): %u.%u.%u.%u->%u.%u.%u.%u ->", index,
			  IP_FORMAT3(entry->ipv4_hnapt.sip),
			  IP_FORMAT2(entry->ipv4_hnapt.sip),
			  IP_FORMAT1(entry->ipv4_hnapt.sip),
			  IP_FORMAT0(entry->ipv4_hnapt.sip),
			  IP_FORMAT3(entry->ipv4_hnapt.dip),
			  IP_FORMAT2(entry->ipv4_hnapt.dip),
			  IP_FORMAT1(entry->ipv4_hnapt.dip), IP_FORMAT0(entry->ipv4_hnapt.dip));
		NAT_PRINT(" %u.%u.%u.%u->%u.%u.%u.%u\n",
			  IP_FORMAT3(entry->ipv4_hnapt.new_sip),
			  IP_FORMAT2(entry->ipv4_hnapt.new_sip),
			  IP_FORMAT1(entry->ipv4_hnapt.new_sip),
			  IP_FORMAT0(entry->ipv4_hnapt.new_sip),
			  IP_FORMAT3(entry->ipv4_hnapt.new_dip),
			  IP_FORMAT2(entry->ipv4_hnapt.new_dip),
			  IP_FORMAT1(entry->ipv4_hnapt.new_dip),
			  IP_FORMAT0(entry->ipv4_hnapt.new_dip));
	}

	if (IS_IPV6_1T_ROUTE(entry)) {
		NAT_PRINT("IPv6_1T(%d): %08X:%08X:%08X:%08X\n", index,
			  entry->ipv6_1t_route.ipv6_dip3,
			  entry->ipv6_1t_route.ipv6_dip2,
			  entry->ipv6_1t_route.ipv6_dip1, entry->ipv6_1t_route.ipv6_dip0);
	} else if (IS_IPV4_DSLITE(entry)) {
		NAT_PRINT
		    ("IPv4 Ds-Lite(%d): %u.%u.%u.%u.%d->%u.%u.%u.%u:%d ->", index,
		     IP_FORMAT3(entry->ipv4_dslite.sip),
		     IP_FORMAT2(entry->ipv4_dslite.sip),
		     IP_FORMAT1(entry->ipv4_dslite.sip),
		     IP_FORMAT0(entry->ipv4_dslite.sip), entry->ipv4_dslite.sport,
		     IP_FORMAT3(entry->ipv4_dslite.dip),
		     IP_FORMAT2(entry->ipv4_dslite.dip),
		     IP_FORMAT1(entry->ipv4_dslite.dip),
		     IP_FORMAT0(entry->ipv4_dslite.dip), entry->ipv4_dslite.dport);
		NAT_PRINT(" %08X:%08X:%08X:%08X->%08X:%08X:%08X:%08X\n",
			  entry->ipv4_dslite.tunnel_sipv6_0,
			  entry->ipv4_dslite.tunnel_sipv6_1,
			  entry->ipv4_dslite.tunnel_sipv6_2,
			  entry->ipv4_dslite.tunnel_sipv6_3,
			  entry->ipv4_dslite.tunnel_dipv6_0,
			  entry->ipv4_dslite.tunnel_dipv6_1,
			  entry->ipv4_dslite.tunnel_dipv6_2, entry->ipv4_dslite.tunnel_dipv6_3);
	} else if (IS_IPV6_3T_ROUTE(entry)) {
		NAT_PRINT
		    ("IPv6_3T(%d): %08X:%08X:%08X:%08X-> %08X:%08X:%08X:%08X (Prot=%d)\n",
		     index,
		     entry->ipv6_3t_route.ipv6_sip0,
		     entry->ipv6_3t_route.ipv6_sip1,
		     entry->ipv6_3t_route.ipv6_sip2,
		     entry->ipv6_3t_route.ipv6_sip3,
		     entry->ipv6_3t_route.ipv6_dip0,
		     entry->ipv6_3t_route.ipv6_dip1,
		     entry->ipv6_3t_route.ipv6_dip2,
		     entry->ipv6_3t_route.ipv6_dip3, entry->ipv6_3t_route.prot);
	} else if (IS_IPV6_5T_ROUTE(entry)) {
		if (IS_IPV6_FLAB_EBL()) {
			NAT_PRINT
			    ("IPv6_5T(%d): %08X:%08X:%08X:%08X-> %08X:%08X:%08X:%08X",
			     index,
			     entry->ipv6_5t_route.ipv6_sip0,
			     entry->ipv6_5t_route.ipv6_sip1,
			     entry->ipv6_5t_route.ipv6_sip2,
			     entry->ipv6_5t_route.ipv6_sip3,
			     entry->ipv6_5t_route.ipv6_dip0,
			     entry->ipv6_5t_route.ipv6_dip1,
			     entry->ipv6_5t_route.ipv6_dip2, entry->ipv6_5t_route.ipv6_dip3);
			NAT_PRINT("(Flow Label=%08X)\n",
				  ((entry->ipv6_5t_route.
				    sport << 16) | (entry->ipv6_5t_route.dport)) & 0xFFFFF);
		} else {
			NAT_PRINT
			    ("IPv6_5T(%d): %08X:%08X:%08X:%08X:%d-> ",
			     index,
			     entry->ipv6_5t_route.ipv6_sip0,
			     entry->ipv6_5t_route.ipv6_sip1,
			     entry->ipv6_5t_route.ipv6_sip2,
			     entry->ipv6_5t_route.ipv6_sip3, entry->ipv6_5t_route.sport);
			NAT_PRINT("%08X:%08X:%08X:%08X:%d\n",
				  entry->ipv6_5t_route.ipv6_dip0,
				  entry->ipv6_5t_route.ipv6_dip1,
				  entry->ipv6_5t_route.ipv6_dip2,
				  entry->ipv6_5t_route.ipv6_dip3, entry->ipv6_5t_route.dport);
		}
	} else if (IS_IPV6_6RD(entry)) {
		if (IS_IPV6_FLAB_EBL()) {
			NAT_PRINT
			    ("IPv6_6RD(%d): %08X:%08X:%08X:%08X-> %08X:%08X:%08X:%08X",
			     index,
			     entry->ipv6_6rd.ipv6_sip0, entry->ipv6_6rd.ipv6_sip1,
			     entry->ipv6_6rd.ipv6_sip2, entry->ipv6_6rd.ipv6_sip3,
			     entry->ipv6_6rd.ipv6_dip0, entry->ipv6_6rd.ipv6_dip1,
			     entry->ipv6_6rd.ipv6_dip2, entry->ipv6_6rd.ipv6_dip3);
			NAT_PRINT("(Flow Label=%08X)\n",
				  ((entry->ipv6_5t_route.
				    sport << 16) | (entry->ipv6_5t_route.dport)) & 0xFFFFF);
		} else {
			NAT_PRINT
			    ("IPv6_6RD(%d): %08X:%08X:%08X:%08X:%d-> ",
			     index,
			     entry->ipv6_6rd.ipv6_sip0, entry->ipv6_6rd.ipv6_sip1,
			     entry->ipv6_6rd.ipv6_sip2, entry->ipv6_6rd.ipv6_sip3,
			     entry->ipv6_6rd.sport);
			NAT_PRINT(" %08X:%08X:%08X:%08X:%d\n", entry->ipv6_6rd.ipv6_dip0,
				  entry->ipv6_6rd.ipv6_dip1, entry->ipv6_6rd.ipv6_dip2,
				  entry->ipv6_6rd.ipv6_dip3, entry->ipv6_6rd.dport);
		}
	}
}

void dbg_dump_cr(void)
{
	unsigned int cr_base;
	int i;
	int cr_max;

	if (hnat_chip_name & (MT7622_HWNAT | LEOPARD_HWNAT))
		cr_base = 0x1B100C00;
	else
		cr_base = 0x1B100E00;
	cr_max = 319 * 4;
	for (i = 0; i < cr_max; i = i + 0x10) {
		pr_notice("0x%08x : 0x%08x 0x%08x 0x%08x 0x%08x\n", cr_base + i,
			reg_read(PPE_MCAST_L_10 + i), reg_read(PPE_MCAST_L_10 + i + 4),
			reg_read(PPE_MCAST_L_10 + i + 8), reg_read(PPE_MCAST_L_10 + i + 0xc));
	}
}

int hnat_set_usage(int level, int ignore2, int ignore3)
{
	pr_notice("Choose CPU reason 'x'");
	pr_notice(" we can see which entry indx has cpu reason 'x'\n");
	pr_notice("echo \"1 [cpu_reason]\" > /proc/%s\n",
		PROCREG_CPU_REASON);

	pr_notice("(2)IPv4(IPv6) TTL(hop limit) = 0\n");
	pr_notice("(3)IPv4(IPv6) has option(extension) header\n");
	pr_notice("(7)No flow is assigned\n");
	pr_notice("(8)IPv4 HNAT doesn't support IPv4 /w fragment\n");
	pr_notice("(9)IPv4 HNAPT/DS-Lite doesn't support IPv4 /w fragment\n");
	pr_notice("(10)IPv4 HNAPT/DS-Lite can't find TCP/UDP sport/dport\n");
	pr_notice("(11)IPv6 5T-route/6RD can't find TCP/UDP sport/dport\n");
	pr_notice("(12) Ingress packet is TCP fin/syn/rst\n");
	pr_notice("(13) FOE Un-hit\n");
	pr_notice("(14) FOE Hit unbind\n");
	pr_notice("(15) FOE Hit unbind & rate reach\n");
	pr_notice("(16) Hit bind PPE TCP FIN entry\n");
	pr_notice("(17) Hit bind PPE entry and TTL(hop limit) = 1\n");
	pr_notice("(18) Hit bind and VLAN replacement violation\n");
	pr_notice("(19) Hit bind and keep alive with unicast old-header packet\n");
	pr_notice("(20) Hit bind and keep alive with multicast new-header packet\n");
	pr_notice("(21) Hit bind and keep alive with duplicate old-header packet\n");
	pr_notice("(22) FOE Hit bind & force to CPU\n");
	/* Hit bind and remove tunnel IP header, */
	/* but inner IP has option/next header */
	pr_notice("(23) HIT_BIND_WITH_OPTION_HEADER\n");
	pr_notice("(28) Hit bind and exceed MTU\n");
	pr_notice("(27) HIT_BIND_PACKET_SAMPLING\n");
	pr_notice("(24) Switch clone multicast packet to CPU\n");
	pr_notice("(25) Switch clone multicast packet to GMAC1 & CPU\n");
	pr_notice("(26) HIT_PRE_BIND\n");
	debug_level = level;
	pr_notice("debug_level = %d\n", debug_level);
	return 0;
}

int entry_set_usage(int level, int ignore2, int ignore3)
{
	pr_notice("<Usage> Get all bind entry  : cat /proc/%s/%s\n",
		HNAT_PROCREG_DIR, PROCREG_PPE_ENTRY);

	pr_notice("<Usage> set entry state  : echo 1 [STATE] > /proc/%s/%s\n",
		HNAT_PROCREG_DIR, PROCREG_PPE_ENTRY);
	pr_notice("<Usage> get entry detail  : echo 2 [index] > /proc/%s/%s\n",
		HNAT_PROCREG_DIR, PROCREG_PPE_ENTRY);
	pr_notice("<Usage> delete entry  : echo 3 [index] > /proc/%s/%s\n",
		HNAT_PROCREG_DIR, PROCREG_PPE_ENTRY);
	pr_notice("STATE: NVALID = 0, UNBIND = 1, BIND = 2, FIN = 3\n");
	pr_notice("<Usage> set debug level : echo 0 [level] >  /proc/%s/%s\n",
		HNAT_PROCREG_DIR, PROCREG_PPE_ENTRY);
	debug_level = level;
	pr_notice("debug_level = %d\n", debug_level);

	return 0;
}

int cr_set_usage(int level, int ignore2, int ignore3)
{
	pr_notice("<Usage> get hnat CR  : cat /proc/%s/%s\n",
		HNAT_PROCREG_DIR, PROCREG_PPE_SETTING);

	pr_notice("<Usage> set debug level : echo 0 [level] >  /proc/%s/%s\n",
		HNAT_PROCREG_DIR, PROCREG_PPE_SETTING);
	pr_notice("<Usage> set binding threshold : echo 1 [threshold] >  /proc/%s/%s\n",
		HNAT_PROCREG_DIR, PROCREG_PPE_SETTING);
	pr_notice("<Usage> set bind lifetime");
	pr_notice(" :echo 2 [tcp_life] [udp_life] [fin_life] >  /proc/%s/%s\n",
		HNAT_PROCREG_DIR, PROCREG_PPE_SETTING);
	pr_notice("<Usage> set keep alive interval");
	pr_notice(": echo 3 [tcp_interval] [udp_interval]  >  /proc/%s/%s\n",
		HNAT_PROCREG_DIR, PROCREG_PPE_SETTING);

	pr_notice("<Usage> enable 464XLAT : echo 4 [1:enable,0:disable] >  /proc/%s/%s\n",
		HNAT_PROCREG_DIR, PROCREG_PPE_SETTING);

	debug_level = level;
	pr_notice("debug_level = %d\n", debug_level);

	return 0;
}

int multicast_set_usage(int level, int ignore2, int ignore3)
{
	pr_notice("<Usage> get hnat multicast table  : cat /proc/%s/%s\n",
		HNAT_PROCREG_DIR, PROCREG_PPE_MULTICAST);

	pr_notice("<Usage> set debug level : echo 0 [level] >  /proc/%s/%s\n",
		HNAT_PROCREG_DIR, PROCREG_PPE_SETTING);

	debug_level = level;
	pr_notice("debug_level = %d\n", debug_level);

	return 0;
}

int whitelist_set_usage(int level, char *ignore2, int ignore3)
{
	pr_notice("<Usage> get hnat whitelist table  : cat /proc/%s/%s\n",
		HNAT_PROCREG_DIR, PROCREG_PPE_WHITELIST);
	pr_notice("<Usage> set hnat whitelist table  : echo 1 rax /proc/%s/%s\n",
		HNAT_PROCREG_DIR, PROCREG_PPE_WHITELIST);
	pr_notice("<Usage> set debug level : echo 0 [level] >  /proc/%s/%s\n",
		HNAT_PROCREG_DIR, PROCREG_PPE_SETTING);

	debug_level = level;
	pr_notice("debug_level = %d\n", debug_level);

	return 0;
}

int mib_set_usage(int level, int ignore2, char *ignore3)
{
	pr_notice("<Usage> set debug level : echo 0 [level] > /proc/%s/%s\n",
		HNAT_PROCREG_DIR, PROCREG_PPE_MIB);

	pr_notice("<Usage> set which interface getting mib: echo 1 [rax] > /proc/%s/%s\n",
		HNAT_PROCREG_DIR, PROCREG_PPE_MIB);

	pr_notice("<Usage> set entry index getting mib: echo 2 [entry_idx] > /proc/%s/%s\n",
		HNAT_PROCREG_DIR, PROCREG_PPE_MIB);

	pr_notice("<Usage> set mib counter enable/disable: echo 3 [disable:0/enable:1] > /proc/%s/%s\n",
		HNAT_PROCREG_DIR, PROCREG_PPE_MIB);

	pr_notice("<Usage> set accounting group getting mib: echo 4 [ac_grp] > /proc/%s/%s\n",
		HNAT_PROCREG_DIR, PROCREG_PPE_MIB);

	pr_notice("<Usage> set entry and ppe index getting ipv4 napt mib: echo 5 [entry_idx][ppe_idx] > /proc/%s/%s\n",
		HNAT_PROCREG_DIR, PROCREG_PPE_MIB);

	debug_level = level;
	pr_notice("debug_level = %d\n", debug_level);

	return 0;
}

int type_set_usage(int level, char *ignore2, int ignore3)
{
	pr_notice("<Usage> get hnat type table  : cat /proc/%s/%s\n",
		HNAT_PROCREG_DIR, PROCREG_PPE_TYPE);
	pr_notice("<Usage> set hnat interface SW fast : echo 1 rax /proc/%s/%s\n",
		HNAT_PROCREG_DIR, PROCREG_PPE_TYPE);
	pr_notice("<Usage> set hnat interface HW fast : echo 2 rax /proc/%s/%s\n",
		HNAT_PROCREG_DIR, PROCREG_PPE_TYPE);
	pr_notice("<Usage> set debug level : echo 0 [level] >  /proc/%s/%s\n",
		HNAT_PROCREG_DIR, PROCREG_PPE_SETTING);

	debug_level = level;
	pr_notice("debug_level = %d\n", debug_level);

	return 0;
}

int qos_set_usage(int fqos, int ignor, int ignore3)
{
	set_fqos = fqos;
	pr_notice("set_fqos = %d\n", set_fqos);

	return 0;
}

int whitelist_set_if(int level, char *interface, int ignore3)
{
	struct net_device *dev;

	dev = dev_get_by_name(&init_net, interface);
	ppe_dev_reg_handler(dev);

	return 0;
}

int mib_set_if(int ignore, int ignore2, char *interface)
{
	struct net_device *dev;
	struct rtnl_link_stats64 stats = {0};
	int ret;

	dev = dev_get_by_name(&init_net, interface);

	ret = ppe_get_dev_stats_handler(dev, &stats);

	if (ret == 1) { /* succeed */
		pr_notice("interface %s\n", interface);
		pr_notice("tx: %llu pkt, %llu bytes\n", stats.tx_packets, stats.tx_bytes);
		pr_notice("rx: %llu pkt, %llu bytes\n", stats.rx_packets, stats.rx_bytes);
	} else {
		pr_notice("%s, interface %s, get mib error!\n", __func__, interface);
	}
	return 0;
}

int type_set_sw(int level, char *interface, int ignore3)
{
	struct net_device *dev;
	int i;

	dev = dev_get_by_name(&init_net, interface);
	for (i = 0; i < MAX_IF_NUM; i++) {
		if(dst_port[i] == dev) {
			dst_port_type[i] = 1;
			pr_notice("set %s software fast path\n", interface);
			break;
		}
	}
	return 0;
}

int type_set_hw(int level, char *interface, int ignore3)
{
	struct net_device *dev;
	int i;

	dev = dev_get_by_name(&init_net, interface);
	for (i = 0; i < MAX_IF_NUM; i++) {
		if(dst_port[i] == dev) {
			dst_port_type[i] = 0;
			pr_notice("set %s hardware acceleration\n", interface);
			break;
		}
	}
	return 0;
}
int whitelist_del_if(int level, char *interface, int ignore3)
{
	struct net_device *dev;

	dev = dev_get_by_name(&init_net, interface);
	ppe_dev_unreg_handler(dev);

	return 0;
}

int mib_set_idx(int entry_num, int ignore2, char *ignore3)
{
	unsigned long tx_pkt_cnt;
	unsigned long tx_byte_cnt;

	ppe_mib_dump(entry_num, &tx_pkt_cnt, &tx_byte_cnt);

	return 0;
}

int mib_set_counter(int mib_counter, int ignore2, char *ignore3)
{
	ppe_mib_counter_en = mib_counter;
	pr_notice("\nppe_mib_counter_en = %d\n", ppe_mib_counter_en);

	ppe_start_mib_timer();

	return 0;
}

int mib_set_agcnt(int agcnt, int ignore2, char *ignore3)
{
	struct hwnat_ac_args args = {0};
	args.ag_index = agcnt;

	ppe_get_agcnt(&args);

	pr_notice("\n%s, acnt:%d, packet cnt:%lld, byte cnt: %lld\n",
		__func__, agcnt, args.ag_pkt_cnt, args.ag_byte_cnt);

	return 0;
}

int mib_set_ipv4_idx(int entry_num, int ppe_index, char *ignore3)
{
	struct foe_entry *entry;

	pr_notice("%s, entry_num:%d, ppe_index: %d\n", __func__, entry_num, ppe_index);

	if (entry_num >= FOE_4TB_SIZ)
		return HWNAT_FAIL;

	if (ppe_index == 0)
		entry = &ppe_foe_base[entry_num];
	else if (ppe_index == 1)
		entry = &ppe1_foe_base[entry_num];
	else
		return HWNAT_FAIL;

	// update mib before query
	ppe_mib_update();

	pr_notice("\n**********PPE%d ENTRY(%d)******************\n", ppe_index, entry_num);

	if (IS_IPV4_HNAPT(entry)) {
		pr_notice("ppe%d(%d), pkt_cnt: %llu, byte_cnt:%llu\n",
			ppe_index, entry_num,
			entry->ipv4_hnapt.pkt_cnt_l + ((unsigned long long)entry->ipv4_hnapt.pkt_cnt_h <<32),
			entry->ipv4_hnapt.byte_cnt_l + ((unsigned long long)entry->ipv4_hnapt.byte_cnt_h <<32));

	} else
		pr_notice("%s, pkt_type(%d) is not IPV4 NAPT entry\n", __func__, entry->bfib1.pkt_type);

	pr_notice("\n********************************************\n");
	return 0;
}


int binding_threshold(int threshold, int ignore1, int ignore2)
{
	pr_notice("Binding Threshold =%d\n", threshold);
	reg_write(PPE_FOE_BNDR, threshold);
	return 0;
}

int bind_life_time(int tcp_life, int udp_life, int fin_life)
{
	pr_notice("tcp_life = %d, udp_life = %d, fin_life = %d\n",
		tcp_life, udp_life, fin_life);
	ppe_set_bind_lifetime(tcp_life, udp_life, fin_life);
	return 0;
}

int keep_alive_interval(int tcp_interval, int udp_interval, int ignore2)
{
	if (tcp_interval > 255 || udp_interval > 255) {
		tcp_interval = 255;
		udp_interval = 255;
		pr_notice("TCP/UDP keep alive max interval = 255\n");
	} else {
		pr_notice("tcp_interval = %d, udp_interval = %d\n",
			tcp_interval, udp_interval);
	}

	ppe_set_ka_interval(tcp_interval, udp_interval);
	return 0;
}

int enable_464xlat(int enable, int ignore1, int ignore2)
{
	pr_notice("%s, enable = %d\n", __func__, enable);

	ppe_set_464_enable(enable);
	xlat_enable = enable;

	return 0;
}


int hnat_cpu_reason(int cpu_reason, int ignore1, int ignore2)
{
	dbg_cpu_reason = cpu_reason;
	pr_notice("show cpu reason = %d entry index = %d\n",
		cpu_reason, hwnat_dbg_entry);
	/* foe_dump_entry(hwnat_dbg_entry); */

	return 0;
}

int entry_set_state(int state, int ignore1, int ignore2)
{
	dbg_entry_state = state;
	pr_notice("ENTRY STATE = %s\n",
		dbg_entry_state ==
		0 ? "Invalid" : dbg_entry_state ==
		1 ? "Unbind" : dbg_entry_state ==
		2 ? "BIND" : dbg_entry_state ==   3 ?
		"FIN" : "Unknown");
	return 0;
}

int entry_detail(int index, int ignore1, int ignore2)
{
	struct foe_entry *entry = NULL;

	entry = &ppe_foe_base[index];
	foe_dump_entry(index, entry, 0);
	return 0;
}

int entry_delete(int index, int ignore1, int ignore2)
{
	pr_notice("delete entry idx = %d\n", index);
	foe_del_entry_by_num(index, 0);
	return 0;
}

static const CPU_REASON_SET_FUNC hnat_set_func[] = {
	[0] = hnat_set_usage,
	[1] = hnat_cpu_reason,
};

static const ENTRY_SET_FUNC entry_set_func[] = {
	[0] = entry_set_usage,
	[1] = entry_set_state,
	[2] = entry_detail,
	[3] = entry_delete,
};

static const CR_SET_FUNC cr_set_func[] = {
	[0] = cr_set_usage,
	[1] = binding_threshold,
	[2] = bind_life_time,
	[3] = keep_alive_interval,
	[4] = enable_464xlat
};
//TBD multcast forward setting
static const MULTICAST_SET_FUNC multicast_set_func[] = {
	[0] = multicast_set_usage,
};

static const WHITELIST_SET_FUNC whitelist_set_func[] = {
	[0] = whitelist_set_usage,
	[1] = whitelist_set_if,
	[2] = whitelist_del_if,
};

static const TYPE_SET_FUNC type_set_func[] = {
	[0] = type_set_usage,
	[1] = type_set_sw,
	[2] = type_set_hw,
};

static const QOS_SET_FUNC qos_set_func[] = {
	[0] = qos_set_usage,
};

static const MIB_SET_FUNC mib_set_func[] = {
	[0] = mib_set_usage,
	[1] = mib_set_if,
	[2] = mib_set_idx,
	[3] = mib_set_counter,
	[4] = mib_set_agcnt,
	[5] = mib_set_ipv4_idx
};

ssize_t cpu_reason_write(struct file *file, const char __user *buffer,
			 size_t count, loff_t *data)
{
	char buf[32];
	char *p_buf;
	int len = count;
	long arg0 = 0, arg1 = 0, arg2 = 0, arg3 = 0;
	char *p_token = NULL;
	char *p_delimiter = " \t";
	int ret;

	if (len >= sizeof(buf)) {
		pr_notice("input handling fail!\n");
		len = sizeof(buf) - 1;
		return -1;
	}

	if (copy_from_user(buf, buffer, len))
		return -EFAULT;

	buf[len] = '\0';
	pr_notice("write parameter data = %s\n", buf);

	p_buf = buf;
	p_token = strsep(&p_buf, p_delimiter);
	if (!p_token)
		arg0 = 0;
	else
		ret = kstrtol(p_token, 10, &arg0);

	switch (arg0) {
	case 0:
		p_token = strsep(&p_buf, p_delimiter);
		if (!p_token)
			arg1 = 0;
		else
			ret = kstrtol(p_token, 10, &arg1);
		break;
	case 1:
		p_token = strsep(&p_buf, p_delimiter);
		if (!p_token)
			arg1 = 0;
		else
			ret = kstrtol(p_token, 10, &arg1);
		break;
	}

	if (hnat_set_func[arg0] &&
	    (ARRAY_SIZE(hnat_set_func) > arg0)) {
		(*hnat_set_func[arg0]) (arg1, arg2, arg3);
	} else {
		pr_notice("no handler defined for command id(0x%08lx)\n\r", arg0);
		(*hnat_set_func[0]) (0, 0, 0);
	}

	return len;
}

ssize_t entry_write(struct file *file, const char __user *buffer,
		    size_t count, loff_t *data)
{
	char buf[32];
	char *p_buf;
	int len = count;
	long arg0 = 0, arg1 = 0, arg2 = 0, arg3 = 0;
	char *p_token = NULL;
	char *p_delimiter = " \t";
	int ret;

	if (len >= sizeof(buf)) {
		pr_notice("input handling fail!\n");
		len = sizeof(buf) - 1;
		return -1;
	}

	if (copy_from_user(buf, buffer, len))
		return -EFAULT;

	buf[len] = '\0';
	pr_notice("write parameter data = %s\n\r", buf);

	p_buf = buf;
	p_token = strsep(&p_buf, p_delimiter);
	if (!p_token)
		arg0 = 0;
	else
		ret = kstrtol(p_token, 10, &arg0);

	switch (arg0) {
	case 0:
		p_token = strsep(&p_buf, p_delimiter);
		if (!p_token)
			arg1 = 0;
		else
			ret = kstrtol(p_token, 10, &arg1);
		break;
	case 1:
		p_token = strsep(&p_buf, p_delimiter);
		if (!p_token)
			arg1 = 0;
		else
			ret = kstrtol(p_token, 10, &arg1);
		break;
	case 2:
		p_token = strsep(&p_buf, p_delimiter);
		if (!p_token)
			arg1 = 0;
		else
			ret = kstrtol(p_token, 10, &arg1);
		p_token = strsep(&p_buf, p_delimiter);
		if (!p_token)
			arg2 = 0;
		else
			ret = kstrtol(p_token, 10, &arg2);
		p_token = strsep(&p_buf, p_delimiter);
		if (!p_token)
			arg3 = 0;
		else
			ret = kstrtol(p_token, 10, &arg3);
		break;
	case 3:
		p_token = strsep(&p_buf, p_delimiter);
		if (!p_token)
			arg1 = 0;
		else
			ret = kstrtol(p_token, 10, &arg1);
		p_token = strsep(&p_buf, p_delimiter);
		if (!p_token)
			arg2 = 0;
		else
			ret = kstrtol(p_token, 10, &arg2);
		p_token = strsep(&p_buf, p_delimiter);
		if (!p_token)
			arg3 = 0;
		else
			ret = kstrtol(p_token, 10, &arg3);
		break;
	}

	if (entry_set_func[arg0] &&
	    (ARRAY_SIZE(entry_set_func) > arg0)) {
		(*entry_set_func[arg0]) (arg1, arg2, arg3);
	} else {
		pr_notice("no handler defined for command id(0x%08lx)\n\r", arg0);
		(*entry_set_func[0]) (0, 0, 0);
	}

	return len;
}

ssize_t setting_write(struct file *file, const char __user *buffer,
		      size_t count, loff_t *data)
{
	char buf[32];
	char *p_buf;
	int len = count;
	long arg0 = 0, arg1 = 0, arg2 = 0, arg3 = 0;
	char *p_token = NULL;
	char *p_delimiter = " \t";
	int ret;

	if (len >= sizeof(buf)) {
		pr_notice("input handling fail!\n");
		len = sizeof(buf) - 1;
		return -1;
	}

	if (copy_from_user(buf, buffer, len))
		return -EFAULT;

	buf[len] = '\0';
	pr_notice("write parameter data = %s\n\r", buf);

	p_buf = buf;
	p_token = strsep(&p_buf, p_delimiter);
	if (!p_token)
		arg0 = 0;
	else
		ret = kstrtol(p_token, 10, &arg0);

	switch (arg0) {
	case 0:
	case 1:
	case 4:
		p_token = strsep(&p_buf, p_delimiter);
		if (!p_token)
			arg1 = 0;
		else
			ret = kstrtol(p_token, 10, &arg1);
		break;

	case 2:
		p_token = strsep(&p_buf, p_delimiter);
		if (!p_token)
			arg1 = 0;
		else
			ret = kstrtol(p_token, 10, &arg1);
		p_token = strsep(&p_buf, p_delimiter);
		if (!p_token)
			arg2 = 0;
		else
			ret = kstrtol(p_token, 10, &arg2);
		p_token = strsep(&p_buf, p_delimiter);
		if (!p_token)
			arg3 = 0;
		else
			ret = kstrtol(p_token, 10, &arg3);
		break;
	case 3:
		p_token = strsep(&p_buf, p_delimiter);
		if (!p_token)
			arg1 = 0;
		else
			ret = kstrtol(p_token, 10, &arg1);
		p_token = strsep(&p_buf, p_delimiter);
		if (!p_token)
			arg2 = 0;
		else
			ret = kstrtol(p_token, 10, &arg2);
		break;
	}

	if (cr_set_func[arg0] &&
	    (ARRAY_SIZE(cr_set_func) > arg0)) {
		(*cr_set_func[arg0]) (arg1, arg2, arg3);
	} else {
		pr_notice("no handler defined for command id(0x%08lx)\n\r", arg0);
		(*cr_set_func[0]) (0, 0, 0);
	}

	return len;
}

ssize_t multicast_write(struct file *file, const char __user *buffer,
			size_t count, loff_t *data)
{
	char buf[32];
	char *p_buf;
	int len = count;
	long arg0 = 0, arg1 = 0, arg2 = 0, arg3 = 0;
	char *p_token = NULL;
	char *p_delimiter = " \t";
	int ret;

	if (len >= sizeof(buf)) {
		pr_notice("input handling fail!\n");
		len = sizeof(buf) - 1;
		return -1;
	}

	if (copy_from_user(buf, buffer, len))
		return -EFAULT;

	buf[len] = '\0';
	pr_notice("write parameter data = %s\n\r", buf);

	p_buf = buf;
	p_token = strsep(&p_buf, p_delimiter);
	if (!p_token)
		arg0 = 0;
	else
		ret = kstrtol(p_token, 10, &arg0);

	switch (arg0) {
	case 0:
		p_token = strsep(&p_buf, p_delimiter);
		if (!p_token)
			arg1 = 0;
		else
			ret = kstrtol(p_token, 10, &arg1);
		break;
	}

	if (multicast_set_func[arg0] &&
	    (ARRAY_SIZE(multicast_set_func) > arg0)) {
		(*multicast_set_func[arg0]) (arg1, arg2, arg3);
	} else {
		pr_notice("no handler defined for command id(0x%08lx)\n\r", arg0);
		(*multicast_set_func[0]) (0, 0, 0);
	}

	return len;
}

ssize_t whitelist_write(struct file *file, const char __user *buffer,
			size_t count, loff_t *data)
{
	char buf[32];
	char *p_buf;
	int len = count;
	long arg0 = 0, arg1 = 0, arg3 = 0;
	char *p_token = NULL;
	char *arg2 = NULL;
	char *p_delimiter = " \t";
	char *p_delimiter1 = " \n";
	int ret;

	if (len >= sizeof(buf)) {
		pr_notice("input handling fail!\n");
		len = sizeof(buf) - 1;
		return -1;
	}

	if (copy_from_user(buf, buffer, len))
		return -EFAULT;

	buf[len] = '\0';
	pr_notice("write parameter data = %s\n\r", buf);

	p_buf = buf;
	p_token = strsep(&p_buf, p_delimiter);
	if (!p_token)
		arg0 = 0;
	else
		ret = kstrtol(p_token, 10, &arg0);

	switch (arg0) {
	case 0:
		p_token = strsep(&p_buf, p_delimiter);
		if (!p_token)
			arg1 = 0;
		else
			ret = kstrtol(p_token, 10, &arg1);
		break;
	case 1:
		p_token = strsep(&p_buf, p_delimiter1);
		arg2 = p_token;
		break;
	case 2:
		p_token = strsep(&p_buf, p_delimiter1);
		arg2 = p_token;
		break;
	}

	if (whitelist_set_func[arg0] &&
	    (ARRAY_SIZE(whitelist_set_func) > arg0)) {
		(*whitelist_set_func[arg0]) (arg1, arg2, arg3);
	} else {
		pr_notice("no handler defined for command id(0x%08lx)\n\r", arg0);
		(*whitelist_set_func[0]) (0, 0, 0);
	}

	return len;
}

ssize_t type_write(struct file *file, const char __user *buffer,
			size_t count, loff_t *data)
{
	char buf[32];
	char *p_buf;
	int len = count;
	long arg0 = 0, arg1 = 0, arg3 = 0;
	char *p_token = NULL;
	char *arg2 = NULL;
	char *p_delimiter = " \t";
	char *p_delimiter1 = " \n";
	int ret;

	if (len >= sizeof(buf)) {
		pr_notice("input handling fail!\n");
		len = sizeof(buf) - 1;
		return -1;
	}

	if (copy_from_user(buf, buffer, len))
		return -EFAULT;

	buf[len] = '\0';
	pr_notice("write parameter data = %s\n\r", buf);

	p_buf = buf;
	p_token = strsep(&p_buf, p_delimiter);
	if (!p_token)
		arg0 = 0;
	else
		ret = kstrtol(p_token, 10, &arg0);

	switch (arg0) {
	case 0:
		p_token = strsep(&p_buf, p_delimiter);
		if (!p_token)
			arg1 = 0;
		else
			ret = kstrtol(p_token, 10, &arg1);
		break;
	case 1:
		p_token = strsep(&p_buf, p_delimiter1);
		arg2 = p_token;
		break;
	case 2:
		p_token = strsep(&p_buf, p_delimiter1);
		arg2 = p_token;
		break;
	}

	if (type_set_func[arg0] &&
	    (ARRAY_SIZE(type_set_func) > arg0)) {
		(*type_set_func[arg0]) (arg1, arg2, arg3);
	} else {
		pr_notice("no handler defined for command id(0x%08lx)\n\r", arg0);
		(*type_set_func[0]) (0, 0, 0);
	}

	return len;
}

ssize_t qos_write(struct file *file, const char __user *buffer,
			size_t count, loff_t *data)

{
	char buf[32];
	char *p_buf;
	int len = count;
	long arg0 = 0, arg1 = 0, arg2 = 0, arg3 = 0;
	char *p_token = NULL;
	char *p_delimiter = " \t";
	int ret;

	if (len >= sizeof(buf)) {
		pr_notice("input handling fail!\n");
		len = sizeof(buf) - 1;
		return -1;
	}

	if (copy_from_user(buf, buffer, len))
		return -EFAULT;

	buf[len] = '\0';
	pr_notice("write parameter data = %s\n\r", buf);

	p_buf = buf;
	p_token = strsep(&p_buf, p_delimiter);
	if (!p_token)
		arg0 = 0;
	else
		ret = kstrtol(p_token, 10, &arg0);

	switch (arg0) {
	case 0:
		p_token = strsep(&p_buf, p_delimiter);
		if (!p_token)
			arg1 = 0;
		else
			ret = kstrtol(p_token, 10, &arg1);
		break;
	}

	if (qos_set_func[arg0] &&
	    (ARRAY_SIZE(qos_set_func) > arg0)) {
		(*qos_set_func[arg0]) (arg1, arg2, arg3);
	} else {
		pr_notice("no handler defined for command id(0x%08lx)\n\r", arg0);
		(*qos_set_func[0]) (0, 0, 0);
	}

	return len;
}

ssize_t mib_write(struct file *file, const char __user *buffer,
			size_t count, loff_t *data)
{
	char buf[32];
	char *p_buf;
	int len = count;
	long arg0 = 0, arg_long = 0, arg_long2 = 0;
	char *p_token = NULL;
	char *arg_char = NULL;
	char *p_delimiter = " \t";
	char *p_delimiter1 = " \n";
	int ret;

	if (len >= sizeof(buf)) {
		pr_notice("input handling fail!\n");
		len = sizeof(buf) - 1;
		return -1;
	}

	if (copy_from_user(buf, buffer, len))
		return -EFAULT;

	buf[len] = '\0';
	pr_notice("write parameter data = %s\n\r", buf);

	p_buf = buf;
	p_token = strsep(&p_buf, p_delimiter);
	if (!p_token)
		arg0 = 0;
	else
		ret = kstrtol(p_token, 10, &arg0);

	switch (arg0) {
	case 0:
	case 2:
	case 3:
	case 4:
		p_token = strsep(&p_buf, p_delimiter);
		if (!p_token)
			arg_long = 0;
		else
			ret = kstrtol(p_token, 10, &arg_long);
		break;
	case 1:
		p_token = strsep(&p_buf, p_delimiter1);
		arg_char = p_token;
		break;
	case 5:
		p_token = strsep(&p_buf, p_delimiter);
		if (!p_token)
			arg_long = 0;
		else
			ret = kstrtol(p_token, 10, &arg_long);

		p_token = strsep(&p_buf, p_delimiter);
		if (!p_token)
			arg_long2 = 0;
		else
			ret = kstrtol(p_token, 10, &arg_long2);
		break;
	}

	if (mib_set_func[arg0] &&
	    (ARRAY_SIZE(mib_set_func) > arg0)) {
		(*mib_set_func[arg0]) (arg_long, arg_long2, arg_char);
	} else {
		pr_notice("no handler defined for command id(0x%08lx)\n\r", arg0);
		(*mib_set_func[0]) (0, 0, 0);
	}

	return len;
}


ssize_t med_write(struct file *file, const char __user *buffer,
			size_t count, loff_t *data)
{
	return 0;
}

ssize_t mdma_write(struct file *file, const char __user *buffer,
			size_t count, loff_t *data)
{
	return 0;
}


ssize_t disabling_write(struct file *file, const char __user *buffer,
			 size_t count, loff_t *data)
{
	if (count > 0) {
		char c;
		int val;

		if (get_user(c, buffer))
			return -EFAULT;

		val = (c != '0');

		disabling_hwnat = val;
	}

	return count;
}

int cpu_reason_read(struct seq_file *seq, void *v)
{
	int i;

	pr_notice("============ CPU REASON =========\n");
	pr_notice("(2)IPv4(IPv6) TTL(hop limit) = %u\n",
		dbg_cpu_reason_cnt[0]);
	pr_notice("(3)Ipv4(IPv6) has option(extension) header = %u\n",
		dbg_cpu_reason_cnt[1]);
	pr_notice("(7)No flow is assigned = %u\n", dbg_cpu_reason_cnt[2]);
	pr_notice("(8)IPv4 HNAT doesn't support IPv4 /w fragment = %u\n",
		dbg_cpu_reason_cnt[3]);
	pr_notice("(9)IPv4 HNAPT/DS-Lite doesn't support IPv4 /w fragment = %u\n",
		dbg_cpu_reason_cnt[4]);
	pr_notice("(10)IPv4 HNAPT/DS-Lite can't find TCP/UDP sport/dport = %u\n",
		dbg_cpu_reason_cnt[5]);
	pr_notice("(11)IPv6 5T-route/6RD can't find TCP/UDP sport/dport = %u\n",
		dbg_cpu_reason_cnt[6]);
	pr_notice("(12)Ingress packet is TCP fin/syn/rst = %u\n",
		dbg_cpu_reason_cnt[7]);
	pr_notice("(13)FOE Un-hit = %u\n", dbg_cpu_reason_cnt[8]);
	pr_notice("(14)FOE Hit unbind = %u\n", dbg_cpu_reason_cnt[9]);
	pr_notice("(15)FOE Hit unbind & rate reach = %u\n", dbg_cpu_reason_cnt[10]);
	pr_notice("(16)Hit bind PPE TCP FIN entry = %u\n", dbg_cpu_reason_cnt[11]);
	pr_notice("(17)Hit bind PPE entry and TTL(hop limit) = 1 and TTL(hot limit) - 1 = %u\n",
		dbg_cpu_reason_cnt[12]);
	pr_notice("(18)Hit bind and VLAN replacement violation = %u\n",
		dbg_cpu_reason_cnt[13]);
	pr_notice("(19)Hit bind and keep alive with unicast old-header packet = %u\n",
		dbg_cpu_reason_cnt[14]);
	pr_notice("(20)Hit bind and keep alive with multicast new-header packet = %u\n",
		dbg_cpu_reason_cnt[15]);
	pr_notice("(21)Hit bind and keep alive with duplicate old-header packet = %u\n",
		dbg_cpu_reason_cnt[16]);
	pr_notice("(22)FOE Hit bind & force to CPU = %u\n", dbg_cpu_reason_cnt[17]);
	pr_notice("(28)Hit bind and exceed MTU =%u\n", dbg_cpu_reason_cnt[18]);
	pr_notice("(24)Hit bind multicast packet to CPU = %u\n",
		dbg_cpu_reason_cnt[19]);
	pr_notice("(25)Hit bind multicast packet to GMAC & CPU = %u\n",
		dbg_cpu_reason_cnt[20]);
	pr_notice("(26)Pre bind = %u\n", dbg_cpu_reason_cnt[21]);

	for (i = 0; i < 22; i++)
		dbg_cpu_reason_cnt[i] = 0;
	return 0;
}

int entry_read(struct seq_file *seq, void *v)
{
	struct foe_entry *entry;
	struct foe_entry *entry1;
	int hash_index;
	int cnt;

	cnt = 0;
	for (hash_index = 0; hash_index < FOE_4TB_SIZ; hash_index++) {
		entry = &ppe_foe_base[hash_index];
		if (entry->bfib1.state == dbg_entry_state) {
			cnt++;
			dbg_dump_entry(hash_index, entry);
		}
	}
	pr_notice("PPE0 Total State = %s cnt = %d\n",
		dbg_entry_state ==
		0 ? "Invalid" : dbg_entry_state ==
		1 ? "Unbind" : dbg_entry_state ==
		2 ? "BIND" : dbg_entry_state ==   3 ? "FIN" : "Unknown", cnt);

	cnt = 0;
	for (hash_index = 0; hash_index < FOE_4TB_SIZ; hash_index++) {
		entry1 = &ppe1_foe_base[hash_index];
		if (entry1->bfib1.state == dbg_entry_state) {
			cnt++;
			dbg_dump_entry(hash_index, entry1);
		}
	}
	pr_notice("PPE1 Total State = %s cnt = %d\n",
		dbg_entry_state ==
		0 ? "Invalid" : dbg_entry_state ==
		1 ? "Unbind" : dbg_entry_state ==
		2 ? "BIND" : dbg_entry_state ==   3 ? "FIN" : "Unknown", cnt);
	return 0;
}

int setting_read(struct seq_file *seq, void *v)
{
	dbg_dump_cr();
	return 0;
}

int multicast_read(struct seq_file *seq, void *v)
{
	foe_mcast_entry_dump();
	return 0;
}

int whitelist_read(struct seq_file *seq, void *v)
{
	dump_dport();
	return 0;
}

int type_read(struct seq_file *seq, void *v)
{
	int i;

	for (i = 0; i < MAX_IF_NUM; i++) {
		if(dst_port[i] != NULL)
			pr_notice("%s -> %s\n",dst_port[i]->name,
				dst_port_type[i] == 0 ? "HW_fast" :
			  	dst_port_type[i] == 1 ? "SW_fast" : "Unknown");
	}
	return 0;
}

int qos_read(struct seq_file *seq, void *v)
{
	pr_notice("support hw qos = %d\n", set_fqos);

	return 0;
}

int mib_read(struct seq_file *seq, void *v)
{
	u8 fport, sport, fport1, sport1, i;
	int hash_index;
	struct foe_entry *entry;
	struct foe_entry *entry1;
	unsigned long pkt_cnt, byte_cnt, pkt_cnt1, byte_cnt1;

	for (i = 0; i < MAX_IF_NUM; i++)
		hnat_if[i].dev = dst_port[i];

	pkt_cnt = byte_cnt = 0;
	pkt_cnt1 = byte_cnt1 = 0;

	for (hash_index = 0; hash_index < FOE_4TB_SIZ; hash_index++) {
		entry = &ppe_foe_base[hash_index];
		entry1 = &ppe1_foe_base[hash_index];

		fport = get_act_dp(entry);
		sport = get_rxif_idx(entry);

		fport1 = get_act_dp(entry1);
		sport1 = get_rxif_idx(entry1);

		ppe_mib_dump_ppe0(hash_index, &pkt_cnt, &byte_cnt);
		ppe_mib_dump_ppe1(hash_index, &pkt_cnt1, &byte_cnt1);

		hnat_if[sport].rx_byte_cnt += byte_cnt;
		hnat_if[fport].tx_byte_cnt += byte_cnt;

		hnat_if[sport].rx_pkt_cnt += pkt_cnt;
		hnat_if[fport].tx_pkt_cnt += pkt_cnt;


		hnat_if[sport1].rx_byte_cnt += byte_cnt1;
		hnat_if[fport1].tx_byte_cnt += byte_cnt1;

		hnat_if[sport1].rx_pkt_cnt += pkt_cnt1;
		hnat_if[fport1].tx_pkt_cnt += pkt_cnt1;
	}

	for (i = 0; i < 16; i++) {
		if((hnat_if[i].dev) != NULL) {
			pr_notice("Interface : %s\n", hnat_if[i].dev->name);
			pr_notice("Rx pkt cnt =%llu, Rx byte cnt=%llu\n", hnat_if[i].rx_pkt_cnt, hnat_if[i].rx_byte_cnt);
			pr_notice("Tx pkt cnt =%llu, Tx byte cnt=%llu\n", hnat_if[i].tx_pkt_cnt, hnat_if[i].tx_byte_cnt);
		}
	}

	return 0;
}

int med_read(struct seq_file *seq, void *v)
{

	struct MED_HNAT_INFO_HOST *med_dmad;
	unsigned int wdix, rdix, i, j;
	u32 *p;

	rdix = reg_read(MEDHW_SSR1_DST_RB0_RIDX);
	wdix = reg_read(MEDHW_SSR1_DST_RB0_WIDX);
	med_dmad = &med_info_base[0];
	p = (u32 *)med_dmad;
	pr_notice("wdix = %x, rdix = %x\n", wdix, rdix);
	for (i = 0; i < MED_INFO_SIZE; i++) {
		pr_notice("********** HNAT_INFO_HOST(%d)*********\n", i);
		for (j = 0; j < 2; j++)
			pr_notice("%02d: %08X\n", j, *(p + j));
	}

	return 0;
}


int mdma_read(struct seq_file *seq, void *v)
{
	struct MDMA_txdmad *tx_ring;
	struct MDMA_rxdmad *rx_ring;
	int i, j;
	u32 tx_size = 0;
	u32 rx_size = 0;
	void __iomem *mdma_base;
	void __iomem *mdma_base_rx;
	u32 *p;

	tx_size = reg_read(MDMA_TX_MAX_CNT_0);
	rx_size = reg_read(MDMA_RX_MAX_CNT_0);
	mdma_base = ioremap(reg_read(MDMA_TX_BASE_PTR_0), 0x1000);
	mdma_base_rx = ioremap(reg_read(MDMA_RX_BASE_PTR_0), 0x1000);
	tx_ring = mdma_base;
	rx_ring = mdma_base_rx;
	p = (u32 *)tx_ring;
	seq_printf(seq, "!!!!!!!!! MDMA TX_RING!!!!!!!\n");
	for (i = 0; i < tx_size; i++) {
		for (j = 0; j < 8; j++)
			seq_printf(seq, "tx indx (%d)%02d: %08X\n", i, j, *(p + j));
	}
	p = (u32 *)rx_ring;
	seq_printf(seq, "!!!!!!!!! MDMA RX_RING!!!!!!!\n");
	for (i = 0; i < rx_size; i++) {
		for (j = 0; j < 8; j++)
			seq_printf(seq, "rx indx (%d)%02d: %08X\n", i, j, *(p + j));
	}

	iounmap(mdma_base);

	return 0;
}

int disabling_read(struct seq_file *seq, void *v)
{
	seq_printf(seq, "disabling_hwnat=%d\n", disabling_hwnat);
	return 0;
}

static int cpu_reason_open(struct inode *inode, struct file *file)
{
	return single_open(file, cpu_reason_read, NULL);
}

static int entry_open(struct inode *inode, struct file *file)
{
	return single_open(file, entry_read, NULL);
}

static int setting_open(struct inode *inode, struct file *file)
{
	return single_open(file, setting_read, NULL);
}

static int multicast_open(struct inode *inode, struct file *file)
{
	return single_open(file, multicast_read, NULL);
}

static int whitelist_open(struct inode *inode, struct file *file)
{
	return single_open(file, whitelist_read, NULL);
}

static int type_open(struct inode *inode, struct file *file)
{
	return single_open(file, type_read, NULL);
}

static int qos_open(struct inode *inode, struct file *file)
{
	return single_open(file, qos_read, NULL);
}

static int mib_open(struct inode *inode, struct file *file)
{
	return single_open(file, mib_read, NULL);
}

static int med_open(struct inode *inode, struct file *file)
{
	return single_open(file, med_read, NULL);
}

static int mdma_open(struct inode *inode, struct file *file)
{
	return single_open(file, mdma_read, NULL);
}

static int disabling_open(struct inode *inode, struct file *file)
{
	return single_open(file, disabling_read, NULL);
}

static const struct file_operations cpu_reason_fops = {
	.owner = THIS_MODULE,
	.open = cpu_reason_open,
	.read = seq_read,
	.llseek = seq_lseek,
	.write = cpu_reason_write,
	.release = single_release
};

static const struct file_operations hnat_entry_fops = {
	.owner = THIS_MODULE,
	.open = entry_open,
	.read = seq_read,
	.llseek = seq_lseek,
	.write = entry_write,
	.release = single_release
};

static const struct file_operations hnat_setting_fops = {
	.owner = THIS_MODULE,
	.open = setting_open,
	.read = seq_read,
	.llseek = seq_lseek,
	.write = setting_write,
	.release = single_release
};

static const struct file_operations hnat_multicast_fops = {
	.owner = THIS_MODULE,
	.open = multicast_open,
	.read = seq_read,
	.llseek = seq_lseek,
	.write = multicast_write,
	.release = single_release
};

static const struct file_operations hnat_whitelist_fops = {
	.owner = THIS_MODULE,
	.open = whitelist_open,
	.read = seq_read,
	.llseek = seq_lseek,
	.write = whitelist_write,
	.release = single_release
};

static const struct file_operations hnat_type_fops = {
	.owner = THIS_MODULE,
	.open = type_open,
	.read = seq_read,
	.llseek = seq_lseek,
	.write = type_write,
	.release = single_release
};

static const struct file_operations hnat_qos_fops = {
	.owner = THIS_MODULE,
	.open = qos_open,
	.read = seq_read,
	.llseek = seq_lseek,
	.write = qos_write,
	.release = single_release
};

static const struct file_operations hnat_mib_fops = {
	.owner = THIS_MODULE,
	.open = mib_open,
	.read = seq_read,
	.llseek = seq_lseek,
	.write = mib_write,
	.release = single_release
};

static const struct file_operations hnat_med_fops = {
	.owner = THIS_MODULE,
	.open = med_open,
	.read = seq_read,
	.llseek = seq_lseek,
	.write = med_write,
	.release = single_release
};

static const struct file_operations hnat_mdma_fops = {
	.owner = THIS_MODULE,
	.open = mdma_open,
	.read = seq_read,
	.llseek = seq_lseek,
	.write = mdma_write,
	.release = single_release
};

static const struct file_operations hnat_disabling_fops = {
	.owner = THIS_MODULE,
	.open = disabling_open,
	.read = seq_read,
	.llseek = seq_lseek,
	.write = disabling_write,
	.release = single_release
};

int hnat_debug_proc_init(void)
{
	if (!hnat_proc_reg_dir)
		hnat_proc_reg_dir = proc_mkdir(HNAT_PROCREG_DIR, NULL);

	proc_cpu_reason = proc_create(PROCREG_CPU_REASON, 0,
				      hnat_proc_reg_dir, &cpu_reason_fops);
	if (!proc_cpu_reason)
		pr_notice("!! FAIL to create %s PROC !!\n", PROCREG_CPU_REASON);

	proc_hnat_entry = proc_create(PROCREG_PPE_ENTRY, 0,
				      hnat_proc_reg_dir, &hnat_entry_fops);
	if (!proc_hnat_entry)
		pr_notice("!! FAIL to create %s PROC !!\n", PROCREG_PPE_ENTRY);

	proc_hnat_setting = proc_create(PROCREG_PPE_SETTING, 0,
					hnat_proc_reg_dir, &hnat_setting_fops);
	if (!proc_hnat_setting)
		pr_notice("!! FAIL to create %s PROC !!\n", PROCREG_PPE_ENTRY);

	proc_hnat_multicast = proc_create(PROCREG_PPE_MULTICAST, 0,
					  hnat_proc_reg_dir, &hnat_multicast_fops);
	if (!proc_hnat_multicast)
		pr_notice("!! FAIL to create %s PROC !!\n", PROCREG_PPE_MULTICAST);

	proc_hnat_whitelist = proc_create(PROCREG_PPE_WHITELIST, 0,
					  hnat_proc_reg_dir, &hnat_whitelist_fops);
	if (!proc_hnat_whitelist)
		pr_notice("!! FAIL to create %s PROC !!\n", PROCREG_PPE_WHITELIST);

	proc_hnat_type = proc_create(PROCREG_PPE_TYPE, 0,
					  hnat_proc_reg_dir, &hnat_type_fops);
	if (!proc_hnat_type)
		pr_notice("!! FAIL to create %s PROC !!\n", PROCREG_PPE_TYPE);

	proc_hnat_qos = proc_create(PROCREG_PPE_QOS, 0,
					  hnat_proc_reg_dir, &hnat_qos_fops);
	if (!proc_hnat_qos)
		pr_notice("!! FAIL to create %s PROC !!\n", PROCREG_PPE_QOS);

	proc_hnat_mib = proc_create(PROCREG_PPE_MIB, 0,
					  hnat_proc_reg_dir, &hnat_mib_fops);
	if (!proc_hnat_mib)
		pr_notice("!! FAIL to create %s PROC !!\n", PROCREG_PPE_MIB);

	proc_hnat_med = proc_create(PROCREG_PPE_MED, 0,
					  hnat_proc_reg_dir, &hnat_med_fops);
	if (!proc_hnat_med)
		pr_notice("!! FAIL to create %s PROC !!\n", PROCREG_PPE_MDMA);


	proc_hnat_mdma = proc_create(PROCREG_PPE_MDMA, 0,
					  hnat_proc_reg_dir, &hnat_mdma_fops);
	if (!proc_hnat_mdma)
		pr_notice("!! FAIL to create %s PROC !!\n", PROCREG_PPE_MDMA);


	proc_hnat_disabling_hwnat = proc_create(PROCREG_DISABLING_HWNAT, 0,
					  hnat_proc_reg_dir, &hnat_disabling_fops);
	if (!proc_hnat_disabling_hwnat)
		pr_notice("!! FAIL to create %s PROC !!\n", PROCREG_DISABLING_HWNAT);
	disabling_hwnat = 0;

	return 0;
}

void hnat_debug_proc_exit(void)
{
	pr_notice("proc exit\n");
	if (proc_cpu_reason)
		remove_proc_entry(PROCREG_CPU_REASON, hnat_proc_reg_dir);

	if (proc_hnat_entry)
		remove_proc_entry(PROCREG_PPE_ENTRY, hnat_proc_reg_dir);

	if (proc_hnat_setting)
		remove_proc_entry(PROCREG_PPE_SETTING, hnat_proc_reg_dir);

	if (proc_hnat_multicast)
		remove_proc_entry(PROCREG_PPE_MULTICAST, hnat_proc_reg_dir);

	if (proc_hnat_whitelist)
		remove_proc_entry(PROCREG_PPE_WHITELIST, hnat_proc_reg_dir);

	if (proc_hnat_type)
		remove_proc_entry(PROCREG_PPE_TYPE, hnat_proc_reg_dir);

	if (proc_hnat_qos)
		remove_proc_entry(PROCREG_PPE_QOS, hnat_proc_reg_dir);

	if (proc_hnat_mib)
		remove_proc_entry(PROCREG_PPE_MIB, hnat_proc_reg_dir);

	if (proc_hnat_med)
		remove_proc_entry(PROCREG_PPE_MED, hnat_proc_reg_dir);

	if (proc_hnat_mdma)
		remove_proc_entry(PROCREG_PPE_MDMA, hnat_proc_reg_dir);

	if (proc_hnat_disabling_hwnat)
		remove_proc_entry(PROCREG_DISABLING_HWNAT, hnat_proc_reg_dir);

	if (hnat_proc_reg_dir)
		remove_proc_entry(HNAT_PROCREG_DIR, 0);
}

