/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#ifndef GOSTECALLUTILS_H_
#define GOSTECALLUTILS_H_

#include <cstdio>
#include <string>
#include <cstdint>

#if 1
#include <log/log.h>
#define MTK_RLOGE(fmt, args...) RLOGE("%s: " fmt, __FUNCTION__, ##args)
#define MTK_RLOGD(fmt, args...) RLOGD("%s: " fmt, __FUNCTION__, ##args)
#define MTK_RLOGW(fmt, args...) RLOGW("%s: " fmt, __FUNCTION__, ##args)
#define MTK_RLOGI(fmt, args...) RLOGI("%s: " fmt, __FUNCTION__, ##args)
#else
#define MTK_RLOGE(fmt, args...) printf("%s(%d): %s() "#fmt"\n",__FILE__,__LINE__,__func__,##args)
#define MTK_RLOGD(fmt, args...) printf("%s(%d): %s() "#fmt"\n",__FILE__,__LINE__,__func__,##args)
#define MTK_RLOGW(fmt, args...) printf("%s(%d): %s() "#fmt"\n",__FILE__,__LINE__,__func__,##args)
#define MTK_RLOGI(fmt, args...) printf("%s(%d): %s() "#fmt"\n",__FILE__,__LINE__,__func__,##args)
#endif

//p25, table 16
typedef enum {
    //this service may be used by the IVDS only after a new TCP/IP connection with
    //the telematic platform is established.
    EGTS_AUTH_SERVICE=1,
    EGTS_TELEDATA_SERVICE=2,
    //process of commands and acknowledgements transferred between the IVDS,
    //telematic platform and client applications.
    EGTS_COMMANDS_SERVICE=4, //6.7.3 37page
    //p45 6.7.4 This service is intended for downloading data to the IVDS,
    //including configuration data and firmware updates for modules and units of the IVDS
    // itself as well as of its connected peripheral equipment.
    EGTS_FIRMWARE_SERVICE=9,
    //7.2 47page , accident emergency response service
    //support EGTS_COMMANDS_SERVICE
    //support EGTS_ECALL_REQ and EGTS_ECALL_MSD_REQ
    EGTS_ECALL_SERVICE=10,
}service_support_layer_protocol;

typedef enum {
    EGTS_SR_AUTH_RECORD_RESPONSE = 0,
    EGTS_SR_TERM_IDENTIFY = 1,
    EGTS_SR_MODULE_DATA = 2,
    EGTS_SR_VEHICLE_DATA = 3,
    EGTS_SR_AUTH_PARAMS = 6,
    EGTS_SR_AUTH_INFO = 7,
    EGTS_SR_SERVICE_INFO = 8,
    EGTS_SR_RESULT_CODE = 9,
}sub_records_egts_auth_ser;

typedef enum {
    EGTS_PC_OK = 0,
    EGTS_PC_IN_PROGRESS = 1,
    EGTS_PC_UNS_PROTOCOL = 128,
    EGTS_PC_DECRYPT_ERROR = 129,
    EGTS_PC_PORC_DENIED = 130,
    EGTS_PC_INC_HEADERFORM=131,
    EGTS_PC_INC_DATAFORM=132,
    EGTS_PC_UNS_TYPE = 133,
    EGTS_PC_NOTEN_PARAMS = 134,
    EGTS_PC_DBL_PROC = 135,
    EGTS_PC_PROC_SRC_DENIED=136,
    EGTS_PC_HEADERCRC_ERROR=137,
    EGTS_PC_DATACRC_ERROR=138,
    EGTS_PC_INVDATALEN=139,
    EGTS_PC_ROUTE_NFOUND=140,
    EGTS_PC_ROUTE_CLOSED=141,
    EGTS_PC_ROUTE_DENIED=142,
    EGTS_PC_INVADDR=143,
    EGTS_PC_TTLEXPIRED=144,
    EGTS_PC_NO_ACK=145,
    EGTS_PC_OBJ_NFOUND=146,
    EGTS_PC_EVENT_NFOUND=147,
    EGTS_PC_SRVC_NFOUND=148,
    EGTS_PC_SRVC_DENIED=149,
    EGTS_PC_SRVC_UNKN=150,
    EGTS_PC_AUTH_DENIED=151,
    EGTS_PC_ALREADY_EXISTS=152,
    EGTS_PC_ID_NFOUND=153,
    EGTS_PC_INC_DATETIME=154,
    EGTS_PC_IO_ERROR=155,
    EGTS_PC_NO_RES_AVAIL=156,
    EGTS_PC_MODULE_FAULT=157,
    EGTS_PC_MODULE_PWR_FLT=158,
    EGTS_PC_MODULE_PROC_FLT = 159,
    EGTS_PC_MODULE_SW_FLT=160,
    EGTS_PC_MODULE_FW_FLT=161,
    EGTS_PC_MODULE_IO_FLT=162,
    EGTS_PC_MODULE_MEM_FLT=163,
    EGTS_PC_TEST_FAILED=164,
}ecall_result_code;

std::string decodeData(const std::string &str, std::uint32_t offset, const std::string &tag, std::uint32_t &index);
int64_t decodeValue(const std::string &str, std::uint32_t &index,std::uint32_t offset, const std::string &tag);
std::string encodeValue(int64_t value, uint8_t charset, const std::string tag);

#endif /* GOSTECALLUTILS_H_ */
