#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <dirent.h>
#include <sys/stat.h>
#include<sys/types.h>
#include <errno.h>

#include "liblog/lynq_deflog.h"
#include "include/iot_rock.h"

#define USER_LOG_TAG "LOGROTATE_SERVICE"
#define MCU_LOG_ADDR "/var/log/mculog.log"

int lynq_write_mculog_file(char *mculog_data, int mculog_data_len)//lt add @2021.7.28 for write mcu log to /var/log/cmulog.log
{
    int fd, err;
    int write_len = 0;
    fd = open(MCU_LOG_ADDR,O_WRONLY |O_CREAT |O_APPEND,S_IRWXU);
    if(fd < 0)
    {
        return fd;
    }
	
    do {
        write_len = write(fd,mculog_data,mculog_data_len);
        if (write_len == 0) 
        {
            break;
        } 
        else if (write_len < 0) 
        {
            if (errno == EINTR) 
            {
                continue;
            }
            err = -errno;
            close(fd);
            return err;
        }
        mculog_data_len -= write_len;
        mculog_data += write_len;
    } while(mculog_data_len > 0);

    close(fd);
    return write_len;   
}

int main()
{
    char muclog[1024] = {0};
    LYLOGEINIT(USER_LOG_TAG);
    LYLOGSET(4);
    lynq_fota_func();
    while(1)
    {
        //receive mcu log
        //memset(muclog,1,1024);
        //lynq_write_mculog_file(muclog,1024);//lt add @2021.7.28 for test mculog

        system("logrotate /etc/logrotate.d/syslog");
        //system("logrotate /etc/logrotate.d/mculog");//lt add @2021.7.28 for start mculog logrotate
        //system("logrotate /etc/logrotate.d/mtklog");//lt add @2021.7.28 for start mculog mtklog
        sleep(1);
    }
}

