// SPDX-License-Identifier: MediaTekProprietary
/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2016. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#include <vendor-ril/telephony/ril.h>
#include <stdlib.h>
#include <stdio.h>
#include <cutils/jstring.h>
#include <log/log.h>
#include <unistd.h>
#include <math.h>
#include "em/em_el1_public_struct.h"
#include  "common.h"
#include "em/em.h"
#include "Radio_capability_switch_util.h"
#include "../util/utils.h"

#if EM_MODE_SUPPORT

#undef LOG_TAG
#define LOG_TAG "EM_EL1"

#define MAX_RAN_CELL_SIZE 32

static int mItemCount = 0;
static int mFlag = 0;// at cmd flag
static int mCurrentFlag = 0; // at cmd handle flag

static const int MSG_NW_INFO = 1;
static const int MSG_NW_INFO_OPEN = 4;
static const int MSG_NW_INFO_CLOSE = 5;
static const int MSG_NW_CA_INFO_LTE_NR = 6;


static const int IDX_EL1 = -1;
static const int IDX_CA_INFO_LTE_NR = 0;
int intput_idx = 0;

static const std::string CMD_SAME_EDMFAPP = "+EDMFAPP: 6,3,";

struct cell_band_bandwidth_struct {
    /** @brief Cell Identity. */
    int cid;
    int c_state;        /*1: SCELL_STATUS_NOTACTIVE 2: SCELL_STATUS_ACTIVE */
    int cell_band;      /* cell band: 1~1024 */
    int cell_bandwidth; /* cell bandwidth index */
    int cc_cw0_cqi;     /*0~15*/
    int cc_cw1_cqi;     /*0~15*/
    int cc_pci;         /*0~1024*/
    int cc_arfcn;       /*22bit*/
};

struct all_cell_band_bandwidth_struct{
    int num_serving_lte_cell_dl;
    int num_serving_lte_cell_ul;
    int num_serving_nr_cell_dl;
    int num_serving_nr_cell_ul;
    cell_band_bandwidth_struct lte_band_bandwidth_dl[MAX_RAN_CELL_SIZE];
    cell_band_bandwidth_struct lte_band_bandwidth_ul[MAX_RAN_CELL_SIZE];
    cell_band_bandwidth_struct nr_band_bandwidth_dl[MAX_RAN_CELL_SIZE];
    cell_band_bandwidth_struct nr_band_bandwidth_ul[MAX_RAN_CELL_SIZE];
};

static void sendATCommand(const char *cmd,int msg)
{
    mCurrentFlag = msg;
    emSendATCommand(cmd, get_default_sim_all_except_data());
    return ;
}

static char hex2char(unsigned int hex) {
    if (hex >= '0' && hex <= '9') {
        return hex - '0';
    }
    if (hex >= 'A' && hex <= 'F') {
        return 0xA + hex - 'A';
    }
    if (hex >= 'a' && hex <= 'f') {
        return 0xA + hex - 'a';
    }
    return 0;
}

static void hex2char(char *input, int input_len, char *buf, int buf_size) {
    RLOGD("hex2char, input_len: %d, buf_size: %d", input_len, buf_size);
    memset(buf, 0, buf_size);
    //respose data lack of 8 byte, corresponding to header
    //ref_count(1)+lp_reserved(1)+ msg_len(2) + em_info(4)
    if (input_len < (buf_size-8) * 2) { // should not happen
        buf_size = input_len / 2;
    }
    for (int i = 0; i < buf_size; i++) {
        buf[i+8] = (hex2char(input[i * 2]) << 4) + hex2char(input[i * 2 + 1]);
    }

}

static void parseCAInfo(char* data) {
    RLOGD("parseCAInfo, rsp=%s", data);
    std::vector<std::string> out;
    utils::tokenize(string(data), "\n", out);
    int cell_idx = 0, at_idx = 0;
    std::string str;
    str.clear();
    char tmp[1024] = {0};

    for(auto i: out) {
        if(i.find(CMD_SAME_EDMFAPP) != std::string::npos) {
            std::string splitString = i.substr(std::string(CMD_SAME_EDMFAPP).size());
            std::vector<std::string> getDigitalVal;
            utils::tokenize(string(splitString), ",\n", getDigitalVal);
            RLOGD("parseCurrentMode splitString: %s, getDigitalVal.size()=%d",
                    splitString.c_str(), getDigitalVal.size());

            try {
                all_cell_band_bandwidth_struct cells_info;
                memset(&cells_info, 0, sizeof(all_cell_band_bandwidth_struct));
                str.append("[Cell Info]\n");

                // LTE DL
                cells_info.num_serving_lte_cell_dl = std::stoi(getDigitalVal[at_idx]);
                RLOGW("cells_info.num_serving_lte_cell_dl=%d", cells_info.num_serving_lte_cell_dl);
                sprintf(tmp, "num_serving_lte_cell_dl:%d\n", cells_info.num_serving_lte_cell_dl);
                str.append(tmp);
                memset(tmp, 0, sizeof(char)*1024);
                at_idx++;

                if (cells_info.num_serving_lte_cell_dl != 0) {
                    for (cell_idx = 0; cell_idx < cells_info.num_serving_lte_cell_dl; cell_idx++) {

                        if (cell_idx >= MAX_RAN_CELL_SIZE) {
                            RLOGW("cell_idx=%d > MAX_RAN_CELL_SIZE=%d, ignore", cell_idx, MAX_RAN_CELL_SIZE);
                            continue;
                        }

                        cells_info.lte_band_bandwidth_dl[cell_idx].cid = std::stoi(getDigitalVal[at_idx]);
                        RLOGD("cells_info.lte_dl[%d].cid=%d", cell_idx, cells_info.lte_band_bandwidth_dl[cell_idx].cid);
                        at_idx++;

                        cells_info.lte_band_bandwidth_dl[cell_idx].c_state = std::stoi(getDigitalVal[at_idx]);
                        RLOGD("cells_info.lte_dl[%d].c_state=%d", cell_idx, cells_info.lte_band_bandwidth_dl[cell_idx].c_state);
                        at_idx++;

                        cells_info.lte_band_bandwidth_dl[cell_idx].cell_band = std::stoi(getDigitalVal[at_idx]);
                        RLOGD("cells_info.lte_dl[%d].cell_band=%d", cell_idx, cells_info.lte_band_bandwidth_dl[cell_idx].cell_band);
                        at_idx++;

                        cells_info.lte_band_bandwidth_dl[cell_idx].cell_bandwidth = std::stoi(getDigitalVal[at_idx]);
                        RLOGD("cells_info.lte_dl[%d].cell_bandwidth=%d", cell_idx, cells_info.lte_band_bandwidth_dl[cell_idx].cell_bandwidth);
                        at_idx++;

                        cells_info.lte_band_bandwidth_dl[cell_idx].cc_cw0_cqi = std::stoi(getDigitalVal[at_idx]);
                        RLOGD("cells_info.lte_dl[%d].cc_cw0_cqi=%d", cell_idx, cells_info.lte_band_bandwidth_dl[cell_idx].cc_cw0_cqi);
                        at_idx++;

                        cells_info.lte_band_bandwidth_dl[cell_idx].cc_cw1_cqi = std::stoi(getDigitalVal[at_idx]);
                        RLOGD("cells_info.lte_dl[%d].cc_cw1_cqi=%d", cell_idx, cells_info.lte_band_bandwidth_dl[cell_idx].cc_cw1_cqi);
                        at_idx++;

                        cells_info.lte_band_bandwidth_dl[cell_idx].cc_pci = std::stoi(getDigitalVal[at_idx]);
                        RLOGD("cells_info.lte_dl[%d].cc_pci=%d", cell_idx, cells_info.lte_band_bandwidth_dl[cell_idx].cc_pci);
                        at_idx++;

                        cells_info.lte_band_bandwidth_dl[cell_idx].cc_arfcn = std::stoi(getDigitalVal[at_idx]);
                        RLOGD("cells_info.lte_dl[%d].cc_arfcn=%d", cell_idx, cells_info.lte_band_bandwidth_dl[cell_idx].cc_arfcn);
                        at_idx++;

                        sprintf(tmp,
                                "lte_dl[%d]:\n"
                                " - cid: %d\n"
                                " - c_state: %d\n"
                                " - cell_band: %d\n"
                                " - cell_bandwidth: %d\n"
                                " - cc_cw0_cqi: %d\n"
                                " - cc_cw1_cqi: %d\n"
                                " - cc_pci: %d\n"
                                " - cc_arfcn: %d\n",
                                cell_idx,
                                cells_info.lte_band_bandwidth_dl[cell_idx].cid,
                                cells_info.lte_band_bandwidth_dl[cell_idx].c_state,
                                cells_info.lte_band_bandwidth_dl[cell_idx].cell_band,
                                cells_info.lte_band_bandwidth_dl[cell_idx].cell_bandwidth,
                                cells_info.lte_band_bandwidth_dl[cell_idx].cc_cw0_cqi,
                                cells_info.lte_band_bandwidth_dl[cell_idx].cc_cw1_cqi,
                                cells_info.lte_band_bandwidth_dl[cell_idx].cc_pci,
                                cells_info.lte_band_bandwidth_dl[cell_idx].cc_arfcn);
                        str.append(tmp);
                        RLOGD("result1 str=%s", str.c_str());
                        memset(tmp, 0, sizeof(char)*1024);
                    }
                }

                // LTE UL
                cells_info.num_serving_lte_cell_ul = std::stoi(getDigitalVal[at_idx]);
                RLOGW("cells_info.num_serving_lte_cell_ul=%d", cells_info.num_serving_lte_cell_ul);
                sprintf(tmp, "num_serving_lte_cell_ul:%d\n", cells_info.num_serving_lte_cell_ul);
                str.append(tmp);
                memset(tmp, 0, 1024);
                at_idx++;

                if (cells_info.num_serving_lte_cell_ul != 0) {
                    for (cell_idx = 0; cell_idx < cells_info.num_serving_lte_cell_ul; cell_idx++) {

                        if (cell_idx >= MAX_RAN_CELL_SIZE) {
                            RLOGW("cell_idx=%d >= MAX_RAN_CELL_SIZE=%d, ignore", cell_idx, MAX_RAN_CELL_SIZE);
                            continue;
                        }

                        cells_info.lte_band_bandwidth_ul[cell_idx].cid = std::stoi(getDigitalVal[at_idx]);
                        RLOGD("cells_info.lte_ul[%d].cid=%d", cell_idx, cells_info.lte_band_bandwidth_ul[cell_idx].cid);
                        at_idx++;

                        cells_info.lte_band_bandwidth_ul[cell_idx].c_state = std::stoi(getDigitalVal[at_idx]);
                        RLOGD("cells_info.lte_ul[%d].c_state=%d", cell_idx, cells_info.lte_band_bandwidth_ul[cell_idx].c_state);
                        at_idx++;

                        cells_info.lte_band_bandwidth_ul[cell_idx].cell_band = std::stoi(getDigitalVal[at_idx]);
                        RLOGD("cells_info.lte_ul[%d].cell_band=%d", cell_idx, cells_info.lte_band_bandwidth_ul[cell_idx].cell_band);
                        at_idx++;

                        cells_info.lte_band_bandwidth_ul[cell_idx].cell_bandwidth = std::stoi(getDigitalVal[at_idx]);
                        RLOGD("cells_info.lte_ul[%d].cell_bandwidth=%d", cell_idx, cells_info.lte_band_bandwidth_ul[cell_idx].cell_bandwidth);
                        at_idx++;

                        cells_info.lte_band_bandwidth_ul[cell_idx].cc_pci = std::stoi(getDigitalVal[at_idx]);
                        RLOGD("cells_info.lte_ul[%d].cc_pci=%d", cell_idx, cells_info.lte_band_bandwidth_ul[cell_idx].cc_pci);
                        at_idx++;

                        cells_info.lte_band_bandwidth_ul[cell_idx].cc_arfcn = std::stoi(getDigitalVal[at_idx]);
                        RLOGD("cells_info.lte_ul[%d].cc_arfcn=%d", cell_idx, cells_info.lte_band_bandwidth_ul[cell_idx].cc_arfcn);
                        at_idx++;

                        sprintf(tmp,
                                "lte_ul[%d]:\n"
                                " - cid: %d\n"
                                " - c_state: %d\n"
                                " - cell_band: %d\n"
                                " - cell_bandwidth: %d\n"
                                " - cc_pci: %d\n"
                                " - cc_arfcn: %d\n",
                                cell_idx,
                                cells_info.lte_band_bandwidth_ul[cell_idx].cid,
                                cells_info.lte_band_bandwidth_ul[cell_idx].c_state,
                                cells_info.lte_band_bandwidth_ul[cell_idx].cell_band,
                                cells_info.lte_band_bandwidth_ul[cell_idx].cell_bandwidth,
                                cells_info.lte_band_bandwidth_ul[cell_idx].cc_pci,
                                cells_info.lte_band_bandwidth_ul[cell_idx].cc_arfcn);
                        str.append(tmp);
                        RLOGD("result2 str=%s", str.c_str());
                        memset(tmp, 0, sizeof(char)*1024);
                    }
                }

                // NR DL
                cells_info.num_serving_nr_cell_dl = std::stoi(getDigitalVal[at_idx]);
                RLOGW("cells_info.num_serving_nr_cell_dl=%d", cells_info.num_serving_nr_cell_dl);
                sprintf(tmp, "num_serving_nr_cell_dl:%d\n", cells_info.num_serving_nr_cell_dl);
                str.append(tmp);
                memset(tmp, 0, 1024);
                at_idx++;

                if (cells_info.num_serving_nr_cell_dl != 0) {
                    for (cell_idx = 0; cell_idx < cells_info.num_serving_nr_cell_dl; cell_idx++) {

                        if (cell_idx >= MAX_RAN_CELL_SIZE) {
                            RLOGW("cell_idx=%d > MAX_RAN_CELL_SIZE=%d, ignore", cell_idx, MAX_RAN_CELL_SIZE);
                            continue;
                        }

                        cells_info.nr_band_bandwidth_dl[cell_idx].cid = std::stoi(getDigitalVal[at_idx]);
                        RLOGD("cells_info.nr_dl[%d].cid=%d", cell_idx, cells_info.nr_band_bandwidth_dl[cell_idx].cid);
                        at_idx++;

                        cells_info.nr_band_bandwidth_dl[cell_idx].c_state = std::stoi(getDigitalVal[at_idx]);
                        RLOGD("cells_info.nr_dl[%d].c_state=%d", cell_idx, cells_info.nr_band_bandwidth_dl[cell_idx].c_state);
                        at_idx++;

                        cells_info.nr_band_bandwidth_dl[cell_idx].cell_band = std::stoi(getDigitalVal[at_idx]);
                        RLOGD("cells_info.nr_dl[%d].cell_band=%d", cell_idx, cells_info.nr_band_bandwidth_dl[cell_idx].cell_band);
                        at_idx++;

                        cells_info.nr_band_bandwidth_dl[cell_idx].cell_bandwidth = std::stoi(getDigitalVal[at_idx]);
                        RLOGD("cells_info.nr_dl[%d].cell_bandwidth=%d", cell_idx, cells_info.nr_band_bandwidth_dl[cell_idx].cell_bandwidth);
                        at_idx++;

                        cells_info.nr_band_bandwidth_dl[cell_idx].cc_cw0_cqi = std::stoi(getDigitalVal[at_idx]);
                        RLOGD("cells_info.nr_dl[%d].cc_cw0_cqi=%d", cell_idx, cells_info.nr_band_bandwidth_dl[cell_idx].cc_cw0_cqi);
                        at_idx++;

                        cells_info.nr_band_bandwidth_dl[cell_idx].cc_cw1_cqi = std::stoi(getDigitalVal[at_idx]);
                        RLOGD("cells_info.nr_dl[%d].cc_cw1_cqi=%d", cell_idx, cells_info.nr_band_bandwidth_dl[cell_idx].cc_cw1_cqi);
                        at_idx++;

                        cells_info.nr_band_bandwidth_dl[cell_idx].cc_pci = std::stoi(getDigitalVal[at_idx]);
                        RLOGD("cells_info.nr_dl[%d].cc_pci=%d", cell_idx, cells_info.nr_band_bandwidth_dl[cell_idx].cc_pci);
                        at_idx++;

                        cells_info.nr_band_bandwidth_dl[cell_idx].cc_arfcn = std::stoi(getDigitalVal[at_idx]);
                        RLOGD("cells_info.nr_dl[%d].cc_arfcn=%d", cell_idx, cells_info.nr_band_bandwidth_dl[cell_idx].cc_arfcn);
                        at_idx++;

                        sprintf(tmp,
                                "nr_dl[%d]:\n"
                                " - cid: %d\n"
                                " - c_state: %d\n"
                                " - cell_band: %d\n"
                                " - cell_bandwidth: %d\n"
                                " - cc_cw0_cqi: %d\n"
                                " - cc_cw1_cqi: %d\n"
                                " - cc_pci: %d\n"
                                " - cc_arfcn: %d\n",
                                cell_idx,
                                cells_info.nr_band_bandwidth_dl[cell_idx].cid,
                                cells_info.nr_band_bandwidth_dl[cell_idx].c_state,
                                cells_info.nr_band_bandwidth_dl[cell_idx].cell_band,
                                cells_info.nr_band_bandwidth_dl[cell_idx].cell_bandwidth,
                                cells_info.nr_band_bandwidth_dl[cell_idx].cc_cw0_cqi,
                                cells_info.nr_band_bandwidth_dl[cell_idx].cc_cw1_cqi,
                                cells_info.nr_band_bandwidth_dl[cell_idx].cc_pci,
                                cells_info.nr_band_bandwidth_dl[cell_idx].cc_arfcn);
                        str.append(tmp);
                        RLOGD("result3 str=%s", str.c_str());
                        memset(tmp, 0, 1024);
                    }
                }

                // NR UL
                cells_info.num_serving_nr_cell_ul = std::stoi(getDigitalVal[at_idx]);
                RLOGW("cells_info.num_serving_nr_cell_ul=%d", cells_info.num_serving_nr_cell_ul);
                sprintf(tmp, "num_serving_nr_cell_ul:%d\n", cells_info.num_serving_nr_cell_ul);
                str.append(tmp);
                memset(tmp, 0, 1024);

                at_idx++;

                if (cells_info.num_serving_nr_cell_ul != 0) {
                    for (cell_idx = 0; cell_idx < cells_info.num_serving_nr_cell_ul; cell_idx++) {

                        if (cell_idx >= MAX_RAN_CELL_SIZE) {
                            RLOGW("cell_idx=%d > MAX_RAN_CELL_SIZE=%d, ignore", cell_idx, MAX_RAN_CELL_SIZE);
                            continue;
                        }

                        cells_info.nr_band_bandwidth_ul[cell_idx].cid = std::stoi(getDigitalVal[at_idx]);
                        RLOGD("cells_info.nr_ul[%d].cid=%d", cell_idx, cells_info.nr_band_bandwidth_ul[cell_idx].cid);
                        at_idx++;

                        cells_info.nr_band_bandwidth_ul[cell_idx].c_state = std::stoi(getDigitalVal[at_idx]);
                        RLOGD("cells_info.nr_ul[%d].c_state=%d", cell_idx, cells_info.nr_band_bandwidth_ul[cell_idx].c_state);
                        at_idx++;

                        cells_info.nr_band_bandwidth_ul[cell_idx].cell_band = std::stoi(getDigitalVal[at_idx]);
                        RLOGD("cells_info.nr_ul[%d].cell_band=%d", cell_idx, cells_info.nr_band_bandwidth_ul[cell_idx].cell_band);
                        at_idx++;

                        cells_info.nr_band_bandwidth_ul[cell_idx].cell_bandwidth = std::stoi(getDigitalVal[at_idx]);
                        RLOGD("cells_info.nr_ul[%d].cell_bandwidth=%d", cell_idx, cells_info.nr_band_bandwidth_ul[cell_idx].cell_bandwidth);
                        at_idx++;

                        cells_info.nr_band_bandwidth_ul[cell_idx].cc_pci = std::stoi(getDigitalVal[at_idx]);
                        RLOGD("cells_info.nr_ul[%d].cc_pci=%d", cell_idx, cells_info.nr_band_bandwidth_ul[cell_idx].cc_pci);
                        at_idx++;

                        cells_info.nr_band_bandwidth_ul[cell_idx].cc_arfcn = std::stoi(getDigitalVal[at_idx]);
                        RLOGD("cells_info.nr_ul[%d].cc_arfcn=%d", cell_idx, cells_info.nr_band_bandwidth_ul[cell_idx].cc_arfcn);
                        at_idx++;

                        sprintf(tmp,
                                "nr_ul[%d]:\n"
                                " - cid: %d\n"
                                " - c_state: %d\n"
                                " - cell_band: %d\n"
                                " - cell_bandwidth: %d\n"
                                " - cc_pci: %d\n"
                                " - cc_arfcn: %d\n",
                                cell_idx,
                                cells_info.nr_band_bandwidth_ul[cell_idx].cid,
                                cells_info.nr_band_bandwidth_ul[cell_idx].c_state,
                                cells_info.nr_band_bandwidth_ul[cell_idx].cell_band,
                                cells_info.nr_band_bandwidth_ul[cell_idx].cell_bandwidth,
                                cells_info.nr_band_bandwidth_ul[cell_idx].cc_pci,
                                cells_info.nr_band_bandwidth_ul[cell_idx].cc_arfcn);
                        str.append(tmp);
                        RLOGD("result4 str=%s", str.c_str());
                        memset(tmp, 0, 1024);
                    }
                }

                str.append("\ndone\n");
                RLOGD("final result str=%s", str.c_str());
                android::emResultNotify(str.c_str());

            } catch (const out_of_range &e) {
                android::emResultNotify(RET_STRING_LTE_FAIL);
                RLOGD("out of range: %s", e.what());
                return;
            } catch (const invalid_argument &e) {
                android::emResultNotify(RET_STRING_LTE_FAIL);
                RLOGD("invalid argument: %s", e.what());
                return;
            }
        }
    }
}

static void el1_at_cmd_handle(char*response, int responselen) {
    switch (mCurrentFlag) {
        case MSG_NW_INFO:
            if ((responselen > 0) && (response != NULL)) {
                RLOGD("el1_at_cmd_handle response %s\n",response);
                //mFlag = FLAG_OFFSET_BIT;
            }
            else {
                RLOGD("send fail ");
            }
            break;
        case MSG_NW_INFO_OPEN:
        case MSG_NW_INFO_CLOSE:
            break;
        case MSG_NW_CA_INFO_LTE_NR:
            if ((responselen > 0) && (response != NULL)) {
                RLOGD("Get response %s", response);
                parseCAInfo(response);
            } else {
                RLOGE("Query CA info fail failed.");
                android::emResultNotify(RET_STRING_LTE_FAIL);
            }
            break;
        default:
            break;
    }
}

static void el1_parse(char *output,char * input){
    em_el1_status_ind_struct buf;
    hex2char(input, strlen(input), (char *)&buf, sizeof(em_el1_status_ind_struct));
    snprintf(output, 8192,
            "[Cell Info]\n"
            "  band: %u,%u,%u,%u\n"
            "  DL_BW: %u,%u,%u,%u\n"
            "  UL_BW: %u,%u,%u,%u\n"
            "  TM: %u,%u,%u,%u\n"
            "  PCI: %d,%d,%d,%d\n"
            "  EARFCN: %u,%u,%u,%u\n"
            "[DL]\n"
            "  dl_rssi: (%d,%d),(%d,%d),(%d,%d),(%d,%d)\n"
            "  dl_rsrp: (%d,%d),(%d,%d),(%d,%d),(%d,%d)\n"
            "  dl_rsrq: (%d,%d),(%d,%d),(%d,%d),(%d,%d)\n"
            "  dl_sinr: (%d,%d),(%d,%d),(%d,%d),(%d,%d)\n"
            "  rsrp: %d,%d,%d,%d\n"
            "  rsrq: %d,%d,%d,%d\n"
            "  sinr: %d,%d,%d,%d\n"
            "  rsSNR: %d,%d,%d,%d\n"
            "  tm: %d,%d,%d,%d\n"
            "  rsrp_l1_rxpath_sum_dBm: %d,%d,%d,%d\n"
            "  rsrq_l1_rxpath_sum_dB: %d,%d,%d,%d\n"
            "  snr_l1_rxpath_sum_dB: %d,%d,%d,%d\n",
        buf.cell_info[0].band, buf.cell_info[1].band,buf.cell_info[2].band,buf.cell_info[3].band,
        buf.cell_info[0].dl_bw, buf.cell_info[1].dl_bw,buf.cell_info[2].dl_bw,buf.cell_info[3].dl_bw,
        buf.cell_info[0].ul_bw, buf.cell_info[1].ul_bw,buf.cell_info[2].ul_bw,buf.cell_info[3].ul_bw,
        buf.cell_info[0].tm, buf.cell_info[1].tm,buf.cell_info[2].tm,buf.cell_info[3].tm,
        buf.cell_info[0].pci, buf.cell_info[1].pci,buf.cell_info[2].pci,buf.cell_info[3].pci,
        buf.cell_info[0].earfcn, buf.cell_info[1].earfcn,buf.cell_info[2].earfcn,buf.cell_info[3].earfcn,
        buf.dl_info[0].dl_rssi[0],buf.dl_info[0].dl_rssi[1],buf.dl_info[1].dl_rssi[0],buf.dl_info[1].dl_rssi[1],
        buf.dl_info[2].dl_rssi[0],buf.dl_info[2].dl_rssi[1],buf.dl_info[3].dl_rssi[0],buf.dl_info[3].dl_rssi[1],
        buf.dl_info[0].dl_rsrp[0],buf.dl_info[0].dl_rsrp[1],buf.dl_info[1].dl_rsrp[0],buf.dl_info[1].dl_rsrp[1],
        buf.dl_info[2].dl_rsrp[0],buf.dl_info[2].dl_rsrp[1],buf.dl_info[3].dl_rsrp[0],buf.dl_info[3].dl_rsrp[1],
        buf.dl_info[0].dl_rsrq[0],buf.dl_info[0].dl_rsrq[1],buf.dl_info[1].dl_rsrq[0],buf.dl_info[1].dl_rsrq[1],
        buf.dl_info[2].dl_rsrq[0],buf.dl_info[2].dl_rsrq[1],buf.dl_info[3].dl_rsrq[0],buf.dl_info[3].dl_rsrq[1],
        buf.dl_info[0].dl_sinr[0],buf.dl_info[0].dl_sinr[1],buf.dl_info[1].dl_sinr[0],buf.dl_info[1].dl_sinr[1],
        buf.dl_info[2].dl_sinr[0],buf.dl_info[2].dl_sinr[1],buf.dl_info[3].dl_sinr[0],buf.dl_info[3].dl_sinr[1],
        buf.dl_info[0].rsrp, buf.dl_info[1].rsrp, buf.dl_info[2].rsrp, buf.dl_info[3].rsrp,
        buf.dl_info[0].rsrq, buf.dl_info[1].rsrq, buf.dl_info[2].rsrq, buf.dl_info[3].rsrq,
        buf.dl_info[0].sinr, buf.dl_info[1].sinr, buf.dl_info[2].sinr, buf.dl_info[3].sinr,
        buf.dl_info[0].rsSNR, buf.dl_info[1].rsSNR, buf.dl_info[2].rsSNR, buf.dl_info[3].rsSNR,
        buf.dl_info[0].tm, buf.dl_info[1].tm, buf.dl_info[2].tm, buf.dl_info[3].tm,
        buf.dl_info[0].rsrp_l1_rxpath_sum_dBm, buf.dl_info[1].rsrp_l1_rxpath_sum_dBm, buf.dl_info[2].rsrp_l1_rxpath_sum_dBm, buf.dl_info[3].rsrp_l1_rxpath_sum_dBm,
        buf.dl_info[0].rsrq_l1_rxpath_sum_dB, buf.dl_info[1].rsrq_l1_rxpath_sum_dB, buf.dl_info[2].rsrq_l1_rxpath_sum_dB, buf.dl_info[3].rsrq_l1_rxpath_sum_dB,
        buf.dl_info[0].snr_l1_rxpath_sum_dB, buf.dl_info[1].snr_l1_rxpath_sum_dB, buf.dl_info[2].snr_l1_rxpath_sum_dB, buf.dl_info[3].snr_l1_rxpath_sum_dB
        );
}

static void  el1_urc_handle(int type, char *data){
    RLOGD("el1_urc_handle type %d data %s\n",type,data);
    if(type == EM_EL1_INFO) {
        char outbuf[8192] = {0};
        el1_parse(outbuf,data);
        android::emResultNotify(outbuf);
        android::emResultNotify(RET_STRING_LTE_SUCCESS);
        android::unregisterNetwork();
        char atcommand[32] = {0};
        sprintf(atcommand,"AT+EINFO=%d,%d,1",mFlag,EM_EL1_INFO);
        sendATCommand(atcommand, MSG_NW_INFO_CLOSE);
    }
}

//create thread to send command
void * emEl1Thread(void* arg)
{
    // EL1
    if (lte_info[intput_idx].name == "EL1") {
        RLOGD("emEl1Thread, MSG_NW_INFO");

        //sendATCommand("AT+EINFO?",MSG_NW_INFO);
        mFlag = 8;
        char atcommand[32] = {0};
        sprintf(atcommand,"AT+EINFO=%d,%d,0",mFlag,EM_EL1_INFO);
        sendATCommand(atcommand, MSG_NW_INFO_OPEN);

    // Send AT+ECAINFO
    } else if (lte_info[intput_idx].name == "NR L1 Info") {
        RLOGD("emEl1Thread, query the latest CA information of LTE/NR");

        char atcommand[32] = {0};
        sprintf(atcommand,"AT+EDMFAPP=6,3");
        sendATCommand(atcommand, MSG_NW_CA_INFO_LTE_NR);
    }

    pthread_exit(0);
}

int em_el1_start(int argc, int multicnt,int *item)
{
    RLOGD("em_el1_start called, item[0]=%d", item[0]);

    intput_idx = item[0];
    if(argc < 1)
    {
        RLOGD("em_el1_start: please select page to show info");
        android::emResultNotify(RET_STRING_LTE_FAIL);
        return -1;
    }

    if (lte_info[intput_idx].name == "EL1") {
        mItemCount = multicnt + 1;
        RLOGD("mItemCount: %d, item[%d]: %d", mItemCount, multicnt, item[multicnt]);
        android::registerForNetworkInfo(el1_urc_handle);
    }

    android::registerForATcmdResponse(el1_at_cmd_handle);
    pthread_t emEl1_thread;
    pthread_create(&emEl1_thread,NULL, emEl1Thread, NULL);
    return (0);
}
#endif

