#include <stdio.h>
#include "common.h"
#include "utils.h"
#include "Phone_utils.h"
#include <time.h>
#include "sim.h"
#include <string.h>
#include<pthread.h>
#include <cutils/properties.h>
#ifdef __cplusplus
extern "C" {
#endif
#include <pthread.h>
#define SIM_COUNT 2
#define RIL_REQUEST_GET_SIM_STATUS 1
int already_gps = 0;
int enable_nema = 0;
int sustain = 1;
pthread_t lynq_gps_tid;
// static pthread_mutex_t s_gps_state_change_mutex = PTHREAD_MUTEX_INITIALIZER;
// static pthread_cond_t s_gps_change_cond = PTHREAD_COND_INITIALIZER;
typedef enum {
    sim1,
#if (SIM_COUNT >= 2)
    sim2,
#if (SIM_COUNT >= 3)
    RIL_SOCKET_3,
#endif
#if (SIM_COUNT >= 4)
    RIL_SOCKET_4,
#endif
#endif
    //RIL_SOCKET_NUM
} RIL_SIM_COUNT;

#include "lynq_factory.h"

static const char *usb3_speed = "super-speed";
static const char *usb2_speed = "high-speed";
pthread_mutex_t lynq_audio_mutex = PTHREAD_MUTEX_INITIALIZER;


static void lynq_factory_response_ttyGS3(char *buf){
    write(ttyGS3_fd,buf,strlen(buf));
    return;
}

static void lynq_get_sim_state(RIL_SIM_COUNT id){
    char *argv[MAX_ARGS];
    if(utils::is_support_dsds()) {
        id = (RIL_SIM_COUNT)get_default_sim_all_except_data();
    } else if(utils::is_suppport_dsss()) {
        id = (RIL_SIM_COUNT)Phone_utils::get_enable_sim_for_dsss();
    }
    RequestInfo *pRI  = creatRILInfoAndInit(RIL_REQUEST_GET_SIM_STATUS, UDP, (RIL_SOCKET_ID)(id));
    getIccCardStatus(RIL_REQUEST_GET_SIM_STATUS,argv,(RIL_SOCKET_ID)id,pRI);
}
void *thread_test(void *arg){
    char *num = (char *)arg;
    int number = atoi(num);
    lynq_factory_response_ttyGS3("+GPS OPEN:OK\n");
    char gnss_buf[128] = {0};
    sprintf(gnss_buf, "%s%d%s", "echo \"GNSS_MODE=", number, "\">>/etc/gnss/mnl.prop");
    system(gnss_buf);
    #if 1
    FILE *fp;
    char test[100] = {0};
    sprintf(test, "lynq-gnss-test cold %s", "2>&1");
    char lynq_factory_buf[1024] = {0};
    fp=popen(test, "r");
    if(NULL == fp){
        lynq_factory_response_ttyGS3("popen errorn\n");
        return 0;
    }
    while (sustain)
    {   
        if(fgets(lynq_factory_buf,sizeof(lynq_factory_buf),fp)){
            if(enable_nema == 1){
                lynq_factory_response_ttyGS3(lynq_factory_buf);
            }
        }
    }
    pclose(fp);
    #endif
    #if 0
    system("echo \"debug.dbg2file=1\">/etc/gnss/mnl.prop");
    system("mnld_test start &");
    #endif
    return 0;
}

/**
 * @brief parse ipv4 eg:192.168.131.222 ->192.168.131.1
 * @param  buf              My Param doc
 */
static void parse_ipv4(char *buf)
{
    char *p = buf;
    int cnt = 0;
    while(*p != '\0')
    {
        if(*p == '.')
        {
            cnt++;
            if(cnt == 3)
            {
                *p++;
                *p = '1';
                *p++;
                *p = '\0';
            }
        }
        *p++;
    }

}

void *thread_test_RGMII(void *arg){
    FILE *fp;
    char ipv4[128] = {0};
    fp= popen("ifconfig 'eth2' | grep \"inet addr\" | cut -f 2 -d \":\" | cut -f 1 -d \" \" 2>&1", "r");
    if(NULL == fp){
        lynq_factory_response_ttyGS3("popen errorn\n");
        return 0;
    }
    fgets(ipv4,sizeof(ipv4),fp);
    if(strstr(ipv4, "error"))
    {
        lynq_factory_response_ttyGS3("RGMII don't insert\n");
        return 0;
    }
    else
    {
        parse_ipv4(ipv4);
        char cmd[128] = {0};
        sprintf(cmd, "%s %s %s %s", "ping -I eth2", ipv4, "-c4", "2>&1");
        fp=popen(cmd, "r");
        if(NULL == fp){
            lynq_factory_response_ttyGS3("popen errorn\n");
            return 0;
        }
        char lynq_factory_buf[1024] = {0};
        while (NULL != fgets(lynq_factory_buf,sizeof(lynq_factory_buf),fp))
        {   
            lynq_factory_response_ttyGS3(lynq_factory_buf);
        }
        pclose(fp);
        return 0;
    }
}

static void lynq_test_RGMII(void){
    pthread_t thid;
    if(pthread_create(&thid, NULL, thread_test_RGMII, NULL) != 0) {
        return;
    }
    pthread_join(thid, NULL);
    return;
}

/**
 * @brief factory test for sgmii
 * 
 */
void *thread_test_SGMII(void *arg){
    FILE *fp;
    char ipv4[128] = {0};
    fp= popen("ifconfig 'eth1' | grep \"inet addr\" | cut -f 2 -d \":\" | cut -f 1 -d \" \" 2>&1", "r");
    if(NULL == fp){
        lynq_factory_response_ttyGS3("popen errorn\n");
        return 0;
    }
    fgets(ipv4,sizeof(ipv4),fp);
    if(strstr(ipv4, "error"))
    {
        lynq_factory_response_ttyGS3("SGMII don't insert\n");
        return 0;
    }
    else
    {
        parse_ipv4(ipv4);
        char cmd[128] = {0};
        sprintf(cmd, "%s %s %s %s", "ping -I eth1", ipv4, "-c4", "2>&1");
        fp=popen(cmd, "r");
        if(NULL == fp){
            lynq_factory_response_ttyGS3("popen errorn\n");
            return 0;
        }
        char lynq_factory_buf[1024] = {0};
        while (NULL != fgets(lynq_factory_buf,sizeof(lynq_factory_buf),fp))
        {
            lynq_factory_response_ttyGS3(lynq_factory_buf);
        }
        pclose(fp);
        return 0;
    }
}

/**
 * @brief factory test for sgmii
 * 
 */
static void lynq_test_SGMII(void){
    pthread_t thid;
    if(pthread_create(&thid, NULL, thread_test_SGMII, NULL) != 0) {
        return;
    }
    pthread_join(thid, NULL);
    return;
}


static void lynq_gps_open(char *num){
    if(already_gps == 1){
        lynq_factory_response_ttyGS3("gps already open\n");
        return;
    }
    if(num == NULL)
    {
        return;
    }
    pthread_attr_t attr;
    pthread_attr_init(&attr);
    pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);
    int ret = pthread_create(&lynq_gps_tid, NULL, thread_test, num);
    if(ret < 0)
    {
        lynq_factory_response_ttyGS3("gps thread create failure!!!\n");
        return;
    }
    already_gps = 1;
    return;
}

static void lynq_gps_close(void){
    #if 1
    enable_nema = 1;
    // sustain = 1;
    // int res = -1;
    // res = pthread_cancel(lynq_gps_tid);
    // if(res){
    //     lynq_factory_response_ttyGS3("pthread cancel fail\n");
    //     return;
    // }
    // pthread_join(lynq_gps_tid,NULL);
    // int ret = system("killall mnld_test");
    already_gps = 0;
    lynq_factory_response_ttyGS3("+GPS ENABLE:OK\n");
    // if(!ret){
    //     lynq_factory_response_ttyGS3("GPS CLOSE SUCCESS\n");
    // }
    // else{
    //     lynq_factory_response_ttyGS3("GPS CLOSE Failed\n");
    // }
    #endif
    #if 0
    system("killall mnld_test");
    FILE *fp;
    char test[100] = {0};
    sleep(1);
    sprintf(test, "cat /etc/gnss/*.nma %s", "2>&1");
    char lynq_factory_buf[1024] = {0};
    fp=popen(test, "r");
    if(NULL == fp){
        lynq_factory_response_ttyGS3("popen errorn\n");
        return;
    }
    while(NULL != fgets(lynq_factory_buf,sizeof(lynq_factory_buf),fp)){
        lynq_factory_response_ttyGS3(lynq_factory_buf);
    }
    pclose(fp);
    #endif
    return;
}

static void lynq_wifi_open(void){
    FILE *fp;
    char test[100] = {0};
    sprintf(test, "connmanctl enable wifi %s", "2>&1");
    char lynq_factory_buf[1024] = {0};
    fp=popen(test, "r");
    if(NULL == fp){
        lynq_factory_response_ttyGS3("popen errorn\n");
        return;
    }
    while(NULL != fgets(lynq_factory_buf,sizeof(lynq_factory_buf),fp)){
        if(strlen(lynq_factory_buf) > 0)
        {
            lynq_factory_response_ttyGS3(lynq_factory_buf);
        }else{
            lynq_factory_response_ttyGS3("+CME: ERROR TIMEOUT\n");
        }
    }
    pclose(fp);
}

static void lynq_wifi_close(void){
    FILE *fp;
    char test[100] = {0};
    sprintf(test, "connmanctl disable wifi %s", "2>&1");
    char lynq_factory_buf[1024] = {0};
    fp=popen(test, "r");
    if(NULL == fp){
        lynq_factory_response_ttyGS3("popen errorn\n");
        return;
    }
    while(NULL != fgets(lynq_factory_buf,sizeof(lynq_factory_buf),fp)){
        if(strlen(lynq_factory_buf) > 0)
        {
            lynq_factory_response_ttyGS3(lynq_factory_buf);
        }else{
            lynq_factory_response_ttyGS3("+CME: ERROR TIMEOUT\n");
        }
    }
    pclose(fp);
}


int lynq_dispose_factory_adc(int num,char *argv[MAX_ARGS])
{
    FILE *fp;
    char lynq_adc_dev[126] = {0};
    char lynq_adc_buf[64] = {0};
    int lynq_adc_num = atoi(argv[4]);
    if(lynq_adc_num == 0)
    {
        sprintf(lynq_adc_dev,"cat /sys/bus/iio/devices/iio:device1/in_voltage0_input  2>&1");
    }
    else if(lynq_adc_num == 1)
    {
        sprintf(lynq_adc_dev,"cat /sys/bus/iio/devices/iio:device1/in_voltage1_input  2>&1");
    }
    else if(lynq_adc_num == 2)
    {
        sprintf(lynq_adc_dev,"cat /sys/bus/iio/devices/iio:device1/in_voltage2_input  2>&1");
    }
    else if(lynq_adc_num == 3)
    {
        sprintf(lynq_adc_dev,"cat /sys/bus/iio/devices/iio:device1/in_voltage3_input  2>&1");
    }
    else
    {
        lynq_factory_response_ttyGS3("[adc][errror]:no adc device \n");
        return 0;
    }
    fp=popen(lynq_adc_dev, "r");
    fgets(lynq_adc_buf,sizeof(lynq_adc_buf),fp);
    lynq_factory_response_ttyGS3(lynq_adc_buf);
    pclose(fp);
    return 1;
}

int lynq_dispose_factory_usb(int num,char *argv[MAX_ARGS])
{
        FILE *fp;
        char lynq_usb_dev[512] = {0};
        char lynq_usb_buf[512];

        bzero(lynq_usb_buf, 512);
        bzero(lynq_usb_dev,512);
        sprintf(lynq_usb_dev,"cat /sys/devices/platform/11201000.usb/udc/11201000.usb/current_speed  2>&1");

        fp=popen(lynq_usb_dev, "r");
        fgets(lynq_usb_buf,sizeof(lynq_usb_buf),fp);
        if(!strncmp(lynq_usb_buf,usb3_speed,strlen(usb3_speed)))
        {   
            lynq_factory_response_ttyGS3("[usb][result],3.0 \n");
        }
        else if(!strncmp(lynq_usb_buf,usb2_speed,strlen(usb2_speed)))
        {
            lynq_factory_response_ttyGS3("[usb][result],2.0 \n");
        }
        else
        {
            lynq_factory_response_ttyGS3("[usb][rat][UNKNOWN] \n");
        }
        pclose(fp);
        return 1;
}

void *lynq_deal_witch_audio(void *arg)
{
    char lynq_adudio_time_arr[128] = {0};
    char *lynq_argv  = (char *)arg;
    pthread_mutex_lock(&lynq_audio_mutex);
    system("echo write_reg,0x002c,0x0008 > /sys/kernel/debug/mtksocaudio");
    system("echo write_reg,0x0030,0x0010 > /sys/kernel/debug/mtksocaudio");
    sprintf(lynq_adudio_time_arr,"arecord -D plughw:0,1 --buffer-size=1024 -r 16000 -d %s -f S16_LE -c1 | aplay -D plughw:0,7 --buffer-size=1024 -r 16000 -d %s -f S16_LE -c1",lynq_argv,lynq_argv);
//    system("arecord -D plughw:0,1 --buffer-size=1024 -r 16000 -d 2 -f S16_LE -c1 | aplay -D plughw:0,7 --buffer-size=1024 -r 16000 -d 2 -f S16_LE -c1 ");
    system(lynq_adudio_time_arr);
    free(lynq_argv);
    lynq_argv = NULL;
    pthread_mutex_unlock(&lynq_audio_mutex);
    pthread_exit(0);
}

int lynq_dispose_factory_audio(int num,char *argv[MAX_ARGS])
{
    pthread_t id;
    int i,ret;
    char *lynq_audio_time = (char *)malloc(16);
    bzero(lynq_audio_time, 16);
    if(lynq_audio_time != NULL)
    {
        memcpy(lynq_audio_time,argv[4],strlen(argv[4]));
    } 
    ret=pthread_create(&id,NULL,lynq_deal_witch_audio,(char *)lynq_audio_time); 
    if(ret!=0)
    {
        return ret;
    }
    pthread_join(id,NULL);
    return 0;
}

int lynq_check_emmc()
{
    FILE *fp;
    char emmc_buf[100] = {0};
    char buf[100] = {0};
    sprintf(emmc_buf, "ls /dev | grep mmcblk0  2>&1");
    fp=popen(emmc_buf, "r");
    if(!fp){
        lynq_factory_response_ttyGS3("\n+CME: POPEN ERROR\n");
        return -1;
    }
    while(fgets(buf, sizeof(buf), fp) != NULL){
        lynq_factory_response_ttyGS3("[EMMC] EMMC OK \n"); 
        pclose(fp);
        return 0;   
    }
    lynq_factory_response_ttyGS3("\033[47;31m[EMMC] NO EMMC\033[0m\n");
    pclose(fp);
    return 0;
}

static void lynq_gpsinfo(char *argv){
    if(argv ==NULL)
        return;
    // pthread_mutex_lock(&s_gps_state_change_mutex);
    enable_nema = atoi(argv);
    // pthread_cond_signal(&s_gps_change_cond);
    // pthread_mutex_unlock(&s_gps_state_change_mutex);
    if(enable_nema == 1){
        lynq_factory_response_ttyGS3("enable neam\n"); 
    }
    else if(enable_nema == 0){
        lynq_factory_response_ttyGS3("disable neam\n"); 
    }
    else{
        lynq_factory_response_ttyGS3("invalid value\n"); 
    }
}

int lynq_check_gpio()
{
    #if 0
    FILE *fp;
    int lynq_gpio_arr[88] = {6,230,231,232,233,234,102,104,103,101,186,188,187,185,194,196,195,193,205,204,203,202,199,200,201,190,192,191,189,173,174,175,176,170,169,184,183,182,181,24,25,23,25,157,158,155,156,143,144,140,141,153,154,180,179,29,30,178,177,7,5,4,113,112,116,115,114,107,108,105,106,100,99,98,97,94,93,92,91,1,130,41,67,69,68,63};
    char lynq_show_gpio_state[64] = {0};
    char lynq_set_gpio_arr[256] = {0};
    char lynq_get_gpio_state[512] = {0};
    int lynq_gpio_low = 0;
    int lynq_gpio_hig = 0;
    int i = 0;
    for(i = 0; i < 58; i++)
    {
        lynq_gpio_low = 0;
        lynq_gpio_hig = 0;
        bzero(lynq_set_gpio_arr, 256);
        sprintf(lynq_set_gpio_arr,"echo mode %d 0 >/sys/devices/platform/10005000.pinctrl/mt_gpio & echo dir %d 1 >/sys/devices/platform/10005000.pinctrl/mt_gpio & echo out %d 0 >/sys/devices/platform/10005000.pinctrl/mt_gpio",lynq_gpio_arr[i],lynq_gpio_arr[i],lynq_gpio_arr[i]);
        system(lynq_set_gpio_arr);
        bzero(lynq_set_gpio_arr, 256);
        sprintf(lynq_set_gpio_arr,"cat /sys/devices/platform/10005000.pinctrl/mt_gpio |grep %03d",lynq_gpio_arr[i]);
        fp=popen(lynq_set_gpio_arr, "r");
        bzero(lynq_get_gpio_state, 512);
        fgets(lynq_get_gpio_state,sizeof(lynq_get_gpio_state),fp);
        pclose(fp);
        if(lynq_get_gpio_state[6] == '0')
        {
            lynq_gpio_low = 1;
        }
        bzero(lynq_set_gpio_arr, 256);
        sprintf(lynq_set_gpio_arr,"echo mode %d 0 >/sys/devices/platform/10005000.pinctrl/mt_gpio & echo dir %d 1 >/sys/devices/platform/10005000.pinctrl/mt_gpio & echo out %d 1 >/sys/devices/platform/10005000.pinctrl/mt_gpio",lynq_gpio_arr[i],lynq_gpio_arr[i],lynq_gpio_arr[i]);
        system(lynq_set_gpio_arr);
        bzero(lynq_set_gpio_arr, 256);
        sprintf(lynq_set_gpio_arr,"cat /sys/devices/platform/10005000.pinctrl/mt_gpio |grep %03d:",lynq_gpio_arr[i]);
        fp=popen(lynq_set_gpio_arr, "r");
        bzero(lynq_get_gpio_state, 512);
        fgets(lynq_get_gpio_state,sizeof(lynq_get_gpio_state),fp);
        pclose(fp);
        if(lynq_get_gpio_state[6] == '1')
        {
            lynq_gpio_hig = 1;
        }
        bzero(lynq_show_gpio_state, 64);
        if((lynq_gpio_low == 1) && (lynq_gpio_hig == 1))
        {
            sprintf(lynq_show_gpio_state,"[gpio%d][result]:PASS \n",lynq_gpio_arr[i]);
        }
        else
        {
            sprintf(lynq_show_gpio_state,"[gpio%d][result]:FAIL \n",lynq_gpio_arr[i]);
        }
        printf("%s\n",lynq_show_gpio_state);
    }
    #endif
    FILE *fp;
    char lynq_usb_dev[52] = {0};
    sprintf(lynq_usb_dev,"source /data/gpio/T800_GPIO_TEST.sh  2>&1");
    fp=popen(lynq_usb_dev, "r");
    char lynq_usb_buf[512];
    if(NULL == fp){
        lynq_factory_response_ttyGS3("popen errorn\n");
        return 0;
    }
    while(NULL != fgets(lynq_usb_buf,sizeof(lynq_usb_buf),fp)){
        lynq_factory_response_ttyGS3(lynq_usb_buf);
    }
    pclose(fp);
   return 0;
}

int lynq_test_sink(){
    FILE *fp;
    char lynq_usb_dev[512] = {0};
    char lynq_usb_buf[512] = {0};
    char buf[512] = {0};
    int sink[3][3] = {{255,0,0},{0,255,0},{0,0,255}};
    char dev_buf[][40]={{"green:cellular-radio/brightness"},{"green:cellular-quality/brightness"},{"red:system/brightness"}};
    int i;
    int j;
    int k = 15;
    int cnt = 1;
    for(i = 0;i < 3;i++){
        bzero(lynq_usb_buf, 512);
        bzero(buf, 512);
        k = 15;
        for(j = 0;j < 3;j++){
            bzero(lynq_usb_dev, 512);
            sprintf(lynq_usb_dev,"echo %d >  /sys/class/leds/led95%d:%s  2>&1", sink[i][j], k++, dev_buf[j]);
            fp=popen(lynq_usb_dev, "r");
        }
        usleep(10000);
        sprintf(lynq_usb_buf,"cat /sys/bus/iio/devices/iio:device1/in_voltage4_input  2>&1");
        fp=popen(lynq_usb_buf, "r");
        fgets(buf,sizeof(buf),fp);
        strcat(buf, "\n");
        lynq_factory_response_ttyGS3(buf); 
    }
    pclose(fp);
    return 1;
}

int lynq_check_pcie(void){
    FILE *fp;
    char lynq_usb_dev[128] = {0};
    char lynq_get_gpio_state[512] = {0};
    sprintf(lynq_usb_dev,"cat sys/devices/platform/10005000.pinctrl/mt_gpio |grep 097  2>&1");
    fp=popen(lynq_usb_dev, "r");
    fgets(lynq_get_gpio_state,sizeof(lynq_get_gpio_state),fp);
    pclose(fp);
    if(lynq_get_gpio_state[6] == '1')
    {
        lynq_factory_response_ttyGS3("PCIE SUCCESS\n");
    }
    else{
        lynq_factory_response_ttyGS3("PCIE ERROR\n");
    }
    return 0;
}

int lynq_get_factory_data(int num,char *argv[MAX_ARGS]){
    if(num < 4)
        return -1;
    // if(!strcmp(argv[3], "wifi")){
    //     lynq_wifi_open();
    // }
    // else if(!strcmp(argv[3], "wifi_close")){
    //     lynq_wifi_close();
    // }
    else if(!strcmp(argv[3], "gps_open")){
        lynq_gps_open(argv[4]);
    }
    else if(!strcmp(argv[3], "gps_enable")){
        lynq_gps_close();
    }
    else if(!strcmp(argv[3], "sink")){
        lynq_test_sink();
    }
    #if 0
    else if(!strcmp(argv[3], "gpsinfo")){
        lynq_gpsinfo(argv[4]);
    }
    else if(!strcmp(argv[3], "sim1")){
        lynq_get_sim_state(sim1);
    }
    else if(!strcmp(argv[3], "sim2")){
        lynq_get_sim_state(sim2);
    }
    #endif
    else if(!strcmp(argv[3], "rgmii")){
        lynq_test_RGMII();
    }
    else if(!strcmp(argv[3], "sgmii")){
        lynq_test_SGMII();
    }
    else if((!strcmp(argv[3],"adc")))
    {
        lynq_dispose_factory_adc(num,argv);
    }
    else if((!strcmp(argv[3],"usb")))
    {
         lynq_dispose_factory_usb(num,argv);
    }
    // else if((!strcmp(argv[3],"audio")))
    // {
    //     lynq_dispose_factory_audio(num,argv);
    // }
    else if((!strcmp(argv[3], "emmc")))
    {
        lynq_check_emmc();
    }
    else if((!strcmp(argv[3],"gpio")))
    {
        lynq_check_gpio();
    }
    else if((!strcmp(argv[3],"pcie")))
    {
        lynq_check_pcie();
    }
    else{
        lynq_factory_response_ttyGS3("invalid command\n"); 
    }
    return 0;
}

#ifdef __cplusplus
}
#endif