/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#include <bitset>
#include <memory>

#include "SrComDataFormat.h"
#include "../../utils/GostEcallUtils.h"
#include "CmdUtils.h"

using namespace std;

#undef LOG_TAG
#define LOG_TAG "DEMO_EGOST_SrComDataFmt"

//CT: command type
const std::uint8_t SrComDataFormat::CT_COMCONF;
const std::uint8_t SrComDataFormat::CT_MSGCONF;
const std::uint8_t SrComDataFormat::CT_MSGFROM;
const std::uint8_t SrComDataFormat::CT_MSGTO;
const std::uint8_t SrComDataFormat::CT_COM;
const std::uint8_t SrComDataFormat::CT_DELCOM;
const std::uint8_t SrComDataFormat::CT_SUBREQ;
const std::uint8_t SrComDataFormat::CT_DELIV;

//CCT-type fo acknowledgement (make sense for CT_COMCONF, CT_MSGCONF, or CT_DELIV commands)
const std::uint8_t SrComDataFormat::CC_OK;
const std::uint8_t SrComDataFormat::CC_ERROR;
const std::uint8_t SrComDataFormat::CC_ILL;
const std::uint8_t SrComDataFormat::CC_DEL;
const std::uint8_t SrComDataFormat::CC_NFOUND;
const std::uint8_t SrComDataFormat::CC_NCONF;
const std::uint8_t SrComDataFormat::CC_INPROG;

//CHS -character encoding used in the CD field that contains the command body
const std::uint8_t SrComDataFormat::cp_1251;
const std::uint8_t SrComDataFormat::IA5;
const std::uint8_t SrComDataFormat::binary_data;
const std::uint8_t SrComDataFormat::Latin1;
const std::uint8_t SrComDataFormat::binary_data_2;
const std::uint8_t SrComDataFormat::JIS;
const std::uint8_t SrComDataFormat::cyrillic;
const std::uint8_t SrComDataFormat::latin_Hebrew;
const std::uint8_t SrComDataFormat::UCS2;

SrComDataFormat::SrComDataFormat() {
    type = UINT8_MAX;
    CT = UINT8_MAX; //4bit
    CCT = UINT8_MAX;//4bit

    CID = UINT32_MAX;
    SID = UINT32_MAX;

    fileExs = UINT8_MAX;
    ACFE = 0; //1bit
    CHSFE = 0; //1bit

    CHS = UINT8_MAX; // O (CHSFE)
    ACL = 0; //O (ACFE)
    std::string AC = ""; //O (0, 255)
    std::string CD = ""; //O (0, 65205)

}

SrComDataFormat::~SrComDataFormat() {
    // TODO Auto-generated destructor stub
}

const std::string& SrComDataFormat::getAc() const {
    return AC;
}

void SrComDataFormat::setAc(const std::string ac) {
    AC = ac;
}

std::uint8_t SrComDataFormat::getAcfe() const {
    return ACFE;
}

void SrComDataFormat::setAcfe(std::uint8_t acfe) {
    ACFE = acfe;
}

std::uint8_t SrComDataFormat::getAcl() const {
    return ACL;
}

void SrComDataFormat::setAcl(std::uint8_t acl) {
    ACL = acl;
}

std::uint8_t SrComDataFormat::getCct() const {
    return CCT;
}

void SrComDataFormat::setCct(std::uint8_t cct) {
    CCT = cct;
}

const std::string& SrComDataFormat::getCd() const {
    return CD;
}

void SrComDataFormat::setCd(const std::string cd) {
    CD = cd;
}

std::uint8_t SrComDataFormat::getChs() const {
    return CHS;
}

void SrComDataFormat::setChs(std::uint8_t chs) {
    CHS = chs;
}

std::uint8_t SrComDataFormat::getChsfe() const {
    return CHSFE;
}

void SrComDataFormat::setChsfe(std::uint8_t chsfe) {
    CHSFE = chsfe;
}

std::uint32_t SrComDataFormat::getCid() const {
    return CID;
}

void SrComDataFormat::setCid(std::uint32_t cid) {
    CID = cid;
}

std::uint8_t SrComDataFormat::getCt() const {
    return CT;
}

void SrComDataFormat::setCt(std::uint8_t ct) {
    CT = ct;
}

std::uint8_t SrComDataFormat::getFileExs() const {
    return fileExs;
}

void SrComDataFormat::setFileExs(std::uint8_t fileExs) {
    this->fileExs = fileExs;
}

std::uint32_t SrComDataFormat::getSid() const {
    return SID;
}

void SrComDataFormat::setSid(std::uint32_t sid) {
    SID = sid;
}

std::uint8_t SrComDataFormat::getType() const {
    return type;
}

void SrComDataFormat::setType(std::uint8_t type) {
    this->type = type;
}

int SrComDataFormat::getEcallReqPara() {
    if(!mCmdBody) {
        MTK_RLOGW("no decode command body sub records");
        return 0;
    }
    return mCmdBody->getEcallReqPara();
}

int SrComDataFormat::decodeCtComCfg() {
    uint32_t index = 0;
    int64_t ret = 0;
    mCmdAck = std::make_shared<CommandAck>();

    //ADR(address)
    ret = decodeValue(CD, index, 4, "ADR(address)");
    if (ret == -1) {
        MTK_RLOGW("decode ADR fail");
        return -1;
    }
    MTK_RLOGD("index: %d, ADR: 0X%04x", index, (uint16_t )ret);
    mCmdAck->setAdr((uint16_t) (ret));

    //CCD(command code)
    ret = decodeValue(CD, index, 4, "CCD(command code)");
    if (ret == -1) {
        MTK_RLOGW("decode CCD fail");
        return -1;
    }
    MTK_RLOGD("index: %d, CCD: 0X%04x", index, (uint16_t )ret);
    mCmdAck->setCcd((uint16_t) (ret));

    //DT(data)
    if (index < CD.size()) {
        std::string sub = CD.substr(index);
        mCmdAck->setDt(sub);
        ret = mCmdAck->decodeCmdAckDt();
        if (ret == -1) {
            MTK_RLOGW("decode decodeCmdDt fail");
            return -1;
        }
    }
    return 0;
}

int SrComDataFormat::decodeCtCom() {
    uint32_t index = 0;
    int64_t ret = 0;
    mCmdBody = std::make_shared<CommandBody>();

    //ADR(address)
    ret = decodeValue(CD, index, 4, "ADR(address)");
    if (ret == -1) {
        MTK_RLOGW("decode ADR fail");
        return -1;
    }
    MTK_RLOGD("index: %d, ADR: 0X%04x", index, (uint16_t )ret);
    mCmdBody->setAdr((uint16_t) (ret));

    //decode CommandBody->SzAct
    ret = decodeValue(CD, index, 2, "CommandBody->SzAct");
    if (ret == -1) {
        MTK_RLOGW("decode SzAct fail");
        return -1;
    }
    MTK_RLOGD("index: %d, SzAct: 0X%02x", index, (uint8_t )ret);
    mCmdBody->setSzAct((uint8_t) ((ret)));
    bitset<8> tmp(mCmdBody->getSzAct());
    mCmdBody->setSz((tmp[7] << 3) | (tmp[6]) << 2 | (tmp[5] << 1) | tmp[4]);
    mCmdBody->setAct((tmp[3] << 3) | (tmp[2]) << 2 | (tmp[1] << 1) | tmp[0]);
    MTK_RLOGD("index: %d, ct=0X%02X, cct=0X%02X", index, mCmdBody->getSz(),mCmdBody->getAct());

    //CCD(command code)
    ret = decodeValue(CD, index, 4, "CCD(command code)");
    if (ret == -1) {
        MTK_RLOGW("decode CCD fail");
        return -1;
    }
    MTK_RLOGD("index: %d, CCD: 0X%04x", index, (uint16_t )ret);
    mCmdBody->setCcd((uint16_t) (ret));

    //DT(data)
    if (index < CD.size()) {
        std::string sub = CD.substr(index);
        mCmdBody->setDt(sub);
        ret = mCmdBody->decodeCmdDt();
        if (ret == -1) {
            MTK_RLOGW("decode decodeCmdDt fail");
            return -1;
        }
    }
    return 0;
}

int SrComDataFormat::decodeSrCmomDt() {
    //TBD .check CHS(charset) of  CD(command data) ? how to handle ?
    if(CD.empty()) {
        MTK_RLOGW("CD is empty");
        return 0;
    }
    MTK_RLOGD("CT=0X%02X, CCT = %02X,, CD: %s ", CT, CCT, CD.c_str());
    if(CT == CT_COM) {
        int ret = decodeCtCom();
        if(ret == -1) {
            MTK_RLOGW("decodeCtCom fail , just return");
            return -1;
        }
    } else if(CT == CT_COMCONF) {
        int ret = decodeCtComCfg();
        if(ret == -1) {
            MTK_RLOGW("decodeCtComCfg fail , just return");
            return -1;
        }
    } else {
        MTK_RLOGW("CT(%d) don't define", CT);
    }
    return 0;
}

std::string SrComDataFormat::ct2str(uint8_t ct) {
    MTK_RLOGD("ct: %d", ct);
    switch(ct) {
    case CT_COMCONF : return "acknowledgement of command";
    case CT_MSGCONF : return "acknowledement of message";
    case CT_MSGFROM : return "information message from IVDS";
    case CT_MSGTO   : return "information message for output to vehicle display device";
    case CT_COM     : return "command to be executed on the vehicle";
    case CT_DELCOM  : return "deleting the previous command from the execution queue";
    case CT_SUBREQ  : return "additional sub-request for execution(for a command sent before)";
    case CT_DELIV   : return "acknowledgement of command/message delivery";
    default: return "unknown";
    }
}

std::string SrComDataFormat::cct2str(uint8_t cct) {
    MTK_RLOGD("cct: %d", cct);
    switch(cct) {
    case CC_OK     : return "successful completion, positive response";
    case CC_ERROR  : return "processing failed";
    case CC_ILL    : return "command can not be executed";
    case CC_DEL    : return "command deleted successfully";
    case CC_NFOUND : return "command to be deleted isn't found";
    case CC_NCONF  : return "successful execution, negative response";
    case CC_INPROG : return "command dispatched for processing";
    default: return "unknown";
    }
}

bool SrComDataFormat::isIncludedCmdCode(std::uint16_t cmd) {
    MTK_RLOGD("cmd=0X%04X", cmd);
    if(!mCmdBody) {
        MTK_RLOGW("no decode command body sub records");
        return false;
    }
    return mCmdBody->isIncludedCmdCode(cmd);
}

//std::string encodeValue(int64_t value, uint8_t charset, const std::string tag);
std::string SrComDataFormat::encode(std::uint16_t cmd, bool ack) {
    MTK_RLOGD("cmd=0X%04X, cct=%u, ct=%u, ack=%d", cmd, CCT, CT, ack);
    if(!mCmdBody) {
        MTK_RLOGW("no decode command body sub records");
        return "";
    }
    bool ret = mCmdBody->isIncludedCmdCode(cmd);
    if(ret) {
        //encode CT and CCT
        if(CT != CT_COM) {
            MTK_RLOGW("no CT_COM, don't support");
            return "";
        }
        uint8_t value = (CT_COMCONF << 4) + (ack ? CC_OK : CC_ERROR);
        std::string ctCct = encodeValue(value, 2, "CT&CCT");

        //encode CID
        std::string cid = encodeValue(CID, 8, "CID");
        MTK_RLOGD("encode CID(0X%04X) result: %s",CID, cid.c_str());

        //encode SID;
        std::string sid = encodeValue(SID, 8, "SID");
        MTK_RLOGD("encode SID(0X%04X) result: %s",SID, sid.c_str());

        //encode ACFE&CHSFE
        bitset<8> flag;
        std::string fe = encodeValue(flag.to_ulong(), 2, "ACFE&CHSF");
        MTK_RLOGD("encode ACFE&CHSFE(0X%02X) result: %s",flag.to_ulong(), fe.c_str());
        return ctCct + cid + sid + fe;
    }
    return "";
}

bool SrComDataFormat::isNeedNewSms() {
    if(!mCmdBody) {
        MTK_RLOGW("no decode command body sub records");
        return false;
    }
    return mCmdBody->isNeedNewSms();
}
