#include <stdlib.h>
#include <stdio.h>
#include <log/log.h>
#include <stdint.h>
#include <unistd.h>
#include "common.h"
#include <stateManager/stateManager.h>
#include <liblog/lynq_deflog.h>
#include <pthread.h>
#include "lynq_data.h"
#include "lynq_call.h"
#include "lynq_sms.h"
#include "lynq_network.h"

#ifdef __cplusplus
extern "C" {
#endif
#define LYNQ_APN_LEN_MAX 100
#define LYNQ_APNTPYE_LEN_MAX 50
#define LYNQ_APN_CHANNEL_MAX 10
#define LYNQ_AT_LEN_MAX 20
#define LYNQ_EVENT_WAIT_TIME_MAX 25 //m


typedef struct
{
    char apn[LYNQ_APN_LEN_MAX];
    char apntype[LYNQ_APNTPYE_LEN_MAX];
    char ifaceName[LYNQ_APNTPYE_LEN_MAX];
    int netId;
    int used;//0:not use,1:used.
    int apnstatus;//1:has enable;0:need disable.
}apn_table_t;
extern apn_table_t apn_table[LYNQ_APN_CHANNEL_MAX];
extern int apn_count;
extern lynq_data_call_state_cb dataCb;
extern lynq_recive_new_sms_cb smsCb;
extern lynq_incoming_call_cb callCb;
extern lynq_signal_strength_change_ind sigStrengthChangeCb;
extern lynq_voice_network_state_change_ind voiceChangeCb;

int lynq_incoming_call_callback(RIL_SOCKET_ID soc_id,int index, char addr[], int callState, int toa);
int lynq_recive_new_sms_callback(RIL_SOCKET_ID soc_id,char num[], char smsc[], char msg[], int charset);
int lynq_data_callback(char apn[],char apnType[],int pdnState,char ifaceName[]);
int lynq_signal_strength_change_callback(int slot,signalStrength_t signalStrength);
int lynq_voice_network_state_change_callback(int slot);

void lynqp_thread_cond_init();
int lynqWaitRespWithTime(int time);
int lynqUnlockWaitingReq();
int lynqNoneParame(const char *requestStr);
int lynqIntParame(const char *requestStr,int parame);
int lynqStringParame(const char *requestStr,const char*serviceNumber);
int lynqStringParameOperate_enable(const char *requestStr, char *facility, char *pin, int serviceclass);
int lynqStringParameOperate_disable(const char *requestStr, char *facility, char *pin, int serviceclass);
int lynqStringParameQuery(const char *requestStr, char *facility, char *pin, int serviceclass);
int lynqStringParameChange(const char *requestStr, char *old_pin, char *new_pin);
void set_timer(int it_interval_sec, int it_interval_usec,int it_value_sec,int it_value_usec);
int millli_sleep_with_restart(int millisecond);
int sleep_with_restart(int second);
int strUpper(char * str);
lynqQueue *commonFindParcelmsg(const int32_t token,const int time,RIL_Errno&e);
lynqQueue *commonUpdateEstatus(const int32_t token,const int time,RIL_Errno&e);

typedef struct 
{
    char *MCCMCN;
    char *buf;
    char *MCN;
}FindOperator;

FindOperator*find_ope_command (char *name,FindOperator *Class);

#ifdef __cplusplus
}
#endif
