#include <stdio.h>
#include <string.h>
#include <pthread.h>
#include <ctype.h>
#include <stdlib.h>
#include <errno.h>
#include <fcntl.h>
#include <log/log.h>
#include "broadcast_receiver.h"
#include "link_id.h"
#define BROADCAST_BY_NAME "broadcast_to_name"
#define BROADCAST_BY_ID   "broadcast_to_id"
#define BROADCAST_UNFIXED_PARM   "broadcast_parme_unfixed"
#define BROADCAST_SERVICE "broadcast.lynq" /*well-known bus name */
#define BROADCAST_DATA_INTERFACE "broadcast.lynq.Data" /*interface name*/
#define BROADCAST_DATA_PATH "/broadcast/lynq/data" /*object name*/
#define LOG_TAG "BROADCAST_RECEIVE"
static GMainLoop *loop = NULL;
static GDBusProxy *pProxy = NULL;
BroadcastCallbackByName callback_by_name = NULL;
BroadcastCallbackById Callback_by_id = NULL;
BroadcastCallbackParamUnfixed callbacke_param_unfixed = NULL;
static pthread_mutex_t mutex_id = PTHREAD_MUTEX_INITIALIZER;
static pthread_mutex_t mutex_name = PTHREAD_MUTEX_INITIALIZER;

void proxy_signals_on_signal_by_name (GDBusProxy  *proxy,
                              const gchar *sender_name,
                              const gchar *signal_name,
                              GVariant    *parameters,
                              gpointer     user_data)
{
    const gchar *name, *param;
    int id;
    int data_length;
    RLOGD("signal_name: %s,sender_name:%s\n", signal_name,sender_name);
    if(!strcmp(signal_name,BROADCAST_BY_NAME)){
        
        g_variant_get (parameters,"(sis)",&name,&data_length,&param);
        pthread_mutex_lock(&mutex_name);
        if((NULL != FindNodeByName(name)) && (NULL != callback_by_name))
        {
            callback_by_name(name,data_length,param);
        }
        else
        {
            RLOGE("callback_by_name NULL");
        }
        pthread_mutex_unlock(&mutex_name);
    }
    else if(!strcmp(signal_name,BROADCAST_BY_ID))
    {
        g_variant_get (parameters,"(iis)",&id,&data_length,&param);	
        pthread_mutex_lock(&mutex_id);
        if((NULL != FindNode(id)) && (NULL != Callback_by_id))
        {
            Callback_by_id(id,data_length,param);
        }
        
        else
        {
            RLOGE("Callback_by_id NULL or  not has this broadcast id");
        }
        pthread_mutex_unlock(&mutex_id);
    }
    else if(!strcmp(signal_name,BROADCAST_UNFIXED_PARM))
    {
        GVariant  *data;
        g_variant_get (parameters,"(s@*)",&name,&data);
        pthread_mutex_lock(&mutex_name);
        if((NULL != FindNodeByName(name)) && (NULL != callbacke_param_unfixed))
        {
            callbacke_param_unfixed(name,data);
            RLOGD("callbacke_param_unfixed");
        }
        else
        {
            RLOGE("Callback_by_id NULL");
        }
        pthread_mutex_unlock(&mutex_name);
        
    }
    else
    {
        RLOGD("discard broadcast");
        return;
    }

}

gboolean register_signal(GDBusProxy *proxy)
{
    gulong signal_handler_id;
    signal_handler_id = g_signal_connect(proxy, "g-signal",
                      G_CALLBACK (proxy_signals_on_signal_by_name), NULL);

    RLOGD("proxy is ready");
    if (signal_handler_id == 0) {
        RLOGD("listen singal fail!");
        return FALSE;
    }
    return TRUE;
}
void receive_callback_by_name( char* name,BroadcastCallbackByName callback)
{
    if (NULL != callback){
        //memcpy(&mbroadcastcallback, callback, sizeof(broadcastCallback));
        pthread_mutex_lock(&mutex_name);
        AddListTillByName(name);
        pthread_mutex_unlock(&mutex_name);
        callback_by_name = callback;

    }
    else{
        RLOGD("registerSignalCallback: parameter point is NULL");
    }
}
void receive_callback_by_id(int id,BroadcastCallbackById callback)
{
    if (NULL != callback){
        //memcpy(&mbroadcastcallback, callback, sizeof(broadcastCallback));
        pthread_mutex_lock(&mutex_id);
        AddListTill(id);
        pthread_mutex_unlock(&mutex_id);
        Callback_by_id = callback;
    }
    else{
        RLOGD("registerSignalCallback: parameter point is NULL");
    }
}

void receive_callback_prame_unfixed(char* name,BroadcastCallbackParamUnfixed callback)
{
    if (NULL != callback){
        //memcpy(&mbroadcastcallback, callback, sizeof(broadcastCallback));
        pthread_mutex_lock(&mutex_name);
        AddListTillByName(name);
        pthread_mutex_unlock(&mutex_name);       
        callbacke_param_unfixed = callback;
    }
    else{
        RLOGD("registerSignalCallback: parameter point is NULL");
    }
}
void *run_broadcast(void* arg)
{
    g_main_loop_run(loop);
    return ((void*)0);
}

void delete_receive(void)
{
    if(pProxy != NULL) {
        g_object_unref (pProxy);
    }
    if(loop != NULL) {
        g_main_loop_unref(loop);
    }
}
int thread_broadcast_create(void)
{
    int err;
    pthread_t thr;
    err = pthread_create(&thr, NULL, run_broadcast, NULL);
    if(0 != err){
            RLOGD("Can't create thread: %s\n", strerror(err));
    }
    else{       
            RLOGD("New thread created: %s\n", strerror(err));
    }

    return err;
}
int broadcast_loop()
{
    g_main_loop_run(loop);
}
gboolean service_ready(void)
{
    gchar *owner_name = NULL;
    owner_name = g_dbus_proxy_get_name_owner((GDBusProxy*)pProxy);
    if(NULL != owner_name)
    {
        RLOGD("Owner Name: %s\n", owner_name);        
        g_free(owner_name);
        return TRUE;
    }
    else
    {   
        //RLOGD("Owner Name is NULL."); 
		//sleep(5);
        return FALSE;
    }
}
void register_broadcast_loop(void)
{
    register_broadcast_receiver();
    thread_broadcast_create();
}

void register_broadcast_receiver(void){
     GError *error = NULL;
     RLOGD("go!\n");	
     loop = g_main_loop_new(NULL, FALSE);
     pProxy = g_dbus_proxy_new_for_bus_sync (G_BUS_TYPE_SYSTEM,
                                         G_DBUS_PROXY_FLAGS_NONE,
                                         NULL, /* GDBusInterfaceInfo */
                                         BROADCAST_SERVICE,
                                         BROADCAST_DATA_PATH,
                                         BROADCAST_DATA_INTERFACE,
                                         NULL, /* GCancellable */
                                         &error);
    if (pProxy == NULL)
    {
      RLOGD ("Error creating proxy: %s\n", error->message);
      delete_receive();
    }
    if (register_signal(pProxy)== FALSE){
      RLOGD ("register Error");
      delete_receive();
    }
    while(service_ready() != TRUE);
}