#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <fcntl.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <binder/Parcel.h>
#include <log/log.h>
#include <cutils/jstring.h>
#include <pthread.h>
#include "liblog/lynq_deflog.h"
#include <sys/time.h>
#include <string.h>
#include <vendor-ril/telephony/ril.h>
#include <vendor-ril/telephony/mtk_ril_sp.h>
#include <vendor-ril/telephony/mtk_ril_ivt.h>
#include "lynq_call.h"


#define LYNQ_SERVICE_PORT 8088
#define DSET_IP_ADDRESS  "127.0.0.1"
#define LYNQ_URC_SERVICE_PORT 8086
#define LYNQ_REC_BUF 8192
#define LYNQ_REQUEST_PARAM_BUF 8192
#define LYQN_SEDN_BUF 1024*8+sizeof(int)*3
#define USER_LOG_TAG "LYNQ_CALL"

using ::android::Parcel;
 typedef enum {
     LYNQ_CALL_ACTIVE = 0,
     LYNQ_CALL_HOLDING = 1,
     LYNQ_CALL_DIALING = 2,    /* MO call only */
     LYNQ_CALL_ALERTING = 3,   /* MO call only */
     LYNQ_CALL_INCOMING = 4,   /* MT call only */
     LYNQ_CALL_WAITING = 5,    /* MT call only */
     /*warren add for T800 platform 2022/04/26 start*/
     LYNQ_CALL_END = 6,         /*CALL END*/
     /*warren add for T800 platform 2022/04/26 end*/
}lynq_call_state_t;

typedef struct{
    int uToken;
    int request;
    int paramLen;
    char param[LYNQ_REQUEST_PARAM_BUF];
}lynq_client_t;
typedef struct
{
    int used;
    int call_id;
    int call_state;
    int toa;
    int direction;/*0: MO call,1:MT call*/
    char addr[LYNQ_PHONE_NUMBER_MAX];
    int hasTimeout;
}lynq_call_list_e_t;
typedef struct
{
    int call_id;
    int call_state;
    int toa;
    int direction;/*0: MO call,1:MT call*/
    char addr[LYNQ_PHONE_NUMBER_MAX];
}lynq_call_list_t;

lynq_call_list_e_t lynq_call_lists[LYNQ_CALL_MAX]={};
static pthread_mutex_t call_state_change_mutex = PTHREAD_MUTEX_INITIALIZER;
static pthread_cond_t call_state_change_cond = PTHREAD_COND_INITIALIZER;
static pthread_mutex_t s_urc_call_state_change_mutex = PTHREAD_MUTEX_INITIALIZER;
static pthread_cond_t s_urc_call_state_change_cond = PTHREAD_COND_INITIALIZER;
static pthread_mutex_t s_incoming_call_mutex = PTHREAD_MUTEX_INITIALIZER;
static pthread_cond_t s_incoming_call_cond = PTHREAD_COND_INITIALIZER;
pthread_t lynq_call_urc_tid = -1;
pthread_t lynq_call_list_loop_tid = -1;

/*lei add*/
/* socket文件描述符 */ 
int len_addr_serv;
struct sockaddr_in addr_serv;
lynq_client_t client_t;
int client_size = 0;
/*lei add*/

int s_call_urc_event_complete = 1;

enum{
    CALL_OFF=0,
    CALL_ON=1
}call_state;
typedef enum{
    LYNQ_E_CARDSTATE_ERROR=8000,
    /* The voice service state is out of service*/
    LYNQ_E_STATE_OUT_OF_SERVICE=8001,
    /* The voice service state is EMERGENCY_ONLY*/
    LYNQ_E_STATE_EMERGENCY_ONLY=8002,
    /* The radio power is power off*/
    LYNQ_E_STATE_POWER_OFF=8003,
    LYNQ_E_TIME_OUT=8004,
    /*create or open sms DB fail */
    LYNQ_E_SMS_DB_FAIL=8005,
    /*Failed to execute sql statement*/
    LYNQ_E_SMS_SQL_FAIL = 8006,
    LYNQ_E_SMS_NOT_FIND = 8007,
    /* The logic conflict*/
    LYNQ_E_CONFLICT=9000,
    /*Null anomaly*/
    LYNQ_E_NULL_ANONALY=9001
}LYNQ_E;
typedef enum{
    LYNQ_E_VOLUMN_SET_DTMF,
    LYNQ_E_VOLUMN_SET_SPEECH
}LYNQ_E_VOLUMN_SET;   

int lynq_call_state =CALL_OFF;
int lynq_call_client_sockfd = 0;
int Global_uToken_call = 0;
int global_call_count =0;
int global_call_auto_answer = 0;
bool urc_call_recive_status = 1;
bool call_list_loop = 1;
int isDial = 0;
int lynqIncomingCallId = 0;

#ifdef ECALL_SUPPORT
typedef enum{        
    LYNQ_ECALL_TYPE_TEST = 0,     /* Test eCall */
    LYNQ_ECALL_TYPE_RECONFIG = 1,    /*    Reconfiguration eCall */    
    LYNQ_ECALL_MANUAL_EMERGENCY = 2,   /*Manual Emergency eCall */
    LYNQ_ECALL_TYPE_AUTO_EMERGENCY = 3,   /* Automatic Emergency eCall */\
}LYNQ_ECall_Type;

char e_call_addr[LYNQ_ECALL_VAR_MAX][LYNQ_PHONE_NUMBER_MAX]={"","null","112"};



static pthread_mutex_t s_incoming_e_call_mutex = PTHREAD_MUTEX_INITIALIZER;
static pthread_cond_t s_incoming_e_call_cond = PTHREAD_COND_INITIALIZER;

LYNQ_ECall_Indication lynqIncomingEcallIndication;
int lynqEcallId;

void sendSignalIncomingECallEvent()
{
    pthread_mutex_lock(&s_incoming_e_call_mutex);
    pthread_cond_signal(&s_incoming_e_call_cond);
    pthread_mutex_unlock(&s_incoming_e_call_mutex);
}
#endif

/**
 * @brief mark call initialization state
 * 0: deinit state
 * 1: init state
 */
int g_lynq_call_init_flag = 0;

int JumpHeader(Parcel &p,int *resp_type,int *request,int *slot_id,int *error)
{
    if(p.dataAvail() > 0)
    {
        p.readInt32(resp_type);
        p.readInt32(request);
        p.readInt32(slot_id);
        p.readInt32(error);
        return 0;
    }
    else
    {
        return -1;
    }
}
int send_request(int sockfd,lynq_client_t *client_tmp)
{
    int ret=0;
    ret = sendto(sockfd, client_tmp, client_size, 0, (struct sockaddr *)&addr_serv, len_addr_serv);
    if(ret==-1)
    {
        LYERRLOG("sendto error\n");
        return -1;
    }
    return 0;
}

int get_response(int sockfd,Parcel &p)
{
    int len = 0;
    char recvline[LYNQ_REC_BUF];
    bzero(recvline,LYNQ_REC_BUF);
    /* receive data from server */
    len = recvfrom(sockfd,recvline,LYNQ_REC_BUF, 0, (struct sockaddr *)&addr_serv,(socklen_t*)&len_addr_serv);
    if(len == -1)
    {
        LYERRLOG("recvfrom error\n");
        return -1;
    }
    if (recvline != NULL) {
        p.setData((uint8_t *)recvline,len); // p.setData((uint8_t *) buffer, buflen);
        p.setDataPosition(0);
    }
    return 0;
}
static char *strdupReadString(Parcel &p) {
    size_t stringlen;
    const char16_t *s16;
    s16 = p.readString16Inplace(&stringlen);
    return strndup16to8(s16, stringlen);
}

int lynq_get_current_call_list(lynq_call_list_t call_list[LYNQ_CALL_MAX])
{
    Parcel p;
    lynq_client_t client;
    int resp_type = -1;
    int request = -1;
    int slot_id = -1;
    int error = -1;
    int call_num = 0;
    int temp = 0;
    char *remote_phoneNum = NULL;
    char *remote_name= NULL;
    char *uusData = NULL;
    client.uToken = Global_uToken_call;
    client.request = 9;//RIL_REQUEST_GET_CURRENT_CALLS
    client.paramLen = 0;
    bzero(client.param,LYNQ_REQUEST_PARAM_BUF);
    LYDBGLOG("uToken=%d,request=%d,paralen=%d,param=%s\n",client.uToken,client.request,client.paramLen,client.param);
    if(send_request(lynq_call_client_sockfd,&client)==-1)
    {
        LYERRLOG("send request fail");
        return -1;
    }
    get_response(lynq_call_client_sockfd,p);
    JumpHeader(p,&resp_type,&request,&slot_id,&error);
    LYINFLOG("resp_type=%d,request=%d,slot_id=%d,error_code=%d",resp_type,request,slot_id,error);
    if(error == 0)
    {
        p.readInt32(&call_num);
        global_call_count = call_num;
        if(call_num<=0)
        {
            lynq_call_state = CALL_OFF;
            LYINFLOG("lynq_call_state:%d",lynq_call_state);
            return 0;
        }
        lynq_call_state = CALL_ON;
        LYINFLOG("lynq_call_state:%d",lynq_call_state);
        for(int i = 0;i < call_num;i++)
        {
            p.readInt32(&temp);
            call_list[i].call_state = temp;
            p.readInt32(&call_list[i].call_id);
            p.readInt32(&call_list[i].toa);
            p.readInt32(&temp);
            p.readInt32(&temp);
            call_list[i].direction = temp;
            p.readInt32(&temp);
            p.readInt32(&temp);
            p.readInt32(&temp);
            remote_phoneNum = strdupReadString(p);
            memcpy(call_list[i].addr,remote_phoneNum,strlen(remote_phoneNum));
            LYINFLOG("call_id=%d,call_state=%d,direction=%d,addr=%s,toa=%d",call_list[i].call_id,call_list[i].call_state,
            call_list[i].direction,call_list[i].addr,call_list[i].toa);
            p.readInt32(&temp);
            remote_name = strdupReadString(p);
            p.readInt32(&temp);
            p.readInt32(&temp);
            if(temp==0)
            {
                continue;
            }
            p.readInt32(&temp); /* UUS Information is present */
            p.readInt32(&temp);
            p.readInt32(&temp);
            p.read(uusData,temp);
        }
    }
    return 0;
}

void cleanCallList(int lynq_call_id)
{
    lynq_call_lists[lynq_call_id].call_id = 0;
    lynq_call_lists[lynq_call_id].call_state = (int)LYNQ_CALL_END;
    lynq_call_lists[lynq_call_id].toa = 0;
    lynq_call_lists[lynq_call_id].direction = 0;
    lynq_call_lists[lynq_call_id].used = 0;
    lynq_call_lists[lynq_call_id].hasTimeout = 0;
    memset(lynq_call_lists[lynq_call_id].addr,0,sizeof(lynq_call_lists[lynq_call_id].addr));
}
int getUnusedElement()
{
    for(int i=0;i < LYNQ_CALL_MAX; i++)
    {
        if(lynq_call_lists[i].used!=1)
        {
            return i;
        }
    }
    return -1;
}
int updateAddr(char addr[])
{
    int ret = 0;
    ret = getUnusedElement();
    memcpy(lynq_call_lists[ret].addr,addr,strlen(addr)+1);
    lynq_call_lists[ret].used = 1;
    return ret;
}
void updateCallList(lynq_call_list_e_t *callList,    int call_id,int call_state,int toa,int direction)
{
    LYINFLOG("Update Call List");
    callList->call_id = call_id;
    callList->call_state = call_state;
    callList->toa = toa;
    callList->direction = direction;
    callList->used = 1;
    callList->hasTimeout = 0;
    return;
}
int waitCallstateChange(int mtime)
{
    LYINFLOG("wait Call state Change");
    int ret = 0;
    int sec = 0;
    int usec = 0;
    struct timeval now;
    struct timespec timeout;
    gettimeofday(&now,NULL);
    sec = mtime/1000;
    usec = mtime%1000;
    timeout.tv_sec = now.tv_sec+sec;
    timeout.tv_nsec = now.tv_usec*1000+usec*1000000;
    pthread_mutex_lock(&call_state_change_mutex);
    ret = pthread_cond_timedwait(&call_state_change_cond,&call_state_change_mutex,&timeout);
    pthread_mutex_unlock(&call_state_change_mutex);
    return ret;
}
int waitIncomingCall()
{
    LYINFLOG("wait incming call");
    int ret = 0;
    pthread_mutex_lock(&s_incoming_call_mutex);
    ret = pthread_cond_wait(&s_incoming_call_cond,&s_incoming_call_mutex);
    pthread_mutex_unlock(&s_incoming_call_mutex);
    return ret;
}
int checkHasCall(char addr[])
{
    LYINFLOG("check has call");
    for(int i = 0;i<LYNQ_CALL_MAX;i++)
    {
        if(strcmp(lynq_call_lists[i].addr,addr)==0)
        {
            return 1;
        }
    }
    return 0;
}
int find_call_id_with_addr(char *addr)
{
    LYINFLOG("find call id with addr!!!");
    for(int id = 0; id < LYNQ_CALL_MAX; id++)
    {
        if(strcmp(lynq_call_lists[id].addr,addr) == 0)
        {
            return id;
        }
    }
    return -1;
}
void sendSignalToWaitCallStateChange()
{
    LYINFLOG("send Signal To Wait Call State Change");
    pthread_mutex_lock(&call_state_change_mutex);
    pthread_cond_signal(&call_state_change_cond);
    pthread_mutex_unlock(&call_state_change_mutex);
}
void sendSignalIncomingCall()
{
    LYINFLOG("send incoming call signal");
    pthread_mutex_lock(&s_incoming_call_mutex);
    pthread_cond_signal(&s_incoming_call_cond);
    pthread_mutex_unlock(&s_incoming_call_mutex);
}

void addCallListToLynqCallList(lynq_call_list_e_t *callList,    int call_id,int call_state,int toa,int direction,char addr[LYNQ_PHONE_NUMBER_MAX])
{
    callList->call_id = call_id;
    callList->call_state = call_state;
    callList->toa = toa;
    callList->direction = direction;
    memcpy(callList->addr,addr,strlen(addr)+1);
    callList->used = 1;
    callList->hasTimeout = 0;
    return;
}

void *triggerGetCallList(void *parg)
{
    int ret=0;
    bool call_end;
    call_end = 0;//0:this call end,1:call on
    lynq_call_list_t call_list[LYNQ_CALL_MAX];
    int update=0;
    while(call_list_loop)
    {
        update=0;
        pthread_mutex_lock(&s_urc_call_state_change_mutex);
        pthread_cond_wait(&s_urc_call_state_change_cond, &s_urc_call_state_change_mutex);
        LYDBGLOG("triggerGetCallList event!!!\n");
        memset(call_list,0,sizeof(call_list));
        ret = lynq_get_current_call_list(call_list);
        if(ret != 0)
        {
            LYDBGLOG("get current call list failure!!!\n");
            continue;
        }
        LYINFLOG("++++++++++++++triggerGetCallList++++++++++++++");
        for(int i = 0;i < LYNQ_CALL_MAX;i++)
        {
            if(strlen(lynq_call_lists[i].addr) != 0)
            {
                call_end = 0;
                for(int id = 0; id < LYNQ_CALL_MAX; id++)
                {
                    if(strcmp(call_list[id].addr,lynq_call_lists[i].addr) == 0)
                    {
                        call_end = 1;
                        LYINFLOG("find lynq call i %d, id %d!!!",i,id);
                    }
                }
                if(call_end == 0)
                {
                    LYINFLOG("MT hungup,then clean call info");
                    cleanCallList(i);
                    continue;
                }
            } //fix bug API-54
            if(call_list[i].direction == 1)//MT call
            {
                if(call_list[i].call_state ==4)//LYNQ_CALL_INCOMING = 4,   /* MT call only */
                {
                    /*you call me, and i call you,One party failed to dial*/
                    if(!checkHasCall(call_list[i].addr))
                    {
                        lynqIncomingCallId = getUnusedElement();
                        addCallListToLynqCallList(&lynq_call_lists[lynqIncomingCallId],call_list[i].call_id,call_list[i].call_state,call_list[i].toa,call_list[i].direction,call_list[i].addr);
                        sendSignalIncomingCall();
                    }
                    else
                    {
                        int temp_call_id = find_call_id_with_addr(call_list[i].addr);
                        /*if call state not change,Maybe this call was ignored, so we need to continue to inform the user of 
                        **an incoming call until the status changes.
                        **fix bug API-54
                        */
                        if((temp_call_id > 0) && (lynq_call_lists[temp_call_id].call_state == call_list[i].call_state))
                        {
                            sendSignalIncomingCall();
                        }
                    }
                }
                /*if state changed*/
                else
                {
                    /*update call state*/
                    for(int n = 0 ; n < LYNQ_CALL_MAX; n++)
                    {
                        if(strcmp(call_list[i].addr,lynq_call_lists[n].addr)==0)
                        {
                            updateCallList(&lynq_call_lists[n],call_list[i].call_id,call_list[i].call_state,call_list[i].toa,call_list[i].direction);
                            break;
                        }
                    }
                }
            }
            else
            {
                if(call_list[i].call_id==0)
                {
                    break;
                }
                for(int n = 0 ; n < LYNQ_CALL_MAX; n++)
                {
                    if((lynq_call_lists[n].hasTimeout == 1) && (strcmp(lynq_call_lists[n].addr,call_list[i].addr) == 0))
                    {
                        cleanCallList(n);//if this call time out,need clean lynq call list.
                        /*hangup call with call id*/
                        lynq_call_hungup(&call_list[i].call_id);
                        lynq_call_lists[n].hasTimeout==0;
                        continue;
                    }
                    LYDBGLOG("lynq_call_lists n is %d, used is %d, addr is %s addr2 %s\n",
                    n,lynq_call_lists[n].used,call_list[i].addr,lynq_call_lists[n].addr);
                    if(lynq_call_lists[n].used && (strcmp(call_list[i].addr,lynq_call_lists[n].addr)==0))
                    {
                        LYINFLOG("updated\n");                    
                        updateCallList(&lynq_call_lists[n],call_list[i].call_id,call_list[i].call_state,call_list[i].toa,call_list[i].direction);
                        update=1;
                        break;
                    }
                }
                LYDBGLOG("[count:%d]call_id=%d,call_state=%d,direction=%d,addr=%s,toa=%d",i,call_list[i].call_id,call_list[i].call_state,
                call_list[i].direction,call_list[i].addr,call_list[i].toa);
            }
        }
        s_call_urc_event_complete = 1;
        if((isDial==1) && (update==1))
        {
            sendSignalToWaitCallStateChange();
            isDial = 0;
        }
        pthread_mutex_unlock(&s_urc_call_state_change_mutex);
    }
    return NULL;
}

void lynqRespWatingEvent()
{
    if(s_call_urc_event_complete==1)
    {
        pthread_mutex_lock(&s_urc_call_state_change_mutex);
        pthread_cond_signal(&s_urc_call_state_change_cond);
        s_call_urc_event_complete = 0;
        pthread_mutex_unlock(&s_urc_call_state_change_mutex);
    }
    return;
}

/*Warren add for T800 platform 2021/11/19 start*/
int lynq_socket_client_start()
{   
    #if 0
    struct sockaddr_in lynq_socket_server_addr;
    /* init lynq_socket_server_addr */
    bzero(&lynq_socket_server_addr, sizeof(lynq_socket_server_addr));
    lynq_socket_server_addr.sin_family = AF_INET;
    lynq_socket_server_addr.sin_port = htons(LYNQ_SERVICE_PORT);
    lynq_socket_server_addr.sin_addr.s_addr = htons(INADDR_ANY);
    
    /*
    if(inet_pton(AF_INET,"127.0.0.1", &lynq_socket_server_addr.sin_addr) <= 0)
    {
        LYDBGLOG("[%s] is not a valid IPaddress\n", argv[1]);
        exit(1);
    }
*/
    lynq_call_client_sockfd = socket(AF_INET, SOCK_DGRAM, 0);
    if(connect(lynq_call_client_sockfd, (struct sockaddr *)&lynq_socket_server_addr, sizeof(lynq_socket_server_addr)) == -1)
    {
        LYERRLOG("connect error\n");
        return -1;
    }
    #endif
    lynq_call_client_sockfd = socket(AF_INET, SOCK_DGRAM, 0);
    if (-1 == lynq_call_client_sockfd)
    {
        return lynq_call_client_sockfd;
    }
    /* 设置address */  
    memset(&addr_serv, 0, sizeof(addr_serv));  
    addr_serv.sin_family = AF_INET;  
    addr_serv.sin_addr.s_addr = inet_addr(DSET_IP_ADDRESS);  
    addr_serv.sin_port = htons(LYNQ_SERVICE_PORT);  
    len_addr_serv = sizeof(addr_serv);  
    return 0;
}
int lynq_update_call_list_loop()
{
    int ret = 0;
    pthread_attr_t attr;
    pthread_attr_init(&attr);
    pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);
    ret = pthread_create(&lynq_call_list_loop_tid,&attr,triggerGetCallList,NULL);
    if(ret < 0)
    {
        LYERRLOG("lynq_update_call_list_loop fail!!!");
        return -1;
    }
    LYDBGLOG("lynq_update_call_list_loop success!!!\n");
    return 0;

}
void *thread_urc_recv(void *parg)
{
    int socket_fd = (int64_t)parg;
    int len=0;
    socklen_t addr_len=0;
    uint8_t *dataLength = NULL;
    char urc_data[LYNQ_REC_BUF];
    int slot_id = -1;
    int resp_type = -1;
    int urcid = -1;
    Parcel *p = NULL;
    struct sockaddr_in dest_addr;
#ifdef ECALL_SUPPORT
    int ecall_ind;    
#endif

    LYINFLOG("thread_urc_recv in running....\n");
    while(urc_call_recive_status)
    {
        bzero(urc_data,LYNQ_REC_BUF);
        //get data msg
        len = recvfrom(socket_fd,urc_data,LYNQ_REC_BUF,0,(struct sockaddr *)&dest_addr,&addr_len);
        if(len <= 0)
        {
            LYERRLOG("thread_urc_recv step2 fail\n");
            break;
        }
        LYDBGLOG("=====>urc data len<=====:%d\n",len);
        p = new Parcel();
        if(p==NULL)
        {
            LYERRLOG("new parcel failure!!!");
            break;
        }
        p->setData((uint8_t *)urc_data,len); // p.setData((uint8_t *) buffer, buflen);
        p->setDataPosition(0);
        if(p->dataAvail() > 0)
        {
            p->readInt32(&resp_type);
            p->readInt32(&urcid);
            p->readInt32(&slot_id);
            //LYDBGLOG("*******Warren test*******:resp_type=%d,urcid=%d,slot_id=%d\n",resp_type,urcid,slot_id);
            switch (urcid)
            {
                case 1001://RIL_UNSOL_RESPONSE_CALL_STATE_CHANGED
                {
                    LYINFLOG("**************:resp_type=%d,urcid=%d,slot_id=%d\n",resp_type,urcid,slot_id);
                    lynqRespWatingEvent();
                    break;
                }
                case 1018://RIL_UNSOL_CALL_RING
                {
                    if(global_call_auto_answer==1)
                    {
                        lynq_call_answer();
                    }
                    break;
                }
                case 1029://RIL_UNSOL_RINGBACK_TONE
                case 3049://RIL_UNSOL_CALL_INFO_INDICATION
                {
                     LYINFLOG("**************:resp_type=%d,urcid=%d,slot_id=%d\n",resp_type,urcid,slot_id);
                    break;
                }
#ifdef ECALL_SUPPORT
                case RIL_UNSOL_ECALL_INDICATIONS:
                {
                    p->readInt32(&ecall_ind);                  
                    lynqIncomingEcallIndication=ecall_ind;
                    if(LYNQ_ECALL_ACTIVE==lynqIncomingEcallIndication)
                    {
                        if(isDial==1)
                        {                               
                            p->readInt32(&lynqEcallId);
                            sendSignalToWaitCallStateChange();
                            usleep(300*1000);
                        }                              
                    }     
                    sendSignalIncomingECallEvent();
                    break;
                 }
#endif
                default:
                    break;
            }
        }
        delete p;
        p = NULL;
    }
    close(socket_fd);
}
int lynq_socket_urc_start()
{
    int socket_fd=0;
    int rt=0;
    int len=0;
    int on=1;
    struct sockaddr_in urc_local_addr;
    pthread_attr_t attr;
    socket_fd = socket(AF_INET,SOCK_DGRAM,0);
    if(socket_fd < 0)
    {
        LYERRLOG("creaet socket for udp fail\n");
        return -1;
    }
    urc_local_addr.sin_family = AF_INET;
    urc_local_addr.sin_port = htons(LYNQ_URC_SERVICE_PORT);
    urc_local_addr.sin_addr.s_addr = htons(INADDR_ANY);
    /* Set socket to allow reuse of address and port, SO_REUSEADDR value is 2*/
    rt = setsockopt(socket_fd,SOL_SOCKET,SO_REUSEADDR,&on,sizeof on);
    if(rt<0)
    {
        LYERRLOG("SO_REUSEADDR fail\n");
        return -1;
    }
    rt = bind(socket_fd ,(struct sockaddr*)&urc_local_addr, sizeof(urc_local_addr));
    if (rt == -1)
    {
        LYERRLOG("bind failed");
        return -1;
    }
    pthread_attr_init(&attr);
    pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);
    rt = pthread_create(&lynq_call_urc_tid,&attr,thread_urc_recv,(void *)socket_fd);
    if(rt < 0)
    {
        LYERRLOG("urc loop failure!!!\n");
        return -1;
    }
    LYDBGLOG("urc loop success!!!\n");
    return 0;
}
int getSelfElement(char addr[])
{
    for(int i=0;i < LYNQ_CALL_MAX; i++)
    {
        if(lynq_call_lists[i].used==1)
        {
            if(strcmp(lynq_call_lists[i].addr,addr)==0)
            {
                return i;
            }
            
        }
    }
    return -1;
}

void lynq_call_state_change_test(int soc_id)
{
    LYDBGLOG("call state change,sim:%d\n",soc_id);
}
int lynq_init_call(int uToken)
{   
    if(g_lynq_call_init_flag == 1){
        LYDBGLOG("lynq init call failed!!!");
        return -1;
    }
    g_lynq_call_init_flag = 1;
    int result = 0;
    Global_uToken_call = uToken;
    urc_call_recive_status = 1;
    client_size = sizeof(client_t);
    LYLOGSET(LOG_INFO);
    LYLOGEINIT(USER_LOG_TAG);
    result = lynq_socket_client_start();
    if(result!=0)
    {
        return -1;
    }
    result = lynq_socket_urc_start();
    if(result!=0)
    {
        return -1;
    }
    result = lynq_update_call_list_loop();
    if(result!=0)
    {
        return -1;
    }
    memset(lynq_call_lists,0,sizeof(lynq_call_lists));
    LYDBGLOG("lynq init call success!!!");
    return 0;
}
int lynq_deinit_call()
{
    if(g_lynq_call_init_flag == 0)
    {
        LYDBGLOG("lynq_deinit_call failed!!!");
        return -1;
    }
    else
    {   
        g_lynq_call_init_flag = 0;
        int ret = -1;
        if(lynq_call_client_sockfd>0)
        {
            close(lynq_call_client_sockfd);
        }
        urc_call_recive_status = 0;
        call_list_loop = 0;
        if(lynq_call_urc_tid == -1 || lynq_call_list_loop_tid == -1)
        {
            return -1;
        }
        ret = pthread_cancel(lynq_call_urc_tid);
        LYDBGLOG("pthread cancel ret = %d",ret);
        ret = pthread_cancel(lynq_call_list_loop_tid);
        LYDBGLOG("pthread cancel ret = %d",ret);
        ret = pthread_join(lynq_call_urc_tid,NULL);
        LYDBGLOG("pthread join ret = %d",ret);
        ret = pthread_join(lynq_call_list_loop_tid,NULL);
        LYDBGLOG("pthread join ret = %d",ret);
        return 0;
    }
}

int lynq_set_common_request(int request_id, int argc, const char* format,...)
{
    Parcel p;
    lynq_client_t client;
    int resp_type = -1;
    int request = -1;
    int slot_id = -1;
    int error = -1;

    client.uToken = Global_uToken_call;
    client.request = request_id;
    client.paramLen = argc;
    bzero(client.param,LYNQ_REQUEST_PARAM_BUF);
    if(argc!=0)
    {
        va_list args;
        va_start(args, format);
        vsnprintf(client.param, LYNQ_REQUEST_PARAM_BUF, format, args);
        va_end(args);    
    }
    LYINFLOG("uToken=%d,request=%d,paralen=%d,param=%s\n",client.uToken,client.request,client.paramLen,client.param);
    if(send_request(lynq_call_client_sockfd,&client)==-1)
    {
        LYERRLOG("send request fail");
        return -1;
    }
    if(get_response(lynq_call_client_sockfd,p)==0)
    {    
        JumpHeader(p,&resp_type,&request,&slot_id,&error);
        LYINFLOG("resp_type=%d,request=%d,slot_id=%d,error_code=%d",resp_type,request,slot_id,error);
    }
    return error;
}

int lynq_get_common_request(int request_id, int* status)
{
    Parcel p;
    lynq_client_t client;
    int resp_type = -1;
    int request = -1;
    int slot_id = -1;
    int error = -1;
    if(status==NULL)
    {
        LYERRLOG("status is null");
        return -1;
    }
    client.uToken = Global_uToken_call;
    client.request = request_id;
    client.paramLen = 0;
    bzero(client.param,LYNQ_REQUEST_PARAM_BUF);
    LYINFLOG("uToken=%d,request=%d,paralen=%d,param=%s\n",client.uToken,client.request,client.paramLen,client.param);
    if(send_request(lynq_call_client_sockfd,&client)==-1)
    {
        LYERRLOG("send request fail");
        return -1;
    }
    if(get_response(lynq_call_client_sockfd,p)==0)
    {
        JumpHeader(p,&resp_type,&request,&slot_id,&error);
        p.readInt32(status);
        LYINFLOG("resp_type=%d,request=%d,slot_id=%d,error_code=%d",resp_type,request,slot_id,error);
    }
    return error;
}

int lynq_call(int* handle,char addr[])
{
    Parcel p;
    lynq_client_t client;
    int resp_type = -1;
    int request = -1;
    int slot_id = -1;
    int error = -1;
    int lynq_call_id = -1;
    if(addr==NULL)
    {
        LYERRLOG("Phone num is null!!!");
        return -1;
    }
    client.uToken = Global_uToken_call;
    client.request = 10;//RIL_REQUEST_DIAL
    client.paramLen = 2;
    bzero(client.param,LYNQ_REQUEST_PARAM_BUF);
    memcpy(client.param,addr,strlen(addr)+1);
    strcat(client.param," 0");
    LYERRLOG("uToken=%d,request=%d,paralen=%d,param=%s",client.uToken,client.request,client.paramLen,client.param);
    if(send_request(lynq_call_client_sockfd,&client)==-1)
    {
        LYERRLOG("send request fail");
        return -1;
    }
    get_response(lynq_call_client_sockfd,p);
    JumpHeader(p,&resp_type,&request,&slot_id,&error);
    LYINFLOG("resp_type=%d,request=%d,slot_id=%d,error_code=%d",resp_type,request,slot_id,error);
    lynq_call_id = updateAddr(addr);
    if(error==0)
    {
        isDial = 1;
        if(waitCallstateChange(6000)==ETIMEDOUT)//6000ms
        {
            //if timeout,this call need destroy.
            isDial = 0;

            error = LYNQ_E_TIME_OUT;
            LYERRLOG("timeout:wait Call state fail!!!");
            lynq_call_lists[lynq_call_id].hasTimeout = 1;
            return error;
        }
    *handle = lynq_call_id;
    }
    return error;
}
int lynq_call_answer()
{
    Parcel p;
    lynq_client_t client;
    int resp_type = -1;
    int request = -1;
    int slot_id = -1;
    int error = -1;
    client.uToken = Global_uToken_call;
    client.request = 40;//RIL_REQUEST_DIAL
    client.paramLen = 0;
    bzero(client.param,LYNQ_REQUEST_PARAM_BUF);
    LYDBGLOG("uToken=%d,request=%d,paralen=%d,param=%s\n",client.uToken,client.request,client.paramLen,client.param);
    if(send_request(lynq_call_client_sockfd,&client)==-1)
    {
        LYERRLOG("send request fail");
        return -1;
    }
    get_response(lynq_call_client_sockfd,p);
    JumpHeader(p,&resp_type,&request,&slot_id,&error);
    LYINFLOG("resp_type=%d,request=%d,slot_id=%d,error_code=%d",resp_type,request,slot_id,error);
    return error;
}
int lynq_call_hungup(int* handle)
{
    Parcel p;
    lynq_client_t client;
    int resp_type = -1;
    int request = -1;
    int slot_id = -1;
    int error = -1;
    int call_id = 0;
    int lynq_call_id = 0;
    if(handle==NULL||!((*handle>=0)&&(*handle<10)))
    {
        LYERRLOG("[%s] illegal input!!!!",__FUNCTION__);
        return LYNQ_E_CONFLICT;
    }
    client.uToken = Global_uToken_call;
    client.request = 12;//RIL_REQUEST_HUNGUP
    client.paramLen = 1;
    bzero(client.param,LYNQ_REQUEST_PARAM_BUF);
    lynq_call_id = *handle;
    call_id = lynq_call_lists[lynq_call_id].call_id;
    sprintf(client.param,"%d",call_id);
    LYDBGLOG("uToken=%d,request=%d,paralen=%d,param=%s\n",client.uToken,client.request,client.paramLen,client.param);
    if(send_request(lynq_call_client_sockfd,&client)==-1)
    {
        LYERRLOG("send request fail");
        return -1;
    }
    get_response(lynq_call_client_sockfd,p);
    JumpHeader(p,&resp_type,&request,&slot_id,&error);
    LYINFLOG("resp_type=%d,request=%d,slot_id=%d,error_code=%d",resp_type,request,slot_id,error);
    if(error==0)
    {
        cleanCallList(lynq_call_id);
    }
    return error;
}
int lynq_call_hungup_all()
{
    Parcel p;
    lynq_client_t client;
    int resp_type = -1;
    int request = -1;
    int slot_id = -1;
    int error = -1;
    client.uToken = Global_uToken_call;
    client.request = 17;//RIL_REQUEST_UDUB
    client.paramLen = 0;
    bzero(client.param,LYNQ_REQUEST_PARAM_BUF);
    LYDBGLOG("uToken=%d,request=%d,paralen=%d,param=%s\n",client.uToken,client.request,client.paramLen,client.param);
    if(send_request(lynq_call_client_sockfd,&client)==-1)
    {
        LYERRLOG("send request fail");
        return -1;
    }
    get_response(lynq_call_client_sockfd,p);
    JumpHeader(p,&resp_type,&request,&slot_id,&error);
    LYINFLOG("resp_type=%d,request=%d,slot_id=%d,error_code=%d",resp_type,request,slot_id,error);
    return error;
}
int lynq_wait_incoming_call(int *handle)
{
    waitIncomingCall();
    *handle = lynqIncomingCallId;
    LYINFLOG("lynq incoming call id:%d",lynqIncomingCallId);
    return 0;
}

int lynq_set_auto_answercall(const int mode)
{
    global_call_auto_answer = mode;
    LYINFLOG("auto answer call mode =%d",mode);
    return 0;
}
int lynq_get_current_call_state(int *handle,    int *call_state,int *toa,int *direction,char addr[])
{
    int lynq_call_id = 0;
    if(handle==NULL)
    {
        return LYNQ_E_NULL_ANONALY;
    }
    lynq_call_id = *handle;
    *call_state = lynq_call_lists[lynq_call_id].call_state;
    *toa = lynq_call_lists[lynq_call_id].toa;
    *direction = lynq_call_lists[lynq_call_id].direction;
    memcpy(addr,lynq_call_lists[lynq_call_id].addr,strlen(lynq_call_lists[lynq_call_id].addr)+1);
    return 0;
}

/*audio begin*/
static int judge_mic(const int enable){
    switch(enable){
        case 0:
            return 1;
        case 1:
            return 1;
        default:
            return 0;
    }
}

int lynq_set_mute_mic(const int enable)
{   
    if(!judge_mic(enable)){
        return LYNQ_E_CONFLICT;
    }
    return lynq_set_common_request(53,1,"%d",enable); //RIL_REQUEST_SET_MUTE    
}
int lynq_get_mute_mic(int *status)
{
    return lynq_get_common_request(54,status);//RIL_REQUEST_GET_MUTE    
}

/**
 * @brief Check whether DTMF is valid
 * 
 * @param callnum dtmf eg:0-9 * #
 * @return int 
 */
static int judge_dtmf(const char callnum)
{
    if(callnum == '#')
    {
        return 1;
    }
    if(callnum == '*')
    {
        return 1;
    }
    if(callnum >= '0'&& callnum <= '9')
    {
        return 1;
    }
    return 0;
}

int lynq_set_DTMF(const char callnum)
{
    if(!judge_dtmf(callnum))
    {
        return LYNQ_E_CONFLICT;
    }
    if(!lynq_call_state)
    {
        LYERRLOG("LYNQ_E_CONFLICT");
        return LYNQ_E_CONFLICT;
    }
    return lynq_set_common_request(24,1,"%c",callnum); //RIL_REQUEST_DTMF  
}
static int judge_volume(LYNQ_E_VOLUMN_SET set,const int volume){
    if(set==LYNQ_E_VOLUMN_SET_DTMF){
        if(volume < 0 ||volume >36){
            return 0;
        }
    }
    else if (set==LYNQ_E_VOLUMN_SET_SPEECH)
    {
        if(volume < 1 ||volume >7){
            return 0;
        }
    }
    return 1;
}
int lynq_set_DTMF_volume(const int volume)
{   
    if(!judge_volume(LYNQ_E_VOLUMN_SET_DTMF,volume)){
        return LYNQ_E_CONFLICT;
    }
    return lynq_set_common_request(8003,1,"%d",volume);//LYNQ_REQUEST_SET_DTMF_VOLUME
}
int lynq_set_speech_volume(const int volume)//mixer_set_volume
{
    if(!judge_volume(LYNQ_E_VOLUMN_SET_SPEECH,volume))
    {
        return LYNQ_E_CONFLICT;
    }
    return lynq_set_common_request(8009,1,"%d",volume); //LYNQ_REQUEST_SET_SPEECH_VOLUME
}
int lynq_get_speech_volume(int* volumn)//mixer_get_volume
{
    return lynq_get_common_request(8010,volumn);//LYNQ_REQUEST_GET_SPEECH_VOLUME
} 
int lynq_incall_record_start(const char* file_path)
{
	return lynq_set_common_request(8011,2,"%s %s","1",file_path); //LYNQ_REQUEST_RECORD
}
int lynq_incall_record_stop()
{
    const char* unused_file="just_ocuupy_paramter_postion";
    return lynq_set_common_request(8011,2,"%s %s","0",unused_file); //LYNQ_REQUEST_RECORD
}
/*audio end*/

#ifdef ECALL_SUPPORT
LYNQ_ECall_Variant lynq_get_lynq_ecall_variant_from_lynq_type(LYNQ_ECall_Type type)
{
    switch(type)
    {
        case LYNQ_ECALL_TYPE_TEST:
            return LYNQ_ECALL_TEST;
        case LYNQ_ECALL_TYPE_RECONFIG:
            return LYNQ_ECALL_RECONFIG;
        default:
            return LYNQ_ECALL_EMERGENCY;
    }
}

RIL_ECall_Variant lynq_get_ril_ecall_variant_from_lynq_variant(LYNQ_ECall_Variant type)
{
    switch(type)
    {
        case LYNQ_ECALL_TEST:
            return ECALL_TEST;
        case LYNQ_ECALL_RECONFIG:
            return ECALL_RECONFIG;
        default:
            return ECALL_EMERGENCY;
    }
}

RIL_ECall_Category lynq_get_ril_ecall_cat_from_lynq_cat(LYNQ_ECall_Category cat)
{
    switch(cat)
    {
        case LYNQ_EMER_CAT_MANUAL_ECALL:
            return EMER_CAT_MANUAL_ECALL;        
        default:
            return EMER_CAT_AUTO_ECALL;
    }
}


int lynq_set_test_num(LYNQ_ECall_Set_Type type, const char *test_num, int test_num_length)
{
    int error; 

    if(test_num==NULL || test_num_length > LYNQ_PHONE_NUMBER_MAX )
    {
       LYERRLOG("test_num is null or test_num_length %d s greater than %d\n ",test_num_length,LYNQ_PHONE_NUMBER_MAX);
       return -1;
    }       
    
    error=lynq_set_common_request(RIL_REQUEST_ECALL_SET_TEST_NUM,2,"%d %s",type,test_num);

    if(error==0)
    {
        snprintf(e_call_addr[LYNQ_ECALL_TEST],LYNQ_PHONE_NUMBER_MAX,"%s",test_num);
    }

    return error;
}


int lynq_fast_ecall(int* handle, LYNQ_ECall_Category lynq_ecall_cat, LYNQ_ECall_Variant lynq_ecall_variant,  const char *addr, int addr_length, const char *msd_data, int msd_length)
{
    int error = -1;
    int lynq_call_id = -1;
    RIL_ECall_Variant ril_ecall_variant = lynq_get_ril_ecall_variant_from_lynq_variant (lynq_ecall_variant);
    RIL_ECall_Category ril_ecall_cat = lynq_get_ril_ecall_cat_from_lynq_cat(lynq_ecall_cat);

    lynq_call_id = updateAddr(e_call_addr[lynq_ecall_variant]);

    LYINFLOG("e_call_addr is %s\n",e_call_addr[lynq_ecall_variant]);

    error=lynq_set_common_request(RIL_REQUEST_ECALL_FAST_MAKE_ECALL,4,"%d %d %s %s",ril_ecall_cat, ril_ecall_variant, "null", msd_data);
   
    if(error==0)
    {        
        isDial = 1;
        if(waitCallstateChange(30000)==ETIMEDOUT)//30000ms
        {
            isDial = 0;
            error = LYNQ_E_TIME_OUT;
            cleanCallList(lynq_call_id);
            LYERRLOG("timeout:wait Call state fail!!!");           
            return error;
        }
         
        *handle = lynq_call_id;
        if(lynq_ecall_variant==LYNQ_ECALL_EMERGENCY){
            lynq_call_lists[lynq_call_id].call_id=lynqEcallId;
        }
        LYINFLOG("lynq_fast_ecall handle is:%d, call id is %d",lynq_call_id,lynq_call_lists[lynq_call_id].call_id);
        
    }
    else {
        cleanCallList(lynq_call_id);
    }

    return error;
}

int lynq_set_psap(int enable)
{
    return lynq_set_common_request(RIL_REQUEST_ECALL_SET_PSAP,1,"%d",enable);    
}

int lynq_psap_pull_msd()
{
    return lynq_set_common_request(RIL_REQUEST_ECALL_PSAP_PULL_MSD,0,"");  
}

int lynq_make_ecall(int* handle, LYNQ_ECall_Type type)
{
    LYNQ_ECall_Variant lynq_ecall_variant;
    int error = -1;
    int lynq_call_id = -1;

    if(handle==NULL)
    {
        LYERRLOG("handle is NULL, parameter error \n ");
           return -1;
    }
    
    error=lynq_set_common_request(RIL_REQUEST_ECALL_MAKE_ECALL,1,"%d",type);   
    
    if(error==0)
    {
        lynq_ecall_variant=lynq_get_lynq_ecall_variant_from_lynq_type(type);
      
        lynq_call_id = updateAddr(e_call_addr[lynq_ecall_variant]);
        isDial = 1;
        if(waitCallstateChange(10000)==ETIMEDOUT)//10000ms
        {
            error = LYNQ_E_TIME_OUT;
            LYERRLOG("timeout:wait Call state fail!!!");
            lynq_call_lists[lynq_call_id].hasTimeout = 1;
            return error;
        }
 
        *handle = lynq_call_id;
    }

    return error;
}


int lynq_set_msd(int* handle, const char *msd_data, int msd_length)
{
    if(handle==NULL || ((*handle) >= LYNQ_CALL_MAX))
    {
        LYERRLOG("handle is NULL or *handle %d is greater or equeal to %d, parameter error\n",*handle,LYNQ_CALL_MAX);
           return -1;
    }    

    return lynq_set_common_request(RIL_REQUEST_ECALL_SET_MSD,2,"%d %s",lynq_call_lists[(*handle)].call_id,msd_data);
}

int lynq_set_ivs(int enable)
{
    return lynq_set_common_request(RIL_REQUEST_ECALL_SET_IVS,1,"%d",enable);
}

int lynq_reset_ivs()
{
     return lynq_set_common_request(RIL_REQUEST_ECALL_RESET_IVS,0,"");
}

int lynq_ivs_push_msd()
{
    return lynq_set_common_request(RIL_REQUEST_ECALL_IVS_PUSH_MSD,0,"");    
}

int wait_ecall_event()
{
    int ret = 0;
    pthread_mutex_lock(&s_incoming_e_call_mutex);
    ret = pthread_cond_wait(&s_incoming_e_call_cond,&s_incoming_e_call_mutex);
    pthread_mutex_unlock(&s_incoming_e_call_mutex);
    return ret;
}

int lynq_wait_ecall_indication(LYNQ_ECall_Indication *eCall_Indication)
{
    wait_ecall_event();
    *eCall_Indication = lynqIncomingEcallIndication;
    LYINFLOG("lynq incoming e-call indication id:%d",lynqIncomingEcallIndication);
    return 0;
}

#endif

#if 0
int main(int argc,char **argv)
{
    int n = 0;
    n = lynq_init_call(lynq_call_state_change_test,2222);
    if(n<0)
    {
        LYDBGLOG("lynq init call fail!!!\n");
        return -1;
    }
    LYDBGLOG("lynq call init success!!!\n");
    char phoneNum[LYNQ_PHONE_NUMBER_MAX];
    sprintf(phoneNum,"18180053406 0",strlen("18180053406 0")+1);
    lynq_call(phoneNum);
    while(1)
    {
        sleep(1);
    }
    return 0;
}
#endif
/*Warren add for T800 platform 2021/11/19 end*/
