#ifndef __LYNQ_MQTT_H__
#define __LYNQ_MQTT_H__
#include <mosquitto.h>


struct mqtt_set_will{
	int will_flag;
	char *will_topic;
	int will_payloadlen;
	char *will_payload;
	int will_qos;
	bool retain;
};

struct mqtt_set_parament
{
	char *protocol;
	int  session;
	char *action;
	int modify_thread;
	int add_thread;

	 char *usrname; //服务端用户名
	 char *pwd; //服务端密码
	 char *ip_addr;
	 int port;
	 int keep_time; 

	 int subscribe_qos;
	 int publish_qos;

	 char *subscribe_topic;
	 char *unsubscribe_topic; //lt add @2021.7.13 for unsubscribe topic

	 char *publish_topic;
	 char *publish_data;

	char *client_id;
	bool clean_session;

	struct mqtt_set_will set_will;
	 
};


#define NO_ERROR 0
#define CREATE_LIENT_ERROR 1
#define USER_PWD_ERROR 2
#define CONNECT_FAIL 3
#define CREATE_LOOP_FAIL 4
#define MQTT_DISCONNECT_FAIL 5
#define MQTT_CONNECT_FAIL 6


int lynq_mqtt_connect_init(struct mqtt_set_parament mqtt_message);
void lynq_mosquitto_set_connect_callback(void (*connect_callback)(struct mosquitto *mosq, void *userdata, int result));
void lynq_mosquitto_set_message_callback(void (*message_callback)(struct mosquitto *mosq, void *userdata, const struct mosquitto_message *message));
void lynq_mosquitto_set_subscribe_callback(void (*subscribe_callback)(struct mosquitto *mosq, void *userdata, int mid, int qos_count, const int *granted_qos));
void lynq_mosquitto_set_disconnect_callback( void (*disconnect_callback)( struct mosquitto *mosq,void *obj, int rc));
void lynq_mosquitto_set_publish_callback(void (*on_publish)(struct mosquitto *mosq, void *obj, int mid));

void lynq_mosquitto_publish_message(char *pub_topic,int pub_buf_len,char *pub_buf,int qos); //发布
void lynq_mosquitto_subscribe_message(char *sub_topic,int sub_qos); // 订阅
void lynq_mosquitto_disconnect(void); //断开

int lynq_mqtt_login(struct mqtt_set_parament mqtt_message);
void lynq_mosquitto_subscribe_message(char *sub_topic,int sub_qos);
void lynq_mosquitto_publish_message(char *pub_topic,int pub_buf_len,char *pub_buf,int qos);
void lynq_mosquitto_unsubscribe_message(char *unsub_topic);
#endif //__LYNQ_MQTT_H__
