/*============================================================================= 
#     FileName: lynq_sim.cpp
#     Desc: about SIM API
#     Author: mobiletek 
#     Version: V1.0
#     LastChange: 2021-12-29 
#     History: 
=============================================================================*/
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <string.h>
#include <unistd.h>
#include <binder/Parcel.h>
#include <log/log.h>
#include <cutils/jstring.h>
#include <pthread.h>
#include "lynq_sim.h"
#include <sys/socket.h>   
#include <netinet/in.h>   
#include <arpa/inet.h>
#define MAX_BUF 20
#define MAX_NUM 80
#define RIL_REQUEST_GET_SIM_STATUS 1
#define RIL_REQUEST_GET_IMSI 11
#define RIL_REQUEST_QUERY_ICCID 2026
#define RIL_REQUEST_SET_FACILITY_LOCK 43
#define RIL_REQUEST_QUERY_FACILITY_LOCK 42
#define RIL_REQUEST_ENTER_SIM_PIN 2
#define RIL_REQUEST_ENTER_SIM_PUK 3
#define RIL_REQUEST_CHANGE_SIM_PIN 6
#define RIL_REQUEST_OEM_HOOK_RAW 59
#define RIL_REQUEST_SCREEN_STATE 61
#define RIL_REQUEST_SIM_IO 28
#define RIL_REQUEST_DEVICE_IDENTITY 98
#define LYNQ_REQUEST_SET_DEFAULT_SIM_ALL 8008
#define MAX_LEN 1024*8
#define MAX_NUM 10
#define LOG_TAG "LYNQ_SIM"
#define FLAG_TESS 0
using ::android::Parcel;
#define DEST_PORT 8088
#define DSET_IP_ADDRESS  "127.0.0.1"

typedef struct{
    int uToken;
    int request;
    int paramLen;
    char param[MAX_LEN];
}lynq_client_t;

lynq_client_t client_t;
/* socket文件描述符 */ 
int len_addr_serv;
struct sockaddr_in addr_serv;
static int sock_fd = 0;
int Global_uToken = 0; 
int resp_type = -1;
int request = -1;
int slot_id = -1;
int error1 = -1;
/**
 * @brief mark call initialization state
 * 0: deinit state
 * 1: init state
 */
int g_lynq_sim_init_flag = 0;

/**
 * @brief lynq_req_sim_io need to send request
 */
char data_buf[32] = {0};
char pin2_buf[32] = {0};
char aidPtr_buf[32] = {0};

/**/
char options_buf[32] = {0};
char time_buf[32] = {0};
char message_buf[32] = {0};

int lynq_sim_init(int utoken){
    if(g_lynq_sim_init_flag == 1)
    {
        RLOGD("lynq_sim_init  failed");
        return -1;
    }
    g_lynq_sim_init_flag = 1;
    if(utoken < 0){
        return -1;
    }
    Global_uToken = utoken;
    sock_fd = socket(AF_INET, SOCK_DGRAM, 0);
	if (-1 == sock_fd)
	{
		return sock_fd;
	}
    /* 设置address */  
    memset(&addr_serv, 0, sizeof(addr_serv));  
    addr_serv.sin_family = AF_INET;  
    addr_serv.sin_addr.s_addr = inet_addr(DSET_IP_ADDRESS);  
    addr_serv.sin_port = htons(DEST_PORT);  
    len_addr_serv = sizeof(addr_serv);  
    /*test*/
    return 0;
}

int lynq_sim_deinit(void){
    if(g_lynq_sim_init_flag == 0)
    {
        RLOGD("lynq_sim_deinit  failed");
        return -1;
    }
    g_lynq_sim_init_flag = 0;
    close(sock_fd);
    return 0;
}

static char * lynqStrdupReadString(Parcel &p) {
    size_t stringlen;
    const char16_t *s16;

    s16 = p.readString16Inplace(&stringlen);
    return strndup16to8(s16, stringlen);
}

/*If you need to use any API under lynq_sim, you mustfirst call the lynq_sim_init() function to initialize these functions.*/
int lynq_get_sim_status(int *card_status)
{   
    int ret = -1;
    if(card_status == NULL)
        return ret;
    int send_num = 0;
    int recv_num = 0;
    int len = 0;
    lynq_client_t client_t1;
    memset(&client_t1, 0, sizeof(client_t1) );
    client_t1.request = RIL_REQUEST_GET_SIM_STATUS;
    client_t1.paramLen = 0;
    client_t1.uToken = Global_uToken;
    char res_data[MAX_LEN] = {0};
    int len1 = sizeof(client_t1.param);
    memset(client_t1.param, 0, sizeof(char)*MAX_LEN);
    send_num = sendto(sock_fd, &client_t1, sizeof(client_t1), 0, (struct sockaddr *)&addr_serv, len_addr_serv);
    if(send_num < 0)  
    {  
        RLOGD("sendto error:");  
        return send_num;
    }
    //get data msg
    recv_num = recvfrom(sock_fd,res_data,sizeof(char)*MAX_LEN, 0, (struct sockaddr *)&addr_serv,(socklen_t*)&len_addr_serv);
    if(recv_num < 0 || recv_num == 0)
    {
        RLOGD("recvfrom step2 fail:");
        return recv_num;
    }
    Parcel p;;
    p.setData((uint8_t *)res_data,sizeof(char)*recv_num); // p.setData((uint8_t *) buffer, buflen);
    p.setDataPosition(0);
    if(p.dataAvail() > 0)
    {
        p.readInt32(&resp_type);
        p.readInt32(&request);
        p.readInt32(&slot_id);
        p.readInt32(&error1);
        p.readInt32(card_status);
    }
    return error1;
}

int lynq_get_imsi(char buf[])
{   
    int ret = -1;
    if(buf == NULL)
        return ret;
    int send_num = 0;
    int recv_num = 0;
    int len = 0;
    lynq_client_t client_t1;
    memset(&client_t1, 0, sizeof(client_t1) );
    client_t1.request = RIL_REQUEST_GET_IMSI;
    client_t1.paramLen = 0;
    client_t1.uToken = Global_uToken;
    char res_data[MAX_LEN] = {0};
    memset(client_t1.param, 0, sizeof(client_t1.param));
    send_num = sendto(sock_fd, &client_t1, sizeof(client_t1), 0, (struct sockaddr *)&addr_serv, len_addr_serv);
    if(send_num < 0)  
    {  
        RLOGD("sendto error:");  
        return send_num;
    }
    //get data msg
    recv_num = recvfrom(sock_fd,res_data,sizeof(char)*MAX_LEN,0,(struct sockaddr *)&addr_serv,(socklen_t*)&len_addr_serv);
    if(recv_num < 0 || recv_num == 0)
    {
        RLOGD("recvfrom step2 fail:");
        return recv_num;
    }
    Parcel p;
    p.setData((uint8_t *)res_data,sizeof(char)*recv_num); // p.setData((uint8_t *) buffer, buflen);
    p.setDataPosition(0);
    if(p.dataAvail() > 0)
    {
        p.readInt32(&resp_type);
        p.readInt32(&request);
        p.readInt32(&slot_id);
        p.readInt32(&error1);
        if(!error1){
            char * test = lynqStrdupReadString(p);
            memcpy(buf, test, strlen(test));
        }
    }
    return error1;
}


/*add by lei*/

int lynq_get_iccid(char buf[]){
    int ret = -1;
    if(buf == NULL)
        return ret;
    int send_num = 0;
    int recv_num = 0;
    int len = 0; 
    client_t.request = RIL_REQUEST_QUERY_ICCID;
    client_t.paramLen = 0;
    client_t.uToken = Global_uToken;
    char res_data[MAX_LEN] = {0};
    memset(client_t.param, 0, sizeof(client_t.param));
    send_num = sendto(sock_fd, &client_t, sizeof(client_t), 0, (struct sockaddr *)&addr_serv, len_addr_serv);
    if(send_num < 0)  
    {  
        RLOGD("sendto error:");  
        return send_num;
    }
    //get data msg
    recv_num = recvfrom(sock_fd,res_data,sizeof(char)*MAX_LEN,0,(struct sockaddr *)&addr_serv,(socklen_t*)&len_addr_serv);
    if(recv_num < 0 || recv_num == 0)
    {
        RLOGD("recvfrom step2 fail:");
        return recv_num;
    }
    Parcel p;
    p.setData((uint8_t *)res_data,sizeof(char)*recv_num); // p.setData((uint8_t *) buffer, buflen);
    p.setDataPosition(0);
    if(p.dataAvail() > 0)
    {
        p.readInt32(&resp_type);
        p.readInt32(&request);
        p.readInt32(&slot_id);
        p.readInt32(&error1);
        if(!error1){
            char * test = lynqStrdupReadString(p);
            memcpy(buf, test, strlen(test));
        }
    }
    return error1;
}

int lynq_enable_pin(char *pin){
    int ret = -1;
    if(pin == NULL)
        return ret;
    if(!strlen(pin))
        return ret;
    int send_num = 0;
    int recv_num = 0;  
    char res_data[MAX_LEN] = {0};
    client_t.request = RIL_REQUEST_SET_FACILITY_LOCK;
    client_t.paramLen = 4;
    client_t.uToken = Global_uToken;
    sprintf(client_t.param, "%s %s %s %s\n", "SC", pin, "11", "1");
    send_num = sendto(sock_fd, &client_t, sizeof(client_t), 0, (struct sockaddr *)&addr_serv, len_addr_serv);
    if(send_num < 0)  
    {  
        RLOGD("sendto error:");  
        return send_num;
    }

    //get data msg
    recv_num = recvfrom(sock_fd,res_data,sizeof(char)*MAX_LEN,0,(struct sockaddr *)&addr_serv,(socklen_t*)&len_addr_serv);
    if(recv_num < 0 || recv_num == 0)
    {
        RLOGD("recvfrom step2 fail:");
        return recv_num;
    }
    Parcel p;
    p.setData((uint8_t *)res_data,sizeof(char)*recv_num); // p.setData((uint8_t *) buffer, buflen);
    p.setDataPosition(0);
    if(p.dataAvail() > 0)
    {
        p.readInt32(&resp_type);
        p.readInt32(&request);
        p.readInt32(&slot_id);
        p.readInt32(&error1);
    }
    return error1;
}

int lynq_disable_pin(char *pin){
    int ret = -1;
    if(pin == NULL)
        return ret;
    int send_num = 0;  
    int recv_num = 0;
    char res_data[MAX_LEN] = {0};
    client_t.request = RIL_REQUEST_SET_FACILITY_LOCK;
    client_t.paramLen = 4;
    client_t.uToken = Global_uToken;
    sprintf(client_t.param, "%s %s %s %s\n", "SC", pin, "11", "0");
    send_num = sendto(sock_fd, &client_t, sizeof(client_t), 0, (struct sockaddr *)&addr_serv, len_addr_serv);
    if(send_num < 0)  
    {  
        RLOGD("sendto error:");  
        return send_num;
    }
    //get data msg
    recv_num = recvfrom(sock_fd,res_data,sizeof(char)*MAX_LEN,0,(struct sockaddr *)&addr_serv,(socklen_t*)&len_addr_serv);
    if(recv_num < 0 || recv_num == 0)
    {
        RLOGD("recvfrom step2 fail:");
        return recv_num;
    }
    Parcel p;
    p.setData((uint8_t *)res_data,sizeof(char)*recv_num); // p.setData((uint8_t *) buffer, buflen);
    p.setDataPosition(0);
    if(p.dataAvail() > 0)
    {
        p.readInt32(&resp_type);
        p.readInt32(&request);
        p.readInt32(&slot_id);
        p.readInt32(&error1);
    }
    return error1;
}

int lynq_query_pin_lock(char *pin,int buf[]){
    int ret = -1;
    if(pin == NULL)
        return ret;
    int send_num = 0;
    int recv_num = 0;
    int len = 0; 
    client_t.request = RIL_REQUEST_QUERY_FACILITY_LOCK;
    client_t.paramLen = 3;
    client_t.uToken = Global_uToken;
    char res_data[MAX_LEN] = {0};
    sprintf(client_t.param, "%s %s %s\n", "SC", pin, "11");
    send_num = sendto(sock_fd, &client_t, sizeof(client_t), 0, (struct sockaddr *)&addr_serv, len_addr_serv);
    if(send_num < 0)  
    {  
        RLOGD("sendto error:");  
        return send_num;
    }
    //get data msg
    recv_num = recvfrom(sock_fd,res_data,sizeof(char)*MAX_LEN,0,(struct sockaddr *)&addr_serv,(socklen_t*)&len_addr_serv);
    if(recv_num < 0 || recv_num == 0)
    {
        RLOGD("recvfrom step2 fail:");
        return recv_num;
    }
    Parcel p;
    p.setData((uint8_t *)res_data,sizeof(char)*recv_num); // p.setData((uint8_t *) buffer, buflen);
    p.setDataPosition(0);
    int num = -1;
    if(p.dataAvail() > 0)
    {
        p.readInt32(&resp_type);
        p.readInt32(&request);
        p.readInt32(&slot_id);
        p.readInt32(&error1);
        p.readInt32(&num);
        if(num > 0){
            int *test = (int *)calloc(1, sizeof(int)*num);
            for(int i =0; i <num; i++){
                p.readInt32(&test[i]);
                buf[i] = test[i];
            }
            free(test);
        }
    }
    return error1;
}

int lynq_verify_pin(char *pin){
    int ret = -1;
    if(pin == NULL)
        return ret;
    int send_num = 0;
    int recv_num = 0;
    char res_data[MAX_LEN] = {0};
    int len = 0; 
    client_t.request = RIL_REQUEST_ENTER_SIM_PIN;
    client_t.paramLen = 1;
    client_t.uToken = Global_uToken;
    sprintf(client_t.param, "%s\n", pin);
    send_num = sendto(sock_fd, &client_t, sizeof(client_t), 0, (struct sockaddr *)&addr_serv, len_addr_serv);
    if(send_num < 0)  
    {  
        RLOGD("sendto error:");  
        return send_num;
    }
   //get data msg
    recv_num = recvfrom(sock_fd,res_data,sizeof(char)*MAX_LEN,0,(struct sockaddr *)&addr_serv,(socklen_t*)&len_addr_serv);
    if(recv_num < 0 || recv_num == 0)
    {
        RLOGD("recvfrom step2 fail:");
        return recv_num;
    }
    Parcel p;
    p.setData((uint8_t *)res_data,sizeof(char)*recv_num); // p.setData((uint8_t *) buffer, buflen);
    p.setDataPosition(0);
    if(p.dataAvail() > 0)
    {
        p.readInt32(&resp_type);
        p.readInt32(&request);
        p.readInt32(&slot_id);
        p.readInt32(&error1);
    }
    return error1;
}

int lynq_change_pin(char *old_pin, char *new_pin){
    int ret = -1;
    if(old_pin == NULL || new_pin == NULL)
        return ret;
    if(!strlen(new_pin))
        return ret;
    if(!strlen(old_pin))
        return ret;
    int send_num = 0;
    int recv_num = 0;
    char res_data[MAX_LEN] = {0};
    int len = 0; 
    client_t.request = RIL_REQUEST_CHANGE_SIM_PIN;
    client_t.paramLen = 2;
    client_t.uToken = Global_uToken;
    sprintf(client_t.param, "%s %s\n", old_pin, new_pin);
    send_num = sendto(sock_fd, &client_t, sizeof(client_t), 0, (struct sockaddr *)&addr_serv, len_addr_serv);
    if(send_num < 0)  
    {  
        RLOGD("sendto error:");  
        return send_num;
    }
    //get data msg
    recv_num = recvfrom(sock_fd,res_data,sizeof(char)*MAX_LEN,0,(struct sockaddr *)&addr_serv,(socklen_t*)&len_addr_serv);
    if(recv_num < 0 || recv_num == 0)
    {
        RLOGD("recvfrom step2 fail:");
        return recv_num;
    }
    Parcel p;
    p.setData((uint8_t *)res_data,sizeof(char)*recv_num); // p.setData((uint8_t *) buffer, buflen);
    p.setDataPosition(0);
    if(p.dataAvail() > 0)
    {
        p.readInt32(&resp_type);
        p.readInt32(&request);
        p.readInt32(&slot_id);
        p.readInt32(&error1);
    }
    return error1;
}

int lynq_unlock_pin(char *puk, char *pin){
    int ret = -1;
    if(puk == NULL || pin == NULL)
        return ret;
    int send_num = 0;
    int recv_num = 0;
    char res_data[MAX_LEN] = {0};
    int len = 0; 
    client_t.request = RIL_REQUEST_ENTER_SIM_PUK;
    client_t.paramLen = 2;
    client_t.uToken = Global_uToken;
    sprintf(client_t.param, "%s %s\n", puk, pin);
    send_num = sendto(sock_fd, &client_t, sizeof(client_t), 0, (struct sockaddr *)&addr_serv, len_addr_serv);
    if(send_num < 0)  
    {  
        RLOGD("sendto error:");  
        return send_num;
    }
    //get data msg
    recv_num = recvfrom(sock_fd,res_data,sizeof(char)*MAX_LEN,0,(struct sockaddr *)&addr_serv,(socklen_t*)&len_addr_serv);
    if(recv_num < 0 || recv_num == 0)
    {
        RLOGD("recvfrom step2 fail:");
        return recv_num;
    }
    Parcel p;
    p.setData((uint8_t *)res_data,sizeof(char)*recv_num); // p.setData((uint8_t *) buffer, buflen);
    p.setDataPosition(0);
    if(p.dataAvail() > 0)
    {
        p.readInt32(&resp_type);
        p.readInt32(&request);
        p.readInt32(&slot_id);
        p.readInt32(&error1);
    }
    return error1;
}

static void delete_char(char str[],char target){
    if(str == NULL){
        return;
    }
    int i,j;
    for(i=j=0;str[i]!='\0';i++){
        if(str[i]!=target){
            str[j++]=str[i];
        }
    }
    str[j]='\0';
} 

static int parse_param(char *cmd, char **argv, char buf[]){
    if(cmd == NULL || argv == NULL || buf == NULL){
        return 0;
    }
    if(strstr(cmd,"ERROR")){
        //char *test = strchr(cmd, ':')+1;
        int len = strlen(cmd);
        memcpy(buf, cmd, len);
        buf[len] = '\0';
        return 3;
    }
    else{
        int argc = 0;
        char *token;
        token = strtok(cmd, ",");
        if(strstr(token, "CNUM")){
            char *string;
            while (token != NULL)
            {  
                string = token;
                argv[argc++] = string;
                token = strtok(NULL, ",");
            }
            int lengh = strlen(argv[1]);
            memcpy(buf, argv[1], lengh);
            buf[lengh] = '\0';
            delete_char(buf, '"');
        }
    }
    return 0;
}

int lynq_query_phone_number(char buf[]){
    int ret = -1;
    if(buf == NULL)
        return ret;
    int send_num = 0;
    int recv_num = 0;
    int len = 0;
    char res_data[MAX_LEN] = {0};
    client_t.request = RIL_REQUEST_OEM_HOOK_RAW;
    client_t.paramLen = 1;
    client_t.uToken = Global_uToken;
    sprintf(client_t.param, "%s\n", "AT+CNUM");
    send_num = sendto(sock_fd, &client_t, sizeof(client_t), 0, (struct sockaddr *)&addr_serv, len_addr_serv);
    if(send_num < 0)  
    {  
        RLOGD("sendto error:");  
        return ret;
    }
     //get data msg
    recv_num = recvfrom(sock_fd,res_data,sizeof(char)*MAX_LEN,0,(struct sockaddr *)&addr_serv,(socklen_t*)&len_addr_serv);
    if(recv_num < 0 || recv_num == 0)
    {
        RLOGD("recvfrom step2 fail:");
        return recv_num;
    }
    Parcel p;
    p.setData((uint8_t *)res_data,sizeof(char)*recv_num); // p.setData((uint8_t *) buffer, buflen);
    p.setDataPosition(0);
    int num = -1;
    if(p.dataAvail() > 0)
    {   
        char test[128] = {0};
        char *argv[5] = {0};
        p.readInt32(&resp_type);
        p.readInt32(&request);
        p.readInt32(&slot_id);
        p.readInt32(&error1);
        p.readInt32(&num);
        if(num == -1){
        }else{
            p.read(test, num);
            parse_param(test, argv, buf);
        }
    }
    return error1;
}

/**
 * @brief To handle comma-separated strings, take the character before the first comma  eg:123456,78 ->123456
 * 
 * @param buf Type:[IN]
 */
static void parse_imei(char buf[])
{
    if(NULL == buf)
    {
        return;
    }
    const char s[2] = ",";
    char *token;
    token = strtok(buf, s);
    return;
}

int lynq_get_imei(char buf[])
{   
    int ret = -1;
    if(buf == NULL)
        return ret;
    int send_num = 0;
    int recv_num = 0;
    int len = 0;
    lynq_client_t client_t1;
    memset(&client_t1, 0, sizeof(client_t1) );
    client_t1.request = RIL_REQUEST_DEVICE_IDENTITY;
    client_t1.paramLen = 0;
    client_t1.uToken = Global_uToken;
    char res_data[MAX_LEN] = {0};
    memset(client_t1.param, 0, sizeof(client_t1.param));
    send_num = sendto(sock_fd, &client_t1, sizeof(client_t1), 0, (struct sockaddr *)&addr_serv, len_addr_serv);
    if(send_num < 0)  
    {  
        RLOGD("sendto error:");  
        return send_num;
    }
    //get data msg
    recv_num = recvfrom(sock_fd,res_data,sizeof(char)*MAX_LEN,0,(struct sockaddr *)&addr_serv,(socklen_t*)&len_addr_serv);
    if(recv_num < 0 || recv_num == 0)
    {
        RLOGD("recvfrom step2 fail:");
        return recv_num;
    }
    Parcel p;
    p.setData((uint8_t *)res_data,sizeof(char)*recv_num); // p.setData((uint8_t *) buffer, buflen);
    p.setDataPosition(0);
    int num = 0;
    if(p.dataAvail() > 0)
    {
        p.readInt32(&resp_type);
        p.readInt32(&request);
        p.readInt32(&slot_id);
        p.readInt32(&error1);
        if(!error1){
            p.readInt32(&num);
            char * test = lynqStrdupReadString(p);
            parse_imei(test);
            memcpy(buf, test, strlen(test));
        }
    }
    return error1;
}

static int judge(int slot){
    switch(slot){
        case 0:
            return -1;
        case 1:
            return -1;
    }
    return 0;
}

int lynq_switch_card(int slot){
    int ret = -1;
    if(!judge(slot))
        return ret;
    int send_num = 0;
    client_t.request = LYNQ_REQUEST_SET_DEFAULT_SIM_ALL;
    client_t.paramLen = 1;
    client_t.uToken = Global_uToken;
    sprintf(client_t.param, "%d\n", slot);
    send_num = sendto(sock_fd, &client_t, sizeof(client_t), 0, (struct sockaddr *)&addr_serv, len_addr_serv);
    if(send_num < 0)  
    {  
        RLOGD("sendto error:");  
        return send_num;
    }
    return 0;
}

int lynq_screen(int num){
    int ret = -1;
    if(!judge(num))
        return ret;
    int send_num = 0;
    client_t.request = RIL_REQUEST_SCREEN_STATE;
    client_t.paramLen = 1;
    client_t.uToken = Global_uToken;
    sprintf(client_t.param, "%d\n", num);
    send_num = sendto(sock_fd, &client_t, sizeof(client_t), 0, (struct sockaddr *)&addr_serv, len_addr_serv);
    if(send_num < 0)
    {
        RLOGD("sendto error:");
        return send_num;
    }
    return 0;
}

/**
 * @brief                   Check whether the input is valid  for lynq_req_sim_io api
 * @param  list             type: [IN] list[0]:one of the commands listed for TS 27.007 +CRSM.(command)
 *                          type: [IN] list[1]:EF id(fileid)
 *                          type: [IN] list[2]:offset(p1)
 *                          type: [IN] list[3]:offset(p2)
 *                          type: [IN] list[4]:response len,sometimes needn't care(p3)
 * @param  path             type: [IN] "pathid" from TS 27.007 +CRSM command.
                            type: [IN] Path is in hex asciii format eg "7f205f70"
                            type: [IN] Path must always be provided.
 * @param  data             type: [IN] May be NULL
 * @param  pin2             type: [IN] May be NULL
 * @param  aidPtr           type: [IN] AID value, See ETSI 102.221 8.1 and 101.220 4, NULL if no value.
 * @param  sw               type: [OUT] 
 * @param  simResponse      type: [OUT] response
 * @return int
 */
static int judge_illegal(int list[5], char *path, char *data, char *pin2, char *aidPtr, int sw[2], char *simResponse)
{
    if(list == NULL)
    {
        return -1;
    }
    if(path == NULL)
    {
        return -1;
    }
    if(sw == NULL){
        return -1;
    }
    if(simResponse == NULL){
        return -1;
    }
    if(data == NULL)
    {
        memcpy(data_buf, "null", 4);
    }
    else
    {
        bzero(data_buf,32);
        memcpy(data_buf, data, strlen(data));
    }
    if(pin2 == NULL)
    {
        memcpy(pin2_buf, "null", 4);
    }
    else
    {
        bzero(pin2_buf,32);
        memcpy(pin2_buf, data, strlen(data));
    }
    if(aidPtr == NULL)
    {
        memcpy(aidPtr_buf, "null", 4);
    }
    else
    {
        bzero(aidPtr_buf,32);
        memcpy(aidPtr_buf, data, strlen(data));
    }
    return 0;
}

int lynq_req_sim_io(int list[5], char *path, char *data, char *pin2, char *aidPtr, int sw[2], char *simResponse)
{   
    int ret = -1;
    if(judge_illegal(list, path, data, pin2, aidPtr, sw, simResponse))
    {
        return ret;
    }
    int send_num = 0;
    int recv_num = 0;
    char res_data[MAX_LEN] = {0};
    client_t.request = RIL_REQUEST_SIM_IO;
    client_t.paramLen = 9;
    client_t.uToken = Global_uToken;
    sprintf(client_t.param, "%d %d %s %d %d %d %s %s %s\n", list[0], list[1], path, list[2], list[3], list[4], data_buf, pin2_buf, aidPtr_buf);
    send_num = sendto(sock_fd, &client_t, sizeof(client_t), 0, (struct sockaddr *)&addr_serv, len_addr_serv);
    if(send_num < 0)
    {
        RLOGD("sendto error:");
        return send_num;
    }
    recv_num = recvfrom(sock_fd,res_data,sizeof(char)*MAX_LEN,0,(struct sockaddr *)&addr_serv,(socklen_t*)&len_addr_serv);
    if(recv_num < 0 || recv_num == 0)
    {
        RLOGD("recvfrom step2 fail:");
        return recv_num;
    }
    Parcel p;
    p.setData((uint8_t *)res_data,sizeof(char)*recv_num); // p.setData((uint8_t *) buffer, buflen);
    p.setDataPosition(0);
    if(p.dataAvail() > 0)
    {
        p.readInt32(&resp_type);
        p.readInt32(&request);
        p.readInt32(&slot_id);
        p.readInt32(&error1);
        if(!error1)
        {
            p.readInt32(&sw[0]);
            p.readInt32(&sw[1]);
            char * test = lynqStrdupReadString(p);
            memcpy(simResponse, test, strlen(test));
        }

    }
    return error1;
}

/**
 * @brief                   handle shutdown buf
 * @param  options          type: [IN]My Param doc
 * @param  time             type: [IN]My Param doc
 * @param  message          type: [IN]My Param doc
 */
static void handle_shutdown_buf(char options[], char time[], char message[])
{
    if(NULL == options)
    {
        bzero(options_buf, 32);
        memcpy(options_buf," ", 1);
    }
    else
    {
        memcpy(options_buf,options, strlen(options));
    }
    if(NULL == time)
    {
        bzero(time_buf, 32);
        memcpy(time_buf," ", 1);
    }
    else
    {
        memcpy(time_buf, time, strlen(time));
    }
    if(NULL == message)
    {
        bzero(message_buf, 32);
        memcpy(message_buf," ", 1);
    }
    else
    {
        memcpy(message_buf, message, strlen(message));
    }
}

int lynq_shutdown(char options[], char time[], char message[])
{
    char cmd[128] = {0};
    handle_shutdown_buf(options, time, message);
    sprintf(cmd, "%s %s %s %s", "shutdown", options_buf, time_buf, message_buf);
    system(cmd);
    return 0;
}

int lynq_get_version(char buf[])
{
    FILE * fp;
    char buffer[128];
    sprintf(buffer, "%s", "uci get lynq_uci_ro.lynq_version.LYNQ_SW_VERSION");
    fp = popen(buffer, "r");
    fgets(buffer, sizeof(buffer), fp);
    memcpy(buf, buffer, strlen(buffer));
    buf[strlen(buffer)] = '\0';
    pclose(fp);
    return 0;
}
#if FLAG_TESS
int lynq_query_operator(char buf[]){
    int32_t token = -1;
    if(buf == NULL)
        return token;
    char msg_imsi[20] = {0};
    memset(msg_imsi,0,sizeof(msg_imsi));
    token = lynq_get_imsi(msg_imsi);
    if(strlen(msg_imsi) != 0){
        FindOperator *ope_command = NULL;
        ope_command = find_ope_command(msg_imsi, findOperator);
        if(ope_command){
            memcpy(buf, ope_command->buf, strlen(ope_command->buf));
            buf[strlen(ope_command->buf)] = '\0';
        }
        else{
            /*more*/
            char mccmnc[5] = {0};
            memcpy(buf, msg_imsi, 5);
            buf[5] = '\0';
            /*more*/
        }
        return token;
    }
    else{
        //msg->base.e = err;
        const char *test = "please insert sim card";
        memcpy(buf, test, strlen(test));
        return token;
    }
}
FindOperator findOperator[] = {
#include "operator.h"
};

static FindOperator*find_ope_command (char *name,FindOperator *Class){
    if(name == NULL || Class == NULL){
        return ((FindOperator *)NULL);
    }
    register int i;
    for (i = 0; Class[i].MCCMCN; i++)
        if (strncmp (name, Class[i].MCCMCN, 5) == 0)
            return (&Class[i]);
    return ((FindOperator *)NULL);
}

#endif
