#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include<sys/stat.h>
#include<fcntl.h>
#include <unistd.h>
#include <errno.h>

#include "lynq_deal_logrotate.h"

//lt add @2021.7.28 for get file data
int lynq_read_logdata(int fd,unsigned char* dest, unsigned int start, unsigned int size)
{ 
    int ret,err;
	
    if (lseek(fd, start, SEEK_SET) < 0) {
        err = errno;
        printf("mtk_device_wrap_seek read block err\n");
    }

    do {

        ret = read(fd, dest, size);

        if (ret == 0) {
            break;
        } else if (ret < 0) {
            if (errno == EINTR) {
                continue;
            }
            err = -errno;
            printf("Error reading metadata file\n");

            close(fd);

            return err;
        }
        size -= ret;
        dest += ret;
    } while(size > 0);

    close(fd);
    return ret;    
   
}

//lt add @2021.7.28 for get syslog file path
int lynq_get_syslog_path(SYSLOG_PATH syslog_path,char *file_path) //
{
	char syslog_file_path[64] = {0};
	int fd;
	int ret = 0;
 	switch(syslog_path)
	{
		case SYSLOG_1:
			 sprintf(syslog_file_path,"/var/log/syslog.log.1.gz");
			break;
		case SYSLOG_2:
			sprintf(syslog_file_path,"/var/log/syslog.log.2.gz");
			break;
		case SYSLOG_3:
			sprintf(syslog_file_path,"/var/log/syslog.log.3.gz");
			break;
		case SYSLOG_4:
			sprintf(syslog_file_path,"/var/log/syslog.log.4.gz");
			break;
		case SYSLOG_5:
			sprintf(syslog_file_path,"/var/log/syslog.log.5.gz");
			break;
		default :
			ret = -1;
			break;
	 }
	
	if(ret == 0)
	{
		fd = open(syslog_file_path,O_RDONLY);
		ret = fd;
		close(fd);
	}
	
	if(ret >= 0)
	{
		memcpy(file_path,syslog_file_path,sizeof(syslog_file_path));
	}
	return ret;
}

//lt add @2021.7.28 for get mculog file path
int lynq_get_mculog_path(char *file_path)
{
	char mculog_file_path[64] = {0};
	int fd;
	int ret = 0;
 	sprintf(mculog_file_path,"/var/log/mculog.log.1.gz");

	fd = open(mculog_file_path,O_RDONLY);
	ret = fd;
	close(fd);
	
	if(ret >= 0)
	{
		memcpy(file_path,mculog_file_path,sizeof(mculog_file_path));
	}
	
	return ret;
}

//lt add @2021.7.28 for get current mtklog file path
int lynq_get_current_mtklog_path(char *file_path)
{
	char mtklog_file_path[64] = {0};
	int fd;
	int ret = 0;
	
	system("tar -zcvf /var/log/mtklog.tar.gz /var/log/mtklog");
//	system("echo -n "" > /var/log/mtklog");
 	sprintf(mtklog_file_path,"/var/log/mtklog.tar.gz");

	fd = open(mtklog_file_path,O_RDONLY);
	ret = fd;
	close(fd);
	
	if(ret >= 0)
	{
		memcpy(file_path,mtklog_file_path,sizeof(mtklog_file_path));
	}
	return ret;
}


//lt add @2021.7.28 for get current syslog file path
int lynq_get_current_syslog_path(char *file_path)
{
	char syslog_file_path[64] = {0};
	int fd;
	int ret = 0;
	
	system("tar -zcvf /var/log/syslog.tar.gz /var/log/syslog.log");
	system("echo -n "" > /var/log/syslog.log");
 	sprintf(syslog_file_path,"/var/log/syslog.tar.gz");

	fd = open(syslog_file_path,O_RDONLY);
	ret = fd;
	close(fd);
	
	if(ret >= 0)
	{
		memcpy(file_path,syslog_file_path,sizeof(syslog_file_path));
	}
	return ret;
}


//lt add @2021.7.28 for get current mculog file path
int lynq_get_current_mculog_path(char *file_path)
{
	char mculog_file_path[64] = {0};
	int fd;
	int ret = 0;
	
	system("tar -zcvf /var/log/mculog.tar.gz /var/log/mculog.log");
	system("echo -n "" > /var/log/mculog.log");
 	sprintf(mculog_file_path,"/var/log/mculog.tar.gz");

	fd = open(mculog_file_path,O_RDONLY);
	ret = fd;
	close(fd);
	
	if(ret >= 0)
	{
		memcpy(file_path,mculog_file_path,sizeof(mculog_file_path));
	}
	return ret;
}