#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/gpio.h>
#include <linux/of.h>
#include <linux/of_gpio.h>
#include <linux/platform_device.h>

#include "../pinctrl/mediatek/pinctrl-mtk-common-v2_debug.h"
#include "../pinctrl/mediatek/pinctrl-mtk-common-v2.h"
#include "lynq_gpio_init.h"


static int __init drv_init(void)
{
    struct device_node *gpio_device_node = NULL;
    struct device_node *gpio_next_node = NULL;
    int ret = 0;
    int i;

    printk("GPIO_INIT:init start");
    log_offset = sprintf(log_info, "GPIO init start\n");
    //create folder in /sys
	ret = kobject_init_and_add(&kobj,&ktype,NULL,"lynq_gpio");
    ret = kobject_init_and_add(&kobj_log,&ktype_log,NULL,"lynq_log");
    //find the dts node
    gpio_device_node = of_find_node_by_path("/gpio_init");
    if(gpio_device_node == NULL)
    {
        printk("GPIO_INIT: get DTS property failed!\n");
        log_offset += sprintf(log_info + log_offset, "get DTS property failed!\n");
        return 0;
    }
    //get the number of gpio_init child node
    node_num = of_get_child_count(gpio_device_node);
    if(node_num <= GPIO_NODE_NUM)
    {
        printk("GPIO_INIT:node number: %d", node_num);
        log_offset += sprintf(log_info + log_offset, "GPIO_INIT:node number: %d\n", node_num);
    }
    else
    {
        node_num = GPIO_NODE_NUM;
        log_offset += sprintf(log_info + log_offset, "GPIO_INIT:over the max number\n");
        printk("GPIO_INIT:over the max number");
    }
//set each gpio
   for(i = 0; i < node_num; i++)
   {
        gpio_next_node = of_get_next_child(gpio_device_node, gpio_next_node);
        if(gpio_next_node)
        {
            printk("exist this node");
        }
        else
        {
            printk("no more node");
            break;
        }
        ret = set_gpio(gpio_next_node, i);        
    }

    printk("GPIO_INIT:END");
    log_offset += sprintf(log_info + log_offset, "GPIO_INIT:END\n");
    return 0;
}

device_initcall(drv_init);
MODULE_AUTHOR("Mobiletek");
MODULE_DESCRIPTION("driver for init gpio");
MODULE_LICENSE("GPL");
