/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.symmetric;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Enumeration;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.EncryptionScheme;
import org.bouncycastle.asn1.pkcs.KeyDerivationFunc;
import org.bouncycastle.asn1.pkcs.PBES2Parameters;
import org.bouncycastle.asn1.pkcs.PBKDF2Params;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import org.bouncycastle.jcajce.provider.symmetric.util.BaseAlgorithmParameters;
import org.bouncycastle.jcajce.provider.symmetric.util.PBE;
import org.bouncycastle.jcajce.provider.util.AlgorithmProvider;

public class PBES2AlgorithmParameters {
    private PBES2AlgorithmParameters() {
    }

    private static PBEParameterSpec createPBEParameterSpec(byte[] salt, int iterationCount, byte[] iv) {
        try {
            Class<?> pbeParameterSpecClass = PBES2AlgorithmParameters.class.getClassLoader().loadClass("javax.crypto.spec.PBEParameterSpec");
            Constructor<?> constructor = pbeParameterSpecClass.getConstructor(byte[].class, Integer.TYPE, AlgorithmParameterSpec.class);
            return (PBEParameterSpec)constructor.newInstance(salt, iterationCount, new IvParameterSpec(iv));
        }
        catch (Exception e) {
            throw new IllegalStateException("Requested creation PBES2 parameters in an SDK that doesn't support them", e);
        }
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = PBES2AlgorithmParameters.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            int[] keySizes = new int[]{128, 256};
            int[] shaVariants = new int[]{1, 224, 256, 384, 512};
            for (int keySize : keySizes) {
                for (int shaVariant : shaVariants) {
                    provider.addAlgorithm("AlgorithmParameters.PBEWithHmacSHA" + shaVariant + "AndAES_" + keySize, PREFIX + "$PBEWithHmacSHA" + shaVariant + "AES" + keySize + "AlgorithmParameters");
                }
            }
        }
    }

    public static class PBEWithHmacSHA512AES256AlgorithmParameters
    extends BasePBEWithHmacAlgorithmParameters {
        public PBEWithHmacSHA512AES256AlgorithmParameters() {
            super(PKCSObjectIdentifiers.id_hmacWithSHA512, "HmacSHA512", 32, NISTObjectIdentifiers.id_aes256_CBC, "AES256");
        }
    }

    public static class PBEWithHmacSHA384AES256AlgorithmParameters
    extends BasePBEWithHmacAlgorithmParameters {
        public PBEWithHmacSHA384AES256AlgorithmParameters() {
            super(PKCSObjectIdentifiers.id_hmacWithSHA384, "HmacSHA384", 32, NISTObjectIdentifiers.id_aes256_CBC, "AES256");
        }
    }

    public static class PBEWithHmacSHA256AES256AlgorithmParameters
    extends BasePBEWithHmacAlgorithmParameters {
        public PBEWithHmacSHA256AES256AlgorithmParameters() {
            super(PKCSObjectIdentifiers.id_hmacWithSHA256, "HmacSHA256", 32, NISTObjectIdentifiers.id_aes256_CBC, "AES256");
        }
    }

    public static class PBEWithHmacSHA224AES256AlgorithmParameters
    extends BasePBEWithHmacAlgorithmParameters {
        public PBEWithHmacSHA224AES256AlgorithmParameters() {
            super(PKCSObjectIdentifiers.id_hmacWithSHA224, "HmacSHA224", 32, NISTObjectIdentifiers.id_aes256_CBC, "AES256");
        }
    }

    public static class PBEWithHmacSHA1AES256AlgorithmParameters
    extends BasePBEWithHmacAlgorithmParameters {
        public PBEWithHmacSHA1AES256AlgorithmParameters() {
            super(PKCSObjectIdentifiers.id_hmacWithSHA1, "HmacSHA1", 32, NISTObjectIdentifiers.id_aes256_CBC, "AES256");
        }
    }

    public static class PBEWithHmacSHA512AES128AlgorithmParameters
    extends BasePBEWithHmacAlgorithmParameters {
        public PBEWithHmacSHA512AES128AlgorithmParameters() {
            super(PKCSObjectIdentifiers.id_hmacWithSHA512, "HmacSHA512", 16, NISTObjectIdentifiers.id_aes128_CBC, "AES128");
        }
    }

    public static class PBEWithHmacSHA384AES128AlgorithmParameters
    extends BasePBEWithHmacAlgorithmParameters {
        public PBEWithHmacSHA384AES128AlgorithmParameters() {
            super(PKCSObjectIdentifiers.id_hmacWithSHA384, "HmacSHA384", 16, NISTObjectIdentifiers.id_aes128_CBC, "AES128");
        }
    }

    public static class PBEWithHmacSHA256AES128AlgorithmParameters
    extends BasePBEWithHmacAlgorithmParameters {
        public PBEWithHmacSHA256AES128AlgorithmParameters() {
            super(PKCSObjectIdentifiers.id_hmacWithSHA256, "HmacSHA256", 16, NISTObjectIdentifiers.id_aes128_CBC, "AES128");
        }
    }

    public static class PBEWithHmacSHA224AES128AlgorithmParameters
    extends BasePBEWithHmacAlgorithmParameters {
        public PBEWithHmacSHA224AES128AlgorithmParameters() {
            super(PKCSObjectIdentifiers.id_hmacWithSHA224, "HmacSHA224", 16, NISTObjectIdentifiers.id_aes128_CBC, "AES128");
        }
    }

    public static class PBEWithHmacSHA1AES128AlgorithmParameters
    extends BasePBEWithHmacAlgorithmParameters {
        public PBEWithHmacSHA1AES128AlgorithmParameters() {
            super(PKCSObjectIdentifiers.id_hmacWithSHA1, "HmacSHA1", 16, NISTObjectIdentifiers.id_aes128_CBC, "AES128");
        }
    }

    private static abstract class BasePBEWithHmacAlgorithmParameters
    extends BaseAlgorithmParameters {
        private final AlgorithmIdentifier kdf;
        private final String kdfShortName;
        private final int keySize;
        private final ASN1ObjectIdentifier cipherAlgorithm;
        private final String cipherAlgorithmShortName;
        private PBES2Parameters params;

        private BasePBEWithHmacAlgorithmParameters(ASN1ObjectIdentifier kdf, String kdfShortName, int keySize, ASN1ObjectIdentifier cipherAlgorithm, String cipherAlgorithmShortName) {
            this.kdf = new AlgorithmIdentifier(kdf, DERNull.INSTANCE);
            this.kdfShortName = kdfShortName;
            this.keySize = keySize;
            this.cipherAlgorithm = cipherAlgorithm;
            this.cipherAlgorithmShortName = cipherAlgorithmShortName;
        }

        @Override
        protected byte[] engineGetEncoded() {
            try {
                return new DERSequence(new ASN1Encodable[]{PKCSObjectIdentifiers.id_PBES2, this.params}).getEncoded();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read PBES2 parameters: " + e.toString());
            }
        }

        @Override
        protected byte[] engineGetEncoded(String format) {
            if (this.isASN1FormatString(format)) {
                return this.engineGetEncoded();
            }
            return null;
        }

        @Override
        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class parameterSpec) throws InvalidParameterSpecException {
            if (parameterSpec == PBEParameterSpec.class) {
                PBKDF2Params pbeParamSpec = (PBKDF2Params)this.params.getKeyDerivationFunc().getParameters();
                byte[] iv = ((ASN1OctetString)this.params.getEncryptionScheme().getParameters()).getOctets();
                return PBES2AlgorithmParameters.createPBEParameterSpec(pbeParamSpec.getSalt(), pbeParamSpec.getIterationCount().intValue(), iv);
            }
            throw new InvalidParameterSpecException("unknown parameter spec passed to PBES2 parameters object.");
        }

        @Override
        protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
            if (!(paramSpec instanceof PBEParameterSpec)) {
                throw new InvalidParameterSpecException("PBEParameterSpec required to initialise PBES2 algorithm parameters");
            }
            PBEParameterSpec pbeSpec = (PBEParameterSpec)paramSpec;
            AlgorithmParameterSpec algorithmParameterSpec = PBE.Util.getParameterSpecFromPBEParameterSpec(pbeSpec);
            if (!(algorithmParameterSpec instanceof IvParameterSpec)) {
                throw new IllegalArgumentException("Expecting an IV as a parameter");
            }
            byte[] iv = ((IvParameterSpec)algorithmParameterSpec).getIV();
            this.params = new PBES2Parameters(new KeyDerivationFunc(PKCSObjectIdentifiers.id_PBKDF2, new PBKDF2Params(pbeSpec.getSalt(), pbeSpec.getIterationCount(), this.keySize, this.kdf)), new EncryptionScheme(this.cipherAlgorithm, new DEROctetString(iv)));
        }

        @Override
        protected void engineInit(byte[] params) throws IOException {
            ASN1Sequence seq = ASN1Sequence.getInstance(ASN1Primitive.fromByteArray(params));
            Enumeration seqObjects = seq.getObjects();
            ASN1ObjectIdentifier id = (ASN1ObjectIdentifier)seqObjects.nextElement();
            if (!id.getId().equals(PKCSObjectIdentifiers.id_PBES2.getId())) {
                throw new IllegalArgumentException("Invalid PBES2 parameters");
            }
            this.params = PBES2Parameters.getInstance(seqObjects.nextElement());
        }

        @Override
        protected void engineInit(byte[] params, String format) throws IOException {
            if (this.isASN1FormatString(format)) {
                this.engineInit(params);
                return;
            }
            throw new IOException("Unknown parameters format in PBES2 parameters object");
        }

        @Override
        protected String engineToString() {
            return "PBES2 " + this.kdfShortName + " " + this.cipherAlgorithmShortName + " Parameters";
        }
    }
}

