// SPDX-License-Identifier: GPL-2.0
/*
 * Copyright (c) 2019 MediaTek Inc.
 */

#include <linux/cpuidle.h>
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/of.h>
#include <linux/of_irq.h>
#include <linux/slab.h>
#include <linux/cpu_pm.h>
#include <linux/syscore_ops.h>
#include <linux/suspend.h>
#include <linux/rtc.h>
#include <asm/cpuidle.h>
#include <asm/suspend.h>

#include <mtk_lpm.h>
#include <mtk_lpm_module.h>
#include <mtk_lpm_call.h>
#include <mtk_lpm_type.h>
#include <mtk_lpm_call_type.h>
#include <mtk_dbg_common_v1.h>
#include <mtk.h>
#include <mtk_suspend.h>
#ifdef CONFIG_MTK_PMIC_CHIP_MT6330
#include <mtk_pmic_api_buck.h>
#endif
#ifdef CONFIG_MTK_CCCI_DEVICES
#include <mt-plat/mtk_ccci_common.h>
#endif
//you.chen@2023-01-05 add for lpm suspend actions begin
#ifdef CONFIG_LYNQ_LPM_SUSPEND_SUPPORT
#include <lynq_suspend.h>
#endif
//you.chen@2023-01-05 add for lpm suspend actions end

unsigned int mtk_suspend_status;
u64 before_md_sleep_time;
u64 after_md_sleep_time;

void __attribute__((weak)) subsys_if_on(void)
{
	printk_deferred("[name:spm&]NO %s !!!\n", __func__);
}
void __attribute__((weak)) pll_if_on(void)
{
	printk_deferred("[name:spm&]NO %s !!!\n", __func__);
}
void __attribute__((weak)) gpio_dump_regs(void)
{
	printk_deferred("[name:spm&]NO %s !!!\n", __func__);
}

void mtk_suspend_gpio_dbg(void)
{
	gpio_dump_regs();
}
EXPORT_SYMBOL(mtk_suspend_gpio_dbg);

void mtk_suspend_clk_dbg(void)
{
	pll_if_on();
	subsys_if_on();
}
EXPORT_SYMBOL(mtk_suspend_clk_dbg);

#define MD_SLEEP_INFO_SMEM_OFFEST (4)
static u64 get_md_sleep_time(void)
{
	/* dump subsystem sleep info */
#if defined(CONFIG_MTK_ECCCI_DRIVER)
	u32 *share_mem = NULL;
	struct md_sleep_status md_data;

	share_mem = (u32 *)get_smem_start_addr(MD_SYS1,
		SMEM_USER_LOW_POWER, NULL);
	if (share_mem == NULL) {
		printk_deferred("[name:spm&][%s:%d] - No MD share mem\n",
			 __func__, __LINE__);
		return 0;
	}
	share_mem = share_mem + MD_SLEEP_INFO_SMEM_OFFEST;
	memset(&md_data, 0, sizeof(struct md_sleep_status));
	memcpy(&md_data, share_mem, sizeof(struct md_sleep_status));

	return md_data.sleep_time;
#else
	return 0;
#endif
}

static inline int mtk_suspend_common_enter(unsigned int *susp_status)
{
	unsigned int status = PLAT_VCORE_LP_MODE
				| PLAT_PMIC_VCORE_SRCLKEN0
				| PLAT_SUSPEND;

//you.chen@2023-01-05 add for lpm suspend actions begin
#ifdef CONFIG_LYNQ_LPM_SUSPEND_SUPPORT
	lynq_suspend_common_enter(susp_status);
#endif
//you.chen@2023-01-05 add for lpm suspend actions end

	/* maybe need to stop sspm/mcupm mcdi task here */
	if (susp_status)
		*susp_status = status;

	return 0;
}


static inline int mtk_suspend_common_resume(unsigned int susp_status)
{
	/* Implement suspend common flow here */
//you.chen@2023-01-05 add for lpm suspend actions begin
#ifdef CONFIG_LYNQ_LPM_SUSPEND_SUPPORT
	return lynq_suspend_common_resume(susp_status);
#endif
//you.chen@2023-01-05 add for lpm suspend actions end
	return 0;
}

int mtk_suspend_prompt(int cpu, const struct mtk_lpm_issuer *issuer)
{
	int ret = 0;
	unsigned int spm_res = 0;

	mtk_suspend_status = 0;

	printk_deferred("[name:spm&][%s:%d] - prepare suspend enter\n",
			__func__, __LINE__);

	ret = mtk_suspend_common_enter(&mtk_suspend_status);

	if (ret)
		goto PLAT_LEAVE_SUSPEND;

	/* Legacy SSPM flow, spm sw resource request flow */
	mtk_do_mcusys_prepare_pdn(mtk_suspend_status, &spm_res);

	printk_deferred("[name:spm&][%s:%d] - suspend enter\n",
			__func__, __LINE__);

	/* Record md sleep time */
	before_md_sleep_time = get_md_sleep_time();

#ifdef CONFIG_MTK_PMIC_CHIP_MT6330
	rtc_clk_ctrl(0);
#endif

PLAT_LEAVE_SUSPEND:
	return ret;
}

void mtk_suspend_reflect(int cpu,
					const struct mtk_lpm_issuer *issuer)
{
#ifdef CONFIG_MTK_PMIC_CHIP_MT6330
	rtc_clk_ctrl(1);
#endif
	printk_deferred("[name:spm&][%s:%d] - prepare suspend resume\n",
			__func__, __LINE__);

	mtk_suspend_common_resume(mtk_suspend_status);
	mtk_do_mcusys_prepare_on();

	printk_deferred("[name:spm&][%s:%d] - resume\n",
			__func__, __LINE__);

	if (issuer)
		issuer->log(MT_LPM_ISSUER_SUSPEND, "suspend", NULL);

	/* show md sleep duration during AP suspend */
	after_md_sleep_time = get_md_sleep_time();
	if (after_md_sleep_time >= before_md_sleep_time)
		printk_deferred("[name:spm&][SPM] md_slp_duration = %llu",
			after_md_sleep_time - before_md_sleep_time);
}

struct mtk_lpm_model mtk_model_suspend = {
	.flag = MTK_LP_REQ_NONE,
	.op = {
		.prompt = mtk_suspend_prompt,
		.reflect = mtk_suspend_reflect,
	}
};

#ifdef CONFIG_PM
static int mtk_spm_suspend_pm_event(struct notifier_block *notifier,
			unsigned long pm_event, void *unused)
{
	struct timespec ts;
	struct rtc_time tm;

	getnstimeofday(&ts);
	rtc_time_to_tm(ts.tv_sec, &tm);

	switch (pm_event) {
	case PM_HIBERNATION_PREPARE:
		return NOTIFY_DONE;
	case PM_RESTORE_PREPARE:
		return NOTIFY_DONE;
	case PM_POST_HIBERNATION:
		return NOTIFY_DONE;
	case PM_SUSPEND_PREPARE:
		printk_deferred(
		"[name:spm&][SPM] PM: suspend entry %d-%02d-%02d %02d:%02d:%02d.%09lu UTC\n",
			tm.tm_year + 1900, tm.tm_mon + 1, tm.tm_mday,
			tm.tm_hour, tm.tm_min, tm.tm_sec, ts.tv_nsec);

		return NOTIFY_DONE;
	case PM_POST_SUSPEND:
		printk_deferred(
		"[name:spm&][SPM] PM: suspend exit %d-%02d-%02d %02d:%02d:%02d.%09lu UTC\n",
			tm.tm_year + 1900, tm.tm_mon + 1, tm.tm_mday,
			tm.tm_hour, tm.tm_min, tm.tm_sec, ts.tv_nsec);

		return NOTIFY_DONE;
	}
	return NOTIFY_OK;
}

static struct notifier_block mtk_spm_suspend_pm_notifier_func = {
	.notifier_call = mtk_spm_suspend_pm_event,
	.priority = 0,
};
#endif

int __init mtk_model_suspend_init(void)
{
	int ret;

	mtk_lpm_suspend_registry("suspend", &mtk_model_suspend);

#ifdef CONFIG_PM
	ret = register_pm_notifier(&mtk_spm_suspend_pm_notifier_func);
	if (ret) {
		pr_debug("[name:spm&][SPM] Failed to register PM notifier.\n");
		return ret;
	}
#endif /* CONFIG_PM */

#ifdef CONFIG_PM_SLEEP_DEBUG
	pm_print_times_enabled = false;
#endif
	return 0;
}
