/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (C) 2015 MediaTek Inc.
 */

#ifndef __DPMAIF_REG_V2_H__
#define __DPMAIF_REG_V2_H__

#include <linux/io.h>

/* #define DPMAIF_NOT_ACCESS_HW  */
#ifndef DPMAIF_NOT_ACCESS_HW
extern struct hif_dpmaif_ctrl *dpmaif_ctrl;
#endif

/* INFRA */
#define INFRA_RST0_REG_PD (0x0150)/* reset dpmaif reg */
#define INFRA_RST1_REG_PD (0x0154)/* clear dpmaif reset reg */
#define DPMAIF_PD_RST_MASK (1 << 2)
#define INFRA_RST0_REG_AO (0x0140)
#define INFRA_RST1_REG_AO (0x0144)
#define DPMAIF_AO_RST_MASK (1 << 6)
#define INFRA_DPMAIF_CTRL_REG  (0xC00)
#define DPMAIF_IP_BUSY_MASK   (0x3 << 12)
#define SW_CG_2_STA (0xAC)
#define SW_CG_3_STA (0xC8)

#ifdef MT6297
#define INFRA_PROT_DPMAIF_BIT		(1 << 10)
#else
#define INFRA_TOPAXI_PROTECTEN_1_SET  (0x2A8)
#define INFRA_TOPAXI_PROTECTEN_1_CLR  (0x2AC)
#define INFRA_TOPAXI_PROTECTEN_1      (0x250)
#define DPMAIF_SLEEP_PROTECT_CTRL   (0x1<<4)
#define INFRA_TOPAXI_PROTECT_READY_STA1_1 (0x258)
#endif

/***********************************************************************
 *  DPMAIF AO/PD register define macro
 *
 ***********************************************************************/
#ifdef MT6297
#if 0
#define BASE_NADDR_NRL2_DPMAIF_UL                0x1022D000
#define BASE_NADDR_NRL2_DPMAIF_DL                0x1022D100
#define BASE_NADDR_NRL2_DPMAIF_RDMA              0x1022D200
#define BASE_NADDR_NRL2_DPMAIF_WDMA              0x1022D300
#define BASE_NADDR_NRL2_DPMAIF_AP_MISC           0x1022D400
#define BASE_NADDR_NRL2_DPMAIF_AO_UL             0x10014000
#define BASE_NADDR_NRL2_DPMAIF_AO_DL             0x10014400
#define BASE_NADDR_NRL2_DPMAIF_DL_AO_CFG         0x10014800
#else
#define BASE_NADDR_NRL2_DPMAIF_UL                0
#define BASE_NADDR_NRL2_DPMAIF_DL                0
#define BASE_NADDR_NRL2_DPMAIF_RDMA              0
#define BASE_NADDR_NRL2_DPMAIF_WDMA              0
#define BASE_NADDR_NRL2_DPMAIF_AP_MISC           0
#define BASE_NADDR_NRL2_DPMAIF_AO_UL             0
#define BASE_NADDR_NRL2_DPMAIF_AO_DL             0
#define BASE_NADDR_NRL2_DPMAIF_DL_AO_CFG         0
#define BASE_NADDR_NRL2_DPMAIF_PD_MD_MISC        0
#endif
#else
 #ifdef DVT_DEFINITION
#define DPMAIF_PD_BASE                     0x1022D000
#define DPMAIF_AO_BASE                     0x10014000
#define DPMAIF_PD_MD_MISC_BASE       0x1022C000

/*DPMAIF PD domain group*/
#define DPMAIF_UL_CFG_OFFSET               0
#define DPMAIF_DL_CFG_OFFSET               0x100
#define DPMAIF_AP_MISC_OFFSET              0x400

#define DPMAIF_PD_UL_CFG_BASE              (DPMAIF_PD_BASE + 0)
#define DPMAIF_PD_DL_CFG_BASE              (DPMAIF_PD_BASE + 0x100)
#define DPMAIF_PD_AP_MISC_BASE             (DPMAIF_PD_BASE + 0x400)

/*DPMAIF AO domain group*/
#define DPMAIF_AO_UL_OFFSET                0
#define DPMAIF_AO_DL_OFFSET                0x400

#define DPMAIF_AO_UL_CFG_BASE              (DPMAIF_AO_BASE + 0)
#define DPMAIF_AO_DL_CFG_BASE              (DPMAIF_AO_BASE + 0x400)
#else
#define DPMAIF_PD_UL_CFG_BASE              0
#define DPMAIF_PD_DL_CFG_BASE              0
#define DPMAIF_PD_AP_MISC_BASE             0

#define DPMAIF_AO_UL_CFG_BASE              0
#define DPMAIF_AO_DL_CFG_BASE              0
#endif
#endif

#ifdef MT6297
#define NRL2_DPMAIF_UL_ADD_DESC         (BASE_NADDR_NRL2_DPMAIF_UL + 0x00)
#define NRL2_DPMAIF_UL_RESTORE_RIDX     (BASE_NADDR_NRL2_DPMAIF_UL + 0x04)
#define NRL2_DPMAIF_UL_CHNL_ARB1        (BASE_NADDR_NRL2_DPMAIF_UL + 0x14)
#define NRL2_DPMAIF_UL_CACHE_CON0       (BASE_NADDR_NRL2_DPMAIF_UL + 0x70)
#define NRL2_DPMAIF_UL_RDMA_CFG0        (BASE_NADDR_NRL2_DPMAIF_UL + 0x74)
#define NRL2_DPMAIF_UL_DBG_STA0         (BASE_NADDR_NRL2_DPMAIF_UL + 0x80)
#define NRL2_DPMAIF_UL_DBG_STA1         (BASE_NADDR_NRL2_DPMAIF_UL + 0x84)
#define NRL2_DPMAIF_UL_DBG_STA2         (BASE_NADDR_NRL2_DPMAIF_UL + 0x88)
#define NRL2_DPMAIF_UL_DBG_STA3         (BASE_NADDR_NRL2_DPMAIF_UL + 0x8C)
#define NRL2_DPMAIF_UL_DBG_STA4         (BASE_NADDR_NRL2_DPMAIF_UL + 0x90)
#define NRL2_DPMAIF_UL_DBG_STA5         (BASE_NADDR_NRL2_DPMAIF_UL + 0x94)
#define NRL2_DPMAIF_UL_DBG_STA6         (BASE_NADDR_NRL2_DPMAIF_UL + 0x98)
#define NRL2_DPMAIF_UL_DBG_STA7         (BASE_NADDR_NRL2_DPMAIF_UL + 0x9C)
#define NRL2_DPMAIF_UL_DBG_STA8         (BASE_NADDR_NRL2_DPMAIF_UL + 0xA0)
#define NRL2_DPMAIF_UL_DBG_STA9         (BASE_NADDR_NRL2_DPMAIF_UL + 0xA4)
#define NRL2_DPMAIF_UL_RESERVE_RW       (BASE_NADDR_NRL2_DPMAIF_UL + 0xA8)
#define NRL2_DPMAIF_UL_RESERVE_AO_RW    (BASE_NADDR_NRL2_DPMAIF_UL + 0xAC)
#define NRL2_DPMAIF_UL_ADD_DESC_CH0     (BASE_NADDR_NRL2_DPMAIF_UL + 0xB0)
#define NRL2_DPMAIF_UL_ADD_DESC_CH1     (BASE_NADDR_NRL2_DPMAIF_UL + 0xB4)
#define NRL2_DPMAIF_UL_ADD_DESC_CH2     (BASE_NADDR_NRL2_DPMAIF_UL + 0xB8)
#define NRL2_DPMAIF_UL_ADD_DESC_CH3     (BASE_NADDR_NRL2_DPMAIF_UL + 0xBC)
#define NRL2_DPMAIF_UL_ADD_DESC_CH4     (BASE_NADDR_NRL2_DPMAIF_UL + 0xE0)

#define NRL2_DPMAIF_DL_BAT_INIT         (BASE_NADDR_NRL2_DPMAIF_DL + 0x00)
#define NRL2_DPMAIF_DL_BAT_ADD          (BASE_NADDR_NRL2_DPMAIF_DL + 0x04)
#define NRL2_DPMAIF_DL_BAT_INIT_CON0    (BASE_NADDR_NRL2_DPMAIF_DL + 0x08)
#define NRL2_DPMAIF_DL_BAT_INIT_CON1    (BASE_NADDR_NRL2_DPMAIF_DL + 0x0C)
#define NRL2_DPMAIF_DL_BAT_INIT_CON2    (BASE_NADDR_NRL2_DPMAIF_DL + 0x10)
#define NRL2_DPMAIF_DL_PIT_INIT         (BASE_NADDR_NRL2_DPMAIF_DL + 0x20)
#define NRL2_DPMAIF_DL_PIT_ADD          (BASE_NADDR_NRL2_DPMAIF_DL + 0x24)
#define NRL2_DPMAIF_DL_PIT_INIT_CON0    (BASE_NADDR_NRL2_DPMAIF_DL + 0x28)
#define NRL2_DPMAIF_DL_PIT_INIT_CON1    (BASE_NADDR_NRL2_DPMAIF_DL + 0x2C)
#define NRL2_DPMAIF_DL_PIT_INIT_CON2    (BASE_NADDR_NRL2_DPMAIF_DL + 0x30)
#define NRL2_DPMAIF_DL_PIT_INIT_CON3    (BASE_NADDR_NRL2_DPMAIF_DL + 0x34)
#define NRL2_DPMAIF_DL_MISC_CON0        (BASE_NADDR_NRL2_DPMAIF_DL + 0x40)
#define NRL2_DPMAIF_DL_STA12            (BASE_NADDR_NRL2_DPMAIF_DL + 0x4C)
#define NRL2_DPMAIF_DL_BAT_INIT_CON3    (BASE_NADDR_NRL2_DPMAIF_DL + 0x50)
#define NRL2_DPMAIF_DL_PIT_INIT_CON4    (BASE_NADDR_NRL2_DPMAIF_DL + 0x54)
#define NRL2_DPMAIF_DL_STA9             (BASE_NADDR_NRL2_DPMAIF_DL + 0x58)
#define NRL2_DPMAIF_DL_STA10            (BASE_NADDR_NRL2_DPMAIF_DL + 0x5C)
#define NRL2_DPMAIF_DL_STA11            (BASE_NADDR_NRL2_DPMAIF_DL + 0x60)
#define NRL2_DPMAIF_DL_FRG_STA5         (BASE_NADDR_NRL2_DPMAIF_DL + 0x64)
#define NRL2_DPMAIF_DL_FRG_STA6         (BASE_NADDR_NRL2_DPMAIF_DL + 0x68)
#define NRL2_DPMAIF_DL_DBG_STA16        (BASE_NADDR_NRL2_DPMAIF_DL + 0x6C)
#define NRL2_DPMAIF_DL_DBG_FRG0         (BASE_NADDR_NRL2_DPMAIF_DL + 0x70)
#define NRL2_DPMAIF_DL_DBG_FRG1         (BASE_NADDR_NRL2_DPMAIF_DL + 0x74)
#define NRL2_DPMAIF_DL_DBG_FRG2         (BASE_NADDR_NRL2_DPMAIF_DL + 0x78)
#define NRL2_DPMAIF_DL_DBG_FRG3         (BASE_NADDR_NRL2_DPMAIF_DL + 0x7C)
#define NRL2_DPMAIF_DL_STA0             (BASE_NADDR_NRL2_DPMAIF_DL + 0x80)
#define NRL2_DPMAIF_DL_STA1             (BASE_NADDR_NRL2_DPMAIF_DL + 0x84)
#define NRL2_DPMAIF_DL_STA2             (BASE_NADDR_NRL2_DPMAIF_DL + 0x88)
#define NRL2_DPMAIF_DL_STA3             (BASE_NADDR_NRL2_DPMAIF_DL + 0x8C)
#define NRL2_DPMAIF_DL_STA4             (BASE_NADDR_NRL2_DPMAIF_DL + 0x90)
#define NRL2_DPMAIF_DL_STA5             (BASE_NADDR_NRL2_DPMAIF_DL + 0x94)
#define NRL2_DPMAIF_DL_STA6             (BASE_NADDR_NRL2_DPMAIF_DL + 0x98)
#define NRL2_DPMAIF_DL_STA7             (BASE_NADDR_NRL2_DPMAIF_DL + 0x9C)
#define NRL2_DPMAIF_DL_STA8             (BASE_NADDR_NRL2_DPMAIF_DL + 0xA0)
#define NRL2_DPMAIF_DL_DBG_STA15        (BASE_NADDR_NRL2_DPMAIF_DL + 0xA4)
#define NRL2_DPMAIF_DL_RESERVE_RW       (BASE_NADDR_NRL2_DPMAIF_DL + 0xA8)
#define NRL2_DPMAIF_DL_RESERVE_AO_RW    (BASE_NADDR_NRL2_DPMAIF_DL + 0xAC)
#define NRL2_DPMAIF_DL_DBG_STA0         (BASE_NADDR_NRL2_DPMAIF_DL + 0xB0)
#define NRL2_DPMAIF_DL_DBG_STA1         (BASE_NADDR_NRL2_DPMAIF_DL + 0xB4)
#define NRL2_DPMAIF_DL_DBG_STA2         (BASE_NADDR_NRL2_DPMAIF_DL + 0xB8)
#define NRL2_DPMAIF_DL_DBG_STA3         (BASE_NADDR_NRL2_DPMAIF_DL + 0xBC)
#define NRL2_DPMAIF_DL_DBG_STA4         (BASE_NADDR_NRL2_DPMAIF_DL + 0xC0)
#define NRL2_DPMAIF_DL_DBG_STA5         (BASE_NADDR_NRL2_DPMAIF_DL + 0xC4)
#define NRL2_DPMAIF_DL_DBG_STA6         (BASE_NADDR_NRL2_DPMAIF_DL + 0xC8)
#define NRL2_DPMAIF_DL_DBG_STA7         (BASE_NADDR_NRL2_DPMAIF_DL + 0xCC)
#define NRL2_DPMAIF_DL_DBG_STA8         (BASE_NADDR_NRL2_DPMAIF_DL + 0xD0)
#define NRL2_DPMAIF_DL_DBG_STA9         (BASE_NADDR_NRL2_DPMAIF_DL + 0xD4)
#define NRL2_DPMAIF_DL_DBG_STA10        (BASE_NADDR_NRL2_DPMAIF_DL + 0xD8)
#define NRL2_DPMAIF_DL_DBG_STA11        (BASE_NADDR_NRL2_DPMAIF_DL + 0xDC)
#define NRL2_DPMAIF_DL_FRG_STA0         (BASE_NADDR_NRL2_DPMAIF_DL + 0xE0)
#define NRL2_DPMAIF_DL_FRG_STA1         (BASE_NADDR_NRL2_DPMAIF_DL + 0xE4)
#define NRL2_DPMAIF_DL_FRG_STA2         (BASE_NADDR_NRL2_DPMAIF_DL + 0xE8)
#define NRL2_DPMAIF_DL_FRG_STA3         (BASE_NADDR_NRL2_DPMAIF_DL + 0xEC)
#define NRL2_DPMAIF_DL_FRG_STA4         (BASE_NADDR_NRL2_DPMAIF_DL + 0xF0)
#define NRL2_DPMAIF_DL_DBG_STA12        (BASE_NADDR_NRL2_DPMAIF_DL + 0xF4)
#define NRL2_DPMAIF_DL_DBG_STA13        (BASE_NADDR_NRL2_DPMAIF_DL + 0xF8)
#define NRL2_DPMAIF_DL_DBG_STA14        (BASE_NADDR_NRL2_DPMAIF_DL + 0xFC)

#define NRL2_DPMAIF_RDMA_CON0          (BASE_NADDR_NRL2_DPMAIF_RDMA + 0x000)
#define NRL2_DPMAIF_RDMA_CON1          (BASE_NADDR_NRL2_DPMAIF_RDMA + 0x004)
#define NRL2_DPMAIF_RDMA_CON2          (BASE_NADDR_NRL2_DPMAIF_RDMA + 0x008)
#define NRL2_DPMAIF_RDMA_CON3          (BASE_NADDR_NRL2_DPMAIF_RDMA + 0x00C)
#define NRL2_DPMAIF_RDMA_CON4          (BASE_NADDR_NRL2_DPMAIF_RDMA + 0x010)
#define NRL2_DPMAIF_RDMA_CON5          (BASE_NADDR_NRL2_DPMAIF_RDMA + 0x014)
#define NRL2_DPMAIF_RDMA_CON6          (BASE_NADDR_NRL2_DPMAIF_RDMA + 0x018)
#define NRL2_DPMAIF_RDMA_CON7          (BASE_NADDR_NRL2_DPMAIF_RDMA + 0x01C)
#define NRL2_DPMAIF_RDMA_CON8          (BASE_NADDR_NRL2_DPMAIF_RDMA + 0x020)
#define NRL2_DPMAIF_RDMA_CON9          (BASE_NADDR_NRL2_DPMAIF_RDMA + 0x024)
#define NRL2_DPMAIF_RDMA_CON10         (BASE_NADDR_NRL2_DPMAIF_RDMA + 0x028)
#define NRL2_DPMAIF_RDMA_CON11         (BASE_NADDR_NRL2_DPMAIF_RDMA + 0x02C)
#define NRL2_DPMAIF_RDMA_CON12         (BASE_NADDR_NRL2_DPMAIF_RDMA + 0x030)
#define NRL2_DPMAIF_RDMA_CON13         (BASE_NADDR_NRL2_DPMAIF_RDMA + 0x034)
#define NRL2_DPMAIF_RDMA_CON14         (BASE_NADDR_NRL2_DPMAIF_RDMA + 0x038)
#define NRL2_DPMAIF_RDMA_CON15         (BASE_NADDR_NRL2_DPMAIF_RDMA + 0x03C)
#define NRL2_DPMAIF_RDMA_CON16         (BASE_NADDR_NRL2_DPMAIF_RDMA + 0x040)
#define NRL2_DPMAIF_RDMA_CON17         (BASE_NADDR_NRL2_DPMAIF_RDMA + 0x044)
#define NRL2_DPMAIF_RDMA_CON18         (BASE_NADDR_NRL2_DPMAIF_RDMA + 0x048)
#define NRL2_DPMAIF_RDMA_EXCEP_STA     (BASE_NADDR_NRL2_DPMAIF_RDMA + 0x080)
#define NRL2_DPMAIF_RDMA_EXCEP_MASK    (BASE_NADDR_NRL2_DPMAIF_RDMA + 0x084)
#define NRL2_DPMAIF_RDMA_DBG_CON0      (BASE_NADDR_NRL2_DPMAIF_RDMA + 0x090)
#define NRL2_DPMAIF_RDMA_DBG_CON1      (BASE_NADDR_NRL2_DPMAIF_RDMA + 0x094)
#define NRL2_DPMAIF_RDMA_DBG_CON2      (BASE_NADDR_NRL2_DPMAIF_RDMA + 0x098)
#define NRL2_DPMAIF_RDMA_DBG_CON3      (BASE_NADDR_NRL2_DPMAIF_RDMA + 0x09C)
#define NRL2_DPMAIF_RDMA_DBG_CON4      (BASE_NADDR_NRL2_DPMAIF_RDMA + 0x0A0)
#define NRL2_DPMAIF_RDMA_DBG_CON5      (BASE_NADDR_NRL2_DPMAIF_RDMA + 0x0A4)
#define NRL2_DPMAIF_RDMA_DBG_CON6      (BASE_NADDR_NRL2_DPMAIF_RDMA + 0x0A8)
#define NRL2_DPMAIF_RDMA_DBG_CON7      (BASE_NADDR_NRL2_DPMAIF_RDMA + 0x0AC)
#define NRL2_DPMAIF_RDMA_DBG_CON8      (BASE_NADDR_NRL2_DPMAIF_RDMA + 0x0B0)
#define NRL2_DPMAIF_RDMA_DBG_CON9      (BASE_NADDR_NRL2_DPMAIF_RDMA + 0x0B4)
#define NRL2_DPMAIF_RDMA_DBG_CON10     (BASE_NADDR_NRL2_DPMAIF_RDMA + 0x0B8)
#define NRL2_DPMAIF_RDMA_DBG_CON11     (BASE_NADDR_NRL2_DPMAIF_RDMA + 0x0BC)
#define NRL2_DPMAIF_RDMA_DBG_CON12     (BASE_NADDR_NRL2_DPMAIF_RDMA + 0x0C0)
#define NRL2_DPMAIF_RDMA_DBG_CON13     (BASE_NADDR_NRL2_DPMAIF_RDMA + 0x0C4)

#define NRL2_DPMAIF_WDMA_WR_CMD_CON0 (BASE_NADDR_NRL2_DPMAIF_WDMA + 0x000)
#define NRL2_DPMAIF_WDMA_WR_CMD_CON1 (BASE_NADDR_NRL2_DPMAIF_WDMA + 0x004)
#define NRL2_DPMAIF_WDMA_WR_CHNL_CMD_CON2	\
					(BASE_NADDR_NRL2_DPMAIF_WDMA + 0x010)
#define NRL2_DPMAIF_WDMA_WR_CHNL_CMD_CON3	\
					(BASE_NADDR_NRL2_DPMAIF_WDMA + 0x014)

#define NRL2_DPMAIF_AP_MISC_AP_L2TISAR0		\
				(BASE_NADDR_NRL2_DPMAIF_AP_MISC + 0x00)
#define NRL2_DPMAIF_AP_MISC_AP_L1TISAR0		\
				(BASE_NADDR_NRL2_DPMAIF_AP_MISC + 0x10)
#define NRL2_DPMAIF_AP_MISC_AP_L1TIMR0		\
				(BASE_NADDR_NRL2_DPMAIF_AP_MISC + 0x14)
#define NRL2_DPMAIF_AP_MISC_BUS_CONFIG0		\
				(BASE_NADDR_NRL2_DPMAIF_AP_MISC + 0x20)
#define NRL2_DPMAIF_AP_MISC_TOP_AP_CFG		\
				(BASE_NADDR_NRL2_DPMAIF_AP_MISC + 0x24)
#define NRL2_DPMAIF_AP_MISC_EMI_BUS_STATUS0	\
				(BASE_NADDR_NRL2_DPMAIF_AP_MISC + 0x30)
#define NRL2_DPMAIF_AP_MISC_PCIE_BUS_STATUS0	\
				(BASE_NADDR_NRL2_DPMAIF_AP_MISC + 0x34)
#define NRL2_DPMAIF_AP_MISC_AP_DMA_ERR_STA	\
				(BASE_NADDR_NRL2_DPMAIF_AP_MISC + 0x40)
#define NRL2_DPMAIF_AP_MISC_APDL_L2TISAR0	\
				(BASE_NADDR_NRL2_DPMAIF_AP_MISC + 0x50)
#define NRL2_DPMAIF_AP_MISC_AP_IP_BUSY		\
				(BASE_NADDR_NRL2_DPMAIF_AP_MISC + 0x60)
#define NRL2_DPMAIF_AP_MISC_CG_EN		\
				(BASE_NADDR_NRL2_DPMAIF_AP_MISC + 0x68)
#define NRL2_DPMAIF_AP_MISC_CODA_VER		\
				(BASE_NADDR_NRL2_DPMAIF_AP_MISC + 0x6C)
#define NRL2_DPMAIF_AP_MISC_APB_DBG_SRAM	\
				(BASE_NADDR_NRL2_DPMAIF_AP_MISC + 0x70)
#define NRL2_DPMAIF_PD_MD_MISC_MD_L1TIMSR0	\
				(BASE_NADDR_NRL2_DPMAIF_PD_MD_MISC + 0x001C)

#define NRL2_DPMAIF_AO_UL_CH0_STA	(BASE_NADDR_NRL2_DPMAIF_AO_UL + 0x0)
#define NRL2_DPMAIF_AO_UL_CH1_STA	(BASE_NADDR_NRL2_DPMAIF_AO_UL + 0x4)
#define NRL2_DPMAIF_AO_UL_CH2_STA	(BASE_NADDR_NRL2_DPMAIF_AO_UL + 0x8)
#define NRL2_DPMAIF_AO_UL_CH3_STA	(BASE_NADDR_NRL2_DPMAIF_AO_UL + 0xC)
#define NRL2_DPMAIF_AO_UL_CH4_STA	(BASE_NADDR_NRL2_DPMAIF_AO_UL + 0x10)
#define NRL2_DPMAIF_AO_UL_MD_RDY_CNT_TH	(BASE_NADDR_NRL2_DPMAIF_AO_UL + 0x18)
#define NRL2_DPMAIF_AO_UL_CHNL_ARB0	(BASE_NADDR_NRL2_DPMAIF_AO_UL + 0x1C)
#define NRL2_DPMAIF_AO_UL_CHNL0_CON0	(BASE_NADDR_NRL2_DPMAIF_AO_UL + 0x20)
#define NRL2_DPMAIF_AO_UL_CHNL0_CON1	(BASE_NADDR_NRL2_DPMAIF_AO_UL + 0x24)
#define NRL2_DPMAIF_AO_UL_CHNL0_CON2	(BASE_NADDR_NRL2_DPMAIF_AO_UL + 0x28)
#define NRL2_DPMAIF_AO_UL_CHNL0_STA0	(BASE_NADDR_NRL2_DPMAIF_AO_UL + 0x60)
#define NRL2_DPMAIF_AO_UL_CHNL1_CON0	(BASE_NADDR_NRL2_DPMAIF_AO_UL + 0x30)
#define NRL2_DPMAIF_AO_UL_CHNL1_CON1	(BASE_NADDR_NRL2_DPMAIF_AO_UL + 0x34)
#define NRL2_DPMAIF_AO_UL_CHNL1_CON2	(BASE_NADDR_NRL2_DPMAIF_AO_UL + 0x38)
#define NRL2_DPMAIF_AO_UL_CHNL1_STA0	(BASE_NADDR_NRL2_DPMAIF_AO_UL + 0x64)
#define NRL2_DPMAIF_AO_UL_CHNL2_CON0	(BASE_NADDR_NRL2_DPMAIF_AO_UL + 0x40)
#define NRL2_DPMAIF_AO_UL_CHNL2_CON1	(BASE_NADDR_NRL2_DPMAIF_AO_UL + 0x44)
#define NRL2_DPMAIF_AO_UL_CHNL2_CON2	(BASE_NADDR_NRL2_DPMAIF_AO_UL + 0x48)
#define NRL2_DPMAIF_AO_UL_CHNL2_STA0	(BASE_NADDR_NRL2_DPMAIF_AO_UL + 0x68)
#define NRL2_DPMAIF_AO_UL_CHNL3_CON0	(BASE_NADDR_NRL2_DPMAIF_AO_UL + 0x50)
#define NRL2_DPMAIF_AO_UL_CHNL3_CON1	(BASE_NADDR_NRL2_DPMAIF_AO_UL + 0x54)
#define NRL2_DPMAIF_AO_UL_CHNL3_CON2	(BASE_NADDR_NRL2_DPMAIF_AO_UL + 0x58)
#define NRL2_DPMAIF_AO_UL_CHNL3_STA0	(BASE_NADDR_NRL2_DPMAIF_AO_UL + 0x6C)
#define NRL2_DPMAIF_AO_UL_CH_WIDX01	(BASE_NADDR_NRL2_DPMAIF_AO_UL + 0xC0)
#define NRL2_DPMAIF_AO_UL_CH_WIDX23	(BASE_NADDR_NRL2_DPMAIF_AO_UL + 0xC4)
#define NRL2_DPMAIF_AO_ULQN_MAX_PKT_SZ	(BASE_NADDR_NRL2_DPMAIF_AO_UL + 0xC8)
#define NRL2_DPMAIF_AO_UL_CHNL4_CON0	(BASE_NADDR_NRL2_DPMAIF_AO_UL + 0xD0)
#define NRL2_DPMAIF_AO_UL_CHNL4_CON1	(BASE_NADDR_NRL2_DPMAIF_AO_UL + 0xD4)
#define NRL2_DPMAIF_AO_UL_CHNL4_CON2	(BASE_NADDR_NRL2_DPMAIF_AO_UL + 0xD8)
#define NRL2_DPMAIF_AO_UL_CHNL4_STA0	(BASE_NADDR_NRL2_DPMAIF_AO_UL + 0xDC)
#define NRL2_DPMAIF_AO_UL_CH_WIDX4	(BASE_NADDR_NRL2_DPMAIF_AO_UL + 0xE4)
#define NRL2_DPMAIF_AO_UL_CH_WEIGHT0	(BASE_NADDR_NRL2_DPMAIF_AO_UL + 0xE8)
#define NRL2_DPMAIF_AO_UL_CH_WEIGHT1	(BASE_NADDR_NRL2_DPMAIF_AO_UL + 0xEC)
#define NRL2_DPMAIF_AO_UL_AP_L2TIMR0	(BASE_NADDR_NRL2_DPMAIF_AO_UL + 0x80)
#define NRL2_DPMAIF_AO_UL_AP_L2TIMCR0	(BASE_NADDR_NRL2_DPMAIF_AO_UL + 0x84)
#define NRL2_DPMAIF_AO_UL_AP_L2TIMSR0	(BASE_NADDR_NRL2_DPMAIF_AO_UL + 0x88)
#define NRL2_DPMAIF_AO_UL_AP_L1TIMR0	(BASE_NADDR_NRL2_DPMAIF_AO_UL + 0x8C)
#define NRL2_DPMAIF_AO_UL_APDL_L2TIMR0	(BASE_NADDR_NRL2_DPMAIF_AO_UL + 0x90)
#define NRL2_DPMAIF_AO_UL_APDL_L2TIMCR0	(BASE_NADDR_NRL2_DPMAIF_AO_UL + 0x94)
#define NRL2_DPMAIF_AO_UL_APDL_L2TIMSR0	(BASE_NADDR_NRL2_DPMAIF_AO_UL + 0x98)
#define NRL2_DPMAIF_AO_UL_AP_DL_UL_IP_BUSY_MASK	\
					(BASE_NADDR_NRL2_DPMAIF_AO_UL + 0x9C)

#define NRL2_DPMAIF_AO_DL_PKTINFO_CON0	(BASE_NADDR_NRL2_DPMAIF_AO_DL + 0x0)
#define NRL2_DPMAIF_AO_DL_PKTINFO_CON1	(BASE_NADDR_NRL2_DPMAIF_AO_DL + 0x4)
#define NRL2_DPMAIF_AO_DL_PKTINFO_CON2	(BASE_NADDR_NRL2_DPMAIF_AO_DL + 0x8)
#define NRL2_DPMAIF_AO_DL_RDY_CHK_THRES	(BASE_NADDR_NRL2_DPMAIF_AO_DL + 0xC)
#define NRL2_DPMAIF_AO_DL_BAT_STA0	(BASE_NADDR_NRL2_DPMAIF_AO_DL + 0x10)
#define NRL2_DPMAIF_AO_DL_BAT_STA1	(BASE_NADDR_NRL2_DPMAIF_AO_DL + 0x14)
#define NRL2_DPMAIF_AO_DL_BAT_STA2	(BASE_NADDR_NRL2_DPMAIF_AO_DL + 0x18)
#define NRL2_DPMAIF_AO_DL_PIT_STA5	(BASE_NADDR_NRL2_DPMAIF_AO_DL + 0x1C)
#define NRL2_DPMAIF_AO_DL_PIT_STA0	(BASE_NADDR_NRL2_DPMAIF_AO_DL + 0x20)
#define NRL2_DPMAIF_AO_DL_PIT_STA1	(BASE_NADDR_NRL2_DPMAIF_AO_DL + 0x24)
#define NRL2_DPMAIF_AO_DL_PIT_STA2	(BASE_NADDR_NRL2_DPMAIF_AO_DL + 0x28)
#define NRL2_DPMAIF_AO_DL_PIT_STA3	(BASE_NADDR_NRL2_DPMAIF_AO_DL + 0x2C)
#define NRL2_DPMAIF_AO_DL_RDY_CHK_FRG_THRES	\
					(BASE_NADDR_NRL2_DPMAIF_AO_DL + 0x30)
#define NRL2_DPMAIF_AO_DL_REORDER_BITMAP_CACHE	\
					(BASE_NADDR_NRL2_DPMAIF_AO_DL + 0x38)
#define NRL2_DPMAIF_AO_DL_REORDER_CACHE	(BASE_NADDR_NRL2_DPMAIF_AO_DL + 0x3C)
#define NRL2_DPMAIF_AO_DL_FRGBAT_STA0	(BASE_NADDR_NRL2_DPMAIF_AO_DL + 0x40)
#define NRL2_DPMAIF_AO_DL_FRGBAT_STA1	(BASE_NADDR_NRL2_DPMAIF_AO_DL + 0x44)
#define NRL2_DPMAIF_AO_DL_FRGBAT_STA2	(BASE_NADDR_NRL2_DPMAIF_AO_DL + 0x48)
#define NRL2_DPMAIF_AO_DL_BAT_STA3	(BASE_NADDR_NRL2_DPMAIF_AO_DL + 0x50)
#define NRL2_DPMAIF_AO_DL_PIT_STA4	(BASE_NADDR_NRL2_DPMAIF_AO_DL + 0x54)
#define NRL2_DPMAIF_AO_DL_FRGBAT_STA3	(BASE_NADDR_NRL2_DPMAIF_AO_DL + 0x58)
#define NRL2_DPMAIF_AO_DL_REORDER_THRES (BASE_NADDR_NRL2_DPMAIF_AO_DL + 0x80)
#define NRL2_DPMAIF_MISC_AO_CFG0 (BASE_NADDR_NRL2_DPMAIF_DL_AO_CFG + 0x00)
#define NRL2_DPMAIF_MISC_AO_CFG1 (BASE_NADDR_NRL2_DPMAIF_DL_AO_CFG + 0x04)
#define NRL2_DPMAIF_MISC_AO_REMAP_DOMAIN \
				(BASE_NADDR_NRL2_DPMAIF_DL_AO_CFG + 0x20)
#define NRL2_DPMAIF_MISC_AO_REMAP_CACHE	\
				(BASE_NADDR_NRL2_DPMAIF_DL_AO_CFG + 0x24)
#define NRL2_DPMAIF_MISC_AO_REMAP_ALIGN	\
				(BASE_NADDR_NRL2_DPMAIF_DL_AO_CFG + 0x28)
#define NRL2_DPMAIF_MISC_AO_REMAP_LOCK	\
				(BASE_NADDR_NRL2_DPMAIF_DL_AO_CFG + 0x2C)
#define NRL2_DPMAIF_MISC_AO_REMAP_BANK0_MAPA	\
				(BASE_NADDR_NRL2_DPMAIF_DL_AO_CFG + 0x30)
#define NRL2_DPMAIF_MISC_AO_REMAP_BANK0_MAPB	\
				(BASE_NADDR_NRL2_DPMAIF_DL_AO_CFG + 0x34)
#define NRL2_DPMAIF_MISC_AO_REMAP_BANK0_MAPC	\
				(BASE_NADDR_NRL2_DPMAIF_DL_AO_CFG + 0x38)
#define NRL2_DPMAIF_MISC_AO_REMAP_BANK0_MAPD	\
				(BASE_NADDR_NRL2_DPMAIF_DL_AO_CFG + 0x3C)
#define NRL2_DPMAIF_MISC_AO_REMAP_BANK1_MAPA	\
				(BASE_NADDR_NRL2_DPMAIF_DL_AO_CFG + 0x40)
#define NRL2_DPMAIF_MISC_AO_REMAP_BANK1_MAPB	\
				(BASE_NADDR_NRL2_DPMAIF_DL_AO_CFG + 0x44)
#define NRL2_DPMAIF_MISC_AO_REMAP_BANK1_MAPC	\
				(BASE_NADDR_NRL2_DPMAIF_DL_AO_CFG + 0x48)
#define NRL2_DPMAIF_MISC_AO_REMAP_BANK1_MAPD	\
				(BASE_NADDR_NRL2_DPMAIF_DL_AO_CFG + 0x4C)
#define NRL2_DPMAIF_MISC_AO_REMAP_BANK4_MAPA	\
				(BASE_NADDR_NRL2_DPMAIF_DL_AO_CFG + 0x50)
#define NRL2_DPMAIF_MISC_AO_REMAP_BANK4_MAPB	\
				(BASE_NADDR_NRL2_DPMAIF_DL_AO_CFG + 0x54)
#define NRL2_DPMAIF_MISC_AO_REMAP_BANK4_MAPC	\
				(BASE_NADDR_NRL2_DPMAIF_DL_AO_CFG + 0x58)
#define NRL2_DPMAIF_MISC_AO_REMAP_BANK4_MAPD	\
				(BASE_NADDR_NRL2_DPMAIF_DL_AO_CFG + 0x5C)
#define NRL2_DPMAIF_AXI_MAS_SECURE		\
				(BASE_NADDR_NRL2_DPMAIF_DL_AO_CFG + 0x60)
#define NRL2_DPMAIF_PD_MD_IP_BUSY		\
				(BASE_NADDR_NRL2_DPMAIF_PD_MD_MISC + 0x0000)
#define NRL2_DPMAIF_PD_MD_IP_BUSY_MASK		\
				(BASE_NADDR_NRL2_DPMAIF_PD_MD_MISC + 0x0040)
#define NRL2_DPMAIF_PD_MD_DL_RB_PIT_INIT		\
				(BASE_NADDR_NRL2_DPMAIF_PD_MD_MISC + 0x0100)

/*DPMAIF AO UL CONFIG: 0x10014000 / ao + 0*/
#define DPMAIF_AO_UL_CHNL0_STA            NRL2_DPMAIF_AO_UL_CH0_STA
#define DPMAIF_AO_UL_CHNL1_STA            NRL2_DPMAIF_AO_UL_CH1_STA
#define DPMAIF_AO_UL_CHNL2_STA            NRL2_DPMAIF_AO_UL_CH2_STA
#define DPMAIF_AO_UL_CHNL3_STA            NRL2_DPMAIF_AO_UL_CH3_STA
#define DPMAIF_AO_UL_CH_WEIGHT1           NRL2_DPMAIF_AO_UL_CH_WEIGHT1
/*DPMAIF AO DL CONFIG: 0x10014400 / ao + 0x400*/
#define DPMAIF_AO_DL_PKTINFO_CONO         NRL2_DPMAIF_AO_DL_PKTINFO_CON0
#define DPMAIF_AO_DL_PKTINFO_CON1         NRL2_DPMAIF_AO_DL_PKTINFO_CON1
#define DPMAIF_AO_DL_PKTINFO_CON2         NRL2_DPMAIF_AO_DL_PKTINFO_CON2

#define DPMAIF_AO_DL_RDY_CHK_THRES        NRL2_DPMAIF_AO_DL_RDY_CHK_THRES

#define DPMAIF_AO_DL_BAT_STA0             NRL2_DPMAIF_AO_DL_BAT_STA0
#define DPMAIF_AO_DL_BAT_STA1             NRL2_DPMAIF_AO_DL_BAT_STA1
#define DPMAIF_AO_DL_BAT_STA2             NRL2_DPMAIF_AO_DL_BAT_STA2

#define DPMAIF_AO_DL_PIT_STA0             NRL2_DPMAIF_AO_DL_PIT_STA0
#define DPMAIF_AO_DL_PIT_STA1             NRL2_DPMAIF_AO_DL_PIT_STA1
#define DPMAIF_AO_DL_PIT_STA2             NRL2_DPMAIF_AO_DL_PIT_STA2
#define DPMAIF_AO_DL_PIT_STA3             NRL2_DPMAIF_AO_DL_PIT_STA3

#define DPMAIF_AO_DL_RDY_CHK_FRG_THRES    NRL2_DPMAIF_AO_DL_RDY_CHK_FRG_THRES
#define DPMAIF_AO_DL_FRGBAT_STA2          NRL2_DPMAIF_AO_DL_FRGBAT_STA2
#define DPMAIF_AO_DL_REORDER_THRES        NRL2_DPMAIF_AO_DL_REORDER_THRES

/*DPMAIF PD UL CONFIG: 0x1022D000 /pd+0*/
#define DPMAIF_PD_UL_ADD_DESC             NRL2_DPMAIF_UL_ADD_DESC
#define DPMAIF_PD_UL_RESTORE_RIDX         NRL2_DPMAIF_UL_RESTORE_RIDX

#define DPMAIF_PD_UL_MD_RDY_CNT_TH        NRL2_DPMAIF_AO_UL_MD_RDY_CNT_TH
#define DPMAIF_PD_UL_CHNL_ARB0            NRL2_DPMAIF_AO_UL_CHNL_ARB0
#define DPMAIF_PD_UL_CHNL_ARB1            NRL2_DPMAIF_UL_CHNL_ARB1

#define DPMAIF_PD_UL_CHNL0_CON0           NRL2_DPMAIF_AO_UL_CHNL0_CON0
#define DPMAIF_PD_UL_CHNL0_CON1           NRL2_DPMAIF_AO_UL_CHNL0_CON1
#define DPMAIF_PD_UL_CHNL0_STA0           NRL2_DPMAIF_AO_UL_CHNL0_STA0

#define DPMAIF_PD_UL_CHNL1_CON0           NRL2_DPMAIF_AO_UL_CHNL1_CON0
#define DPMAIF_PD_UL_CHNL1_CON1           NRL2_DPMAIF_AO_UL_CHNL1_CON1
#define DPMAIF_PD_UL_CHNL1_STA0           NRL2_DPMAIF_AO_UL_CHNL1_STA0

#define DPMAIF_PD_UL_CHNL2_CON0           NRL2_DPMAIF_AO_UL_CHNL2_CON0
#define DPMAIF_PD_UL_CHNL2_CON1           NRL2_DPMAIF_AO_UL_CHNL2_CON1
#define DPMAIF_PD_UL_CHNL2_STA0           NRL2_DPMAIF_AO_UL_CHNL2_STA0

#define DPMAIF_PD_UL_CHNL3_CON0           NRL2_DPMAIF_AO_UL_CHNL3_CON0
#define DPMAIF_PD_UL_CHNL3_CON1           NRL2_DPMAIF_AO_UL_CHNL3_CON1
#define DPMAIF_PD_UL_CHNL3_STA0           NRL2_DPMAIF_AO_UL_CHNL3_STA0

#define DPMAIF_PD_UL_CACHE_CON0           NRL2_DPMAIF_UL_CACHE_CON0

#define DPMAIF_PD_UL_ADD_DESC_CH          NRL2_DPMAIF_UL_ADD_DESC_CH0
#define DPMAIF_PD_UL_ADD_DESC_CH4         NRL2_DPMAIF_UL_ADD_DESC_CH4

#define DPMAIF_PD_UL_DBG_STA0             NRL2_DPMAIF_UL_DBG_STA0
#define DPMAIF_PD_UL_DBG_STA1             NRL2_DPMAIF_UL_DBG_STA1
#define DPMAIF_PD_UL_DBG_STA2             NRL2_DPMAIF_UL_DBG_STA2
#define DPMAIF_PD_UL_DBG_STA3             NRL2_DPMAIF_UL_DBG_STA3
#define DPMAIF_PD_UL_DBG_STA4             NRL2_DPMAIF_UL_DBG_STA4
#define DPMAIF_PD_UL_DBG_STA5             NRL2_DPMAIF_UL_DBG_STA5
#define DPMAIF_PD_UL_DBG_STA6             NRL2_DPMAIF_UL_DBG_STA6
#define DPMAIF_PD_UL_DBG_STA7             NRL2_DPMAIF_UL_DBG_STA7
#define DPMAIF_PD_UL_DBG_STA8             NRL2_DPMAIF_UL_DBG_STA8
#define DPMAIF_PD_UL_DBG_STA9             NRL2_DPMAIF_UL_DBG_STA9

/*DPMAIF PD DL CONFIG: 0x1022D100 /pd+0x100*/
#define DPMAIF_PD_DL_BAT_INIT             NRL2_DPMAIF_DL_BAT_INIT
#define DPMAIF_PD_DL_BAT_ADD              NRL2_DPMAIF_DL_BAT_ADD
#define DPMAIF_PD_DL_BAT_INIT_CON0        NRL2_DPMAIF_DL_BAT_INIT_CON0
#define DPMAIF_PD_DL_BAT_INIT_CON1        NRL2_DPMAIF_DL_BAT_INIT_CON1
#define DPMAIF_PD_DL_BAT_INIT_CON2        NRL2_DPMAIF_DL_BAT_INIT_CON2

#define DPMAIF_PD_DL_PIT_INIT             NRL2_DPMAIF_DL_PIT_INIT
#define DPMAIF_PD_DL_PIT_ADD              NRL2_DPMAIF_DL_PIT_ADD
#define DPMAIF_PD_DL_PIT_INIT_CON0        NRL2_DPMAIF_DL_PIT_INIT_CON0
#define DPMAIF_PD_DL_PIT_INIT_CON1        NRL2_DPMAIF_DL_PIT_INIT_CON1
#define DPMAIF_PD_DL_PIT_INIT_CON2        NRL2_DPMAIF_DL_PIT_INIT_CON2
#define DPMAIF_PD_DL_PIT_INIT_CON3        NRL2_DPMAIF_DL_PIT_INIT_CON3

#define DPMAIF_PD_DL_MISC_CON0            NRL2_DPMAIF_DL_MISC_CON0

#define DPMAIF_PD_DL_STA0                 NRL2_DPMAIF_DL_STA0
#define DPMAIF_PD_DL_STA8                 NRL2_DPMAIF_DL_STA8

#define DPMAIF_PD_DL_DBG_STA0             NRL2_DPMAIF_DL_DBG_STA0
#define DPMAIF_PD_DL_DBG_STA1             NRL2_DPMAIF_DL_DBG_STA1
#define DPMAIF_PD_DL_DBG_STA7             NRL2_DPMAIF_DL_DBG_STA7

#define DPMAIF_PD_DL_DBG_STA14            NRL2_DPMAIF_DL_DBG_STA14

#define DPMAIF_PD_DL_EMI_ENH1             (DPMAIF_PD_DL_CFG_BASE + 0x0210)
#define DPMAIF_PD_DL_EMI_ENH2             (DPMAIF_PD_DL_CFG_BASE + 0x0214)

/*DPMAIF PD AP MSIC CONFIG: 0x1022D400 /pd+0x400*/
#define DPMAIF_PD_AP_UL_L2TISAR0          NRL2_DPMAIF_AP_MISC_AP_L2TISAR0
#define DPMAIF_PD_AP_UL_L2TIMR0           NRL2_DPMAIF_AO_UL_AP_L2TIMR0
#define DPMAIF_PD_AP_UL_L2TICR0           NRL2_DPMAIF_AO_UL_AP_L2TIMCR0
#define DPMAIF_PD_AP_UL_L2TISR0           NRL2_DPMAIF_AO_UL_AP_L2TIMSR0

#define DPMAIF_PD_AP_L1TISAR0             NRL2_DPMAIF_AP_MISC_AP_L1TISAR0
#define DPMAIF_PD_AP_L1TIMR0              NRL2_DPMAIF_AP_MISC_AP_L1TIMR0

#define DPMAIF_PD_BUS_CONFIG0             NRL2_DPMAIF_AP_MISC_BUS_CONFIG0
#define DPMAIF_PD_TOP_AP_CFG              NRL2_DPMAIF_AP_MISC_TOP_AP_CFG
#define DPMAIF_PD_BUS_STATUS0             NRL2_DPMAIF_AP_MISC_EMI_BUS_STATUS0
#define DPMAIF_PD_AP_DMA_ERR_STA          NRL2_DPMAIF_AP_MISC_AP_DMA_ERR_STA

#define DPMAIF_PD_AP_DL_L2TISAR0          NRL2_DPMAIF_AP_MISC_APDL_L2TISAR0
#define DPMAIF_PD_AP_DL_L2TIMR0           NRL2_DPMAIF_AO_UL_APDL_L2TIMR0
#define DPMAIF_PD_AP_DL_L2TIMCR0          NRL2_DPMAIF_AO_UL_APDL_L2TIMCR0
#define DPMAIF_PD_AP_DL_L2TIMSR0          NRL2_DPMAIF_AO_UL_APDL_L2TIMSR0

#define DPMAIF_PD_AP_IP_BUSY		NRL2_DPMAIF_AP_MISC_AP_IP_BUSY
#define DPMAIF_PD_AP_DLUL_IP_BUSY_MASK	NRL2_DPMAIF_AO_UL_AP_DL_UL_IP_BUSY_MASK
#define DPMAIF_AP_MISC_APB_DBG_SRAM       NRL2_DPMAIF_AP_MISC_APB_DBG_SRAM

#define DPMAIF_PD_AP_CG_EN                NRL2_DPMAIF_AP_MISC_CG_EN
#define DPMAIF_PD_AP_CODA_VER             NRL2_DPMAIF_AP_MISC_CODA_VER

#define DPMAIF_MISC_AO_CFG0               NRL2_DPMAIF_MISC_AO_CFG0
#define DPMAIF_AXI_MAS_SECURE             NRL2_DPMAIF_AXI_MAS_SECURE

/*DPMAIF PD MD MISC CONFIG: 0x1022C000 */
#define DPMAIF_PD_MD_IP_BUSY              NRL2_DPMAIF_PD_MD_IP_BUSY
#define DPMAIF_PD_MD_IP_BUSY_MASK         NRL2_DPMAIF_PD_MD_IP_BUSY_MASK


#else /*MT6297*/
/*DPMAIF AO UL CONFIG: 0x10014000 / ao + 0*/
#define DPMAIF_AO_UL_CHNL0_STA            (DPMAIF_AO_UL_CFG_BASE + 0x0000)
#define DPMAIF_AO_UL_CHNL1_STA            (DPMAIF_AO_UL_CFG_BASE + 0x0004)
#define DPMAIF_AO_UL_CHNL2_STA            (DPMAIF_AO_UL_CFG_BASE + 0x0008)
#define DPMAIF_AO_UL_CHNL3_STA            (DPMAIF_AO_UL_CFG_BASE + 0x000C)


/*DPMAIF AO DL CONFIG: 0x10014400 / ao + 0x400*/
#define DPMAIF_AO_DL_PKTINFO_CONO         (DPMAIF_AO_DL_CFG_BASE + 0x0000)
#define DPMAIF_AO_DL_PKTINFO_CON1         (DPMAIF_AO_DL_CFG_BASE + 0x0004)
#define DPMAIF_AO_DL_PKTINFO_CON2         (DPMAIF_AO_DL_CFG_BASE + 0x0008)

#define DPMAIF_AO_DL_RDY_CHK_THRES        (DPMAIF_AO_DL_CFG_BASE + 0x000C)

#define DPMAIF_AO_DL_BAT_STA0             (DPMAIF_AO_DL_CFG_BASE + 0x0010)
#define DPMAIF_AO_DL_BAT_STA1             (DPMAIF_AO_DL_CFG_BASE + 0x0014)
#define DPMAIF_AO_DL_BAT_STA2             (DPMAIF_AO_DL_CFG_BASE + 0x0018)

#define DPMAIF_AO_DL_PIT_STA0             (DPMAIF_AO_DL_CFG_BASE + 0x0020)
#define DPMAIF_AO_DL_PIT_STA1             (DPMAIF_AO_DL_CFG_BASE + 0x0024)
#define DPMAIF_AO_DL_PIT_STA2             (DPMAIF_AO_DL_CFG_BASE + 0x0028)
#define DPMAIF_AO_DL_PIT_STA3             (DPMAIF_AO_DL_CFG_BASE + 0x002C)

#define DPMAIF_AO_DL_RDY_CHK_FRG_THRES    (DPMAIF_AO_DL_CFG_BASE + 0x0030)
#define DPMAIF_AO_DL_FRGBAT_STA2          (DPMAIF_AO_DL_CFG_BASE + 0x0048)

/*DPMAIF PD UL CONFIG: 0x1022D000 /pd+0*/
#define DPMAIF_PD_UL_ADD_DESC             (DPMAIF_PD_UL_CFG_BASE + 0x0000)
#define DPMAIF_PD_UL_RESTORE_RIDX         (DPMAIF_PD_UL_CFG_BASE + 0x0004)

#define DPMAIF_PD_UL_MD_RDY_CNT_TH        (DPMAIF_PD_UL_CFG_BASE + 0x0008)
#define DPMAIF_PD_UL_CHNL_ARB0            (DPMAIF_PD_UL_CFG_BASE + 0x0010)
#define DPMAIF_PD_UL_CHNL_ARB1            (DPMAIF_PD_UL_CFG_BASE + 0x0014)

#define DPMAIF_PD_UL_CHNL0_CON0           (DPMAIF_PD_UL_CFG_BASE + 0x0020)
#define DPMAIF_PD_UL_CHNL0_CON1           (DPMAIF_PD_UL_CFG_BASE + 0x0024)
#define DPMAIF_PD_UL_CHNL0_STA0           (DPMAIF_PD_UL_CFG_BASE + 0x0060)

#define DPMAIF_PD_UL_CHNL1_CON0           (DPMAIF_PD_UL_CFG_BASE + 0x0030)
#define DPMAIF_PD_UL_CHNL1_CON1           (DPMAIF_PD_UL_CFG_BASE + 0x0034)
#define DPMAIF_PD_UL_CHNL1_STA0           (DPMAIF_PD_UL_CFG_BASE + 0x0064)

#define DPMAIF_PD_UL_CHNL2_CON0           (DPMAIF_PD_UL_CFG_BASE + 0x0040)
#define DPMAIF_PD_UL_CHNL2_CON1           (DPMAIF_PD_UL_CFG_BASE + 0x0044)
#define DPMAIF_PD_UL_CHNL2_STA0           (DPMAIF_PD_UL_CFG_BASE + 0x0068)

#define DPMAIF_PD_UL_CHNL3_CON0           (DPMAIF_PD_UL_CFG_BASE + 0x0050)
#define DPMAIF_PD_UL_CHNL3_CON1           (DPMAIF_PD_UL_CFG_BASE + 0x0054)
#define DPMAIF_PD_UL_CHNL3_STA0           (DPMAIF_PD_UL_CFG_BASE + 0x006C)

#define DPMAIF_PD_UL_CACHE_CON0           (DPMAIF_PD_UL_CFG_BASE + 0x0070)

#define DPMAIF_PD_UL_ADD_DESC_CH          (DPMAIF_PD_UL_CFG_BASE + 0x00B0)

#define DPMAIF_PD_UL_DBG_STA0             (DPMAIF_PD_UL_CFG_BASE + 0x0080)
#define DPMAIF_PD_UL_DBG_STA1             (DPMAIF_PD_UL_CFG_BASE + 0x0084)
#define DPMAIF_PD_UL_DBG_STA2             (DPMAIF_PD_UL_CFG_BASE + 0x0088)
#define DPMAIF_PD_UL_DBG_STA3             (DPMAIF_PD_UL_CFG_BASE + 0x008C)
#define DPMAIF_PD_UL_DBG_STA4             (DPMAIF_PD_UL_CFG_BASE + 0x0090)
#define DPMAIF_PD_UL_DBG_STA5             (DPMAIF_PD_UL_CFG_BASE + 0x0094)
#define DPMAIF_PD_UL_DBG_STA6             (DPMAIF_PD_UL_CFG_BASE + 0x0098)
#define DPMAIF_PD_UL_DBG_STA7             (DPMAIF_PD_UL_CFG_BASE + 0x009C)
#define DPMAIF_PD_UL_DBG_STA8             (DPMAIF_PD_UL_CFG_BASE + 0x00A0)
#define DPMAIF_PD_UL_DBG_STA9             (DPMAIF_PD_UL_CFG_BASE + 0x00A4)

/*DPMAIF PD DL CONFIG: 0x1022D100 /pd+0x100*/
#define DPMAIF_PD_DL_BAT_INIT             (DPMAIF_PD_DL_CFG_BASE + 0x0000)
#define DPMAIF_PD_DL_BAT_ADD              (DPMAIF_PD_DL_CFG_BASE + 0x0004)

#define DPMAIF_PD_DL_BAT_INIT_CON0        (DPMAIF_PD_DL_CFG_BASE + 0x0008)
#define DPMAIF_PD_DL_BAT_INIT_CON1        (DPMAIF_PD_DL_CFG_BASE + 0x000C)
#define DPMAIF_PD_DL_BAT_INIT_CON2        (DPMAIF_PD_DL_CFG_BASE + 0x0010)

#define DPMAIF_PD_DL_PIT_INIT             (DPMAIF_PD_DL_CFG_BASE + 0x0020)
#define DPMAIF_PD_DL_PIT_ADD              (DPMAIF_PD_DL_CFG_BASE + 0x0024)

#define DPMAIF_PD_DL_PIT_INIT_CON0        (DPMAIF_PD_DL_CFG_BASE + 0x0028)
#define DPMAIF_PD_DL_PIT_INIT_CON1        (DPMAIF_PD_DL_CFG_BASE + 0x002C)
#define DPMAIF_PD_DL_PIT_INIT_CON2        (DPMAIF_PD_DL_CFG_BASE + 0x0030)
#define DPMAIF_PD_DL_PIT_INIT_CON3        (DPMAIF_PD_DL_CFG_BASE + 0x0034)

#define DPMAIF_PD_DL_MISC_CON0            (DPMAIF_PD_DL_CFG_BASE + 0x0040)

#define DPMAIF_PD_DL_STA0                 (DPMAIF_PD_DL_CFG_BASE + 0x0080)
#define DPMAIF_PD_DL_STA8                 (DPMAIF_PD_DL_CFG_BASE + 0x00A0)

#define DPMAIF_PD_DL_DBG_STA0             (DPMAIF_PD_DL_CFG_BASE + 0x00B0)
#define DPMAIF_PD_DL_DBG_STA1             (DPMAIF_PD_DL_CFG_BASE + 0x00B4)
#define DPMAIF_PD_DL_DBG_STA7             (DPMAIF_PD_DL_CFG_BASE + 0x00CC)

#define DPMAIF_PD_DL_DBG_STA14             (DPMAIF_PD_DL_CFG_BASE + 0x00FC)

#define DPMAIF_PD_DL_EMI_ENH1             (DPMAIF_PD_DL_CFG_BASE + 0x0210)
#define DPMAIF_PD_DL_EMI_ENH2             (DPMAIF_PD_DL_CFG_BASE + 0x0214)

/*DPMAIF PD AP MSIC CONFIG: 0x1022D400 /pd+0x400*/
#define DPMAIF_PD_AP_UL_L2TISAR0          (DPMAIF_PD_AP_MISC_BASE + 0x0000)
#define DPMAIF_PD_AP_UL_L2TIMR0           (DPMAIF_PD_AP_MISC_BASE + 0x0004)
#define DPMAIF_PD_AP_UL_L2TICR0           (DPMAIF_PD_AP_MISC_BASE + 0x0008)
#define DPMAIF_PD_AP_UL_L2TISR0           (DPMAIF_PD_AP_MISC_BASE + 0x000C)

#define DPMAIF_PD_AP_L1TISAR0             (DPMAIF_PD_AP_MISC_BASE + 0x0010)
#define DPMAIF_PD_AP_L1TIMR0              (DPMAIF_PD_AP_MISC_BASE + 0x0014)

#define DPMAIF_PD_BUS_CONFIG0             (DPMAIF_PD_AP_MISC_BASE + 0x0020)
#define DPMAIF_PD_TOP_AP_CFG              (DPMAIF_PD_AP_MISC_BASE + 0x0024)
#define DPMAIF_PD_BUS_STATUS0             (DPMAIF_PD_AP_MISC_BASE + 0x0030)
#define DPMAIF_PD_AP_DMA_ERR_STA          (DPMAIF_PD_AP_MISC_BASE + 0x0040)

#define DPMAIF_PD_AP_DL_L2TISAR0          (DPMAIF_PD_AP_MISC_BASE + 0x0050)
#define DPMAIF_PD_AP_DL_L2TIMR0           (DPMAIF_PD_AP_MISC_BASE + 0x0054)
#define DPMAIF_PD_AP_DL_L2TIMCR0           (DPMAIF_PD_AP_MISC_BASE + 0x0058)
#define DPMAIF_PD_AP_DL_L2TIMSR0           (DPMAIF_PD_AP_MISC_BASE + 0x005C)

#define DPMAIF_PD_AP_IP_BUSY              (DPMAIF_PD_AP_MISC_BASE + 0x0060)
#define DPMAIF_PD_AP_DLUL_IP_BUSY_MASK    (DPMAIF_PD_AP_MISC_BASE + 0x0064)

#define DPMAIF_PD_AP_CG_EN               (DPMAIF_PD_AP_MISC_BASE + 0x0068)
#define DPMAIF_PD_AP_CODA_VER            (DPMAIF_PD_AP_MISC_BASE + 0x006C)

/*DPMAIF PD MD MISC CONFIG: 0x1022C000 */
#define DPMAIF_PD_MD_IP_BUSY              (DPMAIF_PD_MD_MISC_BASE + 0x0000)
#define DPMAIF_PD_MD_IP_BUSY_WAKE         (DPMAIF_PD_MD_MISC_BASE + 0x0004)

#define DPMAIF_PD_MD_L1TISAR0             (DPMAIF_PD_MD_MISC_BASE + 0x0010)
#define DPMAIF_PD_MD_L1TIMR0              (DPMAIF_PD_MD_MISC_BASE + 0x0014)
#define DPMAIF_PD_MD_L1TICR0              (DPMAIF_PD_MD_MISC_BASE + 0x0018)
#define DPMAIF_PD_MD_L1TISR0              (DPMAIF_PD_MD_MISC_BASE + 0x001C)
#endif /*MT6297*/

/*assistant macros*/
#define CLDMA_AP_TQSAR(i)  (CLDMA_AP_UL_START_ADDR_0   + (4 * (i)))
#define CLDMA_AP_TQCPR(i)  (CLDMA_AP_UL_CURRENT_ADDR_0 + (4 * (i)))
#define CLDMA_AP_RQSAR(i)  (CLDMA_AP_SO_START_ADDR_0   + (4 * (i)))
#define CLDMA_AP_RQCPR(i)  (CLDMA_AP_SO_CURRENT_ADDR_0 + (4 * (i)))
#define CLDMA_AP_TQSABAK(i)  (CLDMA_AP_UL_START_ADDR_BK_0 + (4 * (i)))
#define CLDMA_AP_TQCPBAK(i)  (CLDMA_AP_UL_CURRENT_ADDR_BK_0 + (4 * (i)))

#ifdef DPMAIF_NOT_ACCESS_HW
#define dpmaif_write32(b, a, v)
#define dpmaif_write16(b, a, v)
#define dpmaif_write8(b, a, v)

#define dpmaif_read32(b, a)			0
#define dpmaif_read16(b, a)			0
#define dpmaif_read8(b, a)			0

#define DPMA_READ_PD_MISC(a)	0
#define DPMA_READ_PD_UL(a)		0
#define DPMA_READ_PD_DL(a)		0

#define DPMA_READ_AO_DL(a)		0

#define DPMA_WRITE_PD_MISC(a, v)
#define DPMA_WRITE_PD_UL(a, v)
#define DPMA_WRITE_PD_DL(a, v)
#define DPMA_WRITE_AO_DL(a, v)
#else
#define dpmaif_write32(b, a, v)	\
do { \
	writel(v, (b) + (a)); \
	mb(); /* make sure register access in order */ \
} while (0)

#define dpmaif_write16(b, a, v)	\
do { \
	writew(v, (b) + (a)); \
	mb(); /* make sure register access in order */ \
} while (0)

#define dpmaif_write8(b, a, v) \
do { \
	writeb(v, (b) + (a)); \
	mb(); /* make sure register access in order */ \
} while (0)

#define dpmaif_read32(b, a)		ioread32((void __iomem *)((b)+(a)))
#define dpmaif_read16(b, a)		ioread16((void __iomem *)((b)+(a)))
#define dpmaif_read8(b, a)		ioread8((void __iomem *)((b)+(a)))

#define DPMA_READ_PD_MISC(a) \
	dpmaif_read32(dpmaif_ctrl->dpmaif_pd_misc_base, (a))
#define DPMA_READ_PD_UL(a) dpmaif_read32(dpmaif_ctrl->dpmaif_pd_ul_base, (a))
#define DPMA_READ_PD_DL(a) dpmaif_read32(dpmaif_ctrl->dpmaif_pd_dl_base, (a))

#define DPMA_WRITE_PD_MISC(a, v) \
	dpmaif_write32(dpmaif_ctrl->dpmaif_pd_misc_base, (a), v)
#define DPMA_WRITE_PD_UL(a, v) \
	dpmaif_write32(dpmaif_ctrl->dpmaif_pd_ul_base, (a), v)
#define DPMA_WRITE_PD_DL(a, v) \
	dpmaif_write32(dpmaif_ctrl->dpmaif_pd_dl_base, (a), v)
#define DPMA_WRITE_AO_DL(a, v) \
	dpmaif_write32(dpmaif_ctrl->dpmaif_ao_dl_base, (a), v)

#define DPMA_READ_AO_DL(a) \
	dpmaif_read32(dpmaif_ctrl->dpmaif_ao_dl_base, (a))


#define DPMA_WRITE_AO_UL(a, v) \
	dpmaif_write32(dpmaif_ctrl->dpmaif_ao_ul_base, (a), v)

#define DPMA_READ_AO_UL(a) \
	dpmaif_read32(dpmaif_ctrl->dpmaif_ao_ul_base, (a))


#define DPMA_WRITE_WDMA(a, v) \
	dpmaif_write32(dpmaif_ctrl->dpmaif_pd_wdma_base, (a), v)

#define DPMA_READ_WDMA(a) \
	dpmaif_read32(dpmaif_ctrl->dpmaif_pd_wdma_base, (a))


#define DPMA_WRITE_AO_MD_DL(a, v) \
	dpmaif_write32(dpmaif_ctrl->dpmaif_ao_md_dl_base, (a), v)

#define DPMA_READ_AO_MD_DL(a) \
	dpmaif_read32(dpmaif_ctrl->dpmaif_ao_md_dl_base, (a))

#define DPMA_WRITE_MD_MISC_DL(a, v) \
	dpmaif_write32(dpmaif_ctrl->dpmaif_pd_md_misc_base, (a), v)

#define DPMA_READ_MD_MISC_DL(a) \
	dpmaif_read32(dpmaif_ctrl->dpmaif_pd_md_misc_base, (a))
#endif

/* DL */
/* DPMAIF_PD_DL_BAT/PIT_ADD */
#define DPMAIF_DL_ADD_UPDATE                (1 << 31)
#define DPMAIF_DL_ADD_NOT_READY             (1 << 31)
#define DPMAIF_DL_BAT_FRG_ADD               (1 << 16)

#define DPMAIF_DL_BAT_INIT_ALLSET           (1 << 0)
#define DPMAIF_DL_BAT_FRG_INIT              (1 << 16)
#define DPMAIF_DL_BAT_INIT_EN               (1 << 31)
#define DPMAIF_DL_BAT_INIT_NOT_READY        (1 << 31)
#define DPMAIF_DL_BAT_INIT_ONLY_ENABLE_BIT  (0 << 0)

#define DPMAIF_DL_PIT_INIT_ALLSET           (1 << 0)
#define DPMAIF_DL_PIT_INIT_ONLY_ENABLE_BIT  (0 << 0)
#define DPMAIF_DL_PIT_INIT_EN               (1 << 31)
#define DPMAIF_DL_PIT_INIT_NOT_READY        (1 << 31)

#define DPMAIF_PKT_ALIGN64_MODE        0
#define DPMAIF_PKT_ALIGN128_MODE       1

#define DPMAIF_BAT_REMAIN_SZ_BASE      16
#define DPMAIF_BAT_BUFFER_SZ_BASE      128
#define DPMAIF_FRG_BAT_BUFFER_SZ_BASE  128

#define DPMAIF_PIT_EN_MSK              0x01
#define DPMAIF_PIT_SIZE_MSK            0xFFFF
#define DPMAIF_PIT_ADDRH_MSK           0xFF000000

#define DPMAIF_BAT_EN_MSK              (1 << 16)
#define DPMAIF_BAT_SIZE_MSK            0xFFFF
#define DPMAIF_BAT_ADDRH_MSK           0xFF000000

#define DPMAIF_BAT_BID_MAXCNT_MSK      0xFFFF0000
#define DPMAIF_BAT_REMAIN_MINSZ_MSK    0x0000FF00
#define DPMAIF_PIT_CHK_NUM_MSK         0xFF000000
#define DPMAIF_BAT_BUF_SZ_MSK          0x0001FF00
#define DPMAIF_BAT_RSV_LEN_MSK         0x000000FF
#define DPMAIF_PKT_ALIGN_MSK           (0x3 << 22)

#define DPMAIF_BAT_CHECK_THRES_MSK     (0x3F << 16)

#define DPMAIF_PKT_ALIGN_EN            (1 << 23)

#define DPMAIF_DL_PIT_WRIDX_MSK        0xFFFF
#define DPMAIF_DL_BAT_WRIDX_MSK        0xFFFF

#define DPMAIF_BAT_CHECK_THRES_MSK     (0x3F << 16)
#define DPMAIF_FRG_CHECK_THRES_MSK     (0xFF)
#define DPMAIF_AO_DL_ISR_MSK           (0x7F)

#define DPMAIF_FRG_BAT_BUF_FEATURE_ON_MSK   (1 << 28)
#define DPMAIF_FRG_BAT_BUF_FEATURE_EN       (1 << 28)
#define DPMAIF_FRG_BAT_BUF_SZ_MSK           (0xff << 8)
#define DPMAIF_CHKSUM_ON_MSK                (1 << 31)

/*DPMAIF_PD_DL_DBG_STA1*/
#define DPMAIF_DL_IDLE_STS             (1 << 25)

/*DPMAIF_PD_DL_DBG_STA7*/
#define DPMAIF_DL_FIFO_PUSH_RIDX       (0x3F << 20)
#define DPMAIF_DL_FIFO_PUSH_SHIFT       20
#define DPMAIF_DL_FIFO_PUSH_MSK         0x3F

#define DPMAIF_DL_FIFO_PUSH_IDLE_STS   (1 << 16)

#define DPMAIF_DL_FIFO_POP_RIDX        (0x3F << 5)
#define DPMAIF_DL_FIFO_POP_SHIFT        5
#define DPMAIF_DL_FIFO_POP_MSK          0x3F

#define DPMAIF_DL_FIFO_POP_IDLE_STS    (1 << 0)

#define DPMAIF_DL_FIFO_IDLE_STS \
	(DPMAIF_DL_FIFO_POP_IDLE_STS|DPMAIF_DL_FIFO_PUSH_IDLE_STS)


#define DPMAIF_CHK_RB_PITNUM_MSK 0x000000FF
/*BASE_NADDR_NRL2_DPMAIF_WDMA*/
#define DPMAIF_DL_WDMA_CTRL_OSTD_OFST (28)
#define DPMAIF_DL_WDMA_CTRL_OSTD_MSK (0xF)
#define DPMAIF_DL_WDMA_CTRL_OSTD_VALUE (0xE)

#define DPMAIF_AWDOMAIN_BIT_MSK 0xF
#define DPMAIF_ARDOMAIN_BIT_MSK 0xF
#define DPMAIF_AWDOMAIN_BIT_OFT 0
#define DPMAIF_ARDOMAIN_BIT_OFT 8

#define DPMAIF_CACHE_BANK0_BIT_MSK 0x3F
#define DPMAIF_CACHE_BANK1_BIT_MSK 0x3F
#define DPMAIF_CACHE_BANK0_BIT_OFT 0
#define DPMAIF_CACHE_BANK1_BIT_OFT 8

#define DP_DOMAIN_ID 1
#define DP_BANK0_ID 6
#define DP_BANK1_ID 7

#define DPMAIF_MD_AO_REMAP_ENABLE (1 << 0)

#ifdef _HW_REORDER_SW_WORKAROUND_
#define DPMAIF_MD_DUMMYPIT_EN     (1 << 31)
#endif

/* ======== UL ========= */

/* DPMAIF_PD_UL_CHNL(*)_CON1 */
#define DPMAIF_DRB_ADDRH_MSK           0xFF000000
#define DPMAIF_DRB_SIZE_MSK            0x0000FFFF

#define DPMAIF_UL_ADD_NOT_READY             (1 << 31)

#define DPMAIF_UL_ALL_QUE_ARB_EN            (0xF << 8)

#define DPMAIF_UL_ADD_UPDATE                (1 << 31)
#define DPMAIF_ULQ_ADD_DESC_CH_n(q_num)     \
	((DPMAIF_PD_UL_ADD_DESC_CH) + (0x04 * (q_num)))

#define DPMAIF_ULQSAR_n(q_num)      \
	((DPMAIF_PD_UL_CHNL0_CON0) + (0x10 * (q_num)))
#define DPMAIF_UL_DRBSIZE_ADDRH_n(q_num)    \
	((DPMAIF_PD_UL_CHNL0_CON1) + (0x10 * (q_num)))

#ifdef MT6297
#define DPMAIF_ULQ_STA0_n(q_num)     \
	((NRL2_DPMAIF_AO_UL_CH0_STA) + (0x04 * (q_num)))
#else
#define DPMAIF_ULQ_STA0_n(q_num)            \
	((DPMAIF_PD_UL_CHNL0_STA0) + (0x04 * (q_num)))
#endif

/*DPMAIF_PD_UL_DBG_STA2*/
#define DPMAIF_UL_STS_CUR_SHIFT        (26)
#define DPMAIF_UL_IDLE_STS_MSK         (0x3F)
#define DPMAIF_UL_IDLE_STS             (0x01)

/* === tx interrupt mask === */
#define UL_INT_DONE_OFFSET          0
#define UL_INT_EMPTY_OFFSET         5
#define UL_INT_MD_NOTRDY_OFFSET     10
#define UL_INT_PWR_NOTRDY_OFFSET    15
#define UL_INT_LEN_ERR_OFFSET       20

#define DPMAIF_UL_INT_DONE(q_num)            (1 << (q_num+UL_INT_DONE_OFFSET))
#define DPMAIF_UL_INT_EMPTY(q_num)          (1 << (q_num+UL_INT_EMPTY_OFFSET))
#define DPMAIF_UL_INT_MD_NOTRDY(q_num)           \
	(1 << (q_num+UL_INT_MD_NOTRDY_OFFSET))
#define DPMAIF_UL_INT_PWR_NOTRDY(q_num)         \
	(1 << (q_num+UL_INT_PWR_NOTRDY_OFFSET))
#define DPMAIF_UL_INT_LEN_ERR(q_num)                 \
	(1 << (q_num+UL_INT_LEN_ERR_OFFSET))

#define DPMAIF_UL_INT_QDONE_MSK	(0x1F << UL_INT_DONE_OFFSET)
#define DPMAIF_UL_INT_EMPTY_MSK	(0x1F << UL_INT_EMPTY_OFFSET)
#define DPMAIF_UL_INT_MD_NOTREADY_MSK	(0x1F << UL_INT_MD_NOTRDY_OFFSET)
#define DPMAIF_UL_INT_MD_PWR_NOTREADY_MSK	\
	(0x1F << UL_INT_PWR_NOTRDY_OFFSET)
#define DPMAIF_UL_INT_ERR_MSK		(0x1F << UL_INT_LEN_ERR_OFFSET)

#define AP_UL_L2INTR_ERR_En_Msk \
	(DPMAIF_UL_INT_ERR_MSK | DPMAIF_UL_INT_MD_NOTREADY_MSK | \
	DPMAIF_UL_INT_MD_PWR_NOTREADY_MSK)
/* DPMAIF_UL_INT_EMPTY_MSK | */
#define AP_UL_L2INTR_En_Msk \
	(AP_UL_L2INTR_ERR_En_Msk | \
	DPMAIF_UL_INT_QDONE_MSK)

/* === RX interrupt mask === */
#define DPMAIF_DL_INT_ERR_MSK                    (0x07 << 1)
#define DPMAIF_DL_INT_EMPTY_MSK                  (0x03 << 4)
#define DPMAIF_DL_INT_MTU_ERR_MSK                (0x01 << 6)
#define DPMAIF_DL_INT_QDONE_MSK                  (0x01 << 0)
#define DPMAIF_DL_INT_SKB_LEN_ERR(q_num)              (1 << 1)
#define DPMAIF_DL_INT_BATCNT_LEN_ERR(q_num)           (1 << 2)
#define DPMAIF_DL_INT_PITCNT_LEN_ERR(q_num)           (1 << 3)
#ifdef _E1_SB_SW_WORKAROUND_
#define AP_DL_L2INTR_ERR_En_Msk \
	(DPMAIF_DL_INT_SKB_LEN_ERR(0) | DPMAIF_DL_INT_PITCNT_LEN_ERR(0) | \
	DPMAIF_DL_INT_MTU_ERR_MSK | DPMAIF_DL_INT_BATCNT_LEN_ERR(0))
/* DPMAIF_DL_INT_EMPTY_MSK | */
#define AP_DL_L2INTR_En_Msk \
	(AP_DL_L2INTR_ERR_En_Msk | \
	DPMAIF_DL_INT_QDONE_MSK)
#else
#define AP_DL_L2INTR_ERR_En_Msk \
	(DPMAIF_DL_INT_SKB_LEN_ERR(0) | \
	DPMAIF_DL_INT_MTU_ERR_MSK)
/* DPMAIF_DL_INT_EMPTY_MSK | */
#define AP_DL_L2INTR_En_Msk \
	(AP_DL_L2INTR_ERR_En_Msk | \
	DPMAIF_DL_INT_QDONE_MSK)
#endif
#endif				/* __DPMAIF_REG_V2_H__ */
