// SPDX-License-Identifier: GPL-2.0
/*
 * Mediatek meta gpio driver
 *
 * Copyright (C) 2021 MediaTek Inc.
 *
 * Author: Zenghui Zhao <ot_zenghui.zhao@mediatek.com>
 */

#include <linux/init.h>
#include <linux/module.h>
#include <linux/device.h>
#include <linux/platform_device.h>
#include <linux/of_device.h>
#include <linux/of_irq.h>
#include <linux/miscdevice.h>
#include <linux/delay.h>
#include <linux/gpio.h>
#include <linux/of_gpio.h>
#include <linux/kernel.h>

bool m_g_true;

static int meta_gpio_probe(struct platform_device *pdev)
{
	int ret = 0, value;

	ret = of_get_named_gpio(pdev->dev.of_node, "meta_gpio_num", 0);
	value = __gpio_get_value(ret);
	pr_info("meta gpio value = (%d)\n", value);

//tianyan@2021.10.18 modify for meta gpio start
	if (value == 1) {
		pr_info("The eint0 is pressed!\n");
		m_g_true = true;
	}
//tianyan@2021.10.18 modify for meta gpio end

	return 0;
}
EXPORT_SYMBOL(m_g_true);

static const struct of_device_id meta_gpio_of_match[] = {
	{.compatible = "mediatek,metainfo"},
	{},
};

static struct platform_driver meta_gpio_driver = {
	.probe = meta_gpio_probe,
	.driver = {
		   .name = "meta_info",
		   .owner = THIS_MODULE,
		   .of_match_table = meta_gpio_of_match,
		   },
};

static int __init meta_gpio_init(void)
{
	int ret;

	ret = platform_driver_register(&meta_gpio_driver);
	pr_info("meta gpio init, ret = %d\n", ret);
	if (ret)
		pr_debug("meta gpio register driver failed (%d)\n", ret);

	return 0;
}
core_initcall(meta_gpio_init);

static void __exit meta_gpio_exit(void)
{
	platform_driver_unregister(&meta_gpio_driver);
}
module_exit(meta_gpio_exit);

MODULE_DESCRIPTION("meta gpio Device Driver");
MODULE_LICENSE("GPL v2");
